/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PagesAllocationRange;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PartitionAllocationMap;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.TrackingPageIsCorruptedException;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.database.snapshot.AbstractFullPageIdIterable;
import org.gridgain.grid.internal.processors.cache.database.snapshot.PageIdIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FullPageIdIncrementalSnapshotIterable
extends AbstractFullPageIdIterable {
    FullPageIdIncrementalSnapshotIterable(GridCacheSharedContext<?, ?> sharedCtx, Map<Integer, Long> nextSnapshotTagsForCacheGrp, Map<Integer, Long> lastSuccessfulSnapshotIdsForCache, PartitionAllocationMap partStateMap) {
        super(sharedCtx, nextSnapshotTagsForCacheGrp, lastSuccessfulSnapshotIdsForCache, partStateMap);
    }

    @Override
    protected PageIdIterable.CountingIterator<FullPageId> createIterator(Queue<T2<GroupPartitionId, PagesAllocationRange>> queue) {
        return new FullPageIdIncrementalSnapshotIterator(queue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean contains(@NotNull FullPageId fullId) {
        PagesAllocationRange pages;
        int grpId = fullId.groupId();
        long pageId = fullId.pageId();
        GroupPartitionId cachePartId = PartitionAllocationMap.createCachePartId((FullPageId)fullId);
        if (!this.partStateMap.containsKey(cachePartId)) {
            return false;
        }
        int idx = PageIdUtils.pageIndex((long)pageId);
        if (idx >= (pages = this.partStateMap.get(cachePartId)).getCurrAllocatedPageCnt()) {
            return false;
        }
        if (idx >= pages.getLastAllocatedPageCnt()) {
            return true;
        }
        if (idx == 0) {
            return true;
        }
        long trackingPage = this.io.trackingPageFor(pageId, this.realPageSize(grpId));
        if (trackingPage == pageId) {
            return false;
        }
        try (AbstractFullPageIdIterable.TrackingPageBufferScope ignored = this.borrowTrackingPage(grpId, trackingPage);){
            boolean bl = this.io.wasChanged(this.getCachedTrackingPage(), pageId, this.getCurrentSnapshotTag(grpId), this.getLastSuccessfulSnapshotTag(grpId), this.realPageSize(grpId));
            return bl;
        }
        catch (TrackingPageIsCorruptedException ex) {
            if (ex != TrackingPageIsCorruptedException.INSTANCE) {
                U.error((IgniteLogger)this.sharedCtx.logger(this.getClass()), (Object)("Corrupted nextSnapshotTag grpId=" + grpId + ", partition=" + PageIdUtils.partId((long)pageId) + ", trackingPageId=" + U.hexLong((long)trackingPage) + ", lastSavedTag=" + ex.lastTag() + ", nextSnapshotTag=" + ex.passedTag()), (Throwable)ex);
            }
            this.markCorruptedTrackingPage(trackingPage, grpId);
            return true;
        }
    }

    @Override
    @Nullable
    public FullPageId next(@Nullable FullPageId curPageFullId) {
        return this.next(curPageFullId, null, this::nextStartPage);
    }

    @Nullable
    private FullPageId next(@Nullable FullPageId curPageFullId, @Nullable AtomicInteger progressCntr, Function<@Nullable GroupPartitionId, @Nullable FullPageId> nextStartPage) {
        if (this.partStateMap.isEmpty()) {
            return null;
        }
        if (curPageFullId == null) {
            return nextStartPage.apply(null);
        }
        GroupPartitionId curCachePartId = PartitionAllocationMap.createCachePartId((FullPageId)curPageFullId);
        PagesAllocationRange curAllocPagesRange = this.partStateMap.get(curCachePartId);
        int curTotalAllocatedPageCnt = curAllocPagesRange != null ? curAllocPagesRange.getCurrAllocatedPageCnt() : 0;
        int curMaxPageIdx = curTotalAllocatedPageCnt - 1;
        int curPageIdx = PageIdUtils.pageIndex((long)curPageFullId.pageId());
        if (curAllocPagesRange == null) {
            return nextStartPage.apply(null);
        }
        if (curPageIdx == curMaxPageIdx) {
            if (progressCntr != null) {
                progressCntr.addAndGet(curAllocPagesRange.getCurrAllocatedPageCnt());
            }
            return nextStartPage.apply(curCachePartId);
        }
        int prevSnapshotWrittenPage = curAllocPagesRange.getLastAllocatedPageCnt();
        return this.getNextId(curPageFullId, progressCntr, nextStartPage, curTotalAllocatedPageCnt, curMaxPageIdx, prevSnapshotWrittenPage);
    }

    private FullPageId getNextId(@NotNull FullPageId curPageFullId, @Nullable AtomicInteger progressCntr, Function<@Nullable GroupPartitionId, @Nullable FullPageId> nextStartPage, int curTotalAllocatedPageCnt, int curMaxPageIdx, int prevSnapshotWrittenPage) {
        int curGrpId;
        long trackingPage;
        int nextId;
        long curPageId = curPageFullId.pageId();
        int nextPageIdx = PageIdUtils.pageIndex((long)curPageId) + 1;
        long nextPageId = PageIdUtils.pageId((int)PageIdUtils.partId((long)curPageId), (byte)PageIdUtils.flag((long)curPageId), (int)nextPageIdx);
        do {
            Long founded;
            int index;
            if ((index = PageIdUtils.pageIndex((long)nextPageId)) > curMaxPageIdx) {
                return this.next(new FullPageId(PageIdUtils.pageId((int)PageIdUtils.partId((long)curPageId), (byte)PageIdUtils.flag((long)curPageId), (int)curMaxPageIdx), curPageFullId.groupId()), progressCntr, nextStartPage);
            }
            curGrpId = curPageFullId.groupId();
            if (index >= prevSnapshotWrittenPage) {
                return new FullPageId(nextPageId, curGrpId);
            }
            trackingPage = this.io.trackingPageFor(nextPageId, this.realPageSize(curGrpId));
            if (trackingPage == nextPageId) {
                return this.next(new FullPageId(nextPageId, curGrpId), progressCntr, nextStartPage);
            }
            long lastSuccessfulSnapshotTag = this.getLastSuccessfulSnapshotTag(curGrpId);
            try (AbstractFullPageIdIterable.TrackingPageBufferScope ignored = this.borrowTrackingPage(curGrpId, trackingPage);){
                founded = this.io.findNextChangedPage(this.getCachedTrackingPage(), nextPageId, this.getCurrentSnapshotTag(curGrpId), lastSuccessfulSnapshotTag, this.realPageSize(curGrpId));
            }
            catch (TrackingPageIsCorruptedException e) {
                if (e != TrackingPageIsCorruptedException.INSTANCE) {
                    U.error((IgniteLogger)this.sharedCtx.logger(this.getClass()), (Object)("Corrupted nextSnapshotTag grpId=" + curGrpId + ", partition=" + PageIdUtils.partId((long)nextPageId) + ", trackingPageId=" + U.hexLong((long)trackingPage) + ", lastSavedTag=" + e.lastTag() + ", nextSnapshotTag=" + e.passedTag()), (Throwable)e);
                }
                this.markCorruptedTrackingPage(trackingPage, curGrpId);
                return new FullPageId(nextPageId, curGrpId);
            }
            if (founded == null) continue;
            nextId = PageIdUtils.pageIndex((long)founded);
            if (nextId > prevSnapshotWrittenPage) {
                return new FullPageId(PageIdUtils.pageId((int)PageIdUtils.partId((long)curPageId), (byte)PageIdUtils.flag((long)curPageId), (int)prevSnapshotWrittenPage), curGrpId);
            }
            return new FullPageId(founded.longValue(), curGrpId);
        } while ((nextId = PageIdUtils.pageIndex((long)(nextPageId = PageIdUtils.pageId((int)PageIdUtils.partId((long)curPageId), (byte)PageIdUtils.flag((long)curPageId), (int)(PageIdUtils.pageIndex((long)trackingPage) + this.io.countOfPageToTrack(this.realPageSize(curPageFullId.groupId()))))))) < prevSnapshotWrittenPage || prevSnapshotWrittenPage >= curTotalAllocatedPageCnt);
        return new FullPageId(PageIdUtils.pageId((int)PageIdUtils.partId((long)curPageId), (byte)PageIdUtils.flag((long)curPageId), (int)prevSnapshotWrittenPage), curGrpId);
    }

    @Override
    public boolean isEmpty() {
        return this.next(null) == null;
    }

    private class FullPageIdIncrementalSnapshotIterator
    implements PageIdIterable.CountingIterator<FullPageId> {
        private final Queue<T2<GroupPartitionId, PagesAllocationRange>> queue;
        @Nullable
        private FullPageId next;
        private final AtomicInteger overallIteratedCnt = new AtomicInteger();

        private FullPageIdIncrementalSnapshotIterator(Queue<T2<GroupPartitionId, PagesAllocationRange>> queue) {
            this.queue = queue;
            this.advance();
        }

        private void advance() {
            FullPageId curPageFullId = this.next;
            FullPageIdIncrementalSnapshotIterable this0 = FullPageIdIncrementalSnapshotIterable.this;
            this.next = this0.next(curPageFullId, this.overallIteratedCnt, this::nextStartPage);
        }

        private FullPageId nextStartPage(GroupPartitionId id) {
            GroupPartitionId grpPartId;
            PagesAllocationRange range;
            do {
                T2<GroupPartitionId, PagesAllocationRange> entry;
                if ((entry = this.queue.poll()) == null) {
                    return null;
                }
                grpPartId = (GroupPartitionId)entry.getKey();
                range = (PagesAllocationRange)entry.getValue();
                assert (grpPartId != null && range != null);
            } while (range.getCurrAllocatedPageCnt() == 0);
            return grpPartId.createFirstPageFullId();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public FullPageId next() {
            FullPageId next = this.next;
            if (next == null) {
                throw new NoSuchElementException();
            }
            this.advance();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public int currentInternalCount() {
            return this.overallIteratedCnt.get();
        }

        @Override
        public int totalInternalCount() {
            return FullPageIdIncrementalSnapshotIterable.this.getTotalPageCnt();
        }
    }
}

