/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.util.Set;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.gridgain.grid.internal.processors.cache.database.snapshot.ConsistentCutMeta;

class PitrEntryPredicate
implements IgniteBiPredicate<WALRecord, DataEntry> {
    private static final long serialVersionUID = 0L;
    private final FileWALPointer fuzzyBorderStartPtr;
    private final FileWALPointer cutPtr;
    private final Set<GridCacheVersion> skipTxs;
    private final IgniteBiPredicate<WALRecord, DataEntry> superPred;

    PitrEntryPredicate(IgniteBiPredicate<WALRecord, DataEntry> superPred, ConsistentCutMeta meta) {
        this.fuzzyBorderStartPtr = (FileWALPointer)meta.fuzzyBorderStartPtr();
        this.cutPtr = (FileWALPointer)meta.cutPtr();
        this.skipTxs = meta.skipTxs();
        this.superPred = superPred;
    }

    public boolean apply(WALRecord rec, DataEntry entry) {
        FileWALPointer ptr = (FileWALPointer)rec.position();
        boolean apply = ptr.compareTo(this.cutPtr) >= 0 || ptr.compareTo(this.fuzzyBorderStartPtr) >= 0 && (entry == null || entry.nearXidVersion() == null || this.skipTxs.contains(entry.nearXidVersion()));
        return apply && this.superPred.apply((Object)rec, (Object)entry);
    }
}

