/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.MemoryRecoveryRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.DatabaseLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointStatus;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginContext;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.GridPluginProcessorAdapter;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridRecovery;
import org.gridgain.grid.internal.processors.cache.database.recovery.NodeStartPoint;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRFolderRecoveryContextFactory;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRLocalFolderRecoveryContext;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRParameters;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRRecoveryContext;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRRecoveryContextFactory;
import org.gridgain.grid.internal.processors.cache.database.recovery.RecoveryCoordinatorLeftException;
import org.gridgain.grid.internal.processors.cache.database.recovery.RecoveryMessageWrapper;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.jetbrains.annotations.Nullable;

public class GridRecoveryProcessor
extends GridPluginProcessorAdapter
implements GridRecovery,
DatabaseLifecycleListener {
    private static final String NODE_STARTED_FILE_NAME_SUFFIX = "-node-started.bin";
    private final AtomicReference<PITRRecoveryContext> contextHolder = new AtomicReference();
    private volatile Object locNodeConstId;
    private final LinkedBlockingQueue<RecoveryMessageWrapper> queue = new LinkedBlockingQueue();
    private final CopyOnWriteArrayList<GridMessageListener> listeners = new CopyOnWriteArrayList();
    private volatile PITRRecoveryContextFactory recoveryContextFactory;
    private FileIOFactory ioFactory;
    private GridCacheDatabaseSharedManager database;
    private IgniteWriteAheadLogManager wal;

    public GridRecoveryProcessor(PluginContext ctx, GridGainConfiguration cfg) {
        super(ctx, cfg);
    }

    public void start() {
        this.igniteCtx.internalSubscriptionProcessor().registerDatabaseListener((DatabaseLifecycleListener)this);
        this.ioFactory = this.igniteCtx.config().getDataStorageConfiguration().getFileIOFactory();
        GridCacheSharedContext cctx = this.igniteCtx.cache().context();
        this.database = (GridCacheDatabaseSharedManager)cctx.database();
        this.wal = cctx.wal();
    }

    public void afterBinaryMemoryRestore(IgniteCacheDatabaseSharedManager mgr, GridCacheDatabaseSharedManager.RestoreBinaryState binaryState) throws IgniteCheckedException {
        this.addRecoveryPoint((WALPointer)binaryState.lastReadRecordPointer());
    }

    public void onBaselineChange() throws IgniteCheckedException {
        this.addRecoveryPoint(null);
    }

    private void addRecoveryPoint(@Nullable WALPointer pointer) throws IgniteCheckedException {
        this.nodeStart(pointer);
        this.wal.log((WALRecord)new MemoryRecoveryRecord(U.currentTimeMillis()));
    }

    private void nodeStart(@Nullable WALPointer ptr) throws IgniteCheckedException {
        File cpDir = this.database.checkpointDirectory();
        FileWALPointer p = (FileWALPointer)(ptr == null ? CheckpointStatus.NULL_PTR : ptr);
        String fileName = U.currentTimeMillis() + NODE_STARTED_FILE_NAME_SUFFIX;
        String tmpFileName = fileName + ".tmp";
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.order(ByteOrder.nativeOrder());
        try {
            try (FileIO io = this.ioFactory.create(Paths.get(cpDir.getAbsolutePath(), tmpFileName).toFile(), new OpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE});){
                buf.putLong(p.index());
                buf.putInt(p.fileOffset());
                buf.putInt(p.length());
                buf.flip();
                io.writeFully(buf);
                buf.clear();
                io.force(true);
            }
            Files.move(Paths.get(cpDir.getAbsolutePath(), tmpFileName), Paths.get(cpDir.getAbsolutePath(), fileName), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new StorageException("Failed to write node start marker: " + ptr, e);
        }
    }

    /*
     * Exception decompiling
     */
    public List<NodeStartPoint> nodeStartedPoints() throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void onIgniteStart() throws IgniteCheckedException {
        this.locNodeConstId = this.igniteCtx.discovery().localNode().consistentId();
        GridIoManager io = this.igniteCtx.cache().context().gridIO();
        io.addMessageListener(GridTopic.TOPIC_SNAPSHOT, new GridMessageListener(){

            public void onMessage(UUID nodeId, Object msg, byte plc) {
                if (msg instanceof RecoveryMessageWrapper) {
                    try {
                        GridRecoveryProcessor.this.queue.put((RecoveryMessageWrapper)msg);
                    }
                    catch (InterruptedException e) {
                        GridRecoveryProcessor.this.log.error("Interrupted while putting message to queue", (Throwable)e);
                    }
                } else if (!GridRecoveryProcessor.this.listeners.isEmpty()) {
                    for (GridMessageListener listener : GridRecoveryProcessor.this.listeners) {
                        listener.onMessage(nodeId, msg, plc);
                    }
                }
            }
        });
        this.recoveryContextFactory = new PITRFolderRecoveryContextFactory(this.log, this.igniteCtx, this.locNodeConstId, this.queue);
    }

    private void initRecoveryContext(PITRRecoveryContext recCtx) throws IgniteCheckedException {
        GridMessageListener lsnr = recCtx.init();
        if (lsnr != null) {
            this.listeners.add(lsnr);
        }
        if (!this.contextHolder.compareAndSet(null, recCtx)) {
            throw new IgniteCheckedException("Previous recovery is not completed.");
        }
    }

    public IgniteInternalFuture<Set<Object>> scanForLeftNodes() {
        PITRRecoveryContext rctx = this.contextHolder.get();
        if (rctx != null) {
            return rctx.scanForLeftNodes();
        }
        return new GridFinishedFuture();
    }

    public IgniteInternalFuture<?> continueTxStateCommunication(Set<Object> allLeftNodes, SnapshotOperationContext snapshotOperationContext) {
        PITRRecoveryContext rctx = this.contextHolder.get();
        if (rctx != null) {
            return rctx.continueScan(allLeftNodes, snapshotOperationContext);
        }
        return new GridFinishedFuture();
    }

    public IgniteInternalFuture<?> onPartitionRestored() {
        PITRRecoveryContext rctx = this.contextHolder.get();
        if (rctx == null || !(rctx instanceof PITRLocalFolderRecoveryContext)) {
            return new GridFinishedFuture();
        }
        PITRLocalFolderRecoveryContext localRecovery = (PITRLocalFolderRecoveryContext)rctx;
        return localRecovery.onPartitionRestored();
    }

    public IgniteInternalFuture<?> recoveryLocalUpdates(SnapshotOperationContext snapshotOperationContext) {
        PITRRecoveryContext recCtx = this.contextHolder.get();
        if (recCtx == null) {
            return new GridFinishedFuture();
        }
        return recCtx.recovery(snapshotOperationContext);
    }

    public void onRecoveryFinish(Throwable e) {
        PITRRecoveryContext rctx = this.contextHolder.getAndSet(null);
        if (rctx != null) {
            rctx.onComplete(e);
        }
        this.listeners.clear();
    }

    public void onNodeLeft(ClusterNode node, boolean crd) {
        PITRRecoveryContext recCtx = this.contextHolder.get();
        if (recCtx != null) {
            recCtx.onNodeLeft(node, crd);
        }
        if (recCtx == null && crd) {
            throw new RecoveryCoordinatorLeftException("Coordinator left during recovery before sending aggregated scan result, can't finish recovery.");
        }
    }

    public void initRecovery(PITRParameters params) throws IgniteCheckedException {
        PITRRecoveryContext recCtx = this.recoveryContextFactory.build(params);
        if (recCtx != null) {
            this.initRecoveryContext(recCtx);
        }
    }

    private static /* synthetic */ boolean lambda$nodeStartedPoints$0(Path path) throws IOException {
        return path.toFile().getName().endsWith(NODE_STARTED_FILE_NAME_SUFFIX);
    }
}

