/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.messages;

import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.messages.AbstractSnapshotLifecycleMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.SnapshotIssueMessage;

public class ClusterWideSnapshotOperationStageFinishedMessage
extends AbstractSnapshotLifecycleMessage {
    private static final long serialVersionUID = 0L;
    private IgniteUuid id;
    private boolean success;
    private String errorMsg;
    private AffinityTopologyVersion ver;
    private SnapshotOperationStage stage;
    @Deprecated
    @GridDirectCollection(value=SnapshotIssueMessage.class)
    private Collection<SnapshotIssueMessage> issues;
    private byte[] payload;

    public ClusterWideSnapshotOperationStageFinishedMessage() {
    }

    public ClusterWideSnapshotOperationStageFinishedMessage(IgniteUuid id, boolean success, String errorMsg, AffinityTopologyVersion ver, Collection<SnapshotIssueMessage> issues, SnapshotOperationStage stage, byte[] payload) {
        this.id = id;
        this.success = success;
        this.errorMsg = errorMsg;
        this.ver = ver;
        this.issues = issues;
        this.stage = stage;
        this.payload = payload;
    }

    @Override
    public IgniteUuid operationId() {
        return this.id;
    }

    public boolean success() {
        return this.success;
    }

    public String errorMessage() {
        return this.errorMsg;
    }

    public Collection<SnapshotIssueMessage> issues() {
        return this.issues;
    }

    public AffinityTopologyVersion ver() {
        return this.ver;
    }

    public byte[] payload() {
        return this.payload;
    }

    public SnapshotOperationStage stage() {
        return this.stage;
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeString("errorMsg", this.errorMsg)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeIgniteUuid("id", this.id)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeCollection("issues", this.issues, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeByteArray("payload", this.payload)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeByte("stage", this.stage != null ? (byte)this.stage.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeBoolean("success", this.success)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeMessage("ver", (Message)this.ver)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.errorMsg = reader.readString("errorMsg");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.id = reader.readIgniteUuid("id");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.issues = reader.readCollection("issues", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.payload = reader.readByteArray("payload");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                byte stageOrd = reader.readByte("stage");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.stage = SnapshotOperationStage.fromOrdinal(stageOrd);
                reader.incrementState();
            }
            case 5: {
                this.success = reader.readBoolean("success");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.ver = (AffinityTopologyVersion)reader.readMessage("ver");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ClusterWideSnapshotOperationStageFinishedMessage.class);
    }

    public short directType() {
        return 2053;
    }

    public byte fieldsCount() {
        return 7;
    }

    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(ClusterWideSnapshotOperationStageFinishedMessage.class, (Object)this);
    }
}

