/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskNoResultCache;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTask;
import org.gridgain.grid.internal.processors.cache.database.CollectSnapshotPartitionDistributionTask;
import org.gridgain.grid.internal.processors.cache.database.SnapshotTaskBase;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CacheSnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotRemotePath;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.snapshot.file.FileSnapshot;
import org.gridgain.grid.persistentstore.snapshot.file.remote.SnapshotPathFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@GridInternal
@ComputeTaskNoResultCache
@Deprecated
public class CollectSnapshotPartitionDistributionTaskV2
extends SnapshotTaskBase<CollectSnapshotPartitionDistributionV2Params, CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionTaskResult> {
    private static final long serialVersionUID = 0L;
    private final ConcurrentHashMap<UUID, CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionJobResult> result = new ConcurrentHashMap();

    @Nullable
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, CollectSnapshotPartitionDistributionV2Params arg) throws IgniteException {
        assert (arg != null);
        HashMap<CollectSnapshotPartitionDistributionJob, ClusterNode> jobs = new HashMap<CollectSnapshotPartitionDistributionJob, ClusterNode>();
        Collection baselineNodes = this.ignite.context().discovery().discoCache().aliveBaselineNodes();
        Collection<Object> nodes = baselineNodes == null ? subgrid : baselineNodes;
        for (ClusterNode clusterNode : nodes) {
            if (clusterNode.isClient() || clusterNode.isDaemon()) continue;
            jobs.put(new CollectSnapshotPartitionDistributionJob(arg.snapshotId, arg.type, arg.cacheNames, arg.paths, arg.c), clusterNode);
        }
        return jobs;
    }

    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) throws IgniteException {
        if (res.getException() != null) {
            return super.result(res, rcvd);
        }
        Object data = res.getData();
        if (data != null && data instanceof CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionJobResult) {
            CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionJobResult r = (CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionJobResult)data;
            this.result.put(res.getNode().id(), r);
        }
        return ComputeJobResultPolicy.WAIT;
    }

    @Nullable
    public CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionTaskResult reduce(List<ComputeJobResult> results) throws IgniteException {
        return new CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionTaskResult(this.result);
    }

    public static class CollectSnapshotPartitionDistributionV2Params
    extends IgniteDataTransferObject {
        private static final long serialVersionUID = 0L;
        private long snapshotId;
        private SnapshotOperationType type;
        private Set<String> cacheNames;
        private Collection<SnapshotRemotePath> paths;
        private IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c;

        public CollectSnapshotPartitionDistributionV2Params() {
        }

        public CollectSnapshotPartitionDistributionV2Params(long snapshotId, SnapshotOperationType type, Set<String> cacheNames, Collection<SnapshotRemotePath> paths, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c) {
            this.snapshotId = snapshotId;
            this.type = type;
            this.cacheNames = cacheNames;
            this.paths = paths;
            this.c = c;
        }

        protected void writeExternalData(ObjectOutput out) throws IOException {
            out.writeLong(this.snapshotId);
            U.writeEnum((DataOutput)out, (Enum)this.type);
            out.writeObject(this.cacheNames);
            out.writeObject(this.paths);
            out.writeObject(this.c);
        }

        protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
            this.snapshotId = in.readLong();
            this.type = SnapshotOperationType.fromOrdinal((int)in.readByte());
            this.cacheNames = (Set)in.readObject();
            this.paths = (Collection)in.readObject();
            this.c = (IgniteBiClosure)in.readObject();
        }
    }

    private static class CollectSnapshotPartitionDistributionJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        protected Ignite ignite;
        private final long snapshotId;
        private final SnapshotOperationType type;
        private final Set<String> cacheNames;
        private final Collection<SnapshotRemotePath> paths;
        private final IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c;

        private CollectSnapshotPartitionDistributionJob(long snapshotId, SnapshotOperationType type, Set<String> cacheNames, Collection<SnapshotRemotePath> paths, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c) {
            this.snapshotId = snapshotId;
            this.type = type;
            this.cacheNames = cacheNames;
            this.paths = paths;
            this.c = c;
        }

        public CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionJobResult execute() throws IgniteException {
            SnapshotMetadataV2 metadata;
            FileSnapshot snapshot;
            if (this.ignite == null) {
                throw new IgniteException("Ignite instance was not injected");
            }
            IgniteEx ig = (IgniteEx)this.ignite;
            GridCacheSnapshotManager snapshotMgr = (GridCacheSnapshotManager)ig.context().cache().context().snapshot();
            IgniteLogger log = ig.log().getLogger(CollectSnapshotInfoTask.class);
            if (log != null && log.isInfoEnabled()) {
                log.info("Starting CollectSnapshotPartitionDistributionJob: snapshotId = " + this.snapshotId + ", path = " + this.paths);
            }
            if (this.c != null) {
                try {
                    ((IgniteEx)this.ignite).context().resource().injectGeneric(this.c);
                }
                catch (IgniteCheckedException e) {
                    U.error((IgniteLogger)log, (Object)"Error during injecting resources to cache configuration transformer", (Throwable)e);
                }
            }
            if ((snapshot = (FileSnapshot)snapshotMgr.snapshotSpi().snapshot(this.snapshotId, SnapshotPathFactory.create(this.paths, log, snapshotMgr.config().getSftpConfiguration()), this.c, true, null, false)) == null || (metadata = snapshot.metadata()) == null) {
                return new CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionJobResult(null, null, null);
            }
            boolean snapshotIsInSharedFolder = !snapshot.isDefaultPath() && this.calcSnapshotInSharedFolder(metadata);
            return new CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionJobResult(snapshotIsInSharedFolder, this.getPartitionsForGroups(ig, metadata, snapshotIsInSharedFolder), metadata.cacheNamesWithGroups());
        }

        private Map<Integer, T2<Integer, Set<Integer>>> getPartitionsForGroups(IgniteEx ig, SnapshotMetadataV2 metadata, boolean snapshotIsInSharedFolder) {
            if (!snapshotIsInSharedFolder) {
                HashMap<Integer, T2<Integer, Set<Integer>>> partitionsPerGrp = new HashMap<Integer, T2<Integer, Set<Integer>>>();
                for (Integer grpId : this.getGroupIds(metadata)) {
                    CacheSnapshotMetadata cacheSnapshotMetadata = (CacheSnapshotMetadata)metadata.cacheGroupsMetadata().get(grpId);
                    Map partCnt = cacheSnapshotMetadata.partitionSizesPerNode();
                    for (Map.Entry e0 : partCnt.entrySet()) {
                        Integer part = (Integer)e0.getKey();
                        if (F.isEmpty((Map)((Map)e0.getValue())) || !((Map)e0.getValue()).containsKey(U.maskForFileName((CharSequence)ig.localNode().consistentId().toString()))) continue;
                        T2 parts = (T2)partitionsPerGrp.get(grpId);
                        if (parts == null) {
                            if (cacheSnapshotMetadata.cacheConfigurations().isEmpty()) continue;
                            parts = new T2((Object)((CacheConfiguration)cacheSnapshotMetadata.cacheConfigurations().iterator().next()).getAffinity().partitions(), new HashSet());
                            partitionsPerGrp.put(grpId, (T2<Integer, Set<Integer>>)parts);
                        }
                        ((Set)parts.get2()).add(part);
                    }
                }
                return partitionsPerGrp;
            }
            return null;
        }

        private boolean calcSnapshotInSharedFolder(SnapshotMetadataV2 metadata) {
            for (Map.Entry e : metadata.cacheGroupsMetadata().entrySet()) {
                CacheSnapshotMetadata meta = (CacheSnapshotMetadata)e.getValue();
                if (!meta.hasCacheConfiguration()) {
                    throw new IgniteException("Snapshot couldn't be restored because cache configuration couldn't be unmarshalled");
                }
                if (meta.checkPartitions()) continue;
                return false;
            }
            return true;
        }

        @NotNull
        private Collection<Integer> getGroupIds(SnapshotMetadataV2 metadata) {
            Collection<Integer> cacheGrpIds0;
            if (this.cacheNames == null) {
                cacheGrpIds0 = metadata.cacheGroupIds();
            } else {
                cacheGrpIds0 = new ArrayList();
                for (String cacheName : this.cacheNames) {
                    Integer grpId = (Integer)metadata.cacheNamesWithGroups().get(cacheName);
                    if (grpId == null) continue;
                    cacheGrpIds0.add(grpId);
                }
            }
            return cacheGrpIds0;
        }
    }
}

