/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.util.GridUnsafe;
import org.gridgain.grid.internal.io.SnapshotReadableByteChannel;

public class SnapshotReadableByteChannelInputStream
extends InputStream {
    public static final int DEFAULT_INPUT_STREAM_BUFFER_SIZE = 4096;
    private final SnapshotReadableByteChannel delegate;
    private final ByteBuffer buffer;
    private volatile boolean closed;
    private final byte[] singleByteArray = new byte[]{0};

    public SnapshotReadableByteChannelInputStream(SnapshotReadableByteChannel delegate, int bufferSize) {
        this.delegate = delegate;
        this.buffer = GridUnsafe.allocateBuffer((int)bufferSize);
        this.buffer.position(bufferSize);
    }

    @Override
    public int read() throws IOException {
        if (this.read(this.singleByteArray) < 0) {
            return -1;
        }
        return this.singleByteArray[0] & 0xFF;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.buffer.rewind();
            while (this.buffer.hasRemaining() && this.delegate.read(this.buffer) >= 0) {
            }
            this.buffer.flip();
        }
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        int size = Math.min(this.buffer.remaining(), len);
        this.buffer.get(bytes, off, size);
        return size;
    }

    @Override
    public long skip(long l) throws IOException {
        throw new UnsupportedOperationException("skip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.delegate.close();
        if (!this.closed) {
            SnapshotReadableByteChannelInputStream snapshotReadableByteChannelInputStream = this;
            synchronized (snapshotReadableByteChannelInputStream) {
                if (!this.closed) {
                    GridUnsafe.freeBuffer((ByteBuffer)this.buffer);
                    this.closed = true;
                }
            }
        }
    }
}

