/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.MessageDigest;
import org.gridgain.grid.internal.io.SnapshotReadableByteChannel;

public class GridReadableDigestByteChannel
extends AbstractInterruptibleChannel
implements SnapshotReadableByteChannel {
    private final ReadableByteChannel channel;
    private final MessageDigest digest;

    public GridReadableDigestByteChannel(ReadableByteChannel channel, MessageDigest digest) {
        this.channel = channel;
        this.digest = digest;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int position = dst.position();
        int res = this.channel.read(dst);
        if (res != -1) {
            ByteBuffer buffer = dst.asReadOnlyBuffer();
            buffer.flip();
            buffer.position(position);
            this.digest.update(buffer);
        }
        return res;
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.channel.close();
    }
}

