/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.compression;

import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FrameInputStream;
import net.jpountz.lz4.LZ4FrameOutputStream;
import net.jpountz.xxhash.XXHashFactory;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.xerial.snappy.SnappyFramedInputStream;
import org.xerial.snappy.SnappyFramedOutputStream;

public class SnapshotCompressionUtils {
    private static final int COPY_BUFFER_SIZE = IgniteSystemProperties.getInteger((String)"GG_SNAPSHOT_COPY_LARGE_BUFFER_SIZE", (int)8192);

    private SnapshotCompressionUtils() {
    }

    public static OutputStream wrapWithCompression(OutputStream original, CompressionOption codec, int compressionLevel, String zipEntryName) throws IOException {
        switch (codec) {
            case ZIP: {
                assert (!F.isEmpty((String)zipEntryName)) : "Invalid zip entry name";
                return SnapshotCompressionUtils.wrapWithZipCompression(original, compressionLevel, zipEntryName);
            }
            case ZSTD: {
                return SnapshotCompressionUtils.wrapWithZstdCompression(original, compressionLevel);
            }
            case LZ4: {
                return SnapshotCompressionUtils.wrapWithLz4Compression(original, compressionLevel);
            }
            case SNAPPY: {
                return SnapshotCompressionUtils.wrapWithSnappyCompression(original);
            }
        }
        throw new IgniteException("Unsupported compression option: " + codec);
    }

    public static ZipOutputStream wrapWithZipCompression(OutputStream original, int compressionLevel, String zipEntryName) throws IOException {
        ZipOutputStream stream = new ZipOutputStream(new BufferedOutputStream(original, COPY_BUFFER_SIZE));
        SnapshotCompressionUtils.ensureCompressionLevel(CompressionOption.ZIP, compressionLevel);
        stream.setLevel(compressionLevel);
        stream.putNextEntry(new ZipEntry(zipEntryName));
        return stream;
    }

    public static ZstdOutputStream wrapWithZstdCompression(OutputStream original, int compressionLevel) throws IOException {
        ZstdOutputStream stream = new ZstdOutputStream(original);
        SnapshotCompressionUtils.ensureCompressionLevel(CompressionOption.ZSTD, compressionLevel);
        stream.setLevel(compressionLevel);
        return stream;
    }

    public static LZ4FrameOutputStream wrapWithLz4Compression(OutputStream original, int compressionLevel) throws IOException {
        SnapshotCompressionUtils.ensureCompressionLevel(CompressionOption.LZ4, compressionLevel);
        LZ4Compressor compressor = compressionLevel == 0 ? LZ4Factory.fastestInstance().fastCompressor() : LZ4Factory.fastestInstance().highCompressor(compressionLevel);
        return new LZ4FrameOutputStream(original, LZ4FrameOutputStream.BLOCKSIZE.SIZE_4MB, -1L, compressor, XXHashFactory.fastestInstance().hash32(), new LZ4FrameOutputStream.FLG.Bits[]{LZ4FrameOutputStream.FLG.Bits.BLOCK_INDEPENDENCE});
    }

    public static SnappyFramedOutputStream wrapWithSnappyCompression(OutputStream original) throws IOException {
        return new SnappyFramedOutputStream(original);
    }

    public static ZipInputStream openZipInputStream(String compressedFile, InputStream inputStream, String zipEntryName) {
        ZipEntry entry;
        ZipInputStream zipInputStream;
        try {
            zipInputStream = new ZipInputStream(inputStream);
            entry = zipInputStream.getNextEntry();
        }
        catch (IOException e) {
            throw new IgniteException((Throwable)e);
        }
        if (entry == null || !entry.getName().equals(zipEntryName)) {
            U.closeQuiet((AutoCloseable)zipInputStream);
            throw new IgniteException("Archive file " + compressedFile + " is corrupted! [expectedEntry=" + zipEntryName + ", realEntry=" + (entry == null ? null : entry.getName()) + ']');
        }
        return zipInputStream;
    }

    public static ZstdInputStream openZstdInputStream(InputStream inputStream) {
        ZstdInputStream stream;
        try {
            stream = new ZstdInputStream(inputStream);
        }
        catch (IOException e) {
            throw new IgniteException((Throwable)e);
        }
        return stream;
    }

    public static LZ4FrameInputStream openLz4InputStream(InputStream inputStream) {
        LZ4FrameInputStream stream;
        try {
            stream = new LZ4FrameInputStream(inputStream);
        }
        catch (IOException e) {
            throw new IgniteException((Throwable)e);
        }
        return stream;
    }

    public static SnappyFramedInputStream openSnappyInputStream(InputStream inputStream) {
        SnappyFramedInputStream stream;
        try {
            stream = new SnappyFramedInputStream(inputStream);
        }
        catch (IOException e) {
            throw new IgniteException((Throwable)e);
        }
        return stream;
    }

    private static void ensureCompressionLevel(CompressionOption codec, int compressionLvl) {
        if (!codec.isCompressionLvlValid(compressionLvl)) {
            throw new IgniteException("Requested invalid compression level [compressionCodec=" + codec + ", requestedLvl=" + compressionLvl + ']');
        }
    }
}

