/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file.remote;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.TestUtils;
import org.gridgain.grid.configuration.SftpConfiguration;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotRemotePath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.sftp.InmemorySftpServerRule;
import org.gridgain.grid.persistentstore.SnapshotPath;
import org.gridgain.grid.persistentstore.snapshot.file.remote.SnapshotPathFactory;
import org.gridgain.grid.persistentstore.snapshot.file.remote.VFS2SnapshotPath;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class SnapshotPathFactoryTest
extends GridCommonAbstractTest {
    private static final String LOGIN = "login";
    private static final String PASSWORD = "password";

    @Test
    public void nullFileTest() {
        SnapshotPathFactoryTest.assertNull((Object)SnapshotPathFactory.create(null, null));
    }

    @Test
    public void regularFileTest() {
        File file = new File("test.idx");
        org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath snapshotPath = SnapshotPathFactory.create((SnapshotRemotePath)new SnapshotRemotePath(file), null);
        SnapshotPathFactoryTest.assertEquals(FsSnapshotPath.class, snapshotPath.getClass());
        SnapshotPathFactoryTest.assertSame((Object)file, (Object)((FsSnapshotPath)snapshotPath).getFile());
    }

    @Test
    public void sftpPrefixInFileNoServerTest() throws URISyntaxException {
        String filePath = "sftp:/login:password@127.0.0.1:239/folder0/test.idx";
        SnapshotRemotePath path = this.createPath(filePath, null);
        Throwable throwable = GridTestUtils.assertThrows(null, () -> SnapshotPathFactory.create((SnapshotRemotePath)path, null), IgniteException.class, (String)("Invalid destination path. " + filePath));
        SnapshotPathFactoryTest.assertEquals(FileSystemException.class, throwable.getCause().getClass());
    }

    @Test
    public void sftpSshKeyPositiveTest() throws Exception {
        Path publicKeyPath = Paths.get(TestUtils.TEST_ROOT, "snapshot/myKey.pub");
        Path privateKeyPath = Paths.get(TestUtils.TEST_ROOT, "snapshot/node.jks");
        try (InmemorySftpServerRule server = InmemorySftpServerRule.createServer(LOGIN, publicKeyPath);){
            String filePath = this.getSftpPath(server).replace(":password", "");
            SnapshotRemotePath file = this.createPath(filePath, "sftp");
            String privateKey = privateKeyPath.toFile().getAbsoluteFile().getPath();
            org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath snapshotPath = SnapshotPathFactory.create((SnapshotRemotePath)file, (SftpConfiguration)new SftpConfiguration().setKeyPath(privateKey).setPassphrase("123456"));
            SnapshotPathFactoryTest.assertEquals(VFS2SnapshotPath.class, snapshotPath.getClass());
            SnapshotPathFactoryTest.assertEquals((String)filePath, (String)((VFS2SnapshotPath)snapshotPath).getFileObject().getPublicURIString());
        }
    }

    @Test
    public void sftpSshKeyIncorrectPrivateKeyPasswordTest() throws Exception {
        Path publicKeyPath = Paths.get(TestUtils.TEST_ROOT, "snapshot/myKey.pub");
        Path privateKeyPath = Paths.get(TestUtils.TEST_ROOT, "snapshot/node.jks");
        try (InmemorySftpServerRule server = InmemorySftpServerRule.createServer(LOGIN, publicKeyPath);){
            String filePath = this.getSftpPath(server).replace(":password", "");
            SnapshotRemotePath file = this.createPath(filePath, "sftp");
            filePath = file.uri().toString();
            String privateKey = privateKeyPath.toFile().getAbsoluteFile().getPath();
            GridTestUtils.assertThrows(null, () -> SnapshotPathFactory.create((SnapshotRemotePath)file, (SftpConfiguration)new SftpConfiguration().setKeyPath(privateKey).setPassphrase("1234563")), IgniteException.class, (String)("Invalid destination path. " + filePath));
        }
    }

    @Test
    public void sftpSshKeyIncorrectPublicKeyTest() throws Exception {
        Path privateKeyPath = Paths.get(TestUtils.TEST_ROOT, "snapshot/node.jks");
        try (InmemorySftpServerRule server = InmemorySftpServerRule.createServer(LOGIN, PASSWORD);){
            String filePath = this.getSftpPath(server).replace(":password", "");
            SnapshotRemotePath file = this.createPath(filePath, "sftp");
            filePath = file.uri().toString();
            String privateKey = privateKeyPath.toFile().getAbsoluteFile().getPath();
            GridTestUtils.assertThrows(null, () -> SnapshotPathFactory.create((SnapshotRemotePath)file, (SftpConfiguration)new SftpConfiguration().setKeyPath(privateKey).setPassphrase("123456")), IgniteException.class, (String)("Invalid destination path. " + filePath));
        }
    }

    @NotNull
    private String getSftpPath(InmemorySftpServerRule server) {
        return "sftp://login:password@127.0.0.1:" + server.getPort() + "/folder0/test.idx";
    }

    @NotNull
    private SnapshotRemotePath createPath(String filePath, String alias) throws URISyntaxException {
        return new SnapshotRemotePath(SnapshotPath.sftp().keyAlias(alias).uri(new URI(filePath)).build());
    }
}

