/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.lang.management.ThreadInfo;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteFutureCancelledException;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.thread.IgniteThread;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutScheduler;
import org.gridgain.grid.internal.txdr.GridGainTxDrConfiguration;
import org.gridgain.grid.internal.txdr.TransactionalDrConfiguration;
import org.gridgain.grid.internal.txdr.TransactionalDrMaster;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ConsistentCutSchedulerTest
extends GridCommonAbstractTest {
    private static final Path TRANSFER_DIR = Paths.get(System.getProperty("java.io.tmpdir"), "_tf_" + UUID.randomUUID().toString());
    private static final Path SNAPSHOT_DIR = Paths.get(System.getProperty("java.io.tmpdir"), "_sd_" + UUID.randomUUID().toString());
    private static final Path SNAPSHOT_TRANSFER_DIR = Paths.get(System.getProperty("java.io.tmpdir"), "_sfd_" + UUID.randomUUID().toString());
    private static final int DELAY_MEASUREMENT_ERROR = 100;

    @Test
    public void testInstantCutCount() throws Exception {
        SnapshotFuture fut = (SnapshotFuture)Mockito.mock(SnapshotFuture.class);
        Mockito.when((Object)fut.get(Matchers.anyLong())).thenReturn(null);
        GridSnapshotManager mgr = (GridSnapshotManager)Mockito.mock(GridSnapshotManager.class);
        Mockito.when((Object)mgr.startGlobalConsistentCut()).thenReturn((Object)fut);
        ConsistentCutScheduler ccScheduler = new ConsistentCutScheduler("test-ignite", log, mgr, 500L);
        IgniteThread ccSchedulerThread = new IgniteThread((GridWorker)ccScheduler);
        ccSchedulerThread.start();
        U.sleep((long)2100L);
        ccScheduler.cancel();
        ccSchedulerThread.join();
        ((GridSnapshotManager)Mockito.verify((Object)mgr, (VerificationMode)Mockito.times((int)4))).startGlobalConsistentCut();
    }

    @Test
    public void testTimeConsumingCutCount() throws Exception {
        SnapshotFuture fut = (SnapshotFuture)Mockito.mock(SnapshotFuture.class);
        Mockito.when((Object)fut.get()).thenAnswer(invocation -> {
            U.sleep((long)250L);
            return null;
        });
        GridSnapshotManager mgr = (GridSnapshotManager)Mockito.mock(GridSnapshotManager.class);
        Mockito.when((Object)mgr.startGlobalConsistentCut()).thenReturn((Object)fut);
        ConsistentCutScheduler ccScheduler = new ConsistentCutScheduler("test-ignite", log, mgr, 500L);
        IgniteThread ccSchedulerThread = new IgniteThread((GridWorker)ccScheduler);
        ccSchedulerThread.start();
        U.sleep((long)2350L);
        ccScheduler.cancel();
        ccSchedulerThread.join();
        ((GridSnapshotManager)Mockito.verify((Object)mgr, (VerificationMode)Mockito.times((int)3))).startGlobalConsistentCut();
    }

    @Test
    public void testCutCreationFailures() throws Exception {
        AtomicBoolean stop = new AtomicBoolean();
        SnapshotFuture fut = (SnapshotFuture)Mockito.mock(SnapshotFuture.class);
        Mockito.when((Object)fut.get()).thenThrow(new Throwable[]{new IgniteFutureCancelledException("")}).thenThrow(new Throwable[]{new IgniteException()}).thenThrow(new Throwable[]{new RuntimeException()}).thenAnswer(invocation -> {
            stop.set(true);
            return null;
        });
        GridSnapshotManager mgr = (GridSnapshotManager)Mockito.mock(GridSnapshotManager.class);
        Mockito.when((Object)mgr.startGlobalConsistentCut()).thenReturn((Object)fut);
        ConsistentCutScheduler ccScheduler = new ConsistentCutScheduler("test-ignite", log, mgr, 500L);
        IgniteThread ccSchedulerThread = new IgniteThread((GridWorker)ccScheduler);
        ccSchedulerThread.start();
        Assert.assertTrue((boolean)GridTestUtils.waitForCondition(stop::get, (long)2300L));
        ccScheduler.cancel();
        ccSchedulerThread.join();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        DataStorageConfiguration dsCfg = new DataStorageConfiguration();
        dsCfg.getDefaultDataRegionConfiguration().setPersistenceEnabled(true).setMaxSize(0xA00000L);
        cfg.setDataStorageConfiguration(dsCfg);
        GridGainTxDrConfiguration ggCfg = new GridGainTxDrConfiguration();
        ggCfg.setTxDrConfiguration(new TransactionalDrConfiguration().setTransferFolderPath(TRANSFER_DIR.toString()).setConsistentCutInterval(30000L));
        ggCfg.setSnapshotConfiguration(new SnapshotConfiguration().setSnapshotsPath(SNAPSHOT_DIR + "/" + igniteInstanceName));
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        return cfg;
    }

    protected void cleanupDbFiles() throws Exception {
        this.cleanPersistenceDir();
        U.delete((Path)SNAPSHOT_DIR);
        U.delete((Path)TRANSFER_DIR);
        U.delete((Path)SNAPSHOT_TRANSFER_DIR);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanupDbFiles();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanupDbFiles();
        super.afterTest();
    }

    @Test
    public void testWorkerResurrectionOnNewCoordinator() throws Exception {
        this.startGrids(3);
        this.grid(0).cluster().active(true);
        this.grid(0).getOrCreateCache(new CacheConfiguration("test-resurrection-on-new-coordinator").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL));
        GridGainImpl gg = (GridGainImpl)this.grid(0).plugin("GridGain");
        AbstractReplicationTest.bootstrapMaster((TransactionalDrMaster)gg.txDr(), SNAPSHOT_TRANSFER_DIR.toFile()).get();
        Assert.assertTrue((boolean)ConsistentCutSchedulerTest.schedulerThreadExists());
        ClusterNode crd = SnapshotUtils.getSnapshotCrd((AffinityTopologyVersion)AffinityTopologyVersion.NONE, (GridCacheSharedContext)this.grid(0).context().cache().context());
        this.grid(this.grid(0).context().discovery().node(crd.id())).close();
        this.waitForTopology(2);
        Assert.assertTrue((boolean)GridTestUtils.waitForCondition(ConsistentCutSchedulerTest::schedulerThreadExists, (long)15000L));
    }

    private static boolean schedulerThreadExists() {
        return Arrays.stream(U.getThreadMx().dumpAllThreads(false, false)).map(ThreadInfo::getThreadName).anyMatch(name -> name.startsWith("cc-scheduler"));
    }
}

