/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.messages.SnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Assert;
import org.junit.Test;

public class ConsistentCutOnTopologyChangeTest
extends AbstractReplicationTest {
    private CountDownLatch stageOfConsistentCutOccurs;
    private CountDownLatch nextStepLatch;
    private SnapshotOperationStage stage;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setCommunicationSpi((CommunicationSpi)new TestCommunicationSpi(this.stage));
        return cfg;
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stageOfConsistentCutOccurs = new CountDownLatch(this.nodesCnt - 1);
        this.nextStepLatch = new CountDownLatch(1);
    }

    @Test
    public void testMajorTopologyChangeAfterFirstStage() throws Exception {
        this.testConsistentCutCreationWhenNodeFails(this.nodesCnt - 1, SnapshotOperationStage.FIRST, true);
    }

    @Test
    public void testMajorTopologyChangeAfterFirstStageCoordinatorFailure() throws Exception {
        this.testConsistentCutCreationWhenNodeFails(0, SnapshotOperationStage.FIRST, true);
    }

    @Test
    public void testMajorTopologyChangeAfterSecondStage() throws Exception {
        this.testConsistentCutCreationWhenNodeFails(this.nodesCnt - 1, SnapshotOperationStage.SECOND, true);
    }

    @Test
    public void testMajorTopologyChangeAfterThirdStage() throws Exception {
        this.testConsistentCutCreationWhenNodeFails(this.nodesCnt - 1, SnapshotOperationStage.THIRD, false);
    }

    @Test
    public void testMajorTopologyChangeAfterFourthStage() throws Exception {
        this.testConsistentCutCreationWhenNodeFails(this.nodesCnt - 1, SnapshotOperationStage.FOURTH, false);
    }

    private void testConsistentCutCreationWhenNodeFails(int nodeToStop, SnapshotOperationStage stage, boolean emptyConsistentCuts) throws Exception {
        this.stage = stage;
        List<IgniteEx> cluster = this.startCluster(ClusterRole.DISABLED);
        IgniteEx initiatorNode = cluster.get((nodeToStop + 1) % this.nodesCnt);
        ConsistentCutOnTopologyChangeTest.replaceTransactionalProcessor(cluster);
        this.populateData((Ignite)initiatorNode, "txCache");
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)initiatorNode.context().cache().context().snapshot();
        long topVer = initiatorNode.cluster().topologyVersion();
        log.info("Topology version before consistent cut is " + topVer);
        SnapshotFuture ccFut = snapMgr.startGlobalConsistentCut();
        this.stageOfConsistentCutOccurs.await();
        this.stopGrid(this.getTestIgniteInstanceName(nodeToStop), true);
        this.nextStepLatch.countDown();
        ccFut.get();
        log.info("Topology version after consistent cut is " + initiatorNode.cluster().topologyVersion());
        Assert.assertNotEquals((String)"Major topology version must change", (long)initiatorNode.cluster().topologyVersion(), (long)topVer);
        ConsistentCutOnTopologyChangeTest.assertEquals((boolean)emptyConsistentCuts, (boolean)this.checkConsistentStoresAreEmpty());
    }

    @Test
    public void testMinorTopologyChangeAfterFirstStage() throws Exception {
        this.testConsistentCutCreationWhenCacheCreates(SnapshotOperationStage.FIRST, true);
    }

    @Test
    public void testMinorTopologyChangeAfterSecondStage() throws Exception {
        this.testConsistentCutCreationWhenCacheCreates(SnapshotOperationStage.SECOND, true);
    }

    @Test
    public void testMinorTopologyChangeAfterThirdStage() throws Exception {
        this.testConsistentCutCreationWhenCacheCreates(SnapshotOperationStage.THIRD, false);
    }

    @Test
    public void testMinorTopologyChangeAfterFourthStage() throws Exception {
        this.testConsistentCutCreationWhenCacheCreates(SnapshotOperationStage.FOURTH, false);
    }

    private void testConsistentCutCreationWhenCacheCreates(SnapshotOperationStage stage, boolean emptyConsistentCuts) throws Exception {
        this.stage = stage;
        List<IgniteEx> cluster = this.startCluster(ClusterRole.DISABLED);
        IgniteEx initiatorNode = cluster.get(0);
        ConsistentCutOnTopologyChangeTest.replaceTransactionalProcessor(cluster);
        this.populateData((Ignite)initiatorNode, "txCache");
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)initiatorNode.context().cache().context().snapshot();
        SnapshotFuture ccFut = snapMgr.startGlobalConsistentCut();
        this.stageOfConsistentCutOccurs.await();
        initiatorNode.getOrCreateCache(new CacheConfiguration("new-cache").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL));
        this.nextStepLatch.countDown();
        ccFut.get();
        ConsistentCutOnTopologyChangeTest.assertEquals((boolean)emptyConsistentCuts, (boolean)this.checkConsistentStoresAreEmpty());
    }

    private boolean checkConsistentStoresAreEmpty() throws IgniteCheckedException {
        boolean res = true;
        for (Ignite ig : G.allGrids()) {
            if (((IgniteEx)ig).localNode().isClient()) continue;
            res &= this.txdr(ig).consistentCutStore().list().isEmpty();
        }
        return res;
    }

    class TestCommunicationSpi
    extends TcpCommunicationSpi {
        private final SnapshotOperationStage stage;

        TestCommunicationSpi(SnapshotOperationStage stage) {
            this.stage = stage;
        }

        public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) throws IgniteSpiException {
            SnapshotOperationStageFinishedMessage cwMsg;
            GridIoMessage ioMsg;
            if (msg instanceof GridIoMessage && (ioMsg = (GridIoMessage)msg).message() instanceof SnapshotOperationStageFinishedMessage && (cwMsg = (SnapshotOperationStageFinishedMessage)ioMsg.message()).stage() == this.stage) {
                ConsistentCutOnTopologyChangeTest.this.stageOfConsistentCutOccurs.countDown();
                try {
                    ConsistentCutOnTopologyChangeTest.this.nextStepLatch.await();
                }
                catch (InterruptedException e) {
                    throw new IgniteSpiException((Throwable)e);
                }
            }
            super.sendMessage(node, msg, ackC);
        }
    }
}

