/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.sftp;

import com.github.marschall.memoryfilesystem.MemoryFileSystemBuilder;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.security.PublicKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.config.keys.DefaultAuthorizedKeysAuthenticator;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.shell.ProcessShellCommandFactory;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;
import org.jetbrains.annotations.NotNull;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class InmemorySftpServerRule
implements TestRule,
AutoCloseable {
    private final Map<String, String> usernamesAndPasswords = new HashMap<String, String>();
    private final Map<String, Path> usernamesAndIdentities = new HashMap<String, Path>();
    private int port = 0;
    private FileSystem fileSystem;
    private SshServer server;

    public int getPort() {
        if (this.server == null || !this.server.isStarted()) {
            throw new IllegalStateException("SFPT is not started or not active");
        }
        return this.server.getPort();
    }

    public InmemorySftpServerRule addUser(String username, String password) {
        this.usernamesAndPasswords.put(username, password);
        return this;
    }

    public InmemorySftpServerRule addIdentity(String username, Path identityPath) {
        this.usernamesAndIdentities.put(username, identityPath);
        return this;
    }

    public boolean fileExists(String path) {
        return Files.exists(this.fileSystem.getPath(path, new String[0]), new LinkOption[0]);
    }

    public void deleteAllFilesAndDirectories() throws IOException {
        for (Path directory : this.fileSystem.getRootDirectories()) {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (dir.getParent() != null) {
                        Files.delete(dir);
                    }
                    return super.postVisitDirectory(dir, exc);
                }
            });
        }
    }

    public void deleteAllFilesInDirectory(String dir) throws IOException {
        Path path = this.fileSystem.getPath(dir, new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (dir.getParent() != null) {
                        Files.delete(dir);
                    }
                    return super.postVisitDirectory(dir, exc);
                }
            });
            Files.createDirectories(path, new FileAttribute[0]);
        }
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try (FileSystem fileSystem = InmemorySftpServerRule.this.createFileSystem();){
                    InmemorySftpServerRule.this.startServer(fileSystem);
                    try {
                        base.evaluate();
                    }
                    finally {
                        InmemorySftpServerRule.this.server.stop();
                        InmemorySftpServerRule.this.server = null;
                    }
                }
                finally {
                    InmemorySftpServerRule.this.fileSystem = null;
                }
            }
        };
    }

    public static InmemorySftpServerRule createServer(@NotNull String login, @NotNull String password) throws IOException {
        InmemorySftpServerRule rule = new InmemorySftpServerRule();
        rule.addUser(login, password);
        FileSystem fileSystem = rule.createFileSystem();
        rule.startServer(fileSystem);
        return rule;
    }

    public static InmemorySftpServerRule createServer(@NotNull String login, @NotNull Path publicKey) throws IOException {
        InmemorySftpServerRule rule = new InmemorySftpServerRule();
        rule.addIdentity(login, publicKey);
        FileSystem fileSystem = rule.createFileSystem();
        rule.startServer(fileSystem);
        return rule;
    }

    @Override
    public void close() throws Exception {
        try {
            this.server.stop();
            this.server = null;
        }
        finally {
            this.fileSystem = null;
        }
    }

    private FileSystem createFileSystem() throws IOException {
        this.fileSystem = MemoryFileSystemBuilder.newLinux().build("InmemorySftpServerRule@" + this.hashCode());
        return this.fileSystem;
    }

    private SshServer startServer(FileSystem fileSystem) throws IOException {
        SshServer server = SshServer.setUpDefaultServer();
        server.setPort(this.port);
        server.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider());
        server.setPasswordAuthenticator(this::authenticate);
        server.setPublickeyAuthenticator(this::authenticatePublicKey);
        server.setSubsystemFactories(Collections.singletonList(new SftpSubsystemFactory()));
        server.setCommandFactory((CommandFactory)new ProcessShellCommandFactory());
        server.setFileSystemFactory(session -> new FSWrapper(fileSystem));
        server.start();
        this.server = server;
        return server;
    }

    private boolean authenticate(String username, String password, ServerSession session) {
        return this.usernamesAndPasswords.containsKey(username) && this.usernamesAndPasswords.get(username).equals(password);
    }

    private boolean authenticatePublicKey(String username, PublicKey publicKey, ServerSession session) {
        if (!this.usernamesAndIdentities.containsKey(username)) {
            return false;
        }
        Path path = this.usernamesAndIdentities.get(username);
        return new DefaultAuthorizedKeysAuthenticator(username, path, false, new LinkOption[0]).authenticate(username, publicKey, session);
    }

    private static class FSWrapper
    extends FileSystem {
        private final FileSystem fileSystem;

        FSWrapper(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
        }

        @Override
        public FileSystemProvider provider() {
            return this.fileSystem.provider();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean isOpen() {
            return this.fileSystem.isOpen();
        }

        @Override
        public boolean isReadOnly() {
            return this.fileSystem.isReadOnly();
        }

        @Override
        public String getSeparator() {
            return this.fileSystem.getSeparator();
        }

        @Override
        public Iterable<Path> getRootDirectories() {
            return this.fileSystem.getRootDirectories();
        }

        @Override
        public Iterable<FileStore> getFileStores() {
            return this.fileSystem.getFileStores();
        }

        @Override
        public Set<String> supportedFileAttributeViews() {
            return this.fileSystem.supportedFileAttributeViews();
        }

        @Override
        public Path getPath(String first, String ... more) {
            return this.fileSystem.getPath(first, more);
        }

        @Override
        public PathMatcher getPathMatcher(String syntaxAndPattern) {
            return this.fileSystem.getPathMatcher(syntaxAndPattern);
        }

        @Override
        public UserPrincipalLookupService getUserPrincipalLookupService() {
            return this.fileSystem.getUserPrincipalLookupService();
        }

        @Override
        public WatchService newWatchService() throws IOException {
            return this.fileSystem.newWatchService();
        }
    }
}

