/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointState;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointHistory;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.util.typedef.internal.GPC;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.DatabaseSnapshotSpi;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class GridPointInTimeRecoveryMoveOrDeleteSnapshotTest
extends GridPointInTimeRecoveryAbstractTest {
    private File movedSnapshotsDir;

    @Override
    protected IgniteConfiguration getConfiguration(String name) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(name);
        cfg.getDataStorageConfiguration().setWalSegmentSize(524288);
        return cfg;
    }

    @Override
    protected CacheConfiguration[] prepareCachesConfiguration() {
        return new CacheConfiguration[]{new CacheConfiguration("default")};
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.movedSnapshotsDir = new File(U.defaultWorkDirectory(), "movedsnapshots");
        U.delete((File)this.movedSnapshotsDir);
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        U.delete((File)this.movedSnapshotsDir);
    }

    @Test
    public void testSnapshotMoveAfterRestart() throws Exception {
        IgniteEx ig = this.startGrid(0);
        ig.cluster().active(true);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        AtomicLong keyGenerator = new AtomicLong();
        this.loadData(keyGenerator, (Ignite)ig);
        SnapshotFuture snp1 = gg.snapshot().createFullSnapshot(null, null);
        snp1.get();
        this.stopGrid(0);
        ig = this.startGrid(0);
        gg = (GridGain)ig.plugin("GridGain");
        this.loadData(keyGenerator, (Ignite)ig);
        gg.snapshot().createFullSnapshot(null, null).get();
        gg.snapshot().moveSnapshot(snp1.snapshotOperation().snapshotId(), this.movedSnapshotsDir, false, null).get();
    }

    @Test
    public void testSnapshotMove() throws Exception {
        IgniteEx ig = this.startGrids(1);
        ig.cluster().active(true);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        AtomicLong keyGenerator = new AtomicLong();
        this.loadData(keyGenerator, (Ignite)ig);
        final GridSnapshot ggSnapshots = gg.snapshot();
        SnapshotFuture snp1 = ggSnapshots.createFullSnapshot(null, null);
        snp1.get();
        this.loadData(keyGenerator, (Ignite)ig);
        SnapshotFuture snp2 = ggSnapshots.createSnapshot(null, null);
        snp2.get();
        this.loadData(keyGenerator, (Ignite)ig);
        final SnapshotFuture snp3 = ggSnapshots.createSnapshot(null, null);
        snp3.get();
        this.loadData(keyGenerator, (Ignite)ig);
        SnapshotFuture snp4 = ggSnapshots.createSnapshot(null, null);
        snp4.get();
        this.loadData(keyGenerator, (Ignite)ig);
        ggSnapshots.createFullSnapshot(null, null).get();
        this.loadData(keyGenerator, (Ignite)ig);
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new GPC<Object>(){

            public Object call() throws Exception {
                return ggSnapshots.moveSnapshot(snp3.snapshotOperation().snapshotId(), GridPointInTimeRecoveryMoveOrDeleteSnapshotTest.this.movedSnapshotsDir, null).get();
            }
        }, IgniteException.class, null);
        log.warning("Force move snapshot 3 [snapshotId=" + snp3.snapshotOperation().snapshotId() + " ,type=inc] ");
        ggSnapshots.forceMoveSnapshot(snp3.snapshotOperation().snapshotId(), this.movedSnapshotsDir, null).get();
        log.warning("Finished force move snapshot 3 [snapshotId=" + snp3.snapshotOperation().snapshotId() + " ,type=inc] ");
        log.warning("Move snapshot 2 [snapshotId=" + snp2.snapshotOperation().snapshotId() + " ,type=inc] ");
        ggSnapshots.moveSnapshot(snp2.snapshotOperation().snapshotId(), this.movedSnapshotsDir, null).get();
        log.warning("Finished move snapshot 2 [snapshotId=" + snp2.snapshotOperation().snapshotId() + " ,type=inc] ");
        log.warning("Move snapshot 1 [snapshotId=" + snp1.snapshotOperation().snapshotId() + " ,type=full] ");
        ggSnapshots.moveSnapshot(snp1.snapshotOperation().snapshotId(), this.movedSnapshotsDir, null).get();
        log.warning("Finished move snapshot 1 [snapshotId=" + snp1.snapshotOperation().snapshotId() + " ,type=full] ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotMoveAfterWalFilesWereDeleted() throws Exception {
        int i;
        int nodesCnt = 3;
        IgniteEx ig = this.startGrids(nodesCnt);
        ig.cluster().active(true);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        AtomicLong keyGenerator = new AtomicLong();
        GridSnapshot ggSnapshots = gg.snapshot();
        SnapshotFuture<Void> snp0 = this.makeFullSnapshot((Ignite)ig, keyGenerator, ggSnapshots);
        SnapshotFuture<Void> snp1 = this.makeFullSnapshot((Ignite)ig, keyGenerator, ggSnapshots);
        SnapshotFuture<Void> snp2 = this.makeFullSnapshot((Ignite)ig, keyGenerator, ggSnapshots);
        this.stopAllGrids();
        this.removeWalFromOneNode((Ignite)ig);
        ig = this.startGrids(nodesCnt);
        ig.cluster().active(true);
        gg = (GridGain)ig.plugin("GridGain");
        ggSnapshots = gg.snapshot();
        ggSnapshots.moveSnapshot(snp0.snapshotOperation().snapshotId(), this.movedSnapshotsDir, null).get(this.getTestTimeout());
        for (i = 0; i < 20; ++i) {
            this.loadData(keyGenerator, (Ignite)ig);
        }
        ig.context().cache().context().database().forceCheckpoint("test").futureFor(CheckpointState.FINISHED).get();
        for (i = 0; i < 10; ++i) {
            this.loadData(keyGenerator, (Ignite)ig);
        }
        IgniteWriteAheadLogManager wal = ig.context().cache().context().wal();
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)ig.context().cache().context().snapshot();
        SnapshotMetadataV2 snap1Meta = snapMgr.snapshotSpi().snapshot(snp1.snapshotOperation().snapshotId(), null, null, true, null, false).metadata();
        FileWALPointer snap1WalPtr = (FileWALPointer)snap1Meta.walPoints().values().iterator().next();
        CheckpointHistory cpHist = ((GridCacheDatabaseSharedManager)ig.context().cache().context().database()).checkpointHistory();
        ArrayList oldCpHist = new ArrayList(cpHist.checkpoints());
        try (WALIterator it = wal.replay((WALPointer)new FileWALPointer(snap1WalPtr.index(), 0, 0));){
            it.next();
        }
        File movedSnapshotsDir = new File(U.defaultWorkDirectory(), "tempmovedsnapshots");
        try {
            SnapshotFuture snpMove = gg.snapshot().moveSnapshot(snp1.snapshotOperation().snapshotId(), movedSnapshotsDir, true, new SnapshotUpdateOperationParams(SnapshotChainMode.FROM_CURRENT_TO_LAST, false, false, null), null);
            snpMove.get();
            ArrayList newCpHist = new ArrayList(cpHist.checkpoints());
            MatcherAssert.assertThat((Object)newCpHist.size(), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(oldCpHist.size()))));
            GridPointInTimeRecoveryMoveOrDeleteSnapshotTest.assertEquals(oldCpHist, newCpHist.subList(0, oldCpHist.size()));
            try (WALIterator it = wal.replay((WALPointer)new FileWALPointer(snap1WalPtr.index(), 0, 0));){
                it.next();
            }
            Path movedSnapshotNodePath = this.getMovedSnapshotNodePath(ig, snp1, movedSnapshotsDir).getParent();
            int nodesCntWithSnapshot = 0;
            for (File movedSnapshotPathForNode : movedSnapshotNodePath.toFile().listFiles()) {
                if (movedSnapshotPathForNode.isFile()) continue;
                ++nodesCntWithSnapshot;
                GridPointInTimeRecoveryMoveOrDeleteSnapshotTest.assertFalse((boolean)Files.exists(Paths.get(movedSnapshotPathForNode.getAbsolutePath(), "wal"), new LinkOption[0]));
            }
            MatcherAssert.assertThat((Object)nodesCntWithSnapshot, (Matcher)Matchers.is((Object)nodesCnt));
            SnapshotFuture<Void> snp3 = this.makeFullSnapshot((Ignite)ig, keyGenerator, ggSnapshots);
            SnapshotFuture<Void> snp4 = this.makeFullSnapshot((Ignite)ig, keyGenerator, ggSnapshots);
            SnapshotFuture successMove = ggSnapshots.moveSnapshot(snp3.snapshotOperation().snapshotId(), movedSnapshotsDir, null);
            successMove.get();
            movedSnapshotNodePath = this.getMovedSnapshotNodePath(ig, snp3, movedSnapshotsDir);
            GridPointInTimeRecoveryMoveOrDeleteSnapshotTest.assertTrue((boolean)movedSnapshotNodePath.toFile().exists());
        }
        finally {
            U.delete((File)movedSnapshotsDir);
        }
    }

    @Test
    public void testSnapshotDeleteAfterWalFilesWereDeleted() throws Exception {
        int i;
        int nodesCnt = 3;
        IgniteEx ig = this.startGrids(nodesCnt);
        ig.cluster().state(ClusterState.ACTIVE);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        AtomicLong keyGenerator = new AtomicLong();
        GridSnapshotEx ggSnapshots = (GridSnapshotEx)gg.snapshot();
        this.makeFullSnapshot((Ignite)ig, keyGenerator, (GridSnapshot)ggSnapshots);
        Thread.sleep(250L);
        long time = System.currentTimeMillis();
        Thread.sleep(250L);
        SnapshotFuture<Void> snp2 = this.makeFullSnapshot((Ignite)ig, keyGenerator, (GridSnapshot)ggSnapshots);
        this.stopAllGrids();
        this.removeWalFromOneNode((Ignite)ig);
        ig = this.startGrids(nodesCnt);
        ig.cluster().state(ClusterState.ACTIVE);
        gg = (GridGain)ig.plugin("GridGain");
        ggSnapshots = (GridSnapshotEx)gg.snapshot();
        for (i = 0; i < 20; ++i) {
            this.loadData(keyGenerator, (Ignite)ig);
        }
        ig.context().cache().context().database().forceCheckpoint("test").futureFor(CheckpointState.FINISHED).get();
        for (i = 0; i < 10; ++i) {
            this.loadData(keyGenerator, (Ignite)ig);
        }
        IgniteWriteAheadLogManager wal = ig.context().cache().context().wal();
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)ig.context().cache().context().snapshot();
        SnapshotMetadataV2 snap1Meta = snapMgr.snapshotSpi().snapshot(snp2.snapshotOperation().snapshotId(), null, null, true, null, false).metadata();
        FileWALPointer snap1WalPtr = (FileWALPointer)snap1Meta.walPoints().values().iterator().next();
        CheckpointHistory cpHist = ((GridCacheDatabaseSharedManager)ig.context().cache().context().database()).checkpointHistory();
        ArrayList oldCpHist = new ArrayList(cpHist.checkpoints());
        try (WALIterator it = wal.replay((WALPointer)new FileWALPointer(snap1WalPtr.index(), 0, 0));){
            it.next();
        }
        this.makeFullSnapshot((Ignite)ig, keyGenerator, (GridSnapshot)ggSnapshots).get();
        SnapshotFuture snpDel = gg.snapshot().deleteSnapshot(snp2.snapshotOperation().snapshotId(), new SnapshotUpdateOperationParams(SnapshotChainMode.FROM_CURRENT_TO_LAST, false, false, null), null);
        snpDel.get();
        ArrayList newCpHist = new ArrayList(cpHist.checkpoints());
        MatcherAssert.assertThat((Object)newCpHist.size(), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(oldCpHist.size()))));
        GridPointInTimeRecoveryMoveOrDeleteSnapshotTest.assertEquals(oldCpHist, newCpHist.subList(0, oldCpHist.size()));
        try (WALIterator it = wal.replay((WALPointer)new FileWALPointer(snap1WalPtr.index(), 0, 0));){
            it.next();
        }
        SnapshotFuture recoveryFut = ggSnapshots.recoveryTo(time, null);
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> ((SnapshotFuture)recoveryFut).get(), IgniteCheckedException.class, (String)"WAL files have been deleted manually");
    }

    private Path getMovedSnapshotNodePath(IgniteEx ig, SnapshotFuture<Void> snp1, File movedSnapshotsDir) {
        DatabaseSnapshotSpi snapshotSpi = ((GridCacheSnapshotManager)ig.context().cache().context().snapshot()).snapshotSpi();
        return ((FsSnapshotPath)snapshotSpi.generateCurNodeSnapshotFolderPath((SnapshotPath)new FsSnapshotPath(movedSnapshotsDir), snp1.snapshotOperation().snapshotId())).getFile().toPath();
    }

    @NotNull
    private SnapshotFuture<Void> makeFullSnapshot(Ignite ig, AtomicLong keyGenerator, GridSnapshot ggSnapshots) {
        this.loadData(keyGenerator, ig);
        SnapshotFuture snp = ggSnapshots.createFullSnapshot(null, null);
        snp.get();
        return snp;
    }

    private void removeWalFromOneNode(Ignite ig) throws IgniteCheckedException {
        File workDirectory = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)this.storePath(), (boolean)false);
        String dirNameToDelete = U.maskForFileName((CharSequence)((String)((Object)ig.configuration().getConsistentId())));
        for (File persistenceDir : workDirectory.listFiles()) {
            String dirName = persistenceDir.getName();
            if (dirName.startsWith(dirNameToDelete)) {
                U.delete((Path)Paths.get(persistenceDir.getAbsolutePath(), "cp"));
                continue;
            }
            if (!dirName.startsWith("archive") && !dirName.startsWith("wal")) continue;
            U.delete((Path)Paths.get(persistenceDir.getAbsolutePath(), dirNameToDelete));
        }
    }

    private void loadData(AtomicLong keyGenerator, Ignite ig) {
        try (IgniteDataStreamer st = ig.dataStreamer("default");){
            st.allowOverwrite(true);
            for (int i = 0; i < 20; ++i) {
                st.addData((Object)keyGenerator.getAndIncrement(), (Object)new byte[1024]);
            }
        }
    }
}

