/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.SystemPropertiesList;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.TestSnapshotRegistryTransformer;
import org.gridgain.grid.internal.processors.cache.database.snapshot.DatabaseSnapshotSpi;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDigestRegistry;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.MessageDigestFactory;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotIssue;
import org.gridgain.grid.persistentstore.SnapshotRegistryTransformer;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.gridgain.grid.persistentstore.snapshot.file.FileSnapshot;
import org.gridgain.grid.persistentstore.snapshot.file.SnapshotDigestRegistryCache;
import org.gridgain.grid.persistentstore.snapshot.file.SnapshotInputStreamFactory;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

@SystemPropertiesList(value={@WithSystemProperty(key="GG_SNAPSHOT_SECURITY_FEATURE", value="true"), @WithSystemProperty(key="IGNITE_DISTRIBUTED_META_STORAGE_FEATURE", value="true")})
public class SnapshotRegistryContentErrorsTest
extends AbstractSnapshotTest {
    protected void beforeTestsStarted() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        File f = Paths.get(U.defaultWorkDirectory(), "db").toFile();
        if (f.exists()) {
            System.out.println("FILE_EXISTS " + f.toPath().toString());
        }
    }

    @Override
    protected SnapshotRegistryTransformer getRegistryTransformer() {
        return new TestSnapshotRegistryTransformer("secret");
    }

    @Test
    public void testRestoreMoved() throws Exception {
        this.doTestRestoreMoved(RegistryError.values());
    }

    @Test
    public void testRestoreLocalChain() throws Exception {
        this.doTestRestoreLocal(RegistryError.values());
    }

    @Test
    public void testCheckLocal() throws Exception {
        this.doTestCheckLocal(true, RegistryError.CORRUPTED_DATA_HASH, RegistryError.INVALID_SNAPSHOT_ID, RegistryError.INVALID_ALGO, RegistryError.INVALID_CONSISTENT_ID, RegistryError.CORRUPTED_META_HASH, RegistryError.MISSING_DATA_HASH);
    }

    @Test
    public void testCheckPartialyBrokenSnapshots() throws Exception {
        this.doTestCheckLocal(false, RegistryError.CORRUPTED_DATA_HASH, RegistryError.INVALID_SNAPSHOT_ID, RegistryError.INVALID_ALGO, RegistryError.INVALID_CONSISTENT_ID, RegistryError.MISSING_DATA_HASH);
    }

    private void doTestRestoreMoved(RegistryError ... errorTypes) throws Exception {
        this.startGrids(2);
        IgniteEx client = this.startGrid("client");
        client.cluster().state(ClusterState.ACTIVE);
        this.changeSecurityLevel(client, SnapshotSecurityLevel.REQUIRE);
        this.load((Ignite)this.grid(0));
        GridSnapshotEx db = this.getSnapshot(client);
        SnapshotFuture fut = db.createFullSnapshot(null, null);
        fut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        long snapshotId = fut.snapshotOperation().snapshotId();
        File moveDir = this.createOrCleanMoveDir();
        SnapshotFuture copyFut = db.moveSnapshot(snapshotId, moveDir, false, new SnapshotUpdateOperationParams.Builder().withChainMode(SnapshotChainMode.DEFAULT).withDeleteSources(Boolean.valueOf(true)).build(), null);
        copyFut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        for (RegistryError e : errorTypes) {
            this.stopGrid(1);
            ReadInvalidRegistrySnapshotSpi spi = new ReadInvalidRegistrySnapshotSpi(e);
            GridCacheSnapshotManager.TEST_SNAPSHOT_SPI.set(new AbstractSnapshotTest.RestorePauseSnapshotSpiWrapper((DatabaseSnapshotSpi)spi));
            this.startGrid(1);
            this.grid(1).cluster().state(ClusterState.ACTIVE);
            log.info("Simulating error : " + e.name());
            SnapshotFuture restoreFut = db.restoreSnapshot(snapshotId, Collections.singletonList(moveDir), null, null);
            GridTestUtils.assertThrows((IgniteLogger)log, () -> (Void)restoreFut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS), IgniteException.class, (String)e.message());
        }
    }

    private void doTestRestoreLocal(RegistryError ... errorTypes) throws Exception {
        this.startGrids(2);
        IgniteEx client = this.startGrid("client");
        client.cluster().state(ClusterState.ACTIVE);
        this.changeSecurityLevel(client, SnapshotSecurityLevel.REQUIRE);
        this.load((Ignite)this.grid(0));
        GridSnapshotEx db = this.getSnapshot(client);
        SnapshotFuture fut = db.createFullSnapshot(null, null);
        fut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        this.load((Ignite)this.grid(0), 10);
        SnapshotFuture fut2 = db.createSnapshot(null, null);
        fut2.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        long snapshotId = fut2.snapshotOperation().snapshotId();
        for (RegistryError e : errorTypes) {
            this.stopGrid(1);
            ReadInvalidRegistrySnapshotSpi spi = new ReadInvalidRegistrySnapshotSpi(e);
            GridCacheSnapshotManager.TEST_SNAPSHOT_SPI.set(new AbstractSnapshotTest.RestorePauseSnapshotSpiWrapper((DatabaseSnapshotSpi)spi));
            this.startGrid(1);
            this.grid(1).cluster().state(ClusterState.ACTIVE);
            log.info("Simulating error : " + e.name());
            SnapshotFuture restoreFut = db.restoreSnapshot(snapshotId, null, null);
            GridTestUtils.assertThrows((IgniteLogger)log, () -> (Void)restoreFut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS), IgniteException.class, (String)e.message());
        }
    }

    private void doTestCheckLocal(boolean allSnapshots, RegistryError ... errorTypes) throws Exception {
        this.startGrids(2);
        IgniteEx client = this.startGrid("client");
        client.cluster().state(ClusterState.ACTIVE);
        this.changeSecurityLevel(client, SnapshotSecurityLevel.REQUIRE);
        this.load((Ignite)this.grid(0));
        AtomicBoolean stop = new AtomicBoolean(false);
        AtomicInteger cnt = new AtomicInteger();
        IgniteInternalFuture loadFut = GridTestUtils.runMultiThreadedAsync(() -> {
            IgniteCache c3 = this.grid(0).cache("cache3");
            ThreadLocalRandom r = ThreadLocalRandom.current();
            while (!stop.get()) {
                c3.put((Object)r.nextInt(), (Object)r.nextInt());
                cnt.incrementAndGet();
            }
        }, (int)3, (String)"atomic-load");
        SnapshotRegistryContentErrorsTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> cnt.get() >= 1000, (long)this.getTestTimeout()));
        GridSnapshotEx db = this.getSnapshot(client);
        SnapshotFuture fullSnapshotFut = db.createFullSnapshot(null, "full-snapshot");
        fullSnapshotFut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        long fullSnapshotId = fullSnapshotFut.snapshotOperation().snapshotId();
        SnapshotFuture incSnapshotFut = db.createSnapshot(null, "incremental-snapshot");
        incSnapshotFut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        long incSnapshotId = incSnapshotFut.snapshotOperation().snapshotId();
        stop.set(true);
        loadFut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        for (RegistryError e : errorTypes) {
            this.stopGrid(1);
            ReadInvalidRegistrySnapshotSpi spi = new ReadInvalidRegistrySnapshotSpi(e, (IgnitePredicate<Long>)(IgnitePredicate & Serializable)id -> allSnapshots || id == fullSnapshotId);
            GridCacheSnapshotManager.TEST_SNAPSHOT_SPI.set(new AbstractSnapshotTest.RestorePauseSnapshotSpiWrapper((DatabaseSnapshotSpi)spi));
            this.startGrid(1);
            this.grid(1).cluster().state(ClusterState.ACTIVE);
            log.info("Simulating error : " + e.name());
            SnapshotFuture checkFut = db.checkSnapshot(incSnapshotId, null, false, null);
            List issues = (List)checkFut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
            SnapshotRegistryContentErrorsTest.assertNotNull((Object)issues);
            SnapshotRegistryContentErrorsTest.assertTrue((String)("Got no issues, unexpected [simulatedErr=" + (Object)((Object)e) + ']'), (!issues.isEmpty() ? 1 : 0) != 0);
            SnapshotRegistryContentErrorsTest.assertTrue((String)("Unexpected issue : " + ((SnapshotIssue)issues.get(0)).getIssue()), (boolean)((SnapshotIssue)issues.get(0)).getIssue().contains(e.message()));
        }
    }

    private GridSnapshotEx getSnapshot(IgniteEx igniteEx) {
        GridGain gg = (GridGain)igniteEx.plugin("GridGain");
        GridSnapshotEx snapshot = (GridSnapshotEx)gg.snapshot();
        assert (snapshot != null);
        return snapshot;
    }

    private void changeSecurityLevel(IgniteEx ignite, SnapshotSecurityLevel level) throws IgniteCheckedException {
        this.getSnapshot(ignite).updateSecurityLevel(level);
    }

    public static enum RegistryError {
        INVALID_SNAPSHOT_ID("Unexpected snapshot id found in digest registry."),
        INVALID_ALGO("Incompatible digest algorithm found in digest registry."),
        INVALID_CONSISTENT_ID("Unexpected consistent node id found in digest registry."),
        CORRUPTED_META_HASH("Metadata partial hash verification failure."),
        MISSING_DATA_HASH("Data/Index partition hash not found in snapshot digest registry."),
        MISSING_INDEX_HASH("Data/Index partition hash not found in snapshot digest registry."),
        CORRUPTED_DATA_HASH("Data/Index partition hash verification failure."),
        CORRUPTED_INDEX_HASH("Data/Index partition hash verification failure.");

        private final String msg;

        private RegistryError(String msg) {
            this.msg = msg;
        }

        public String message() {
            return this.msg;
        }
    }

    public static class ReadInvalidRegistrySnapshotSpi
    extends FileDatabaseSnapshotSpi {
        private final RegistryError errorType;
        private final IgnitePredicate<Long> snapshotPred;

        public ReadInvalidRegistrySnapshotSpi(RegistryError errorType) {
            this.errorType = errorType;
            this.snapshotPred = (IgnitePredicate & Serializable)id -> true;
        }

        public ReadInvalidRegistrySnapshotSpi(RegistryError errorType, IgnitePredicate<Long> snapshotPred) {
            this.errorType = errorType;
            this.snapshotPred = snapshotPred;
        }

        protected FileSnapshot createFileSnapshot(IgniteConfiguration igCfg, FileDatabaseSnapshotSpi snapshotSpi, long id, SnapshotPath snapshotDir, Collection<SnapshotPath> optSearchPath, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, boolean ignoreMissedClasses, boolean remote, SnapshotSecurityLevel securityLevel, MessageDigestFactory msgDigestFactory, SnapshotRegistryTransformer registryTransformer, GridCacheSharedContext cctx) {
            FileSnapshot fileSnapshot = super.createFileSnapshot(igCfg, snapshotSpi, id, snapshotDir, optSearchPath, c, ignoreMissedClasses, remote, securityLevel, msgDigestFactory, registryTransformer, cctx);
            if (!this.snapshotPred.apply((Object)id)) {
                return fileSnapshot;
            }
            try {
                SnapshotInputStreamFactory inputStreamFactory = (SnapshotInputStreamFactory)U.invoke(FileSnapshot.class, (Object)fileSnapshot, (String)"getInputStreamFactory", (Object[])new Object[0]);
                Field field = SnapshotInputStreamFactory.class.getDeclaredField("registryCache");
                field.setAccessible(true);
                SnapshotDigestRegistryCache registryCache = (SnapshotDigestRegistryCache)field.get(inputStreamFactory);
                if (registryCache != null) {
                    registryCache = (SnapshotDigestRegistryCache)Mockito.spy((Object)registryCache);
                    field.set(inputStreamFactory, registryCache);
                    if (this.errorType.compareTo(RegistryError.CORRUPTED_META_HASH) <= 0) {
                        ((SnapshotDigestRegistryCache)Mockito.doAnswer(mock -> {
                            SnapshotDigestRegistry reg = (SnapshotDigestRegistry)mock.callRealMethod();
                            return this.mockRegistry(reg);
                        }).when((Object)registryCache)).readRegistry((String)Matchers.any());
                    } else {
                        ((SnapshotDigestRegistryCache)Mockito.doAnswer(mock -> {
                            SnapshotDigestRegistry reg = (SnapshotDigestRegistry)mock.callRealMethod();
                            return this.mockRegistry(reg);
                        }).when((Object)registryCache)).cachedRegistry((String)Matchers.any());
                    }
                }
            }
            catch (IllegalAccessException | NoSuchFieldException | IgniteCheckedException e) {
                SnapshotRegistryContentErrorsTest.fail((String)e.getMessage());
            }
            return fileSnapshot;
        }

        public SnapshotDigestRegistry mockRegistry(SnapshotDigestRegistry reg) {
            switch (this.errorType) {
                case INVALID_SNAPSHOT_ID: {
                    reg.snapshotId(reg.snapshotId() + 100L);
                    break;
                }
                case INVALID_ALGO: {
                    reg.digestAlgo("BAD" + reg.digestAlgo());
                    break;
                }
                case INVALID_CONSISTENT_ID: {
                    reg.consistentId("BAD" + reg.consistentId());
                    break;
                }
                case CORRUPTED_META_HASH: {
                    reg.metadataDigest(new byte[reg.digestLength()]);
                    break;
                }
                case MISSING_DATA_HASH: {
                    reg.digestMap().entrySet().removeIf(e -> ((GroupPartitionId)e.getKey()).getPartitionId() != 65535);
                    break;
                }
                case MISSING_INDEX_HASH: {
                    reg.digestMap().entrySet().removeIf(e -> ((GroupPartitionId)e.getKey()).getPartitionId() == 65535);
                    break;
                }
                case CORRUPTED_DATA_HASH: {
                    byte[] badVal = new byte[reg.digestLength()];
                    reg.digestMap().replaceAll((k, v) -> k.getPartitionId() == 65535 ? v : badVal);
                    break;
                }
                case CORRUPTED_INDEX_HASH: {
                    byte[] badVal2 = new byte[reg.digestLength()];
                    reg.digestMap().replaceAll((k, v) -> k.getPartitionId() == 65535 ? badVal2 : v);
                    break;
                }
                default: {
                    SnapshotRegistryContentErrorsTest.fail((String)("Unexpected error type - " + (Object)((Object)this.errorType)));
                }
            }
            return reg;
        }
    }
}

