/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.junits.multijvm.IgniteProcessProxy;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationAttrs;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfoEx;
import org.gridgain.grid.persistentstore.SnapshotOperationInfo;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class IgniteSnapshotSelfMultiJvmTest
extends AbstractSnapshotTest {
    private static final String CACHE_A_NAME = "cacheA";
    private static final String CACHE_B_NAME = "cacheB";
    private static final String CACHE_C_NAME = "cacheC";
    private static final String TEST_ATTRIBUTE_NAME = "test_attribute";
    private final Set<String> snapshotDirs = new HashSet<String>();

    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x8000000L).setPersistenceEnabled(true)).setWalMode(WALMode.LOG_ONLY);
        cfg.setDataStorageConfiguration(memCfg);
        CacheConfiguration ccfg1 = new CacheConfiguration();
        ccfg1.setName(CACHE_A_NAME);
        ccfg1.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg1.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg1.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg1.setNodeFilter((IgnitePredicate)new NodeAttributeFilter("A"));
        ccfg1.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        CacheConfiguration ccfg2 = new CacheConfiguration();
        ccfg2.setName(CACHE_B_NAME);
        ccfg2.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg2.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg2.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg2.setNodeFilter((IgnitePredicate)new NodeAttributeFilter("B"));
        ccfg2.setIndexedTypes(new Class[]{Integer.class, TestValue.class});
        CacheConfiguration ccfg3 = new CacheConfiguration();
        ccfg3.setName(CACHE_C_NAME);
        ccfg3.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg3.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg3.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg3.setIndexedTypes(new Class[]{Integer.class, TestValue.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg1, ccfg2, ccfg3});
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        ggCfg.setLicenseUrl(System.getProperty("licenseUrl"));
        SnapshotConfiguration ggDbCfg = new SnapshotConfiguration();
        ggDbCfg.setSnapshotsPath(gridName);
        this.snapshotDirs.add(gridName);
        ggCfg.setSnapshotConfiguration(ggDbCfg);
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        if ("client".equals(gridName)) {
            cfg.setClientMode(true);
        }
        if (gridName.endsWith("A") || this.isFirstGrid(gridName)) {
            cfg.setUserAttributes(F.asMap((Object)TEST_ATTRIBUTE_NAME, (Object)"A"));
        } else if (gridName.endsWith("B")) {
            cfg.setUserAttributes(F.asMap((Object)TEST_ATTRIBUTE_NAME, (Object)"B"));
        }
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotWithNodeFilter() throws Exception {
        try {
            SnapshotFuture sf;
            int i;
            IgniteEx grid = this.startGrid(0);
            IgniteEx a1 = this.startGrid("node1A");
            IgniteEx a2 = this.startGrid("node2A");
            IgniteEx b1 = this.startGrid("node1B");
            IgniteEx b2 = this.startGrid("node2B");
            IgniteEx grid1 = this.startGrid(1);
            this.startGrid("client");
            grid.active(true);
            IgniteCache cache1 = grid.cache(CACHE_A_NAME);
            for (i = 0; i < 300; ++i) {
                cache1.put((Object)i, (Object)new TestValue(i, i));
            }
            IgniteCache cache2 = grid.cache(CACHE_B_NAME);
            for (i = 0; i < 300; ++i) {
                cache2.put((Object)i, (Object)new TestValue(i, i));
            }
            IgniteCache cache3 = grid.cache(CACHE_C_NAME);
            for (i = 0; i < 300; ++i) {
                cache3.put((Object)i, (Object)new TestValue(i, i));
            }
            GridGain gg = (GridGain)grid.plugin("GridGain");
            GridSnapshot db = gg.snapshot();
            ArrayList<SnapshotFuture> snaps = new ArrayList<SnapshotFuture>();
            for (String cacheName : new String[]{CACHE_A_NAME, CACHE_B_NAME, CACHE_C_NAME}) {
                this.info(">>> Full snapshot for cache: " + cacheName);
                sf = db.createFullSnapshot((Set)Sets.newHashSet((Object[])new String[]{cacheName}), null);
                sf.get();
                IgniteSnapshotSelfMultiJvmTest.assertTrue((boolean)GridSnapshotOperationAttrs.getFullSnapshotParameter((GridSnapshotOperationEx)((SnapshotOperationInfoImpl)sf.snapshotOperation()).snapshotOperation()));
                snaps.add(sf);
            }
            this.info(">>> Full snapshot for three caches: [cacheA, cacheB, cacheC]");
            SnapshotFuture snap12 = db.createFullSnapshot((Set)Sets.newHashSet((Object[])new String[]{CACHE_A_NAME, CACHE_B_NAME, CACHE_C_NAME}), null);
            snap12.get();
            IgniteSnapshotSelfMultiJvmTest.assertTrue((boolean)GridSnapshotOperationAttrs.getFullSnapshotParameter((GridSnapshotOperationEx)((SnapshotOperationInfoImpl)snap12.snapshotOperation()).snapshotOperation()));
            snaps.add(snap12);
            for (String cacheName : new SnapshotFuture[]{CACHE_A_NAME, CACHE_B_NAME, CACHE_C_NAME}) {
                this.info(">>> Incremental snapshot for cache: " + cacheName);
                sf = db.createSnapshot((Set)Sets.newHashSet((Object[])new String[]{cacheName}), null);
                sf.get();
                IgniteSnapshotSelfMultiJvmTest.assertFalse((boolean)GridSnapshotOperationAttrs.getFullSnapshotParameter((GridSnapshotOperationEx)((SnapshotOperationInfoImpl)sf.snapshotOperation()).snapshotOperation()));
                snaps.add(sf);
            }
            this.info(">>> Incremental snapshot for three caches: [cacheA, cacheB, cacheC]");
            snap12 = db.createSnapshot((Set)Sets.newHashSet((Object[])new String[]{CACHE_A_NAME, CACHE_B_NAME, CACHE_C_NAME}), null);
            IgniteSnapshotSelfMultiJvmTest.assertFalse((boolean)GridSnapshotOperationAttrs.getFullSnapshotParameter((GridSnapshotOperationEx)((SnapshotOperationInfoImpl)snap12.snapshotOperation()).snapshotOperation()));
            snap12.get();
            for (SnapshotFuture snap : snaps) {
                SnapshotInfoEx info = db.snapshot(snap.snapshotOperation().snapshotId(), null);
                IgniteSnapshotSelfMultiJvmTest.assertEquals((Object)GridSnapshotOperationAttrs.getFullSnapshotParameter((GridSnapshotOperationEx)IgniteSnapshotSelfMultiJvmTest.snapshotOperation(snap.snapshotOperation())), (Object)info.fullSnapshot());
            }
            for (SnapshotFuture snap : snaps) {
                db.restoreSnapshot(snap.snapshotOperation().snapshotId(), null, null).get();
                IgniteCache cacheA1 = a1.cache(CACHE_A_NAME);
                IgniteCache cacheA2 = a2.cache(CACHE_A_NAME);
                for (int i2 = 0; i2 < 300; ++i2) {
                    IgniteSnapshotSelfMultiJvmTest.assertEquals((Object)new TestValue(i2, i2), (Object)cacheA1.get((Object)i2));
                    IgniteSnapshotSelfMultiJvmTest.assertEquals((Object)new TestValue(i2, i2), (Object)cacheA2.get((Object)i2));
                }
                IgniteCache cacheB1 = b1.cache(CACHE_B_NAME);
                IgniteCache cacheB2 = b2.cache(CACHE_B_NAME);
                for (int i3 = 0; i3 < 300; ++i3) {
                    IgniteSnapshotSelfMultiJvmTest.assertEquals((Object)new TestValue(i3, i3), (Object)cacheB1.get((Object)i3));
                    IgniteSnapshotSelfMultiJvmTest.assertEquals((Object)new TestValue(i3, i3), (Object)cacheB2.get((Object)i3));
                }
                IgniteCache cache32 = grid1.cache(CACHE_C_NAME);
                for (int i4 = 0; i4 < 300; ++i4) {
                    IgniteSnapshotSelfMultiJvmTest.assertEquals((Object)new TestValue(i4, i4), (Object)cache32.get((Object)i4));
                }
            }
        }
        finally {
            this.stopAllGrids();
        }
    }

    @Test
    public void testIncrementalSnapshotWithNodeRestartBetweenSnapshots() throws Exception {
        this.startGrids(4);
        IgniteEx ignite = this.ignite(0);
        ignite.active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        ignite.getOrCreateCache(this.getCacheConfig("cache1"));
        ignite.getOrCreateCache(this.getCacheConfig("cache2"));
        this.load((Ignite)ignite);
        gg.snapshot().createFullSnapshot(null, null).get();
        this.load((Ignite)ignite, 1);
        gg.snapshot().createSnapshot(null, null).get();
        IgniteProcessProxy.kill((String)this.grid(3).configuration().getIgniteInstanceName());
        this.startGrid(3);
        this.waitForReadyTopology(ignite.cachex("cache1").context().topology(), new AffinityTopologyVersion(6L, 1));
        HashSet<String> testCaches = new HashSet<String>(Arrays.asList("cache1", "cache2"));
        ignite.resetLostPartitions(testCaches);
        this.awaitPartitionMapExchange(false, false, null, false, testCaches);
        this.load((Ignite)ignite, 2);
        gg.snapshot().createSnapshot(null, null).get();
    }

    @Test
    public void testIncrementalSnapshotCouldLoseSomeDataIfNodeRestartedAfterFullSnapshot() throws Exception {
        this.startGrids(4);
        IgniteEx ignite = this.ignite(0);
        ignite.active(true);
        BaselineTopology baselineTopology = U.getBaselineTopology((GridKernalContext)ignite.context());
        MatcherAssert.assertThat((Object)baselineTopology.consistentIds().size(), (Matcher)Matchers.is((Object)4));
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        ignite.getOrCreateCache(this.getCacheConfig("cache1"));
        ignite.getOrCreateCache(this.getCacheConfig("cache2"));
        this.load((Ignite)ignite);
        gg.snapshot().createFullSnapshot(null, null).get();
        gg.snapshot().createFullSnapshot(null, null).get();
        gg.snapshot().createFullSnapshot(null, null).get();
        this.load((Ignite)ignite, 1);
        gg.snapshot().createFullSnapshot(null, null).get();
        IgniteSnapshotSelfMultiJvmTest.loadWithIntsAsync((Ignite)ignite, "cache1", 3, 1).get();
        IgniteProcessProxy.kill((String)this.grid(1).configuration().getIgniteInstanceName());
        IgniteProcessProxy.kill((String)this.grid(3).configuration().getIgniteInstanceName());
        this.startGrid(1);
        this.startGrid(3);
        this.waitForReadyTopology(ignite.cachex("cache1").context().topology(), new AffinityTopologyVersion(8L, 1));
        HashSet<String> testCaches = new HashSet<String>(Arrays.asList("cache1", "cache2"));
        ignite.resetLostPartitions(testCaches);
        this.awaitPartitionMapExchange(false, false, null, false, testCaches);
        IgniteSnapshotSelfMultiJvmTest.loadWithIntsAsync((Ignite)ignite, "cache1", 4, 1, 100).get();
        SnapshotFuture incSnapshot = gg.snapshot().createSnapshot(null, null);
        incSnapshot.get();
        IgniteSnapshotSelfMultiJvmTest.loadWithIntsAsync((Ignite)ignite, "cache1", 5, 1).get();
        gg.snapshot().restoreSnapshot(incSnapshot.snapshotOperation().snapshotId(), new HashSet<String>(Arrays.asList("cache1", "cache2")), null).get();
        IgniteCache cache = ignite.cache("cache1");
        for (int i = 0; i < 300; ++i) {
            int shift = i < 100 ? 4 : 3;
            MatcherAssert.assertThat((Object)cache.get((Object)i), (Matcher)Matchers.is((Object)(i + shift)));
            IgniteSnapshotSelfMultiJvmTest.assertEquals((Object)cache.get((Object)i), (Object)(i + shift));
        }
    }

    @Test
    public void testClientLeftDuringRestore() throws Exception {
        IgniteEx igniteEx = this.startGrids(2);
        igniteEx.cluster().active(true);
        igniteEx.getOrCreateCache(this.getCacheConfig("cache1"));
        IgniteSnapshotSelfMultiJvmTest.loadWithIntsAsync((Ignite)igniteEx, "cache1", 0, 0, 1000).get();
        GridSnapshot ggSnapshot = this.getSnapshot(igniteEx);
        SnapshotFuture snapFut = ggSnapshot.createFullSnapshot(Collections.singleton("cache1"), null);
        snapFut.get();
        this.startGrid("client");
        IgniteProcessProxy.kill((String)"client");
        ggSnapshot.restoreSnapshot(snapFut.snapshotOperation().snapshotId(), null, null).get();
    }

    private GridSnapshot getSnapshot(IgniteEx igniteEx) {
        GridGain gg = (GridGain)igniteEx.plugin("GridGain");
        return gg.snapshot();
    }

    private static GridSnapshotOperationEx snapshotOperation(SnapshotOperationInfo op) {
        return ((SnapshotOperationInfoImpl)op).snapshotOperation();
    }

    protected boolean isMultiJvm() {
        return true;
    }

    @Override
    protected Set<String> snapshotFolders() {
        return this.snapshotDirs;
    }

    private static class NodeAttributeFilter
    implements IgnitePredicate<ClusterNode> {
        private String attrVal;

        private NodeAttributeFilter(String attrVal) {
            this.attrVal = attrVal;
        }

        public boolean apply(ClusterNode clusterNode) {
            return this.attrVal.equals(clusterNode.attribute(IgniteSnapshotSelfMultiJvmTest.TEST_ATTRIBUTE_NAME));
        }
    }

    private static class TestValue
    implements Serializable {
        private final int v1;
        private final int v2;

        private TestValue(int v1, int v2) {
            this.v1 = v1;
            this.v2 = v2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestValue val = (TestValue)o;
            return this.v1 == val.v1 && this.v2 == val.v2;
        }

        public int hashCode() {
            int res = this.v1;
            res = 31 * res + this.v2;
            return res;
        }

        public String toString() {
            return "TestValue [v1=" + this.v1 + ", v2=" + this.v2 + ']';
        }
    }
}

