/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class IgniteDbSnapshotWithEvictionsSelfTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);
    private static final String CACHE_NAME = "cache1";

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        TcpDiscoverySpi discoverySpi = (TcpDiscoverySpi)cfg.getDiscoverySpi();
        discoverySpi.setIpFinder(ipFinder);
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x4600000L).setPersistenceEnabled(true)).setWalMode(WALMode.LOG_ONLY).setCheckpointFrequency(60000L);
        cfg.setDataStorageConfiguration(memCfg);
        CacheConfiguration ccfg1 = new CacheConfiguration();
        ccfg1.setName(CACHE_NAME);
        ccfg1.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg1.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg1.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 64));
        ccfg1.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg1});
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        SnapshotConfiguration ggDbCfg = new SnapshotConfiguration();
        ggCfg.setSnapshotConfiguration(ggDbCfg);
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        if ("client".equals(gridName)) {
            cfg.setClientMode(true);
        }
        cfg.setConsistentId((Serializable)((Object)gridName));
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.deleteWorkFiles();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.deleteWorkFiles();
    }

    protected long getTestTimeout() {
        return 600000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotDuringLoadEvictions() throws Exception {
        this.startGrids(2).active(true);
        try {
            IgniteEx ig = this.ignite(0);
            int keyCnt = 500000;
            try (IgniteDataStreamer ds = ig.dataStreamer(CACHE_NAME);){
                ds.allowOverwrite(true);
                for (int i = 0; i < 500000; ++i) {
                    ds.addData((Object)i, (Object)new TestValue(ThreadLocalRandom.current().nextInt(), ThreadLocalRandom.current().nextInt()));
                }
            }
            final AtomicBoolean run = new AtomicBoolean(true);
            IgniteInternalFuture fut = GridTestUtils.runMultiThreadedAsync((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    while (run.get()) {
                        ThreadLocalRandom rnd = ThreadLocalRandom.current();
                        int key = rnd.nextInt(1000000);
                        IgniteDbSnapshotWithEvictionsSelfTest.this.ignite(0).cache(IgniteDbSnapshotWithEvictionsSelfTest.CACHE_NAME).put((Object)key, (Object)new TestValue(ThreadLocalRandom.current().nextInt(), ThreadLocalRandom.current().nextInt()));
                    }
                    return null;
                }
            }, (int)8, (String)"loader");
            GridGain gg = (GridGain)ig.plugin("GridGain");
            GridSnapshot db = gg.snapshot();
            for (int i = 0; i < 10; ++i) {
                SnapshotFuture snapFut = db.createFullSnapshot(null, "snapshot-" + i);
                snapFut.get();
                U.sleep((long)2000L);
            }
            run.set(false);
            fut.get();
        }
        finally {
            this.stopAllGrids();
        }
    }

    private void deleteWorkFiles() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
    }

    private static class TestValue
    implements Serializable {
        private final int v1;
        private final int v2;
        private byte[] payload = new byte[400];

        private TestValue(int v1, int v2) {
            this.v1 = v1;
            this.v2 = v2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestValue value = (TestValue)o;
            return this.v1 == value.v1 && this.v2 == value.v2;
        }

        public int hashCode() {
            int result = this.v1;
            result = 31 * result + this.v2;
            return result;
        }

        public String toString() {
            return S.toString(TestValue.class, (Object)this);
        }
    }
}

