/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.StringValueExp;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCacheRestartingException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeBatch;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeRequest;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.lang.GridAbsPredicateX;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.DiscoverySpiCustomMessage;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridStringLogger;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.messages.CancelSnapshotOperationMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.FinishSnapshotOperationAckDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.SnapshotProgressMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.DatabaseSnapshotSpi;
import org.gridgain.grid.internal.processors.cache.database.snapshot.FutureTaskQueue;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.Snapshot;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDescriptorV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotEncryptionOptions;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOutputStream;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotSession;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.MessageDigestFactory;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotIssue;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotProgress;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;
import org.gridgain.grid.persistentstore.SnapshotStatus;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Ignore;
import org.junit.Test;

public class IgniteDbSnapshotNotStableTopologiesTest
extends AbstractSnapshotTest {
    private static final String TEST_CACHE_NAME = "testSnapshotChainIsPartlyLocalAndRemote";
    private static final int INC_SNAPSHOT_EXTRA_KEYS = 32;
    private static final boolean MOVE = true;
    private static final boolean DONT_MOVE = false;
    protected static final Function<long[], int[]> NOOP_EXTRA_ACTIONS = chain -> null;
    protected byte useTestSpi;
    private GridStringLogger strLog;
    private boolean fail;
    private boolean progressTest;
    private CountDownLatch snapshotFinishLatch = new CountDownLatch(1);
    private CountDownLatch snapshotStartedLatch = new CountDownLatch(2);
    private boolean clientMode;
    private boolean skipPersistenceCfg;
    private volatile boolean skipStartCaches = false;
    private volatile CountDownLatch discoveryLatch = null;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        System.setProperty("GG_TEST_SKIP_SNAPSHOT_SYNC", "true");
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        System.clearProperty("GG_TEST_SKIP_SNAPSHOT_SYNC");
    }

    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        if (gridName.startsWith("client")) {
            cfg.setClientMode(true);
        } else {
            cfg.setClientMode(this.clientMode);
        }
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        SnapshotConfiguration ggDbCfg = new SnapshotConfiguration();
        if (this.progressTest) {
            ggDbCfg.setSnapshotProgressThrottlingInterval(-1L);
        }
        if (this.useTestSpi != 0) {
            GridCacheSnapshotManager.TEST_SNAPSHOT_SPI.set(this.createSnapshotSpi(this.useTestSpi, (DatabaseSnapshotSpi)new FileDatabaseSnapshotSpi()));
        }
        if (this.strLog != null) {
            cfg.setGridLogger((IgniteLogger)this.strLog);
        }
        ggCfg.setSnapshotConfiguration(ggDbCfg);
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        if (this.skipPersistenceCfg) {
            cfg.setDataStorageConfiguration(null);
        }
        TestDiscoverySpi discoSpi = new TestDiscoverySpi();
        discoSpi.setIpFinder(ipFinder);
        cfg.setDiscoverySpi((DiscoverySpi)discoSpi);
        cfg.setCommunicationSpi((CommunicationSpi)new BlockTcpCommunicationSpi());
        return cfg;
    }

    protected DatabaseSnapshotSpi createSnapshotSpi(byte type, DatabaseSnapshotSpi spi) {
        assert (type != 0);
        switch (type) {
            case 1: {
                return new TestSnapshotSpiWrapper(spi);
            }
            case 2: {
                return new InhibitoryDatabaseSnapshotSpi();
            }
        }
        throw new IllegalArgumentException("Unsupported snapshot spi type:" + type);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanSnapshotDirs();
        if (this.startDummy()) {
            this.startGrid("dummy");
            this.startGrid("client");
        }
    }

    @Override
    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.useTestSpi = 0;
        this.fail = false;
        this.skipPersistenceCfg = false;
        this.strLog = null;
        this.cleanSnapshotDirs();
    }

    protected boolean startDummy() {
        return true;
    }

    @Test
    public void testOfflineBaselineNodeIsProhibitedToJoinAfterSnapRestore() throws Exception {
        int nodesNum = 4;
        IgniteEx ig = this.startGrids(nodesNum);
        ig.cluster().active(true);
        ig.getOrCreateCache(new CacheConfiguration().setName("default").setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setBackups(3));
        IgniteDbSnapshotNotStableTopologiesTest.loadWithIntsAsync((Ignite)ig, "default", 1, 1).get();
        this.validateData((IgniteCache<Object, Object>)ig.cache("default"), 1);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        GridSnapshot db = gg.snapshot();
        HashSet<String> cachesToSnapshot = new HashSet<String>();
        cachesToSnapshot.add("default");
        SnapshotFuture fullSnap = db.createFullSnapshot(cachesToSnapshot, "full snapshot");
        fullSnap.get();
        IgniteDbSnapshotNotStableTopologiesTest.loadWithIntsAsync((Ignite)ig, "default", 2, 1).get();
        this.stopGrid(nodesNum - 1);
        gg.snapshot().restoreSnapshot(fullSnap.snapshotOperation().snapshotId(), null, null).get();
        this.validateData((IgniteCache<Object, Object>)ig.cache("default"), 1);
        try {
            this.startGrid(nodesNum - 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.awaitPartitionMapExchange();
        this.stopAllGrids();
        this.startGrids(nodesNum - 1);
        ig = this.grid(0);
        ig.cluster().active(true);
        this.awaitPartitionMapExchange();
        IgniteCache defaultCache = ig.cache("default");
        this.assertPartitionsSame(this.idleVerify((Ignite)ig, new String[]{"default"}));
        this.validateData((IgniteCache<Object, Object>)defaultCache, 1);
    }

    @Test
    public void testSnapshotChainFullIsLocalAndIncremetalOnesAreRemote() throws Exception {
        this.testSnapshotChainFullIsLocalAndIncremetalOnesAreRemote(NOOP_EXTRA_ACTIONS);
    }

    @Test
    public void testRestoreOfSharedIncrementalSnapshotShouldWorkIfFullSnapshotIsLocal_NoOneNode() throws Exception {
        this.testSnapshotChainFullIsLocalAndIncremetalOnesAreRemote(chain -> {
            this.stopGrid(2);
            return null;
        });
    }

    @Test
    public void testRestoreOfSharedIncrementalSnapshotShouldWorkIfFullSnapshotIsLocal_NoOneNodeAndOneExtraNode() throws Exception {
        this.testSnapshotChainFullIsLocalAndIncremetalOnesAreRemote(chain -> {
            this.stopGrid(2);
            try {
                IgniteEx ex = this.startGrid(3);
                ex.cluster().setBaselineTopology(ex.cluster().topologyVersion());
            }
            catch (Exception e) {
                e.printStackTrace();
                IgniteDbSnapshotNotStableTopologiesTest.fail();
            }
            return null;
        });
    }

    @Test
    public void testRestoreOfSharedIncrementalSnapshotShouldWorkIfFullSnapshotIsLocal_NoOneNodeAndOneExtraNodeOutsideBaseline() throws Exception {
        this.testSnapshotChainFullIsLocalAndIncremetalOnesAreRemote(chain -> {
            this.stopGrid(2);
            try {
                this.startGrid(3);
            }
            catch (Exception e) {
                e.printStackTrace();
                IgniteDbSnapshotNotStableTopologiesTest.fail();
            }
            return null;
        });
    }

    @Test
    public void testRestoreOfSharedIncrementalSnapshotShouldWorkIfFullSnapshotIsLocal_NoTwoNode() throws Exception {
        this.testSnapshotChainFullIsLocalAndIncremetalOnesAreRemote(chain -> {
            this.stopGrid(2);
            this.stopGrid(1);
            this.grid(0).cluster().setBaselineTopology(this.grid(0).cluster().topologyVersion());
            return null;
        });
    }

    protected void testSnapshotChainFullIsLocalAndIncremetalOnesAreRemote(boolean success, Function<long[], int[]> extraActions) throws Exception {
        this.executeSnapshotChainIsPartlyLocalAndRemoteTest(success, extraActions, new boolean[]{false, true, true});
    }

    protected void testSnapshotChainFullIsLocalAndIncremetalOnesAreRemote(Function<long[], int[]> extraActions) throws Exception {
        this.testSnapshotChainFullIsLocalAndIncremetalOnesAreRemote(true, extraActions);
    }

    @Test
    public void testRestoreOfSharedIncrementalSnapshotShouldWorkIfIntermidiateSnapshotIsLocal() throws Exception {
        this.testSnapshotChainOneIntermidiateIncremetalSnapshotIsRemote(NOOP_EXTRA_ACTIONS);
    }

    @Test
    public void testRestoreOfSharedIncrementalSnapshotShouldWorkIfIntermidiateSnapshotIsLocal_NoOneNode() throws Exception {
        this.testSnapshotChainOneIntermidiateIncremetalSnapshotIsRemote(chain -> {
            this.stopGrid(2);
            return null;
        });
    }

    @Test
    public void testRestoreOfSharedIncrementalSnapshotShouldWorkIfIntermidiateSnapshotIsLocal_NoOneNodeAndOneExtraNode() throws Exception {
        this.testSnapshotChainOneIntermidiateIncremetalSnapshotIsRemote(chain -> {
            this.stopGrid(2);
            try {
                IgniteEx ex = this.startGrid(3);
                ex.cluster().setBaselineTopology(ex.cluster().topologyVersion());
            }
            catch (Exception e) {
                e.printStackTrace();
                IgniteDbSnapshotNotStableTopologiesTest.fail();
            }
            return null;
        });
    }

    @Test
    public void testRestoreOfSharedIncrementalSnapshotShouldWorkIfIntermidiateSnapshotIsLocal_NoOneNodeAndOneExtraNodeOutsideBaseline() throws Exception {
        this.testSnapshotChainOneIntermidiateIncremetalSnapshotIsRemote(chain -> {
            this.stopGrid(2);
            try {
                this.startGrid(3);
            }
            catch (Exception e) {
                e.printStackTrace();
                IgniteDbSnapshotNotStableTopologiesTest.fail();
            }
            return null;
        });
    }

    @Test
    public void testRestoreOfSharedIncrementalSnapshotShouldWorkIfIntermidiateSnapshotIsLocal_NoTwoNode() throws Exception {
        this.testSnapshotChainOneIntermidiateIncremetalSnapshotIsRemote(chain -> {
            this.stopGrid(2);
            this.stopGrid(1);
            this.grid(0).cluster().setBaselineTopology(this.grid(0).cluster().topologyVersion());
            return null;
        });
    }

    protected void testSnapshotChainOneIntermidiateIncremetalSnapshotIsRemote(Function<long[], int[]> extraActions) throws Exception {
        this.testSnapshotChainOneIntermidiateIncremetalSnapshotIsRemote(true, extraActions);
    }

    protected void testSnapshotChainOneIntermidiateIncremetalSnapshotIsRemote(boolean success, Function<long[], int[]> extraActions) throws Exception {
        this.executeSnapshotChainIsPartlyLocalAndRemoteTest(success, extraActions, new boolean[]{true, false, true, true});
    }

    /*
     * Exception decompiling
     */
    @Test
    public void testLocalFullTwoRemoteIncsRestoreBothIncs() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Test
    public void testLocalFullLocalIncRemoteIncRestoreBothIncs() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testRemoteFullLocalIncsRestoreLastInc() throws Exception {
        this.executeSnapshotChainIsPartlyLocalAndRemoteTest(true, NOOP_EXTRA_ACTIONS, new boolean[]{true, false, false});
    }

    @Test
    public void testLocalFullRemoteIncLocalIncRestoreLastInc() throws Exception {
        this.executeSnapshotChainIsPartlyLocalAndRemoteTest(true, NOOP_EXTRA_ACTIONS, new boolean[]{false, true, false});
    }

    protected void executeSnapshotChainIsPartlyLocalAndRemoteTest(boolean success, @NotNull Function<long[], int[]> extraActions, boolean[] chainPartShouldBeMoved) throws Exception {
        this.stopAllGrids();
        IgniteEx ignite = this.startGrids(3);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        File dir = this.createOrCleanMoveDir();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        ignite.createCache(new CacheConfiguration(TEST_CACHE_NAME).setCacheMode(CacheMode.PARTITIONED).setBackups(1).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 8)));
        IgniteDbSnapshotNotStableTopologiesTest.loadWithIntsAsync((Ignite)ignite, TEST_CACHE_NAME, 0, 1).get();
        long[] snapshotChain = this.generateSnapshotChain(gg, (IgniteCache<Object, Object>)ignite.cache(TEST_CACHE_NAME), i -> dir, 32, chainPartShouldBeMoved);
        IgniteDbSnapshotNotStableTopologiesTest.assertEquals((int)snapshotChain.length, (int)chainPartShouldBeMoved.length);
        ignite.cache(TEST_CACHE_NAME).destroy();
        int[] snapshotChainIdxs = extraActions.apply(snapshotChain);
        if (snapshotChainIdxs == null) {
            snapshotChainIdxs = new int[]{snapshotChain.length - 1};
        }
        for (int snapshotChainIdx : snapshotChainIdxs) {
            this.checkAndRestoreWithAssertion(success, (Ignite)ignite, Collections.singleton(dir), gg, snapshotChainIdx, snapshotChain);
        }
    }

    @Test
    public void testTwoRemoteDirsWithIncsRestoreLast() throws Exception {
        this.stopAllGrids();
        IgniteEx ignite = this.startGrids(3);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        File dfltMoveDir = this.createOrCleanMoveDir();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        ignite.createCache(new CacheConfiguration(TEST_CACHE_NAME).setCacheMode(CacheMode.PARTITIONED).setBackups(1).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 8)));
        IgniteDbSnapshotNotStableTopologiesTest.loadWithIntsAsync((Ignite)ignite, TEST_CACHE_NAME, 0, 1).get();
        IntFunction<File> dirFunction = i -> {
            switch (i) {
                case 0: 
                case 1: {
                    return new File(dfltMoveDir, "move1");
                }
                case 2: {
                    return new File(dfltMoveDir, "move2");
                }
            }
            throw new IllegalArgumentException("i=" + i);
        };
        List<File> dirs = Arrays.asList(dirFunction.apply(1), dirFunction.apply(2));
        dirs.forEach(File::mkdirs);
        long[] snapshotChain = this.generateSnapshotChain(gg, (IgniteCache<Object, Object>)ignite.cache(TEST_CACHE_NAME), dirFunction, 32, new boolean[]{false, true, true});
        ignite.cache(TEST_CACHE_NAME).destroy();
        this.checkAndRestoreWithAssertion(true, (Ignite)ignite, dirs, gg, snapshotChain.length - 1, snapshotChain);
    }

    private void checkAndRestoreWithAssertion(boolean success, Ignite ignite, Collection<File> dirs, GridGain gg, int snapshotChainIdx, long[] snapshotChain) throws Exception {
        long chainLastSnapshot = snapshotChain[snapshotChainIdx];
        List issues = (List)gg.snapshot().checkSnapshot(chainLastSnapshot, dirs, false, null).get();
        Callable<Object> restoreSnapshot = () -> (Void)gg.snapshot().restoreSnapshot(chainLastSnapshot, dirs, null, null).get();
        if (success) {
            int j;
            IgniteDbSnapshotNotStableTopologiesTest.assertTrue((String)issues.toString(), (boolean)issues.isEmpty());
            restoreSnapshot.call();
            for (j = 0; j < 300 + 32 * snapshotChainIdx; ++j) {
                IgniteDbSnapshotNotStableTopologiesTest.assertEquals((Object)j, (Object)ignite.cache(TEST_CACHE_NAME).get((Object)j));
            }
            while (j < 300 + 32 * (snapshotChainIdx + 1)) {
                IgniteDbSnapshotNotStableTopologiesTest.assertNull((Object)ignite.cache(TEST_CACHE_NAME).get((Object)j));
                ++j;
            }
        } else {
            IgniteDbSnapshotNotStableTopologiesTest.assertFalse((boolean)issues.isEmpty());
            GridTestUtils.assertThrows((IgniteLogger)log, restoreSnapshot, Exception.class, (String)"Snapshot was not fully restored!");
        }
    }

    private long[] generateSnapshotChain(GridGain gg, IgniteCache<Object, Object> cache, IntFunction<File> dir, int extraKeys, boolean[] chainPartShouldBeMoved) {
        int j;
        int i = 300;
        long[] ids = new long[chainPartShouldBeMoved.length];
        for (j = 0; j < chainPartShouldBeMoved.length; ++j) {
            while (i < 300 + extraKeys * j) {
                cache.put((Object)i, (Object)i);
                ++i;
            }
            SnapshotFuture fut = j == 0 ? gg.snapshot().createFullSnapshot(Collections.singleton(cache.getName()), null) : gg.snapshot().createSnapshot(Collections.singleton(cache.getName()), null);
            fut.get();
            IgniteDbSnapshotNotStableTopologiesTest.assertTrue((boolean)fut.snapshotOperation().cacheNames().contains(cache.getName()));
            ids[j] = fut.snapshotOperation().snapshotId();
        }
        for (j = 0; j < chainPartShouldBeMoved.length; ++j) {
            boolean move = chainPartShouldBeMoved[j];
            if (!move) continue;
            gg.snapshot().copySnapshot(ids[j], dir.apply(j), new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE, true, false, Integer.valueOf(1)), null).get();
        }
        Set snapshotIds = gg.snapshot().list(null).stream().map(SnapshotInfo::snapshotId).collect(Collectors.toSet());
        for (int j2 = 0; j2 < chainPartShouldBeMoved.length; ++j2) {
            if (chainPartShouldBeMoved[j2]) {
                IgniteDbSnapshotNotStableTopologiesTest.assertFalse((boolean)snapshotIds.contains(ids[j2]));
                continue;
            }
            IgniteDbSnapshotNotStableTopologiesTest.assertTrue((boolean)snapshotIds.contains(ids[j2]));
        }
        Set dirs = IntStream.range(0, chainPartShouldBeMoved.length).mapToObj(dir).collect(Collectors.toSet());
        snapshotIds = gg.snapshot().listSnapshots(dirs).stream().map(SnapshotInfo::snapshotId).collect(Collectors.toSet());
        for (long id : ids) {
            IgniteDbSnapshotNotStableTopologiesTest.assertTrue((boolean)snapshotIds.contains(id));
        }
        return ids;
    }

    private void validateData(IgniteCache<Object, Object> cache, int shift) {
        for (int i = 0; i < 300; ++i) {
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((String)"values in cache have diverged", (Object)(i + shift), (Object)cache.get((Object)i));
        }
    }

    @Test
    public void testBinaryMetadataRestoredFromSnapshot() throws Exception {
        this.startGrids(4);
        IgniteEx ig = this.ignite(0);
        ig.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ig.plugin("GridGain");
        this.load((Ignite)ig);
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        this.stopAllGrids();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db/binary_meta", (boolean)false));
        ig = this.startGrids(4);
        this.startGrid("dummy");
        ig.cluster().active(true);
        this.awaitPartitionMapExchange();
        gg = (GridGain)ig.plugin("GridGain");
        gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), null, null, true, null, null).get();
        IgniteCache cache2 = ig.cache("cache2").withKeepBinary();
        BinaryObject binObj = (BinaryObject)cache2.get((Object)0);
        IgniteDbSnapshotNotStableTopologiesTest.assertNotNull((Object)binObj);
        IgniteDbSnapshotNotStableTopologiesTest.assertEquals((String)AbstractSnapshotTest.TestValue.class.getName(), (String)binObj.type().typeName());
    }

    @Test
    public void testThatWeSnapshotOnlyGivenCaches() throws Exception {
        this.stopAllGrids();
        this.startGrids(1);
        IgniteEx ignite = this.ignite(0);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        this.load((Ignite)ignite);
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(Collections.singleton("cache1"), null);
        fut.get();
        for (String s : this.snapshotFolders()) {
            File directory = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)s, (boolean)false);
            for (File snapshotDir : directory.listFiles()) {
                if (!snapshotDir.isDirectory() || !snapshotDir.getName().contains(Long.toString(fut.snapshotOperation().snapshotId()))) continue;
                for (File consId : snapshotDir.listFiles()) {
                    if (!consId.isDirectory()) continue;
                    int count = 0;
                    for (File cacheId : consId.listFiles()) {
                        if (!cacheId.isDirectory()) continue;
                        ++count;
                    }
                    IgniteDbSnapshotNotStableTopologiesTest.assertEquals((int)1, (int)count);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSnapshotProgressAndAbsenceOfAssertionErrorsInCaseWeStopNodeWhileSnapshotCreationInProgress() throws Exception {
        this.useTestSpi = (byte)2;
        this.progressTest = true;
        this.strLog = new GridStringLogger();
        this.startGrids(2);
        IgniteEx ig = this.ignite(0);
        ig.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ig.plugin("GridGain");
        AtomicLong progressCnt = new AtomicLong();
        Object lsn = (nodeId, msg, plc) -> {
            if (msg instanceof SnapshotProgressMessage) {
                progressCnt.incrementAndGet();
            }
        };
        for (Ignite ign : G.allGrids()) {
            ((IgniteEx)ign).context().cache().context().gridIO().addMessageListener(GridTopic.TOPIC_SNAPSHOT, (GridMessageListener)lsn);
        }
        IgniteDataStreamer ldr = ig.dataStreamer("cache1");
        Object object = null;
        try {
            void var7_17;
            boolean bl = false;
            while (var7_17 < 20000) {
                ldr.addData((Object)((int)var7_17), (Object)((int)var7_17));
                ++var7_17;
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ldr != null) {
                if (object != null) {
                    try {
                        ldr.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ldr.close();
                }
            }
        }
        ldr = ig.dataStreamer("cache2");
        object = null;
        try {
            void var7_21;
            boolean bl = false;
            while (var7_21 < 20000) {
                ldr.addData((Object)((int)var7_21), (Object)new AbstractSnapshotTest.TestValue((int)var7_21, (int)var7_21));
                ++var7_21;
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ldr != null) {
                if (object != null) {
                    try {
                        ldr.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ldr.close();
                }
            }
        }
        long snapshotStartTime = System.currentTimeMillis();
        System.out.println("Create full snapshot");
        SnapshotFuture snapshotFuture = gg.snapshot().createFullSnapshot(null, null);
        boolean seenIntermediate = false;
        SnapshotStatus st0 = null;
        block39: while (!snapshotFuture.isDone() && !seenIntermediate) {
            SnapshotStatus st;
            st0 = st = gg.snapshot().ongoingSnapshotOperation();
            if (st != null) {
                for (Map.Entry e : st.progress().entrySet()) {
                    double progress = (double)((SnapshotProgress)e.getValue()).getProcessed() / (double)((SnapshotProgress)e.getValue()).getTotal();
                    if (!(progress > 0.1) || !(progress < 1.0)) continue;
                    seenIntermediate = true;
                    this.info("Registered progress: " + st.progress());
                    continue block39;
                }
                continue;
            }
            System.out.println("Miss snapshot status");
        }
        assert (progressCnt.get() != 0L) : "No one progress message";
        System.out.println("Finish full snapshot creation, time:" + (System.currentTimeMillis() - snapshotStartTime));
        String msg2 = st0 == null ? "Not one result was obtained for snapshot status" : "Last progress result:" + st0.progress();
        IgniteDbSnapshotNotStableTopologiesTest.assertTrue((String)msg2, (boolean)seenIntermediate);
        snapshotFuture.get();
        this.info("Checking incremental snapshot...");
        IgniteDataStreamer ldr2 = ig.dataStreamer("cache1");
        lsn = null;
        try {
            ldr2.allowOverwrite(true);
            for (int i4 = 0; i4 < 20000; ++i4) {
                ldr2.addData((Object)i4, (Object)(-i4));
            }
        }
        catch (Throwable i4) {
            lsn = i4;
            throw i4;
        }
        finally {
            if (ldr2 != null) {
                if (lsn != null) {
                    try {
                        ldr2.close();
                    }
                    catch (Throwable i4) {
                        ((Throwable)lsn).addSuppressed(i4);
                    }
                } else {
                    ldr2.close();
                }
            }
        }
        IgniteDataStreamer ldr3 = ig.dataStreamer("cache2");
        lsn = null;
        try {
            ldr3.allowOverwrite(true);
            for (int i5 = 0; i5 < 20000; ++i5) {
                ldr3.addData((Object)i5, (Object)new AbstractSnapshotTest.TestValue(i5, -i5));
            }
        }
        catch (Throwable i5) {
            lsn = i5;
            throw i5;
        }
        finally {
            if (ldr3 != null) {
                if (lsn != null) {
                    try {
                        ldr3.close();
                    }
                    catch (Throwable i5) {
                        ((Throwable)lsn).addSuppressed(i5);
                    }
                } else {
                    ldr3.close();
                }
            }
        }
        SnapshotFuture fut2 = gg.snapshot().createSnapshot(null, null);
        boolean seenIntermediate2 = false;
        block43: while (!fut2.isDone() && !seenIntermediate2) {
            SnapshotStatus st = gg.snapshot().ongoingSnapshotOperation();
            if (st == null) continue;
            for (Map.Entry entry : st.progress().entrySet()) {
                double progress = (double)((SnapshotProgress)entry.getValue()).getProcessed() / (double)((SnapshotProgress)entry.getValue()).getTotal();
                if (!(progress > 0.1) || !(progress < 1.0)) continue;
                seenIntermediate2 = true;
                this.info("Registered progress: " + st.progress());
                continue block43;
            }
        }
        this.stopAllGrids();
        IgniteDbSnapshotNotStableTopologiesTest.assertFalse((boolean)this.strLog.toString().contains("AssertionError"));
    }

    @Test
    public void testSnapshotCopy() throws Exception {
        File moveDir = this.createOrCleanMoveDir();
        this.startGrids(2);
        IgniteEx ig = this.ignite(0);
        ig.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ig.plugin("GridGain");
        this.load((Ignite)ig);
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        gg.snapshot().copySnapshot(fut.snapshotOperation().snapshotId(), moveDir, new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE, false, false, null), null).get();
        this.stopAllGrids();
        IgniteDbSnapshotNotStableTopologiesTest.assertTrue((boolean)new File(moveDir.listFiles()[0], "snapshot-meta.bin").exists());
        this.cleanSnapshotDirs(false);
        this.startGrids(2);
        ig = this.ignite(0);
        ig.cluster().active(true);
        this.awaitPartitionMapExchange();
        gg = (GridGain)ig.plugin("GridGain");
        gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), Collections.singleton(moveDir), null, null).get();
        IgniteDbSnapshotNotStableTopologiesTest.assertEquals((int)ig.cache("cache1").size(new CachePeekMode[0]), (int)300);
        IgniteDbSnapshotNotStableTopologiesTest.assertEquals((int)ig.cache("cache2").size(new CachePeekMode[0]), (int)300);
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-13404")
    @Test
    public void testCacheDestroyedDuringSnapshot() throws Exception {
        this.useTestSpi = 1;
        this.startGrids(2);
        IgniteEx ignite = this.ignite(0);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteCache cache = ignite.cache("cache1");
        for (int i = 0; i < 300; ++i) {
            cache.put((Object)i, (Object)i);
        }
        this.forceCheckpoint();
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(Collections.singleton("cache1"), null);
        this.snapshotStartedLatch.await();
        System.out.println("Cache destroy started!");
        IgniteDbSnapshotNotStableTopologiesTest.assertFalse((this.snapshotFinishLatch.getCount() == 0L ? 1 : 0) != 0);
        this.snapshotFinishLatch.countDown();
        cache.destroy();
        System.out.println("Cache destroy finished!");
        IgniteDbSnapshotNotStableTopologiesTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> ((SnapshotFuture)fut).isDone(), (long)10000L));
        try {
            fut.get();
            IgniteDbSnapshotNotStableTopologiesTest.fail((String)"Should get an exception.");
        }
        catch (IgniteException igniteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListWhileSnapshotInProgress() throws Exception {
        List snapshots;
        SnapshotFuture fut;
        this.useTestSpi = 1;
        this.startGrids(2);
        IgniteEx ignite = this.ignite(0);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteCache cache = ignite.cache("cache1");
        for (int i = 0; i < 300; ++i) {
            cache.put((Object)i, (Object)i);
        }
        this.forceCheckpoint();
        try {
            fut = gg.snapshot().createFullSnapshot(Collections.singleton("cache1"), null);
            this.snapshotStartedLatch.await();
            snapshots = gg.snapshot().list(null);
            IgniteDbSnapshotNotStableTopologiesTest.assertTrue((String)snapshots.toString(), (boolean)snapshots.isEmpty());
            IgniteDbSnapshotNotStableTopologiesTest.assertFalse((this.snapshotFinishLatch.getCount() == 0L ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            IgniteDbSnapshotNotStableTopologiesTest.assertFalse((this.snapshotFinishLatch.getCount() == 0L ? 1 : 0) != 0);
            this.snapshotFinishLatch.countDown();
            throw throwable;
        }
        this.snapshotFinishLatch.countDown();
        fut.get();
        snapshots = gg.snapshot().list(null);
        assert (snapshots.size() == 1);
        assert (((SnapshotInfo)snapshots.get(0)).snapshotId() == fut.snapshotOperation().snapshotId());
    }

    @Test
    public void testCreatingCacheProxyDuringSnapshotRestore() throws Exception {
        IgniteEx ignite = (IgniteEx)this.startGridsMultiThreaded(3);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        int keyCnt = 10000;
        try (IgniteDataStreamer streamer = ignite.dataStreamer("cache1");){
            streamer.allowOverwrite(true);
            for (int i = 0; i < keyCnt; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
        }
        SnapshotFuture snapshotFuture = gg.snapshot().createFullSnapshot(null, null);
        snapshotFuture.get();
        CountDownLatch latch = this.addWaitingStageFinishListener(SnapshotOperationStage.FIRST, ignite);
        SnapshotFuture restoreFuture = gg.snapshot().restoreSnapshot(snapshotFuture.snapshotOperation().snapshotId(), null, null);
        latch.await(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        IgniteCache cacheProxy = this.grid(2).cache("cache1");
        IgniteDbSnapshotNotStableTopologiesTest.assertNotNull((Object)cacheProxy);
        IgniteCacheRestartingException e = null;
        try {
            cacheProxy.size(new CachePeekMode[0]);
            restoreFuture.get(200L);
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((int)keyCnt, (int)this.grid(1).cache("cache1").size(new CachePeekMode[0]));
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((int)keyCnt, (int)this.grid(2).cache("cache1").size(new CachePeekMode[0]));
            return;
        }
        catch (IgniteCacheRestartingException ex) {
            e = ex;
            cacheProxy = this.grid(1).getOrCreateCache("cache1");
            try {
                cacheProxy.size(new CachePeekMode[0]);
                restoreFuture.get(200L);
            }
            catch (IgniteCacheRestartingException ex2) {
                ex2.restartFuture().get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
            }
            cacheProxy = this.grid(1).getOrCreateCache("cache1");
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((int)keyCnt, (int)cacheProxy.size(new CachePeekMode[0]));
            IgniteDbSnapshotNotStableTopologiesTest.assertNotNull((Object)((Object)e));
            e.restartFuture().get();
            cacheProxy = this.grid(2).cache("cache1");
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((int)keyCnt, (int)cacheProxy.size(new CachePeekMode[0]));
            return;
        }
    }

    @Test
    public void testCreatingDataStreamerDuringSnapshotRestore() throws Exception {
        Throwable throwable;
        IgniteDataStreamer streamer;
        IgniteEx ignite = (IgniteEx)this.startGridsMultiThreaded(3);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        int keyCnt = 10000;
        try (IgniteDataStreamer streamer2 = ignite.dataStreamer("cache1");){
            streamer2.allowOverwrite(true);
            for (int i = 0; i < keyCnt; ++i) {
                streamer2.addData((Object)i, (Object)i);
            }
        }
        SnapshotFuture snapshotFuture = gg.snapshot().createFullSnapshot(null, null);
        snapshotFuture.get();
        CountDownLatch latch = this.addWaitingStageFinishListener(SnapshotOperationStage.FIRST, ignite);
        SnapshotFuture restoreSnapshot = gg.snapshot().restoreSnapshot(snapshotFuture.snapshotOperation().snapshotId(), null, null);
        latch.await(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        try {
            streamer = this.grid(2).dataStreamer("cache1");
            throwable = null;
            try {
                streamer.addData((Object)1, (Object)1);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (streamer != null) {
                    if (throwable != null) {
                        try {
                            streamer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        streamer.close();
                    }
                }
            }
            restoreSnapshot.get(200L);
        }
        catch (IgniteCacheRestartingException e) {
            e.restartFuture().get();
        }
        streamer = this.grid(2).dataStreamer("cache1");
        throwable = null;
        try {
            streamer.addData((Object)1, (Object)1);
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (streamer != null) {
                if (throwable != null) {
                    try {
                        streamer.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    streamer.close();
                }
            }
        }
    }

    @Test
    public void testCreatingConflictingCacheDuringSnapshotRestore() throws Exception {
        IgniteEx ignite = (IgniteEx)this.startGridsMultiThreaded(3);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        int keyCnt = 10000;
        try (IgniteDataStreamer streamer = ignite.dataStreamer("cache1");){
            streamer.allowOverwrite(true);
            for (int i = 0; i < keyCnt; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
        }
        SnapshotFuture snapshotFuture = gg.snapshot().createFullSnapshot(null, null);
        snapshotFuture.get();
        CountDownLatch latch = this.addWaitingStageFinishListener(SnapshotOperationStage.FIRST, ignite);
        SnapshotFuture restoreSnapshot = gg.snapshot().restoreSnapshot(snapshotFuture.snapshotOperation().snapshotId(), null, null);
        latch.await(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        String grpName = "testCreatingConflictingCacheDuringSnapshotRestore";
        try {
            ignite.createCache(this.getCacheConfig("cache1").setGroupName(grpName));
            DynamicCacheDescriptor descriptor = ignite.context().cache().cacheDescriptor("cache1");
            IgniteDbSnapshotNotStableTopologiesTest.assertFalse((descriptor.groupId() == CU.cacheId((String)grpName) ? 1 : 0) != 0);
            IgniteDbSnapshotNotStableTopologiesTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        restoreSnapshot.get();
    }

    @Test
    public void testStress_Incremental() throws Exception {
        this.startGrids(2);
        IgniteEx ignite = this.ignite(0);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        SnapshotFuture fut1 = gg.snapshot().createFullSnapshot(null, null);
        fut1.get();
        for (int i = 0; i < 20; ++i) {
            System.out.println("Iteration " + i);
            SnapshotFuture fut2 = gg.snapshot().createSnapshot(null, null);
            fut2.get();
        }
    }

    @Test
    public void testIncrementalAfterRestart() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        this.load((Ignite)ignite);
        Set cacheNames = F.asSet((Object[])new String[]{"cache1", "cache2"});
        SnapshotFuture fut1 = gg.snapshot().createFullSnapshot(cacheNames, null);
        fut1.get();
        this.load((Ignite)ignite, 1);
        this.stopAllGrids();
        ignite = this.startGrids(2);
        ignite.cluster().active(true);
        gg = (GridGain)ignite.plugin("GridGain");
        gg.snapshot().restoreSnapshot(fut1.snapshotOperation().snapshotId(), cacheNames, null).get();
        this.load((Ignite)ignite, 2);
        fut1 = gg.snapshot().createFullSnapshot(cacheNames, null);
        fut1.get();
        IgniteCache cache1 = ignite.cache("cache1");
        IgniteCache cache2 = ignite.cache("cache2");
        for (int i = 0; i < 300; i += 2) {
            cache1.put((Object)i, (Object)(i + 100));
            cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, i + 100));
        }
        this.stopAllGrids();
        ignite = this.startGrids(2);
        ignite.cluster().active(true);
        gg = (GridGain)ignite.plugin("GridGain");
        SnapshotFuture fut2 = gg.snapshot().createSnapshot(cacheNames, null);
        fut2.get();
        this.stopAllGrids();
        ignite = this.startGrids(2);
        ignite.cluster().active(true);
        gg = (GridGain)ignite.plugin("GridGain");
        gg.snapshot().restoreSnapshot(fut2.snapshotOperation().snapshotId(), cacheNames, null).get();
        cache1 = ignite.cache("cache1");
        cache2 = ignite.cache("cache2");
        for (int i = 0; i < 300; ++i) {
            Integer val1 = (Integer)cache1.get((Object)i);
            IgniteDbSnapshotNotStableTopologiesTest.assertNotNull((String)("index=" + i), (Object)val1);
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((String)("index=" + i), (int)(i % 2 == 0 ? i + 100 : i + 2), (int)val1);
            AbstractSnapshotTest.TestValue val2 = (AbstractSnapshotTest.TestValue)cache2.get((Object)i);
            IgniteDbSnapshotNotStableTopologiesTest.assertNotNull((String)("index=" + i), (Object)val2);
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((String)("index=" + i), (Object)new AbstractSnapshotTest.TestValue(i, i % 2 == 0 ? i + 100 : i + 2), (Object)val2);
        }
    }

    @Test
    public void testIssueWithEmptyPartitionsWhichWereSomeTimeNotEmpty() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        ignite.cluster().active(true);
        String cacheName = "testIWEPWWSTNE";
        IgniteCache cache = ignite.getOrCreateCache(new CacheConfiguration(cacheName).setBackups(2).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 16)));
        IgniteDbSnapshotNotStableTopologiesTest.loadWithIntsAsync((Ignite)ignite, cacheName, 0, 1).get();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        gg.snapshot().createFullSnapshot(null, null).get();
        cache.clear();
        this.startGrid(2);
        ignite.cluster().setBaselineTopology(ignite.cluster().topologyVersion());
        this.awaitPartitionMapExchange();
        SnapshotFuture snapshotFut = gg.snapshot().createFullSnapshot(null, null);
        snapshotFut.get();
        IgniteDbSnapshotNotStableTopologiesTest.loadWithIntsAsync((Ignite)ignite, cacheName, 0, 1).get();
        SnapshotFuture incrementalFut = gg.snapshot().createSnapshot(null, null);
        incrementalFut.get();
        GridCacheSnapshotManager snapshot = (GridCacheSnapshotManager)this.grid(2).context().cache().context().snapshot();
        long snapshotId = snapshotFut.snapshotOperation().snapshotId();
        SnapshotDescriptorV2 desc = snapshot.getMergedSnapshotDescriptorFromClusterV2(snapshotId, null, null);
        System.err.println(desc);
        gg.snapshot().restoreSnapshot(snapshotId, null, null).get();
        MatcherAssert.assertThat((Object)ignite.cache(cacheName).size(new CachePeekMode[0]), (Matcher)Matchers.is((Object)0));
        gg.snapshot().restoreSnapshot(incrementalFut.snapshotOperation().snapshotId(), null, null).get();
        MatcherAssert.assertThat((Object)ignite.cache(cacheName).size(new CachePeekMode[0]), (Matcher)Matchers.is((Object)300));
        for (int i = 0; i < 300; ++i) {
            MatcherAssert.assertThat((Object)cache.get((Object)i), (Matcher)Matchers.is((Object)i));
        }
    }

    @Test
    public void testCallingSnasphotFunctionalityShouldNotHangIfNodeIsAlreadyStopped() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().active(true);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        gg.snapshot().createFullSnapshot(null, null).get();
        this.stopAllGrids();
        try {
            gg.snapshot().createFullSnapshot(null, null).get();
            IgniteDbSnapshotNotStableTopologiesTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testIncrementalSnapshotPartialFail() throws Exception {
        AbstractSnapshotTest.TestValue val2;
        Integer val1;
        int i;
        this.startGrid(0);
        this.useTestSpi = 1;
        IgniteDbSnapshotNotStableTopologiesTest.assertFalse((this.snapshotFinishLatch.getCount() == 0L ? 1 : 0) != 0);
        this.snapshotFinishLatch.countDown();
        this.startGrid(1);
        IgniteEx ignite = this.ignite(0);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteCache cache1 = ignite.cache("cache1");
        IgniteCache cache2 = ignite.cache("cache2");
        for (int i2 = 0; i2 < 300; ++i2) {
            cache1.put((Object)i2, (Object)i2);
            cache2.put((Object)i2, (Object)new AbstractSnapshotTest.TestValue(i2, i2));
        }
        SnapshotFuture fut1 = gg.snapshot().createFullSnapshot(F.asSet((Object[])new String[]{"cache1", "cache2"}), null);
        fut1.get();
        for (int i3 = 0; i3 < 300; ++i3) {
            cache1.put((Object)i3, (Object)(-i3));
            cache2.put((Object)i3, (Object)new AbstractSnapshotTest.TestValue(-i3, i3));
        }
        this.fail = true;
        try {
            SnapshotFuture fut2 = gg.snapshot().createSnapshot(F.asSet((Object[])new String[]{"cache1", "cache2"}), null);
            fut2.get();
            IgniteDbSnapshotNotStableTopologiesTest.fail();
        }
        catch (Exception fut2) {
            // empty catch block
        }
        U.sleep((long)5000L);
        this.fail = false;
        IgniteDbSnapshotNotStableTopologiesTest.assertEquals((int)1, (int)gg.snapshot().list(null).size());
        SnapshotFuture fut3 = gg.snapshot().createSnapshot(F.asSet((Object[])new String[]{"cache1", "cache2"}), null);
        fut3.get();
        List infos = gg.snapshot().list(null);
        IgniteDbSnapshotNotStableTopologiesTest.assertEquals((int)2, (int)infos.size());
        gg.snapshot().restoreSnapshot(fut1.snapshotOperation().snapshotId(), F.asSet((Object[])new String[]{"cache1", "cache2"}), null).get();
        cache1 = ignite.cache("cache1");
        cache2 = ignite.cache("cache2");
        for (i = 0; i < 300; ++i) {
            val1 = (Integer)cache1.get((Object)i);
            IgniteDbSnapshotNotStableTopologiesTest.assertNotNull((String)("index=" + i), (Object)val1);
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((String)("index=" + i), (int)i, (int)val1);
            val2 = (AbstractSnapshotTest.TestValue)cache2.get((Object)i);
            IgniteDbSnapshotNotStableTopologiesTest.assertNotNull((String)("index=" + i), (Object)val2);
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((String)("index=" + i), (Object)new AbstractSnapshotTest.TestValue(i, i), (Object)val2);
        }
        gg.snapshot().restoreSnapshot(fut3.snapshotOperation().snapshotId(), F.asSet((Object[])new String[]{"cache1", "cache2"}), null).get();
        cache1 = ignite.cache("cache1");
        cache2 = ignite.cache("cache2");
        for (i = 0; i < 300; ++i) {
            val1 = (Integer)cache1.get((Object)i);
            IgniteDbSnapshotNotStableTopologiesTest.assertNotNull((String)("index=" + i), (Object)val1);
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((String)("index=" + i), (int)(-i), (int)val1);
            val2 = (AbstractSnapshotTest.TestValue)cache2.get((Object)i);
            IgniteDbSnapshotNotStableTopologiesTest.assertNotNull((String)("index=" + i), (Object)val2);
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((String)("index=" + i), (Object)new AbstractSnapshotTest.TestValue(-i, i), (Object)val2);
        }
    }

    @Test
    public void testRestoreOnNewTopology_2_Than_5_Local_Restore() throws Exception {
        this.startGrids(2);
        IgniteEx ignite = this.ignite(0);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        this.load((Ignite)ignite);
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        this.load((Ignite)ignite, 1);
        gg.snapshot().createFullSnapshot(null, null).get();
        this.startGrid(2);
        this.startGrid(3);
        this.startGrid(4);
        ignite.cluster().setBaselineTopology(ignite.cluster().topologyVersion());
        IgniteDbSnapshotNotStableTopologiesTest.assertEquals((int)6, (int)ignite.cluster().currentBaselineTopology().size());
        this.awaitPartitionMapExchange();
        this.load((Ignite)ignite, 10);
        gg = (GridGain)ignite.plugin("GridGain");
        List issues = (List)gg.snapshot().checkSnapshot(fut.snapshotOperation().snapshotId(), null, false, null).get();
        MatcherAssert.assertThat((Object)issues, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), null, null, null).get();
        for (int g = 0; g <= 4; ++g) {
            IgniteEx ignite0 = this.grid(g);
            IgniteCache cache1 = ignite0.cache("cache1");
            IgniteCache cache2 = ignite0.cache("cache2");
            for (int i = 0; i < 300; ++i) {
                Integer val1 = (Integer)cache1.get((Object)i);
                IgniteDbSnapshotNotStableTopologiesTest.assertNotNull((String)("index=" + i), (Object)val1);
                IgniteDbSnapshotNotStableTopologiesTest.assertEquals((String)("index=" + i), (int)i, (int)val1);
                AbstractSnapshotTest.TestValue val2 = (AbstractSnapshotTest.TestValue)cache2.get((Object)i);
                IgniteDbSnapshotNotStableTopologiesTest.assertNotNull((String)("index=" + i), (Object)val2);
                IgniteDbSnapshotNotStableTopologiesTest.assertEquals((String)("index=" + i), (Object)new AbstractSnapshotTest.TestValue(i, i), (Object)val2);
            }
        }
        IgniteCache cache1 = ignite.cache("cache1");
        IgniteCache cache2 = ignite.cache("cache2");
        for (int i = 0; i < 300; ++i) {
            cache1.put((Object)i, (Object)0);
            cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, i));
        }
    }

    @Test
    public void testRestoreOnNewTopologyWithOneNodeLeft() throws Exception {
        this.startGrids(3);
        IgniteEx ignite = this.ignite(0);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        ignite.cluster().active(true);
        IgniteDbSnapshotNotStableTopologiesTest.assertEquals((int)4, (int)ignite.cluster().currentBaselineTopology().size());
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        String cacheName = "temp";
        ignite.getOrCreateCache(new CacheConfiguration(cacheName).setBackups(1).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC));
        this.awaitPartitionMapExchange();
        IgniteDbSnapshotNotStableTopologiesTest.loadWithIntsAsync((Ignite)ignite, cacheName, 0, 1).get();
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(Collections.singleton("temp"), null);
        fut.get();
        IgniteDbSnapshotNotStableTopologiesTest.loadWithIntsAsync((Ignite)ignite, cacheName, 1, 1).get();
        gg.snapshot().createFullSnapshot(Collections.singleton("temp"), null).get();
        this.stopGrid(2);
        this.startGrid(3);
        this.startGrid(4);
        ignite.cluster().setBaselineTopology(ignite.cluster().topologyVersion());
        IgniteDbSnapshotNotStableTopologiesTest.assertEquals((int)5, (int)ignite.cluster().currentBaselineTopology().size());
        this.awaitPartitionMapExchange(true, true, null, false, Collections.singleton(cacheName));
        IgniteDbSnapshotNotStableTopologiesTest.loadWithIntsAsync((Ignite)ignite, cacheName, 10, 1).get();
        List issues = (List)gg.snapshot().checkSnapshot(fut.snapshotOperation().snapshotId(), null, false, null).get();
        IgniteDbSnapshotNotStableTopologiesTest.assertTrue((boolean)issues.isEmpty());
        gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), null, null, null).get();
        for (int g = 0; g <= 4; ++g) {
            if (g == 2) continue;
            IgniteEx ignite0 = this.grid(g);
            IgniteCache cache = ignite0.cache(cacheName);
            for (int i = 0; i < 300; ++i) {
                Integer val1 = (Integer)cache.get((Object)i);
                IgniteDbSnapshotNotStableTopologiesTest.assertNotNull((String)("index=" + i), (Object)val1);
                IgniteDbSnapshotNotStableTopologiesTest.assertEquals((String)("index=" + i), (int)i, (int)val1);
            }
        }
        IgniteCache cache = ignite.cache(cacheName);
        for (int i = 0; i < 300; ++i) {
            cache.put((Object)i, (Object)0);
        }
    }

    @Test
    public void testListSnapshotFromPreviousTopology_2_Than_5() throws Exception {
        this.startGrids(2);
        IgniteEx ig = this.ignite(0);
        ig.cluster().baselineAutoAdjustEnabled(false);
        ig.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ig.plugin("GridGain");
        this.load((Ignite)ig);
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.startGrids(5);
        this.startGrid("dummy");
        ig = this.ignite(0);
        ig.cluster().active(true);
        ig.cluster().setBaselineTopology(ig.cluster().topologyVersion());
        IgniteDbSnapshotNotStableTopologiesTest.assertEquals((int)6, (int)ig.cluster().currentBaselineTopology().size());
        gg = (GridGain)ig.plugin("GridGain");
        List infos = gg.snapshot().list(null);
        IgniteDbSnapshotNotStableTopologiesTest.assertEquals((int)2, (int)infos.size());
    }

    @Test
    public void testCancelling_CheckAndDelete() throws Exception {
        SnapshotFuture checkFut;
        this.startGrids(3);
        IgniteEx ignite = this.ignite(0);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        ignite.getOrCreateCache("newCache1");
        try (IgniteDataStreamer streamer = ignite.dataStreamer("newCache1");){
            streamer.allowOverwrite(true);
            for (int i = 0; i < 102400; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
        }
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        SnapshotFuture checkFut0 = checkFut = gg.snapshot().checkSnapshot(fut.snapshotOperation().snapshotId(), null, false, null);
        AtomicReference error = new AtomicReference();
        checkFut0.initFuture().listen((IgniteInClosure & Serializable)f -> {
            try {
                f.get();
                for (Ignite ig : G.allGrids()) {
                    if (ig.configuration().isDaemon()) continue;
                    GridGain gg0 = (GridGain)ig.plugin("GridGain");
                    SnapshotStatus status = gg0.snapshot().ongoingSnapshotOperation();
                    IgniteDbSnapshotNotStableTopologiesTest.assertNotNull((String)(ig.name() + ", futIsDone = " + checkFut0.isDone()), (Object)status);
                    SnapshotOperationInfoImpl snapOpImpl = (SnapshotOperationInfoImpl)status.operation();
                    IgniteDbSnapshotNotStableTopologiesTest.assertEquals((Object)SnapshotOperationType.CHECK, (Object)snapOpImpl.snapshotOperation().type());
                }
            }
            catch (Throwable e) {
                error.set(e);
            }
        });
        checkFut0.initFuture().get();
        Throwable th = (Throwable)error.get();
        if (th != null) {
            throw new Exception(th);
        }
        IgniteFuture cancelCheckFut = gg.snapshot().cancelSnapshotOperation(checkFut.operationId(), null);
        Boolean cancelCheckFutRes = (Boolean)cancelCheckFut.get();
        if (!cancelCheckFutRes.booleanValue()) {
            IgniteDbSnapshotNotStableTopologiesTest.assertTrue((boolean)checkFut.isDone());
            checkFut = gg.snapshot().checkSnapshot(fut.snapshotOperation().snapshotId(), null, false, null);
            cancelCheckFut = gg.snapshot().cancelSnapshotOperation(checkFut.operationId(), null);
            IgniteDbSnapshotNotStableTopologiesTest.assertTrue((boolean)((Boolean)cancelCheckFut.get()));
        }
        for (Object ig : G.allGrids()) {
            GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicateX((Ignite)ig){
                final /* synthetic */ Ignite val$ig;
                {
                    this.val$ig = ignite;
                }

                public boolean applyx() {
                    GridGain gg = (GridGain)this.val$ig.plugin("GridGain");
                    SnapshotStatus status = gg.snapshot().ongoingSnapshotOperation();
                    return status == null;
                }
            }, (long)10000L);
        }
        try {
            checkFut.get();
            IgniteDbSnapshotNotStableTopologiesTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        gg.snapshot().createSnapshot(null, null).get();
        SnapshotFuture delFut = gg.snapshot().forceDeleteSnapshot(fut.snapshotOperation().snapshotId(), null);
        delFut.initFuture().get();
        for (Ignite ig : G.allGrids()) {
            GridGain gg0 = (GridGain)ig.plugin("GridGain");
            SnapshotStatus status = gg0.snapshot().ongoingSnapshotOperation();
            IgniteDbSnapshotNotStableTopologiesTest.assertNotNull((String)("futIsDone = " + delFut.isDone()), (Object)status);
            SnapshotOperationInfoImpl snapOpImpl = (SnapshotOperationInfoImpl)status.operation();
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((Object)SnapshotOperationType.DELETE, (Object)snapOpImpl.snapshotOperation().type());
        }
        try {
            gg.snapshot().cancelSnapshotOperation(delFut.operationId(), null).get();
            IgniteDbSnapshotNotStableTopologiesTest.fail();
        }
        catch (Exception ex) {
            IgniteDbSnapshotNotStableTopologiesTest.assertTrue((ex.getMessage() != null && ex.getMessage().startsWith("Snapshot operation in non-cancelable state!") ? 1 : 0) != 0);
        }
        IgniteFuture cancelDelFut = gg.snapshot().forceCancelSnapshotOperation(delFut.operationId(), null);
        cancelDelFut.get();
        IgniteDbSnapshotNotStableTopologiesTest.assertTrue((boolean)delFut.isDone());
        try {
            delFut.get();
            IgniteDbSnapshotNotStableTopologiesTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (final Ignite ig : G.allGrids()) {
            GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicateX(){

                public boolean applyx() {
                    GridGain gg = (GridGain)ig.plugin("GridGain");
                    SnapshotStatus status = gg.snapshot().ongoingSnapshotOperation();
                    return status == null;
                }
            }, (long)10000L);
        }
        gg.snapshot().createFullSnapshot(null, null).get();
    }

    @Test
    public void testSnapshotApiNotAllowedWhileClusterIsNotActive() throws Exception {
        IgniteEx ignite = this.startGrid(1);
        ignite.cluster().active(true);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        ignite.cache("cache1");
        ignite.cluster().active(false);
        try {
            gg.snapshot().createFullSnapshot(Collections.singleton("cache1"), null).get();
            IgniteDbSnapshotNotStableTopologiesTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSnapshotAndRestoreAfterAddingNodeToClusterWithAnotherSnapshots() throws Exception {
        this.startGrids(2);
        IgniteEx ignite = this.ignite(0);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteCache cache1 = ignite.cache("cache1");
        IgniteCache cache2 = ignite.cache("cache2");
        for (int i = 0; i < 300; ++i) {
            cache1.put((Object)i, (Object)i);
            cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, i));
        }
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        this.startGrid(2);
        this.awaitPartitionMapExchange();
        fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), null, null).get();
        cache1 = ignite.cache("cache1");
        cache2 = ignite.cache("cache2");
        for (int i = 0; i < 300; ++i) {
            Integer val1 = (Integer)cache1.get((Object)i);
            IgniteDbSnapshotNotStableTopologiesTest.assertNotNull((String)("index=" + i), (Object)val1);
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((String)("index=" + i), (int)i, (int)val1);
            AbstractSnapshotTest.TestValue val2 = (AbstractSnapshotTest.TestValue)cache2.get((Object)i);
            IgniteDbSnapshotNotStableTopologiesTest.assertNotNull((String)("index=" + i), (Object)val2);
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((String)("index=" + i), (Object)new AbstractSnapshotTest.TestValue(i, i), (Object)val2);
        }
    }

    @Test
    public void testClientWithoutPersistenceConfiguration() throws Exception {
        int i;
        IgniteEx ignite = this.startGrid(0);
        this.clientMode = true;
        this.skipPersistenceCfg = true;
        IgniteEx client = this.startGrid(1);
        ignite.cluster().active(true);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        GridGain ggClient = (GridGain)client.plugin("GridGain");
        this.awaitPartitionMapExchange();
        IgniteCache cache1 = ignite.cache("cache1");
        for (int i2 = 0; i2 < 300; ++i2) {
            cache1.put((Object)i2, (Object)i2);
        }
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, "test");
        fut.get();
        for (int i3 = 0; i3 < 300; ++i3) {
            cache1.put((Object)i3, (Object)(-i3));
        }
        SnapshotFuture fut2 = ggClient.snapshot().createFullSnapshot(null, "test2");
        fut2.get();
        ggClient.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), null, "test").get();
        for (i = 0; i < 300; ++i) {
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((Object)i, (Object)cache1.get((Object)i));
        }
        gg.snapshot().restoreSnapshot(fut2.snapshotOperation().snapshotId(), null, "test2").get();
        for (i = 0; i < 300; ++i) {
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((Object)(-i), (Object)cache1.get((Object)i));
        }
    }

    @Test
    public void testStress_SnapshotUnderLoad_Incremental() throws Exception {
        this.testConcurrentWrites(true);
    }

    @Test
    public void testStress_SnapshotUnderLoad_Full() throws Exception {
        this.testConcurrentWrites(false);
    }

    private void testConcurrentWrites(boolean incremental) throws Exception {
        int i;
        IgniteEx ignite = this.startGrids(4);
        ignite.active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        final IgniteCache cache1 = ignite.cache("cache1");
        final IgniteCache cache2 = ignite.cache("cache2");
        try (IgniteDataStreamer streamer = ignite.dataStreamer("cache1");){
            streamer.allowOverwrite(true);
            for (i = 0; i < 100000; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
        }
        streamer = ignite.dataStreamer("cache2");
        var7_7 = null;
        try {
            streamer.allowOverwrite(true);
            for (i = 0; i < 100000; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
        }
        catch (Throwable i2) {
            var7_7 = i2;
            throw i2;
        }
        finally {
            if (streamer != null) {
                if (var7_7 != null) {
                    try {
                        streamer.close();
                    }
                    catch (Throwable i2) {
                        var7_7.addSuppressed(i2);
                    }
                } else {
                    streamer.close();
                }
            }
        }
        ArrayList<Long> snapshots = new ArrayList<Long>();
        final AtomicBoolean stop = new AtomicBoolean();
        Thread thread1 = new Thread(new Runnable(){

            @Override
            public void run() {
                int i = 300000;
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                while (!stop.get()) {
                    cache1.put((Object)i++, (Object)i);
                    if (i % 1000 != 0) continue;
                    for (int j = 0; j < 100; ++j) {
                        int key = rnd.nextInt(i);
                        int val = rnd.nextInt();
                        cache1.put((Object)key, (Object)val);
                    }
                }
            }
        });
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                int i = 300000;
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                while (!stop.get()) {
                    cache2.put((Object)i++, (Object)i);
                    if (i % 1000 != 0) continue;
                    for (int j = 0; j < 100; ++j) {
                        int key = rnd.nextInt(i);
                        int val = rnd.nextInt();
                        cache2.put((Object)key, (Object)val);
                    }
                }
            }
        });
        thread1.start();
        thread2.start();
        for (int i3 = 0; i3 < 5; ++i3) {
            SnapshotFuture fut = incremental && i3 != 0 ? gg.snapshot().createSnapshot(Collections.singleton("cache1"), null) : gg.snapshot().createFullSnapshot(Collections.singleton("cache1"), null);
            fut.get();
            snapshots.add(fut.snapshotOperation().snapshotId());
            fut = incremental && i3 != 0 ? gg.snapshot().createSnapshot(Collections.singleton("cache2"), null) : gg.snapshot().createFullSnapshot(Collections.singleton("cache2"), null);
            fut.get();
            snapshots.add(fut.snapshotOperation().snapshotId());
        }
        stop.set(true);
        thread1.join();
        thread2.join();
        for (Long id : snapshots) {
            gg.snapshot().restoreSnapshot(id.longValue(), null, null).get();
            cache1.put((Object)1, (Object)1);
            cache1.clear();
            cache2.put((Object)2, (Object)2);
            cache2.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelRestoreWhenCachesStart() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        ignite.active(true);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        GridSnapshot db = gg.snapshot();
        IgniteDbSnapshotNotStableTopologiesTest.assertNotNull((Object)db);
        SnapshotFuture fut = db.createFullSnapshot(null, "test-msg");
        fut.get();
        SnapshotFuture restoreFut = db.restoreSnapshot(fut.snapshotOperation().snapshotId(), null, null);
        this.discoveryLatch = new CountDownLatch(1);
        this.skipStartCaches = true;
        try {
            this.discoveryLatch.await();
            try {
                gg.snapshot().cancelSnapshotOperation(restoreFut.operationId(), null).get();
                IgniteDbSnapshotNotStableTopologiesTest.fail();
            }
            catch (IgniteException igniteException) {
                // empty catch block
            }
        }
        finally {
            this.skipStartCaches = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelWhenCoordinatorInNonCancellableState() throws Exception {
        this.startGrids(3);
        IgniteEx ignite = this.grid(2);
        ignite.cluster().active(true);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        GridSnapshot db = gg.snapshot();
        BlockTcpCommunicationSpi spi = (BlockTcpCommunicationSpi)ignite.configuration().getCommunicationSpi();
        spi.pause(CancelSnapshotOperationMessage.class);
        IgniteDbSnapshotNotStableTopologiesTest.assertNotNull((Object)db);
        SnapshotFuture fut = db.createFullSnapshot(null, "test-msg");
        fut.get();
        SnapshotFuture restoreFut = db.restoreSnapshot(fut.snapshotOperation().snapshotId(), null, null);
        restoreFut.initFuture().get();
        IgniteFuture cancelFut = gg.snapshot().cancelSnapshotOperation(restoreFut.operationId(), null);
        this.discoveryLatch = new CountDownLatch(1);
        this.skipStartCaches = true;
        try {
            this.discoveryLatch.await();
            IgniteDbSnapshotNotStableTopologiesTest.assertFalse((boolean)cancelFut.isDone());
            spi.resume();
            try {
                cancelFut.get();
                IgniteDbSnapshotNotStableTopologiesTest.fail();
            }
            catch (IgniteException igniteException) {
                // empty catch block
            }
        }
        finally {
            this.skipStartCaches = false;
        }
    }

    @Test
    public void testLeftNodesDuringSnapshotCreation() throws Exception {
        this.startGrids(2);
        IgniteEx ig = this.grid(0);
        ig.cluster().active(true);
        GridGainImpl gg = (GridGainImpl)ig.plugin("GridGain");
        GridSnapshot snp = gg.snapshot();
        this.load((Ignite)ig, 0);
        SnapshotFuture snapFut = snp.createFullSnapshot(Collections.singleton("cache1"), "snapshot");
        snapFut.initFuture().get();
        this.stopGrid("dummy", false);
        try {
            snapFut.get();
        }
        catch (IgniteException e) {
            IgniteDbSnapshotNotStableTopologiesTest.fail((String)"Snapshot should be successful after one node left");
        }
    }

    @Test
    public void testMassiveClientNodesDieingDuringSnapshotRestore() throws Exception {
        this.startGrids(2);
        IgniteEx ig = this.grid("dummy");
        ig.cluster().active(true);
        GridGainImpl gg = (GridGainImpl)ig.plugin("GridGain");
        GridSnapshot snp = gg.snapshot();
        this.load((Ignite)ig, 0);
        SnapshotFuture snapCreateFut = snp.createFullSnapshot(Collections.singleton("cache1"), "snapshot");
        snapCreateFut.get();
        int clientCnt = this.getBackupCount() + 1;
        for (int i = 0; i < clientCnt; ++i) {
            this.startGrid("client" + i);
        }
        SnapshotFuture snapRestoreFut = snp.restoreSnapshot(snapCreateFut.snapshotOperation().snapshotId(), Collections.singleton("cache1"), "snapshot");
        snapRestoreFut.initFuture().get();
        gg = (GridGainImpl)this.grid(0).plugin("GridGain");
        GridCacheSnapshotManager mgr = (GridCacheSnapshotManager)gg.provider().databaseManager();
        SnapshotOperationFuture snapOpFut = mgr.snapshotFuture();
        IgniteDbSnapshotNotStableTopologiesTest.assertNotNull((Object)snapOpFut);
        for (int i = 0; i < clientCnt; ++i) {
            this.stopGrid("client" + i);
        }
        try {
            snapOpFut.get();
        }
        catch (IgniteException e) {
            IgniteDbSnapshotNotStableTopologiesTest.fail((String)"Snapshot should be successful after any client nodes left");
        }
    }

    @Test
    public void testRestoreCacheWhichNameClashWithExistentOneInDifferentGroup() throws Exception {
        this.stopAllGrids();
        IgniteEx ig = this.startGrids(2);
        ig.cluster().active(true);
        String CACHE = "cache";
        String GRP1 = "grp1";
        String GRP2 = "grp2";
        CacheConfiguration cache1 = new CacheConfiguration();
        cache1.setName(CACHE);
        cache1.setGroupName(GRP1);
        cache1.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cache1.setBackups(1);
        cache1.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 16));
        IgniteCache cache = ig.createCache(cache1);
        cache.put((Object)0, (Object)0);
        IgniteDbSnapshotNotStableTopologiesTest.assertEquals((Object)0, (Object)cache.get((Object)0));
        GridGain gg = (GridGain)ig.plugin("GridGain");
        GridSnapshot snapshot = gg.snapshot();
        SnapshotFuture snapFut = snapshot.createFullSnapshot(null, null);
        long id = snapFut.snapshotOperation().snapshotId();
        snapFut.get();
        cache.destroy();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        ig = this.startGrids(2);
        ig.cluster().active(true);
        CacheConfiguration cache2 = new CacheConfiguration();
        cache2.setName(CACHE);
        cache2.setGroupName(GRP2);
        cache2.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cache2.setBackups(1);
        cache2.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 16));
        cache = ig.getOrCreateCache(cache2);
        IgniteDbSnapshotNotStableTopologiesTest.assertNull((Object)cache.get((Object)0));
        gg = (GridGain)ig.plugin("GridGain");
        snapshot = gg.snapshot();
        try {
            snapshot.restoreSnapshot(id, null, null).get();
            IgniteDbSnapshotNotStableTopologiesTest.fail((String)"We should check cache names clash before operation start");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.startsWith((String)"There are clashes between existing caches and that ones which could be restored from snapshot(id="));
        }
        List issues = (List)snapshot.checkSnapshot(id, null, false, null).get();
        MatcherAssert.assertThat((Object)issues, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((SnapshotIssue)issues.get(0)).getIssue(), (Matcher)Matchers.startsWith((String)"There are clashes between existing caches and that ones which could be restored from snapshot(id="));
    }

    @Test
    public void testDiscoCacheReuseOnSnapshotCreate() throws Exception {
        this.startGridsMultiThreaded(2);
        boolean exchangelessSnapshot = IgniteSystemProperties.getBoolean((String)"GG_EXCHANGELESS_SNAPSHOT_CREATION", (boolean)true);
        this.assertDiscoCacheReuse(new AffinityTopologyVersion(4L, 1), exchangelessSnapshot);
        this.stopGrid(1);
        this.assertDiscoCacheReuse(new AffinityTopologyVersion(5L, 0), exchangelessSnapshot);
        this.stopGrid("client");
        this.assertDiscoCacheReuse(new AffinityTopologyVersion(6L, 0), exchangelessSnapshot);
        this.grid("dummy").createCache("default");
        this.assertDiscoCacheReuse(exchangelessSnapshot ? new AffinityTopologyVersion(6L, 1) : new AffinityTopologyVersion(6L, 2), exchangelessSnapshot);
        this.grid("dummy").destroyCache("default");
        this.assertDiscoCacheReuse(exchangelessSnapshot ? new AffinityTopologyVersion(6L, 2) : new AffinityTopologyVersion(6L, 4), exchangelessSnapshot);
    }

    private void assertDiscoCacheReuse(AffinityTopologyVersion v1, boolean exchangelessSnapshot) {
        IgniteEx ig = this.grid("dummy");
        GridGain gg = (GridGain)ig.plugin("GridGain");
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        AffinityTopologyVersion v2 = exchangelessSnapshot ? v1 : v1.nextMinorVersion();
        for (Ignite ignite : G.allGrids()) {
            String[] props;
            GridBoundedConcurrentLinkedHashMap discoCacheHist = (GridBoundedConcurrentLinkedHashMap)U.field((Object)((IgniteEx)ignite).context().discovery(), (String)"discoCacheHist");
            DiscoCache discoCache1 = (DiscoCache)discoCacheHist.get((Object)v1);
            DiscoCache discoCache2 = (DiscoCache)discoCacheHist.get((Object)v2);
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((Object)v1, (Object)discoCache1.version());
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((Object)v2, (Object)discoCache2.version());
            for (String prop : props = new String[]{"loc", "rmtNodes", "allNodes", "srvNodes", "daemonNodes", "rmtNodesWithCaches", "allCacheNodes", "allCacheNodes", "cacheGrpAffNodes", "nodeMap", "minNodeVer"}) {
                IgniteDbSnapshotNotStableTopologiesTest.assertSame((Object)U.field((Object)discoCache1, (String)prop), (Object)U.field((Object)discoCache2, (String)prop));
            }
            Set alives1 = (Set)U.field((Object)discoCache1, (String)"alives");
            Set alives2 = (Set)U.field((Object)discoCache2, (String)"alives");
            if (exchangelessSnapshot) {
                IgniteDbSnapshotNotStableTopologiesTest.assertSame((Object)alives1, (Object)alives2);
            } else {
                IgniteDbSnapshotNotStableTopologiesTest.assertNotSame((Object)alives1, (Object)alives2);
            }
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((Object)alives1, (Object)alives2);
        }
    }

    @Test
    public void testStartFullSnapshotCreationFromClientRightAfterIncrementalFailWhenClientConnectedToCoordinator() throws Exception {
        int i;
        this.stopAllGrids();
        int cnt = 5;
        this.startGridsMultiThreaded(cnt);
        IgniteEx ig = this.grid(1);
        ig.cluster().active(true);
        this.load((Ignite)ig);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        this.stopGrid(0);
        this.awaitPartitionMapExchange();
        gg.snapshot().createFullSnapshot(null, null).get();
        ig = this.startGrid(0);
        ig.resetLostPartitions((Collection)staticCacheConfigs);
        gg = (GridGain)this.client(ig).plugin("GridGain");
        gg.snapshot().createSnapshot(Collections.singleton("cache1"), null).get();
        SnapshotFuture snapshot = gg.snapshot().createFullSnapshot(Collections.singleton("cache1"), null);
        snapshot.get();
        List issues = (List)gg.snapshot().checkSnapshot(snapshot.snapshotOperation().snapshotId(), null, false, null).get();
        IgniteDbSnapshotNotStableTopologiesTest.assertTrue((boolean)issues.isEmpty());
        for (i = 1; i < cnt; ++i) {
            this.stopGrid(i);
        }
        for (i = 1; i < cnt; ++i) {
            this.startGrid(i);
        }
        ig.resetLostPartitions((Collection)staticCacheConfigs);
        this.awaitPartitionMapExchange();
        gg.snapshot().createSnapshot(null, null).get();
        snapshot = gg.snapshot().createFullSnapshot(null, null);
        snapshot.get();
        issues = (List)gg.snapshot().checkSnapshot(snapshot.snapshotOperation().snapshotId(), null, false, null).get();
        IgniteDbSnapshotNotStableTopologiesTest.assertTrue((boolean)issues.isEmpty());
    }

    private Ignite client(final IgniteEx nodeToJoin) throws Exception {
        this.clientMode = true;
        IgniteConfiguration configuration = this.getConfiguration("client");
        TcpDiscoverySpi spi = (TcpDiscoverySpi)configuration.getDiscoverySpi();
        spi.setIpFinder((TcpDiscoveryIpFinder)new TcpDiscoveryVmIpFinder(false){
            {
                super(x0);
                this.setAddresses(Collections.singleton("127.0.0.1:" + ((TcpDiscoveryNode)nodeToJoin.context().discovery().localNode()).discoveryPort()));
            }
        });
        Ignite client = this.startGrid("client", configuration);
        this.clientMode = false;
        return client;
    }

    @Test
    public void testCleanupAfterNotSuccessfulCacheRestart() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().active(true);
        String cacheName = "c";
        IgniteCache cache = ignite.getOrCreateCache(cacheName);
        GridCacheProcessor cacheProcessor = ignite.context().cache();
        ArrayList<DynamicCacheChangeRequest> cacheStopReqs = new ArrayList<DynamicCacheChangeRequest>();
        cacheStopReqs.add(cacheProcessor.createStopRequest(cacheName, true, IgniteUuid.randomUuid(), false));
        cacheProcessor.dynamicChangeCaches(cacheStopReqs).get();
        try {
            ignite.createCache(cacheName);
            IgniteDbSnapshotNotStableTopologiesTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.startGrid(2);
            IgniteDbSnapshotNotStableTopologiesTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ObjectName anyInstance = ignite.configuration().getMBeanServer().queryNames(null, Query.isInstanceOf(new StringValueExp("org.gridgain.grid.persistentstore.SnapshotMXBean"))).iterator().next();
        ignite.configuration().getMBeanServer().invoke(anyInstance, "resetRestartingCaches", null, null);
        IgniteDbSnapshotNotStableTopologiesTest.assertNull((Object)ignite.cache(cacheName));
        ignite.createCache(cacheName);
        this.startGrid(2);
    }

    @Test
    public void testDynamicIndexForDynamicCacheRestoredWithRebuild() throws Exception {
        this.testDynamicIndexForCacheRestoredWithRebuild(false);
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-10478")
    @Test
    public void testDynamicIndexForStaticCacheRestoredWithRebuild() throws Exception {
        this.testDynamicIndexForCacheRestoredWithRebuild(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDynamicIndexForCacheRestoredWithRebuild(boolean staticCache) throws Exception {
        IgniteCache cache;
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().active(true);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        if (staticCache) {
            cache = ignite.cache("cache2");
            Collection descs = ignite.context().cache().cacheDescriptors().values();
            List results = descs.stream().filter(DynamicCacheDescriptor::staticallyConfigured).map(DynamicCacheDescriptor::cacheName).filter(k -> k.equals("cache2")).limit(1L).collect(Collectors.toList());
            IgniteDbSnapshotNotStableTopologiesTest.assertFalse((boolean)results.isEmpty());
        } else {
            cache = ignite.createCache(this.getCacheConfig("cache2").setName("DYN_CACHE_NAME").setGroupName("DYN_GROUP_NAME"));
        }
        String cacheName = cache.getName();
        try {
            File[] nodeDirs;
            cache.query(new SqlFieldsQuery("CREATE INDEX \"testvalue_v5_idx\" on TESTVALUE (v5)")).getAll();
            cache.query(new SqlFieldsQuery("CREATE INDEX \"testvalue_v5_IDX\" on TESTVALUE (v5)")).getAll();
            for (int i = 0; i < 300; ++i) {
                cache.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(-i, i));
            }
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((int)300, (int)cache.query(new SqlFieldsQuery("select * from TestValue where v5 between 0 and ?").setArgs(new Object[]{300})).getAll().size());
            String plan = ((List)cache.query(new SqlFieldsQuery("explain select * from TestValue where v5 between 0 and ?").setArgs(new Object[]{300})).getAll().get(0)).get(0).toString();
            IgniteDbSnapshotNotStableTopologiesTest.assertTrue((String)plan, (boolean)plan.contains("testvalue_v5_idx"));
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(Collections.singleton(cacheName), null);
            long snapshotId = fut.snapshotOperation().snapshotId();
            fut.get();
            for (File nodeDir : nodeDirs = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)("snapshot/" + FileDatabaseSnapshotSpi.generateSnapshotDirName((long)snapshotId, null)), (boolean)false).listFiles()) {
                File[] cacheDirs;
                for (File cacheDir : cacheDirs = nodeDir.listFiles()) {
                    if (!cacheDir.isDirectory()) continue;
                    this.assertIndexExists(cacheDir, gg.configuration().getSnapshotConfiguration().getCompressionOption());
                }
            }
            gg.snapshot().restoreSnapshot(snapshotId, null, null).get();
            cache = ignite.cache(cacheName);
            cache.indexReadyFuture().get();
            IgniteEx iex = this.grid(0);
            iex.cache(cacheName).indexReadyFuture().get();
            IgniteInternalCache internalCache = iex.context().cache().cache(cacheName);
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((int)0, (int)internalCache.context().cache().map().internalSize());
            IgniteH2Indexing idx = (IgniteH2Indexing)ignite.context().query().getIndexing();
            GridH2Table tbl = idx.schemaManager().dataTable(cacheName, "TESTVALUE");
            IgniteDbSnapshotNotStableTopologiesTest.assertNotNull((Object)tbl);
            IgniteDbSnapshotNotStableTopologiesTest.assertFalse((boolean)tbl.rebuildFromHashInProgress());
            IgniteDbSnapshotNotStableTopologiesTest.assertEquals((int)300, (int)cache.query(new SqlFieldsQuery("select * from TestValue where v5 between 0 and ?").setArgs(new Object[]{300})).getAll().size());
            plan = ((List)cache.query(new SqlFieldsQuery("explain select * from TestValue where v5 between 0 and ?").setArgs(new Object[]{300})).getAll().get(0)).get(0).toString();
            IgniteDbSnapshotNotStableTopologiesTest.assertTrue((String)plan, (boolean)plan.contains("testvalue_v5_idx"));
            this.stopAllGrids();
            cache = null;
            this.cleanPersistenceDir();
            ignite = this.startGrid(0);
            ignite.cluster().active(true);
            gg = (GridGain)ignite.plugin("GridGain");
            gg.snapshot().restoreSnapshot(snapshotId, null, null).get();
            ignite.getOrCreateCache(this.getCacheConfig("localCache"));
            cache = ignite.cache(cacheName);
            IgniteDbSnapshotNotStableTopologiesTest.assertNotNull((String)(cacheName + " not initialized"), (Object)cache);
            cache.indexReadyFuture().get();
            plan = ((List)cache.query(new SqlFieldsQuery("explain select * from TestValue where v5 between 0 and ?").setArgs(new Object[]{300})).getAll().get(0)).get(0).toString();
            IgniteDbSnapshotNotStableTopologiesTest.assertTrue((String)plan, (boolean)plan.contains("testvalue_v5_idx"));
        }
        finally {
            if (cache != null) {
                cache.query(new SqlFieldsQuery("DROP INDEX IF EXISTS testvalue_v5_idx")).getAll();
            }
            if (!staticCache) {
                ignite.destroyCache(cacheName);
            }
        }
    }

    protected static class BlockTcpCommunicationSpi
    extends TcpCommunicationSpi {
        volatile Class msgCls;
        ConcurrentLinkedQueue<T3<ClusterNode, Message, IgniteInClosure>> queue = new ConcurrentLinkedQueue();
        @LoggerResource
        private IgniteLogger log;

        protected BlockTcpCommunicationSpi() {
        }

        public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) throws IgniteSpiException {
            Class msgCls0 = this.msgCls;
            if (msgCls0 != null && ((GridIoMessage)msg).message().getClass().equals(msgCls0)) {
                this.queue.add((T3<ClusterNode, Message, IgniteInClosure>)new T3((Object)node, (Object)msg, ackC));
                this.log.info("Block message: " + msg);
                return;
            }
            super.sendMessage(node, msg, ackC);
        }

        public synchronized void pause(Class msgCls) {
            this.msgCls = msgCls;
        }

        public synchronized void resume() {
            this.msgCls = null;
            for (T3<ClusterNode, Message, IgniteInClosure> msg : this.queue) {
                super.sendMessage((ClusterNode)msg.get1(), (Message)msg.get2(), (IgniteInClosure)msg.get3());
            }
            this.queue.clear();
        }
    }

    private class TestDiscoverySpi
    extends TcpDiscoverySpi {
        private TestDiscoverySpi() {
        }

        public void sendCustomEvent(DiscoverySpiCustomMessage customMsg) throws IgniteException {
            if (IgniteDbSnapshotNotStableTopologiesTest.this.skipStartCaches) {
                DiscoveryCustomMessage delegate;
                if (customMsg instanceof FinishSnapshotOperationAckDiscoveryMessage) {
                    IgniteDbSnapshotNotStableTopologiesTest.this.discoveryLatch.countDown();
                    return;
                }
                DynamicCacheChangeBatch cacheChangeBatch = null;
                if (customMsg instanceof DynamicCacheChangeBatch) {
                    cacheChangeBatch = (DynamicCacheChangeBatch)customMsg;
                } else if (customMsg.getClass().getName().contains("CustomMessageWrapper") && (delegate = (DiscoveryCustomMessage)U.field((Object)customMsg, (String)"delegate")) instanceof DynamicCacheChangeBatch) {
                    cacheChangeBatch = (DynamicCacheChangeBatch)delegate;
                }
                if (cacheChangeBatch != null) {
                    Collection requests = cacheChangeBatch.requests();
                    for (DynamicCacheChangeRequest request : requests) {
                        if (request.stop()) continue;
                        IgniteDbSnapshotNotStableTopologiesTest.this.discoveryLatch.countDown();
                        return;
                    }
                }
            }
            super.sendCustomEvent(customMsg);
        }
    }

    protected static class InhibitorySnapshotSession
    implements SnapshotSession {
        private final SnapshotSession delegate;
        private final long sleepTime = 200L;
        private final long freq = 500L;
        private final AtomicLong pageCnt = new AtomicLong();

        private InhibitorySnapshotSession(SnapshotSession delegate) {
            this.delegate = delegate;
        }

        public SnapshotEncryptionOptions snapshotEncryptionOptions() {
            return this.delegate.snapshotEncryptionOptions();
        }

        public SnapshotOutputStream getOrOpenForFile(int grpId, int partId) throws IgniteCheckedException {
            final SnapshotOutputStream out = this.delegate.getOrOpenForFile(grpId, partId);
            return new SnapshotOutputStream(){

                public void plainWrite(ByteBuffer data) throws IgniteCheckedException {
                    out.write(data);
                    if (pageCnt.incrementAndGet() % 500L == 0L) {
                        try {
                            System.out.println("Snapshot in progress sleep:200");
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException e) {
                            System.out.println("Fail wait sleep time, " + e.getMessage());
                            Thread.currentThread().interrupt();
                        }
                    }
                }

                public void close() {
                    delegate.close();
                }

                public long position() {
                    return out.position();
                }
            };
        }

        public void writeMetadata(ByteBuffer metadata) throws IgniteCheckedException {
            this.delegate.writeMetadata(metadata);
        }

        public void cancel() throws IgniteException {
            this.delegate.cancel();
        }

        public void close() throws IgniteException {
            this.delegate.close();
        }

        public Runnable onPartitionFinished(GroupPartitionId groupPartitionId) throws IgniteCheckedException {
            return this.delegate.onPartitionFinished(groupPartitionId);
        }

        public void writeRegistry(ByteBuffer registry) throws IgniteCheckedException {
            this.delegate.writeRegistry(registry);
        }
    }

    protected static class InhibitoryDatabaseSnapshotSpi
    extends FileDatabaseSnapshotSpi {
        protected InhibitoryDatabaseSnapshotSpi() {
        }

        public SnapshotSession sessionForSnapshotCreation(long id, boolean fullSnapshot, File storePath, CompressionOption compression, int compressionLevel, FutureTaskQueue<GroupPartitionId> partitionsPostProcessor, SnapshotOperationContext snapshotOperationContext, @Nullable MessageDigestFactory msgDigestFactory, @Nullable SnapshotEncryptionOptions encryptionOptions) throws IgniteCheckedException {
            return new InhibitorySnapshotSession(super.sessionForSnapshotCreation(id, fullSnapshot, storePath, compression, compressionLevel, partitionsPostProcessor, snapshotOperationContext, msgDigestFactory, encryptionOptions));
        }
    }

    private class TestSnapshotSessionWrapper
    implements SnapshotSession {
        private final SnapshotSession delegate;

        private TestSnapshotSessionWrapper(SnapshotSession delegate) {
            this.delegate = delegate;
        }

        public SnapshotEncryptionOptions snapshotEncryptionOptions() {
            return this.delegate.snapshotEncryptionOptions();
        }

        public SnapshotOutputStream getOrOpenForFile(int grpId, int partId) throws IgniteCheckedException {
            try {
                if (IgniteDbSnapshotNotStableTopologiesTest.this.fail) {
                    throw new IgniteCheckedException("Test exception");
                }
                if (Thread.currentThread().getName().contains("snapshot")) {
                    IgniteDbSnapshotNotStableTopologiesTest.this.snapshotStartedLatch.countDown();
                    IgniteDbSnapshotNotStableTopologiesTest.this.snapshotFinishLatch.await();
                }
            }
            catch (InterruptedException e) {
                throw new IgniteCheckedException((Throwable)e);
            }
            return this.delegate.getOrOpenForFile(grpId, partId);
        }

        public void writeMetadata(ByteBuffer metadata) throws IgniteCheckedException {
            this.delegate.writeMetadata(metadata);
        }

        public void cancel() {
            this.delegate.cancel();
        }

        public void close() throws IgniteException {
            this.delegate.close();
        }

        public Runnable onPartitionFinished(GroupPartitionId groupPartitionId) throws IgniteCheckedException {
            return this.delegate.onPartitionFinished(groupPartitionId);
        }

        public void writeRegistry(ByteBuffer registry) throws IgniteCheckedException {
            this.delegate.writeRegistry(registry);
        }
    }

    protected class TestSnapshotSpiWrapper
    implements DatabaseSnapshotSpi {
        @IgniteInstanceResource
        private Ignite ignite;
        @LoggerResource
        private IgniteLogger log;
        private final DatabaseSnapshotSpi delegate;

        protected TestSnapshotSpiWrapper(DatabaseSnapshotSpi delegate) {
            this.delegate = delegate;
        }

        public File snapshotWorkingDirectory() {
            return null;
        }

        public void start() throws IgniteCheckedException {
            if (this.delegate instanceof FileDatabaseSnapshotSpi) {
                try {
                    Field igniteField = FileDatabaseSnapshotSpi.class.getDeclaredField("ignite");
                    igniteField.setAccessible(true);
                    igniteField.set(this.delegate, this.ignite);
                    Field logField = FileDatabaseSnapshotSpi.class.getDeclaredField("log");
                    logField.setAccessible(true);
                    logField.set(this.delegate, this.log);
                }
                catch (Exception e) {
                    throw new IgniteCheckedException((Throwable)e);
                }
            }
            this.delegate.start();
        }

        public void stop() throws IgniteCheckedException {
            this.delegate.stop();
        }

        public SnapshotSession sessionForSnapshotCreation(long id, boolean fullSnapshot, File storePath, CompressionOption compression, int compressionLevel, FutureTaskQueue<GroupPartitionId> futureTaskQueue, SnapshotOperationContext snapshotOperationContext, @Nullable MessageDigestFactory msgDigestFactory, @Nullable SnapshotEncryptionOptions encryptionOptions) throws IgniteCheckedException {
            return new TestSnapshotSessionWrapper(this.delegate.sessionForSnapshotCreation(id, fullSnapshot, storePath, compression, compressionLevel, futureTaskQueue, snapshotOperationContext, msgDigestFactory, encryptionOptions));
        }

        public Iterable<SnapshotMetadataV2> localSnapshots(boolean sort) throws IgniteCheckedException {
            return this.delegate.localSnapshots(sort);
        }

        public Iterable<SnapshotMetadataV2> listRemoteSnapshots(SnapshotPath searchPath) throws IgniteCheckedException {
            return this.delegate.listRemoteSnapshots(searchPath);
        }

        public Snapshot snapshot(long id, Collection<SnapshotPath> optSearchPath, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, boolean ignoreMissedClasses, @Nullable SnapshotSecurityLevel securityLevel, boolean needDecryptKeys) {
            return this.delegate.snapshot(id, optSearchPath, c, ignoreMissedClasses, securityLevel, needDecryptKeys);
        }

        public void copySinglePartition(long snapshotId, int grpId, int partId, SnapshotPath path, SnapshotOperationContext context) throws IgniteCheckedException {
            this.delegate.copySinglePartition(snapshotId, grpId, partId, path, context);
        }

        public void deleteSnapshot(long id, SnapshotOperationContext ctx) {
            this.deleteSnapshot(id, ctx);
        }

        public boolean isCopyRequired(long snapshotId, SnapshotPath pathToMove) throws IgniteCheckedException {
            return this.delegate.isCopyRequired(snapshotId, pathToMove);
        }

        public void startCopy(long snapshotId, SnapshotPath path) throws IgniteCheckedException {
            this.delegate.startCopy(snapshotId, path);
        }

        public void copySnapshotEntirely(long snapshotId, SnapshotPath path, SnapshotOperationContext ctx, ExecutorService taskExecutor) throws IgniteCheckedException {
            this.delegate.copySnapshotEntirely(snapshotId, path, ctx, taskExecutor);
        }

        public void copyMetadata(long snapshotId, SnapshotPath path, SnapshotOperationContext context) throws IgniteCheckedException {
            this.delegate.copyMetadata(snapshotId, path, context);
        }

        public void copyDigestRegistry(long snapshotId, SnapshotPath path, SnapshotOperationContext context) throws IgniteCheckedException {
            this.delegate.copyDigestRegistry(snapshotId, path, context);
        }

        public void copyWalSegments(long snapshotId, Collection<File> segments, SnapshotPath path, SnapshotOperationContext context) throws IgniteCheckedException {
            this.delegate.copyWalSegments(snapshotId, segments, path, context);
        }

        public void finishCopy(long snapshotId, SnapshotPath path) throws IgniteCheckedException {
            this.delegate.finishCopy(snapshotId, path);
        }

        public <T extends SnapshotPath> T findSnapshotDir(T path, long id) {
            return (T)this.delegate.findSnapshotDir(path, id);
        }

        public <T extends SnapshotPath> T generateSnapshotFolderPath(T path, long id) {
            return (T)this.delegate.findSnapshotDir(path, id);
        }

        public FsSnapshotPath findLocalCurNodeSnapshotDir(long id) {
            return this.delegate.findLocalCurNodeSnapshotDir(id);
        }

        public FsSnapshotPath generateCurNodeSnapshotFolderPath(long id) {
            return this.delegate.generateCurNodeSnapshotFolderPath(id);
        }

        public <T extends SnapshotPath> T generateCurNodeSnapshotFolderPathWithLabel(T snapshotBaseFolder, long id, String label) {
            return (T)this.delegate.generateCurNodeSnapshotFolderPathWithLabel(snapshotBaseFolder, id, label);
        }

        public <T extends SnapshotPath> T findCurNodeSnapshotDir(T path, long id) {
            return (T)this.delegate.findCurNodeSnapshotDir(path, id);
        }

        @Nullable
        public SnapshotMetadataV2 nextLocalSnapshot(long id) {
            return this.delegate.nextLocalSnapshot(id);
        }

        public Map<Long, Long> remoteSnapshotWalSizes(@Nullable SnapshotPath searchPath) {
            return this.delegate.remoteSnapshotWalSizes(searchPath);
        }

        public long remoteSnapshotWalSizes(@Nullable SnapshotPath searchPath, long snapshotId) {
            return this.delegate.remoteSnapshotWalSizes(searchPath, snapshotId);
        }
    }
}

