/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsFullMessage;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.junit.Test;

public class IgniteDbSnapshotMultiNodeRebalanceAfterRestoreTest
extends AbstractSnapshotTest {
    private static final int CACHES = 10;

    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        CacheConfiguration[] cCfgs = new CacheConfiguration[10];
        for (int i = 0; i < cCfgs.length; ++i) {
            CacheConfiguration cCfgi;
            cCfgs[i] = cCfgi = new CacheConfiguration("cache_group_" + i).setCacheMode(CacheMode.PARTITIONED).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setBackups(2);
        }
        cfg.setCacheConfiguration(cCfgs);
        GridGainConfiguration ggCfg = null;
        for (PluginConfiguration pluginConfiguration : cfg.getPluginConfigurations()) {
            if (!(pluginConfiguration instanceof GridGainConfiguration)) continue;
            ggCfg = (GridGainConfiguration)pluginConfiguration;
            break;
        }
        assert (ggCfg != null);
        cfg.setCommunicationSpi((CommunicationSpi)new TestRecordingCommunicationSpi());
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.cleanPersistenceDir();
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        this.cleanPersistenceDir();
    }

    @Test
    public void testCheckRebalanceAfterRestore() throws Exception {
        IgniteCache cache;
        IgniteEx ignite0 = this.startGrids(4);
        ignite0.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite0.plugin("GridGain");
        this.stopGrid(2);
        this.stopGrid(3);
        HashSet<String> cacheNames = new HashSet<String>();
        for (int j = 0; j < 10; ++j) {
            cache = ignite0.cache("cache_group_" + j);
            for (int i = 0; i < 2048; ++i) {
                cache.put((Object)i, (Object)i);
            }
            cacheNames.add(cache.getName());
        }
        gg.snapshot().createFullSnapshot(cacheNames, null).get();
        List list = gg.snapshot().list(null);
        long id = ((SnapshotInfo)list.get(0)).snapshotId();
        IgniteEx ignite2 = this.startGrid(2);
        IgniteEx ignite3 = this.startGrid(3);
        for (int j = 0; j < 10; ++j) {
            cache = ignite0.cache("cache_group_" + j);
            for (int i = 0; i < 2048; ++i) {
                cache.put((Object)i, (Object)(i * 2));
            }
        }
        CountDownLatch restorePauseLatch = new CountDownLatch(1);
        CountDownLatch restoreStartLatch = this.nextRestoreShouldAwait(restorePauseLatch);
        SnapshotFuture restoreSnapshot = gg.snapshot().restoreSnapshot(id, cacheNames, null);
        IgniteDbSnapshotMultiNodeRebalanceAfterRestoreTest.assertTrue((boolean)restoreStartLatch.await(this.getTestTimeout(), TimeUnit.MILLISECONDS));
        TestRecordingCommunicationSpi.spi((Ignite)this.ignite(0)).blockMessages((IgniteBiPredicate)new IgniteBiPredicate<ClusterNode, Message>(){

            public boolean apply(ClusterNode clusterNode, Message msg) {
                boolean res;
                boolean bl = res = msg instanceof GridDhtPartitionsFullMessage && ((GridDhtPartitionsFullMessage)msg).exchangeId() != null && ((GridDhtPartitionsFullMessage)msg).topologyVersion().topologyVersion() == 8L && ((GridDhtPartitionsFullMessage)msg).topologyVersion().minorTopologyVersion() == 3 && clusterNode.order() == 7L;
                if (res) {
                    log.info("Message should be blocked");
                }
                return res;
            }
        });
        restorePauseLatch.countDown();
        U.sleep((long)10000L);
        TestRecordingCommunicationSpi.spi((Ignite)this.ignite(0)).stopBlock();
        log.info("Stopped block");
        restoreSnapshot.get();
        U.sleep((long)5000L);
        boolean correct = true;
        this.awaitPartitionMapExchange();
        block4: for (int j = 0; j < 10; ++j) {
            cache = ignite2.cache("cache_group_" + j);
            for (int i = 0; i < 2048; ++i) {
                if (cache.get((Object)i) == null) {
                    log.info(String.format("Name = %s; nullValue key = %d", cache.getName(), i));
                    correct = false;
                    continue block4;
                }
                if ((Integer)cache.get((Object)i) == i) continue;
                correct = false;
            }
        }
        IgniteDbSnapshotMultiNodeRebalanceAfterRestoreTest.assertTrue((boolean)correct);
        this.awaitPartitionMapExchange();
    }

    protected long getPartitionMapExchangeTimeout() {
        return 120000L;
    }
}

