/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteFutureTimeoutException;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.gridgain.grid.persistentstore.snapshot.file.FileSnapshot;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class IgniteDbSnapshotDuringTopologyChangeTest
extends AbstractSnapshotTest {
    public static final String SERVER = "server";
    private int backupCount;
    private FileDatabaseSnapshotSpi spi;

    @Override
    protected int getBackupCount() {
        return this.backupCount;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanSnapshotDirs();
        this.backupCount = 0;
    }

    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration configuration = super.getConfiguration(gridName);
        if (this.spi != null) {
            GridCacheSnapshotManager.TEST_SNAPSHOT_SPI.set(this.spi);
            this.spi = null;
        }
        return configuration;
    }

    protected long getTestTimeout() {
        return 600000L;
    }

    @Test
    public void testSnapshotDuringClientRestartTest() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().active(true);
        String cacheNamePrefix = "cache-";
        int cacheNumbers = 20;
        ArrayList<CacheConfiguration> cacheConfigurations = new ArrayList<CacheConfiguration>();
        for (int i = 0; i < 20; ++i) {
            CacheConfiguration cfg = new CacheConfiguration(cacheNamePrefix + i).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
            cacheConfigurations.add(cfg);
        }
        ignite.createCaches(cacheConfigurations);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        SnapshotFuture future = gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), null, null);
        final AtomicBoolean stop = new AtomicBoolean();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!stop.get()) {
                        IgniteDbSnapshotDuringTopologyChangeTest.this.startGrid("client");
                        Thread.sleep(2000L);
                        IgniteDbSnapshotDuringTopologyChangeTest.this.stopGrid("client", false);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        future.get();
        stop.set(true);
        String name = cacheNamePrefix + 1;
        for (int i = 0; i < 20; ++i) {
            ignite.cache(name).put((Object)i, (Object)i);
        }
    }

    @Test
    public void testCoordinatorLeftDuringSnapshot() throws Exception {
        IgniteEx crd = this.startGrid(0);
        IgniteEx second = this.startGrid(1);
        this.startGrid(2);
        crd.cluster().active(true);
        try (IgniteDataStreamer streamer = crd.dataStreamer("cache1");){
            streamer.allowOverwrite(true);
            for (int i = 0; i < 10000; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
        }
        GridGain gg = (GridGain)crd.plugin("GridGain");
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.initFuture().get();
        this.stopGrid(0, true);
        IgniteFuture operationFuture = ((GridGain)second.plugin("GridGain")).snapshot().ongoingSnapshotOperationFuture();
        if (operationFuture != null) {
            operationFuture.get(this.getTestTimeout());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNodeStartDuringSnapshotRestore() throws Exception {
        String snapshotMessage = "Test";
        final CountDownLatch latch = new CountDownLatch(2);
        this.spi = new FileDatabaseSnapshotSpi(){

            public FileSnapshot snapshot(long id, Collection<SnapshotPath> optSearchPaths, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, boolean ignoreMissedClasses, @Nullable SnapshotSecurityLevel securityLevel, boolean needDecryptKeys) {
                FileSnapshot snapshot = super.snapshot(id, optSearchPaths, c, ignoreMissedClasses, securityLevel, needDecryptKeys);
                if (snapshot.metadata().message().equals("Test")) {
                    boolean isRestore = false;
                    for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                        if (!"startLocalSnapshotRestore".equals(element.getMethodName())) continue;
                        isRestore = true;
                        break;
                    }
                    if (isRestore) {
                        try {
                            latch.countDown();
                            latch.await();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                return snapshot;
            }
        };
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().active(true);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        try (IgniteDataStreamer streamer = ignite.dataStreamer("cache1");){
            streamer.allowOverwrite(true);
            for (int i = 0; i < 50000; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
        }
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, "Test");
        fut.get();
        SnapshotFuture future = gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), null, null);
        try {
            try {
                this.startGrid("client");
                IgniteDbSnapshotDuringTopologyChangeTest.fail((String)"Starting client grid should be failed");
            }
            catch (Exception expected) {
                this.info("Caught expected exception: " + expected);
            }
            try {
                this.startGrid(SERVER);
                IgniteDbSnapshotDuringTopologyChangeTest.fail((String)"Starting server grid should be failed");
            }
            catch (Exception expected) {
                this.info("Caught expected exception: " + expected);
            }
        }
        finally {
            latch.countDown();
        }
        future.get();
        this.startGrid(SERVER);
    }

    @Test
    public void testCoordintatorLeftDuringSingleCopyModeCopying_Backup2() throws Exception {
        this.backupCount = 2;
        this.nodeLeftDuringSnapshotCopyInSingleCopyFileMode(0, 1, true);
    }

    @Test
    public void testNonCoordintatorLeftDuringSingleCopyModeCopying_Backup2_MinimalBatches() throws Exception {
        System.setProperty("GG_SNAPSHOT_COPY_MAX_WORK_BATCH_SIZE", "1");
        try {
            this.backupCount = 2;
            this.nodeLeftDuringSnapshotCopyInSingleCopyFileMode(1, 0, true);
        }
        finally {
            System.clearProperty("GG_SNAPSHOT_COPY_MAX_WORK_BATCH_SIZE");
        }
    }

    @Test
    public void testNonCoordintatorLeftDuringSingleCopyModeCopying_Backup2() throws Exception {
        this.backupCount = 2;
        this.nodeLeftDuringSnapshotCopyInSingleCopyFileMode(1, 0, true);
    }

    @Test
    public void testCoordintatorLeftDuringSingleCopyModeCopying_Backup1() throws Exception {
        this.backupCount = 1;
        this.nodeLeftDuringSnapshotCopyInSingleCopyFileMode(0, 1, true);
    }

    @Test
    public void testCoordintatorLeftDuringSingleCopyModeCopying_Backup1_WithMinimalBatches() throws Exception {
        System.setProperty("GG_SNAPSHOT_COPY_MAX_WORK_BATCH_SIZE", "1");
        try {
            this.backupCount = 1;
            this.nodeLeftDuringSnapshotCopyInSingleCopyFileMode(0, 1, true);
        }
        finally {
            System.clearProperty("GG_SNAPSHOT_COPY_MAX_WORK_BATCH_SIZE");
        }
    }

    @Test
    public void testNonCoordintatorLeftDuringSingleCopyModeCopying_Backup1() throws Exception {
        this.backupCount = 1;
        this.nodeLeftDuringSnapshotCopyInSingleCopyFileMode(1, 0, true);
    }

    @Test
    public void testCoordintatorLeftDuringSingleCopyModeCopying_Backup0() throws Exception {
        this.nodeLeftDuringSnapshotCopyInSingleCopyFileMode(0, 1, false);
    }

    @Test
    public void testNonCoordintatorLeftDuringSingleCopyModeCopying_Backup0() throws Exception {
        this.nodeLeftDuringSnapshotCopyInSingleCopyFileMode(1, 0, false);
    }

    private void nodeLeftDuringSnapshotCopyInSingleCopyFileMode(int leavingNode, int lastingNode, boolean shouldBeOk) throws Exception {
        IgniteEx crd = this.startGrid(0);
        IgniteEx second = this.startGrid(1);
        this.startGrid(2);
        crd.cluster().active(true);
        try (IgniteDataStreamer streamer = crd.dataStreamer("cache1");){
            streamer.allowOverwrite(true);
            for (int i = 0; i < 10000; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
        }
        GridGain gg = (GridGain)crd.plugin("GridGain");
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        File dir = this.createOrCleanMoveDir();
        SnapshotFuture future = gg.snapshot().copySnapshot(fut.snapshotOperation().snapshotId(), dir, new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE, true, true, null), null);
        future.initFuture().get();
        this.stopGrid(leavingNode, true);
        GridSnapshot snapshot = ((GridGain)this.grid(lastingNode).plugin("GridGain")).snapshot();
        IgniteFuture operationFuture = snapshot.ongoingSnapshotOperationFuture();
        if (operationFuture != null) {
            operationFuture.get(this.getTestTimeout());
        }
        if (shouldBeOk) {
            List snapshotIssueList = (List)snapshot.checkSnapshot(fut.snapshotOperation().snapshotId(), Collections.singleton(dir), false, null).get();
            IgniteDbSnapshotDuringTopologyChangeTest.assertTrue((boolean)snapshotIssueList.isEmpty());
        }
    }

    @Test
    public void testSnapshotOperationWithRandomNodeBlinks() throws Exception {
        this.backupCount = 2;
        IgniteEx crd = this.startGrid(0);
        final int nodesCnt = 6;
        ArrayList<IgniteEx> nodes = new ArrayList<IgniteEx>();
        nodes.add(crd);
        for (int i = 1; i < nodesCnt; ++i) {
            nodes.add(this.startGrid(i));
        }
        crd.cluster().active(true);
        try (IgniteDataStreamer streamer = crd.dataStreamer("cache1");){
            streamer.allowOverwrite(true);
            for (int i = 0; i < 1000; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
        }
        final AtomicBoolean stop = new AtomicBoolean(false);
        final AtomicInteger blinkCnt = new AtomicInteger(0);
        final AtomicReference<Object> err = new AtomicReference<Object>(null);
        IgniteInternalFuture blinkFut = GridTestUtils.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                while (!stop.get()) {
                    try {
                        int nodeIdx = ThreadLocalRandom.current().nextInt(1, nodesCnt);
                        IgniteDbSnapshotDuringTopologyChangeTest.this.stopGrid(nodeIdx);
                        IgniteDbSnapshotDuringTopologyChangeTest.this.startGrid(nodeIdx);
                        blinkCnt.incrementAndGet();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        err.compareAndSet(null, e);
                        stop.set(true);
                    }
                }
            }
        }, (String)"blinky");
        int iterations = 0;
        long curTs = System.currentTimeMillis();
        while (System.currentTimeMillis() - curTs < 30000L) {
            GridCacheSnapshotManager mgr = (GridCacheSnapshotManager)crd.context().cache().context().snapshot();
            SnapshotFuture testFut = mgr.startGlobalTestSnapshotOperation(Collections.emptyMap(), null);
            try {
                testFut.get(20000L);
            }
            catch (IgniteFutureTimeoutException ignored) {
                IgniteDbSnapshotDuringTopologyChangeTest.fail((String)"Snapshot operation timed out.");
            }
            ++iterations;
        }
        log.info(">>> Completed " + iterations + " iterations with " + blinkCnt.get() + " blinks");
        IgniteDbSnapshotDuringTopologyChangeTest.assertTrue((iterations > 0 ? 1 : 0) != 0);
        IgniteDbSnapshotDuringTopologyChangeTest.assertTrue((blinkCnt.get() > 0 ? 1 : 0) != 0);
        stop.set(true);
        blinkFut.get();
        IgniteDbSnapshotDuringTopologyChangeTest.assertNull(err.get());
    }
}

