/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.commons.vfs2.provider.sftp.BytesIdentityInfo;
import org.apache.commons.vfs2.provider.sftp.IdentityProvider;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.gridgain.grid.configuration.SftpConfiguration;
import org.gridgain.grid.internal.persistentstore.snapshot.file.remote.sftp.SftpFilesCache;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotRemotePath;
import org.gridgain.grid.persistentstore.snapshot.file.remote.VFS2SnapshotPath;
import org.jetbrains.annotations.Nullable;

public class SnapshotPathFactory {
    private static StandardFileSystemManager MANAGER;
    private static final String CONFIG_RESOURCE = "/org/gridgain/grid/internal/persistentstore/snapshot/file/remote/providers.xml";

    @Nullable
    public static SnapshotPath create(@Nullable SnapshotRemotePath remotePath, @Nullable SftpConfiguration sftpConfiguration) {
        if (remotePath == null) {
            return null;
        }
        if (remotePath.path() != null) {
            return new FsSnapshotPath(remotePath.path());
        }
        if (remotePath.uri() != null) {
            return SnapshotPathFactory.create(remotePath, sftpConfiguration == null ? null : sftpConfiguration.getKeyPath(), sftpConfiguration == null ? null : sftpConfiguration.getPassphrase(), remotePath.keyAlias());
        }
        return null;
    }

    @Nullable
    private static SnapshotPath create(@Nullable SnapshotRemotePath file, @Nullable String privateKeyPath, @Nullable String passPhrase, @Nullable String jksKeyAlias) {
        if (file == null) {
            return null;
        }
        if (file.path() != null) {
            return new FsSnapshotPath(file.path());
        }
        if (file.uri() != null) {
            String path = file.uri().toString();
            try {
                StandardFileSystemManager manager = SnapshotPathFactory.getManager();
                FileSystemOptions opts = new FileSystemOptions();
                SftpFileSystemConfigBuilder.getInstance().setStrictHostKeyChecking(opts, "no");
                SftpFileSystemConfigBuilder.getInstance().setUserDirIsRoot(opts, false);
                if (privateKeyPath != null) {
                    Key pk;
                    FileInputStream in;
                    KeyStore ks;
                    try {
                        ks = KeyStore.getInstance("JKS");
                    }
                    catch (Exception e) {
                        throw new IgniteException("Failed to get key store instance.", (Throwable)e);
                    }
                    File ksFile = new File(privateKeyPath);
                    if (!ksFile.exists() || !ksFile.canRead()) {
                        throw new IgniteException("Key store file doesn't exist or is not readable: " + ksFile.getAbsolutePath());
                    }
                    try {
                        in = new FileInputStream(ksFile);
                    }
                    catch (IOException e) {
                        throw new IgniteException("Failed to open key store file: " + ksFile.getAbsolutePath(), (Throwable)e);
                    }
                    try {
                        ks.load(in, passPhrase.toCharArray());
                        pk = ks.getKey(jksKeyAlias, passPhrase.toCharArray());
                    }
                    catch (Exception e) {
                        throw new IOException("Failed to get private key from key store [keystore=" + privateKeyPath + ", alias=" + jksKeyAlias + ']', e);
                    }
                    finally {
                        U.close((AutoCloseable)in, null);
                    }
                    StringWriter stringWriter = new StringWriter();
                    try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);){
                        pemWriter.writeObject((Object)pk);
                    }
                    BytesIdentityInfo identityInfo = new BytesIdentityInfo(stringWriter.toString().getBytes(StandardCharsets.UTF_8), null);
                    SftpFileSystemConfigBuilder.getInstance().setIdentityProvider(opts, new IdentityProvider[]{identityInfo});
                }
                return new VFS2SnapshotPath(manager, manager.resolveFile(path, opts));
            }
            catch (IOException e) {
                throw new IgniteException("Invalid destination path. " + path, (Throwable)e);
            }
        }
        return null;
    }

    public static synchronized StandardFileSystemManager getManager() throws FileSystemException {
        if (MANAGER == null) {
            StandardFileSystemManager manager = new StandardFileSystemManager();
            URL url = SnapshotPathFactory.class.getResource(CONFIG_RESOURCE);
            assert (url != null);
            manager.setConfiguration(url);
            manager.setFilesCache((FilesCache)new SftpFilesCache());
            manager.init();
            MANAGER = manager;
        }
        return MANAGER;
    }

    @Nullable
    public static Collection<SnapshotPath> create(@Nullable Collection<SnapshotRemotePath> files, @Nullable IgniteLogger log, @Nullable SftpConfiguration sftpConfiguration) {
        if (files == null) {
            return null;
        }
        return files.stream().map(file -> {
            try {
                return SnapshotPathFactory.create(file, sftpConfiguration);
            }
            catch (IgniteException e) {
                if (log != null) {
                    log.warning("Cannot convert File", (Throwable)e);
                }
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

