/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactoryImpl;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.encryption.noop.NoopEncryptionSpi;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CacheSnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.Snapshot;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotEncryptionOptions;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotInputStream;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.CachedSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.MessageDigestFactory;
import org.gridgain.grid.persistentstore.SnapshotRegistryTransformer;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.gridgain.grid.persistentstore.snapshot.file.FileIndexMissingException;
import org.gridgain.grid.persistentstore.snapshot.file.PreviousSnapshotsIterable;
import org.gridgain.grid.persistentstore.snapshot.file.SnapshotDigestRegistryCache;
import org.gridgain.grid.persistentstore.snapshot.file.SnapshotInputStreamFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSnapshot
implements Snapshot {
    public static final int SINGLE_COPY_NO_PARTITION_SIZE = -1;
    private final IgniteLogger log;
    private final long id;
    private final SnapshotPath snapshotDir;
    @GridToStringExclude
    private final FileDatabaseSnapshotSpi snapshotSpi;
    @GridToStringExclude
    private final IgniteConfiguration igCfg;
    private final Map<Long, FileSnapshot> previousSnapshots = new HashMap<Long, FileSnapshot>();
    private final Map<Long, String> consistentIdForUniquePartitionId = new HashMap<Long, String>();
    private final Map<T2<Integer, BitSet>, Set<String>> indexes = new HashMap<T2<Integer, BitSet>, Set<String>>();
    private final Collection<SnapshotPath> optSearchPath;
    private final IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c;
    private final boolean ignoreMissedClasses;
    private final boolean defaultPath;
    private int lastCacheGrpId;
    private String lastConsistentId;
    private final SnapshotSecurityLevel securityLevel;
    @GridToStringExclude
    private final MessageDigestFactory msgDigestFactory;
    @GridToStringExclude
    private final SnapshotRegistryTransformer registryTransformer;
    @GridToStringExclude
    private final GridCacheSharedContext cctx;
    private SnapshotMetadataV2 metadataMerged;
    private SnapshotInputStreamFactory inputStreamFactory;

    public FileSnapshot(IgniteConfiguration igCfg, FileDatabaseSnapshotSpi snapshotSpi, long id, SnapshotPath snapshotDir, Collection<SnapshotPath> optSearchPath, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, boolean ignoreMissedClasses, boolean defaultPath, SnapshotSecurityLevel securityLevel, MessageDigestFactory msgDigestFactory, SnapshotRegistryTransformer registryTransformer, GridCacheSharedContext cctx) {
        this.log = igCfg.getGridLogger().getLogger(this.getClass());
        this.igCfg = igCfg;
        this.snapshotSpi = snapshotSpi;
        this.id = id;
        this.snapshotDir = CachedSnapshotPath.cachedPath((SnapshotPath)snapshotDir);
        this.optSearchPath = optSearchPath;
        this.c = c;
        this.ignoreMissedClasses = ignoreMissedClasses;
        this.defaultPath = defaultPath;
        this.securityLevel = securityLevel == null ? SnapshotSecurityLevel.DISABLED : securityLevel;
        this.msgDigestFactory = msgDigestFactory;
        this.registryTransformer = registryTransformer;
        this.cctx = cctx;
    }

    public long id() {
        return this.id;
    }

    public Set<Integer> cacheGroupIds() {
        return this.metadata().cacheGroupIds();
    }

    public boolean isDefaultPath() {
        return this.defaultPath;
    }

    protected static PageMetaIO getPageIo(int type, int ver) {
        try {
            return (PageMetaIO)PageIO.getPageIO((int)type, (int)ver);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public SnapshotPath snapshotDirectory() {
        return this.snapshotDir;
    }

    private void collectSingleCopySnapshotsForCacheGroup(FileSnapshot snapshot, Map<Long, FileSnapshot> snapshotMap, Set<Long> singleCpSnapshots, int cacheGrpId) {
        if (snapshot == null) {
            return;
        }
        SnapshotMetadataV2 snapMeta = snapshot.metadata();
        CacheSnapshotMetadata cacheMeta = (CacheSnapshotMetadata)snapMeta.cacheGroupsMetadata().get(cacheGrpId);
        assert (cacheMeta != null) : "Cache metadata not found for snapshot. " + snapshot.id + ":" + cacheGrpId;
        if (snapMeta.singleCopyFlagSupported()) {
            if (snapMeta.isSingleCopied()) {
                singleCpSnapshots.add(snapshot.id);
            }
        } else {
            Map cId2PartSizeMap;
            boolean allPartitionsAreForSingleNodeOnly = true;
            Iterator iterator = cacheMeta.partitionSizesPerNode().values().iterator();
            while (iterator.hasNext() && !(cId2PartSizeMap = (Map)iterator.next()).containsValue(-1)) {
                if (cId2PartSizeMap.values().stream().allMatch(cnt -> cnt == 0) || cId2PartSizeMap.size() <= 1) continue;
                allPartitionsAreForSingleNodeOnly = false;
                break;
            }
            if (allPartitionsAreForSingleNodeOnly) {
                singleCpSnapshots.add(snapshot.id);
            }
        }
        String consistentId = U.maskForFileName((CharSequence)this.cctx.kernalContext().discovery().localNode().consistentId().toString());
        Long prevSnapshotId = cacheMeta.previousSnapshotId(consistentId);
        this.collectSingleCopySnapshotsForCacheGroup(snapshotMap.get(prevSnapshotId), snapshotMap, singleCpSnapshots, cacheGrpId);
    }

    public Iterable<Snapshot> getPreviousSnapshots(@Nullable Set<Integer> groupIds, @Nullable Collection<SnapshotPath> paths) {
        SnapshotMetadataV2 metadata = this.metadata();
        if (metadata.fullSnapshot()) {
            return Collections.emptyList();
        }
        Set currentSnapshotGroupIds = metadata.cacheGroupIds();
        HashSet<Integer> targetGroupIds = new HashSet<Integer>(currentSnapshotGroupIds);
        if (groupIds != null) {
            targetGroupIds.retainAll(groupIds);
        }
        String consistentId = U.maskForFileName((CharSequence)this.cctx.kernalContext().discovery().localNode().consistentId().toString());
        return new PreviousSnapshotsIterable(this.id, consistentId, targetGroupIds, this.snapshotSpi, paths, this.ignoreMissedClasses, this.securityLevel);
    }

    public boolean isPresent() {
        return true;
    }

    private void collectSnapshotsForCacheGroup(FileSnapshot snapshot, Map<Long, FileSnapshot> snapshotMap, Map<Long, String> partIdToCId, int grpId) {
        if (!snapshot.metadata().fullSnapshot()) {
            CacheSnapshotMetadata cacheMeta = (CacheSnapshotMetadata)snapshot.metadata().cacheGroupsMetadata().get(grpId);
            if (cacheMeta == null) {
                return;
            }
            for (Long prevSnapshotId : cacheMeta.previousSnapshotIds()) {
                if (prevSnapshotId == null || snapshotMap.containsKey(prevSnapshotId)) continue;
                Snapshot prevSnapshot = this.snapshotSpi.snapshot((long)prevSnapshotId, (Collection)this.optSearchPath, (IgniteBiClosure)null, this.ignoreMissedClasses, this.securityLevel, true);
                if (prevSnapshot == null || prevSnapshot.metadata() == null) {
                    snapshotMap.put(prevSnapshotId, null);
                    continue;
                }
                SnapshotMetadataV2 metadata = prevSnapshot.metadata();
                snapshotMap.put(prevSnapshotId, (FileSnapshot)prevSnapshot);
                if (metadata.fullSnapshot()) {
                    for (CacheSnapshotMetadata cacheMetaFull : metadata.cacheGroupsMetadata().values()) {
                        block2: for (Map.Entry e : cacheMetaFull.partitionSizesPerNode().entrySet()) {
                            Map cIdsWithSizes = (Map)e.getValue();
                            for (Integer sizeInPages : cIdsWithSizes.values()) {
                                if (sizeInPages != -1) continue;
                                for (Map.Entry e0 : cIdsWithSizes.entrySet()) {
                                    if ((Integer)e0.getValue() <= 0) continue;
                                    partIdToCId.put(SnapshotUtils.uniquePartId(cacheMetaFull.groupId(), (Integer)e.getKey()), (String)e0.getKey());
                                    continue block2;
                                }
                                continue block2;
                            }
                        }
                    }
                    continue;
                }
                super.collectSnapshotsForCacheGroup((FileSnapshot)prevSnapshot, snapshotMap, partIdToCId, grpId);
            }
        }
    }

    @Nullable
    private SnapshotInputStream getIndexStream(String consistentId, int grpId, int pageSize) {
        SnapshotPath file = this.getIndexPath(consistentId, grpId);
        if (file == null) {
            return null;
        }
        return this.getInputStreamFactory().makeInputStream(file, grpId, 65535, pageSize, consistentId, false);
    }

    @Nullable
    private SnapshotPath getIndexPath(String consistentId, int grpId) {
        SnapshotPath nodeSnapshotDir = this.snapshotDir.resolve(consistentId);
        SnapshotPath nodeCacheSnapshotDir = nodeSnapshotDir.resolve(Integer.toString(grpId));
        return nodeCacheSnapshotDir.resolveRegularOrCompressed("index.bin");
    }

    private SnapshotInputStream getStream(long snapshotId, int cacheGrpId, int partId, int pageSize, String consistentId) {
        FileSnapshot snapshot = this.getSnapshot(snapshotId);
        SnapshotMetadataV2 metadata = snapshot.metadata();
        CacheSnapshotMetadata cacheMeta = (CacheSnapshotMetadata)metadata.cacheGroupsMetadata().get(cacheGrpId);
        boolean initWALFileInput = metadata.exchangelessSnapshot();
        if (cacheMeta == null) {
            U.warn((IgniteLogger)this.log, (Object)("Get stream for snapshot (id = " + snapshotId + "): cacheMeta is null! grpId=" + cacheGrpId + ", cacheMetadata.size=" + metadata.cacheGroupsMetadata().size()));
            return null;
        }
        Map map = (Map)cacheMeta.partitionSizesPerNode().get(partId);
        if (map == null || map.isEmpty()) {
            U.warn((IgniteLogger)this.log, (Object)("Get stream for snapshot (id = " + snapshotId + "): partitionSizesPerNode is empty! grpId=" + cacheGrpId + ", partId=" + partId + ", cacheMeta.partitionSizesPerNode.size=" + cacheMeta.partitionSizesPerNode().size()));
            return null;
        }
        if (consistentId == null) {
            if (this.consistentIdForUniquePartitionId.containsKey(SnapshotUtils.uniquePartId(cacheGrpId, partId))) {
                String cId = this.consistentIdForUniquePartitionId.get(SnapshotUtils.uniquePartId(cacheGrpId, partId));
                SnapshotPath partitionFile = snapshot.getPartitionPathForCache(cacheGrpId, partId, cId);
                SnapshotInputStream stream = snapshot.getInputStreamFactory().makeInputStream(partitionFile, cacheGrpId, partId, pageSize, cId, initWALFileInput);
                if (stream == null) {
                    U.warn((IgniteLogger)this.log, (Object)("Getting stream for partition (grpId=" + cacheGrpId + ", partId=" + partId + ") for snapshot (id = " + snapshotId + ") failed because we couldn't find partition file: consistentId=" + cId + ", path=" + partitionFile.getAbsolutePath() + ", case - single copy for partition which should be saved by node = " + consistentId + (metadata.fullSnapshot() ? "(was file manually deleted?)" : "(node which only copied partition in -single-mode could be offline when creating or copying incremental snapshot was initialized, try to do copy of the full snapshot again, id=" + metadata.id() + ").")));
                }
                return stream;
            }
            if (cacheGrpId == this.lastCacheGrpId && this.lastConsistentId != null) {
                if (map.containsKey(this.lastConsistentId)) {
                    SnapshotPath partitionFile = snapshot.getPartitionPathForCache(cacheGrpId, partId, this.lastConsistentId);
                    SnapshotInputStream stream = snapshot.getInputStreamFactory().makeInputStream(partitionFile, cacheGrpId, partId, pageSize, this.lastConsistentId, initWALFileInput);
                    if (stream == null && this.log.isDebugEnabled()) {
                        this.log.debug("Getting stream for partition (grpId=" + cacheGrpId + ", partId=" + partId + ") for snapshot (id = " + snapshotId + ") failed because we couldn't find partition file: path=" + partitionFile.getAbsolutePath() + ", case - continue searching for previous group and in certain consistenId.");
                    }
                    return stream;
                }
                U.warn((IgniteLogger)this.log, (Object)("Getting stream for partition (grpId=" + cacheGrpId + ", partId=" + partId + ") for snapshot (id = " + snapshotId + ") failed because we couldn't find page count for consistentId=" + this.lastConsistentId));
                return null;
            }
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry e = iterator.next();
                if ((Integer)e.getValue() <= 0) continue;
                String cId = (String)e.getKey();
                SnapshotPath partitionFile = snapshot.getPartitionPathForCache(cacheGrpId, partId, cId);
                SnapshotInputStream stream = snapshot.getInputStreamFactory().makeInputStream(partitionFile, cacheGrpId, partId, pageSize, cId, initWALFileInput);
                if (stream == null) {
                    U.warn((IgniteLogger)this.log, (Object)("Getting stream for partition (grpId=" + cacheGrpId + ", partId=" + partId + ") for snapshot (id = " + snapshotId + ") failed because we couldn't find partition file: path=" + partitionFile.getAbsolutePath() + ", case - searching in any consistentId), will continue search? " + iterator.hasNext()));
                    continue;
                }
                return stream;
            }
            return null;
        }
        SnapshotPath partitionFile = snapshot.getPartitionPathForCache(cacheGrpId, partId, consistentId);
        SnapshotInputStream stream = snapshot.getInputStreamFactory().makeInputStream(partitionFile, cacheGrpId, partId, pageSize, consistentId, initWALFileInput);
        if (stream == null) {
            U.warn((IgniteLogger)this.log, (Object)("Getting stream for partition (grpId=" + cacheGrpId + ", partId=" + partId + ") for snapshot (id = " + snapshotId + ") failed because we couldn't find partition file: path=" + partitionFile.getAbsolutePath() + ", case - searching for given consistentId = " + consistentId + "."));
        }
        return stream;
    }

    private SnapshotPath getPartitionPathForCache(int cacheGrpId, int partId, String folderName) {
        return this.snapshotDir.resolve(folderName).resolve(Integer.toString(cacheGrpId)).resolve("part-" + partId + ".bin");
    }

    private void populate() {
        for (Map.Entry entry : this.metadata().cacheGroupsMetadata().entrySet()) {
            HashMap<String, BitSet> cIdToParts = new HashMap<String, BitSet>();
            CacheSnapshotMetadata cacheMeta = (CacheSnapshotMetadata)entry.getValue();
            for (Map.Entry e0 : cacheMeta.partitionSizesPerNode().entrySet()) {
                for (Map.Entry e1 : ((Map)e0.getValue()).entrySet()) {
                    String cId = (String)e1.getKey();
                    cIdToParts.computeIfAbsent(cId, k -> new BitSet()).set((Integer)e0.getKey());
                }
            }
            for (Map.Entry e0 : cIdToParts.entrySet()) {
                if (this.getIndexPath((String)e0.getKey(), (Integer)entry.getKey()) == null) continue;
                T2 key = new T2(entry.getKey(), e0.getValue());
                Set<String> consIds = this.indexes.get(key);
                if (consIds == null) {
                    consIds = new HashSet<String>();
                }
                consIds.add((String)e0.getKey());
                this.indexes.put((T2<Integer, BitSet>)key, consIds);
            }
        }
    }

    private FileSnapshot getSnapshot(long snapshotId) {
        return snapshotId == this.id ? this : this.previousSnapshots.get(snapshotId);
    }

    public SnapshotMetadataV2 metadata(SnapshotPath snapDir) {
        return SnapshotUtils.readSnapshotMetadata(snapDir, this.ignoreMissedClasses, this.igCfg, this.log, this.c);
    }

    @Nullable
    public SnapshotMetadataV2 metadata() {
        return this.metadata(true);
    }

    @Nullable
    public SnapshotMetadataV2 metadata(boolean needDecryptKeys) {
        if (this.metadataMerged == null) {
            SnapshotMetadataV2 metadata = SnapshotUtils.readSnapshotMetadata(this.snapshotDir, this.ignoreMissedClasses, this.igCfg, this.log, false, this.c);
            if (metadata == null) {
                FileSnapshot.logMetadataLookupResult(this.log, this.snapshotDir, false);
                for (SnapshotPath consistentIdDir : this.snapshotDir.getEntries()) {
                    if (!consistentIdDir.exists()) continue;
                    if (!consistentIdDir.isDirectory()) {
                        this.log.warning("Unexpected file in snapshot directory: " + consistentIdDir);
                        continue;
                    }
                    SnapshotMetadataV2 cidMetadata = SnapshotUtils.readSnapshotMetadata(consistentIdDir, this.ignoreMissedClasses, this.igCfg, this.log, false, this.c);
                    if (cidMetadata != null) {
                        FileSnapshot.logMetadataLookupResult(this.log, consistentIdDir, true);
                        if (metadata == null) {
                            metadata = cidMetadata;
                            continue;
                        }
                        try {
                            metadata = metadata.merge(cidMetadata);
                            continue;
                        }
                        catch (IgniteCheckedException e) {
                            throw new IgniteException((Throwable)e);
                        }
                    }
                    FileSnapshot.logMetadataLookupResult(this.log, consistentIdDir, false);
                }
            } else {
                FileSnapshot.logMetadataLookupResult(this.log, this.snapshotDir, true);
            }
            if (needDecryptKeys && metadata != null && metadata.encryptionOptions() != null) {
                metadata.encryptionOptions().decryptEncryptionKeys(this.igCfg.getEncryptionSpi());
            }
            this.metadataMerged = metadata;
        }
        return this.metadataMerged;
    }

    private static void logMetadataLookupResult(IgniteLogger log, SnapshotPath path, boolean result) {
        if (log.isDebugEnabled()) {
            log.debug("Trying to lookup snapshot metadata file in " + path + ", result: " + (result ? "found" : "not_found"));
        }
    }

    @Nullable
    public SnapshotMetadataV2 metadata(String consistentId) {
        return this.metadata(this.snapshotDir.resolve(consistentId));
    }

    public SnapshotMetadataV2 verifiedMetadata() throws IgniteCheckedException {
        SnapshotMetadataV2 meta = this.metadata();
        SnapshotDigestRegistryCache registryCache = this.getInputStreamFactory().getRegistryCache();
        if (registryCache != null) {
            try {
                registryCache.verifyMetadata(meta);
            }
            catch (IgniteException e) {
                throw new IgniteCheckedException((Throwable)e);
            }
        }
        return meta;
    }

    public SnapshotInputStream indexStream(int cacheGrpId, BitSet partitions) {
        if (this.indexes.isEmpty()) {
            this.populate();
        }
        Set<String> consistentIds = this.indexes.get(new T2((Object)cacheGrpId, (Object)partitions));
        if (this.lastConsistentId == null || this.lastCacheGrpId != cacheGrpId ? consistentIds == null || consistentIds.isEmpty() : consistentIds == null || !consistentIds.contains(this.lastConsistentId)) {
            return null;
        }
        this.collectSnapshotsForCacheGroup(this, this.previousSnapshots, this.consistentIdForUniquePartitionId, cacheGrpId);
        if (this.chainHasSingleCopySnapshot(cacheGrpId)) {
            return null;
        }
        this.lastCacheGrpId = cacheGrpId;
        this.lastConsistentId = consistentIds.iterator().next();
        return new IndexInputStream(cacheGrpId, this.id, this.lastConsistentId);
    }

    public SnapshotInputStream indexStream(int cacheGrpId, String consistentId) {
        this.collectSnapshotsForCacheGroup(this, this.previousSnapshots, this.consistentIdForUniquePartitionId, cacheGrpId);
        if (this.chainHasSingleCopySnapshot(cacheGrpId)) {
            return null;
        }
        return new IndexInputStream(cacheGrpId, this.id, consistentId);
    }

    private boolean chainHasSingleCopySnapshot(int cacheGrpId) {
        HashSet<Long> singleCpSnapshots = new HashSet<Long>();
        this.collectSingleCopySnapshotsForCacheGroup(this, this.previousSnapshots, singleCpSnapshots, cacheGrpId);
        return !singleCpSnapshots.isEmpty();
    }

    public SnapshotInputStream cacheInputStreams(int cacheGrpId, String cacheOrGrpName, int partId) {
        this.collectSnapshotsForCacheGroup(this, this.previousSnapshots, this.consistentIdForUniquePartitionId, cacheGrpId);
        return new PartitionSnapshotInputStream(cacheGrpId, cacheOrGrpName, partId, this.id);
    }

    public SnapshotInputStream cacheInputStreams(int cacheGrpId, String cacheOrGrpName, String consistentId, int partId) {
        this.collectSnapshotsForCacheGroup(this, this.previousSnapshots, this.consistentIdForUniquePartitionId, cacheGrpId);
        return new PartitionSnapshotInputStream(cacheGrpId, cacheOrGrpName, partId, this.id, consistentId);
    }

    private SnapshotInputStreamFactory getInputStreamFactory() {
        if (this.inputStreamFactory == null) {
            EncryptionSpi encSpi = this.igCfg.getEncryptionSpi();
            SnapshotEncryptionOptions encryptionOptions = this.metadata().encryptionOptions();
            this.inputStreamFactory = new SnapshotInputStreamFactory(this.igCfg, this.id, this.snapshotDir, this.msgDigestFactory, this.registryTransformer, this.securityLevel, (RecordSerializerFactory)new RecordSerializerFactoryImpl(this.cctx, SnapshotUtils.snapshotWalRecordFilter(), SnapshotUtils.snapshotEncryptionProvider((C1<Integer, Serializable>)(C1 & Serializable)grpId -> {
                assert (!(encSpi instanceof NoopEncryptionSpi));
                return encryptionOptions.getGroupKey(grpId).key();
            })), encryptionOptions, this.igCfg.getEncryptionSpi());
        }
        return this.inputStreamFactory;
    }

    public String toString() {
        return S.toString(FileSnapshot.class, (Object)this);
    }

    private class PartitionSnapshotInputStream
    implements SnapshotInputStream {
        private final int partId;
        private final int grpId;
        private final String cacheOrGrpName;
        private SnapshotInputStream curStream;
        private SnapshotInputStream exactSnapshotStream;
        private Long curSnapshotId;
        private final long exactSnapshotId;
        private BitSet alreadyReadIdx;
        private int alreadyReadIdxCnt;
        private int pageCnt;
        private String consistentId;
        private final Map<Long, SnapshotInputStream> snapshotStreams = new ConcurrentHashMap<Long, SnapshotInputStream>();

        private PartitionSnapshotInputStream(int grpId, String cacheOrGrpName, int partId, long snapshotId, String consistentId) {
            this(grpId, cacheOrGrpName, partId, snapshotId);
            this.consistentId = consistentId;
        }

        private PartitionSnapshotInputStream(int grpId, String cacheOrGrpName, int partId, long snapshotId) {
            this.grpId = grpId;
            this.cacheOrGrpName = cacheOrGrpName;
            this.partId = partId;
            this.exactSnapshotId = snapshotId;
            this.curSnapshotId = snapshotId;
        }

        public int partId() {
            return this.partId;
        }

        public String consistentId() {
            return this.consistentId;
        }

        public boolean readNextPage(ByteBuffer buf) throws IOException {
            while (true) {
                if (this.curSnapshotId == null) {
                    this.validateResult();
                    this.afterAllPagesRead();
                    return false;
                }
                if (this.curStream != null) {
                    if (this.readPageFromCurrentStream(buf)) {
                        return true;
                    }
                    this.closeCurrentStream();
                    this.switchToPreviousSnapshot();
                    continue;
                }
                if (this.pageCnt != 0 && this.pageCnt == this.alreadyReadIdxCnt) {
                    this.curSnapshotId = null;
                    continue;
                }
                this.curStream = FileSnapshot.this.getStream(this.curSnapshotId, this.grpId, this.partId, FileSnapshot.this.getSnapshot(this.curSnapshotId).metadata().pageSize(), this.consistentId);
                if (this.curStream == null) {
                    this.curSnapshotId = null;
                    continue;
                }
                if (this.exactSnapshotStream == null) {
                    this.exactSnapshotStream = this.curStream;
                }
                if (this.consistentId != null) continue;
                this.consistentId = this.curStream.consistentId();
                if (!$assertionsDisabled && this.consistentId == null) break;
            }
            throw new AssertionError();
        }

        public WALRecord readNextRecord() throws IOException {
            if (this.curStream == null) {
                return null;
            }
            WALRecord rec = this.curStream.readNextRecord();
            if (rec == null) {
                this.curSnapshotId = null;
                this.closeCurrentStream();
            }
            return rec;
        }

        private void afterAllPagesRead() {
            if (FileSnapshot.this.metadata().exchangelessSnapshot()) {
                this.curSnapshotId = this.exactSnapshotId;
                this.curStream = this.exactSnapshotStream;
            } else if (this.exactSnapshotStream != null) {
                this.closeStream(this.exactSnapshotStream);
            }
        }

        private boolean readPageFromCurrentStream(ByteBuffer buf) throws IOException {
            int pageIdx;
            do {
                buf.rewind();
                if (!this.curStream.readNextPage(buf)) {
                    return false;
                }
                long id = PageIO.getPageId((ByteBuffer)buf);
                pageIdx = PageIdUtils.pageIndex((long)id);
                if (pageIdx == 0 && this.pageCnt == 0) {
                    int type = PageIO.getType((ByteBuffer)buf);
                    if (type != 11 && type != 14) {
                        throw new IgniteException("Unexpected type for page with index 0, expected  - 11, 14, but was - " + type + "(cache - " + this.cacheOrGrpName + ", partId - " + this.partId + ")");
                    }
                    PageMetaIO io = FileSnapshot.getPageIo(type, PageIO.getVersion((ByteBuffer)buf));
                    this.pageCnt = io.getLastAllocatedPageCount(buf);
                    if (this.alreadyReadIdx == null) {
                        this.alreadyReadIdx = new BitSet(this.pageCnt);
                    }
                } else if (this.alreadyReadIdx == null) {
                    this.alreadyReadIdx = new BitSet();
                }
                if (this.pageCnt != 0 && pageIdx >= this.pageCnt) {
                    U.warn((IgniteLogger)FileSnapshot.this.log, (Object)this.incorrectPageIdxErrMsg("Unexpected page index found. pageIdx must be less than pageCnt", pageIdx));
                }
                if (pageIdx >= 0) continue;
                throw new IgniteException(this.incorrectPageIdxErrMsg("Unexpected negative page index found, page is corrupted", pageIdx));
            } while (this.alreadyReadIdx.get(pageIdx));
            this.alreadyReadIdx.set(pageIdx);
            ++this.alreadyReadIdxCnt;
            return true;
        }

        private String incorrectPageIdxErrMsg(String msg, int pageIdx) {
            return S.toString((String)msg, (String)"cache", (Object)this.cacheOrGrpName, (boolean)false, (String)"partId", (Object)this.partId, (boolean)false, (String)"pageCnt", (Object)this.pageCnt, (boolean)false, (String)"pageIdx", (Object)pageIdx, (boolean)false, (String)"partitionPath", (Object)this.getCurrentPartitionPath(), (boolean)false);
        }

        private void closeStream(SnapshotInputStream stream) {
            try {
                stream.close();
            }
            catch (Exception e) {
                U.warn((IgniteLogger)FileSnapshot.this.log, (Object)S.toString((String)"Close snapshot stream failure", (String)"consistentId", (Object)this.consistentId, (boolean)false, (String)"cache", (Object)this.cacheOrGrpName, (boolean)false, (String)"partId", (Object)this.partId, (boolean)false), (Throwable)e);
                throw new IgniteException((Throwable)e);
            }
        }

        private void closeCurrentStream() throws IgniteException {
            if (!FileSnapshot.this.metadata().exchangelessSnapshot() || !Objects.equals(this.curStream, this.exactSnapshotStream)) {
                try {
                    this.closeStream(this.curStream);
                }
                finally {
                    this.curStream = null;
                }
            }
            this.curStream = null;
        }

        private void switchToPreviousSnapshot() throws IOException {
            FileSnapshot snapshot = FileSnapshot.this.getSnapshot(this.curSnapshotId);
            CacheSnapshotMetadata cacheMeta = (CacheSnapshotMetadata)snapshot.metadata().cacheGroupsMetadata().get(this.grpId);
            assert (cacheMeta != null);
            Long prevId = cacheMeta.previousSnapshotId(this.consistentId);
            FileSnapshot previousSnapshot = (FileSnapshot)FileSnapshot.this.previousSnapshots.get(prevId);
            if (previousSnapshot != null) {
                previousSnapshot.collectSnapshotsForCacheGroup(previousSnapshot, FileSnapshot.this.previousSnapshots, FileSnapshot.this.consistentIdForUniquePartitionId, this.grpId);
                this.curSnapshotId = previousSnapshot.id;
            } else {
                if (this.pageCnt != this.alreadyReadIdxCnt && prevId != null && prevId > 0L && !snapshot.metadata().fullSnapshot()) {
                    throw new IOException("Failed to find previous snapshot: " + prevId);
                }
                this.curSnapshotId = null;
            }
        }

        private void validateResult() throws IOException {
            if (this.pageCnt != 0 && this.pageCnt != this.alreadyReadIdxCnt) {
                this.assertThatPageCountReadSmallerThatRequired();
                this.writeTroubleshootingInfo();
                throw new IOException("We didn't read all pages in part = " + this.partId + " for cache - " + this.cacheOrGrpName + ". Snapshot restore failed (read = " + this.alreadyReadIdxCnt + ", saved = " + this.pageCnt + ", partitionPath = " + this.getCurrentPartitionPath() + "). Missing pages - " + this.getMissingPagesIndices() + ", excessive pages - " + this.getExcessivePagesIndices());
            }
        }

        private void writeTroubleshootingInfo() {
            U.warn((IgniteLogger)FileSnapshot.this.log, (Object)("Cache - " + this.cacheOrGrpName + ", partId - " + this.partId + ", partitionPath - " + this.getCurrentPartitionPath()));
            U.warn((IgniteLogger)FileSnapshot.this.log, (Object)("Missed ids - " + this.getMissingPagesIndices()));
            U.warn((IgniteLogger)FileSnapshot.this.log, (Object)("Excessive ids - " + this.getExcessivePagesIndices()));
        }

        @NotNull
        private List<Integer> getMissingPagesIndices() {
            ArrayList<Integer> missingIdx = new ArrayList<Integer>();
            int i = this.alreadyReadIdx.nextClearBit(0);
            while (i >= 0 && i < this.pageCnt) {
                missingIdx.add(i);
                i = this.alreadyReadIdx.nextClearBit(i + 1);
            }
            return missingIdx;
        }

        @NotNull
        private List<Integer> getExcessivePagesIndices() {
            if (this.alreadyReadIdx.nextSetBit(this.pageCnt) == -1) {
                return Collections.emptyList();
            }
            ArrayList<Integer> excessiveIdx = new ArrayList<Integer>();
            int i = this.alreadyReadIdx.nextSetBit(this.pageCnt);
            while (i >= 0 && i != Integer.MAX_VALUE) {
                excessiveIdx.add(i);
                i = this.alreadyReadIdx.nextSetBit(i + 1);
            }
            return excessiveIdx;
        }

        private String getCurrentPartitionPath() {
            return FileSnapshot.this.getPartitionPathForCache(this.grpId, this.partId, this.consistentId).toString();
        }

        private void assertThatPageCountReadSmallerThatRequired() {
            assert (this.alreadyReadIdxCnt < this.pageCnt) : "Read page count is smaller than count saved in the meta page [pageCnt=" + this.pageCnt + ", alreadyRead=" + this.alreadyReadIdxCnt + ", partitionPath=" + this.getCurrentPartitionPath() + "]. Missed ids - " + this.getMissingPagesIndices() + ", excessive ids - " + this.getExcessivePagesIndices();
        }

        public void close() throws Exception {
            if (this.curStream != null) {
                this.curStream.close();
            }
            if (this.exactSnapshotStream != null && !this.exactSnapshotStream.equals(this.curStream)) {
                this.exactSnapshotStream.close();
            }
        }

        public String toString() {
            return S.toString(PartitionSnapshotInputStream.class, (Object)this);
        }
    }

    private class IndexInputStream
    implements SnapshotInputStream {
        private SnapshotInputStream curStream;
        private final int cacheGrpId;
        private final String consistentId;
        private Long curSnapshotId;
        private BitSet alreadyReadIdx = new BitSet();

        private IndexInputStream(int cacheGrpId, long snapshotId, String consistentId) throws FileIndexMissingException {
            this.cacheGrpId = cacheGrpId;
            this.consistentId = consistentId;
            this.curSnapshotId = snapshotId;
            FileSnapshot snapshot = FileSnapshot.this.getSnapshot(this.curSnapshotId);
            this.curStream = snapshot.getIndexStream(consistentId, cacheGrpId, snapshot.metadata().pageSize());
            if (this.curStream == null) {
                throw new FileIndexMissingException();
            }
        }

        public int partId() {
            return 65535;
        }

        public String consistentId() {
            return this.consistentId;
        }

        public boolean readNextPage(ByteBuffer buf) throws IOException {
            while (this.curSnapshotId != null) {
                FileSnapshot snapshot;
                if (this.curStream != null) {
                    block5: {
                        long id;
                        int pageIdx;
                        do {
                            buf.rewind();
                            if (!this.curStream.readNextPage(buf)) break block5;
                        } while (this.alreadyReadIdx.get(pageIdx = PageIdUtils.pageIndex((long)(id = PageIO.getPageId((ByteBuffer)buf)))));
                        this.alreadyReadIdx.set(pageIdx);
                        return true;
                    }
                    U.close((AutoCloseable)this.curStream, (IgniteLogger)FileSnapshot.this.log);
                    this.curStream = null;
                    snapshot = FileSnapshot.this.getSnapshot(this.curSnapshotId);
                    CacheSnapshotMetadata cacheMeta = (CacheSnapshotMetadata)snapshot.metadata().cacheGroupsMetadata().get(this.cacheGrpId);
                    Long prevId = cacheMeta == null ? null : cacheMeta.previousSnapshotId(this.consistentId);
                    FileSnapshot previousSnapshot = (FileSnapshot)FileSnapshot.this.previousSnapshots.get(prevId);
                    if (previousSnapshot != null) {
                        previousSnapshot.collectSnapshotsForCacheGroup(previousSnapshot, FileSnapshot.this.previousSnapshots, FileSnapshot.this.consistentIdForUniquePartitionId, this.cacheGrpId);
                    }
                    this.curSnapshotId = previousSnapshot == null ? null : Long.valueOf(previousSnapshot.id);
                    continue;
                }
                snapshot = FileSnapshot.this.getSnapshot(this.curSnapshotId);
                this.curStream = snapshot.getIndexStream(this.consistentId, this.cacheGrpId, snapshot.metadata().pageSize());
                if (this.curStream != null) continue;
                this.curSnapshotId = null;
            }
            return false;
        }

        public WALRecord readNextRecord() {
            return null;
        }

        public void close() throws Exception {
            if (this.curStream != null) {
                this.curStream.close();
            }
        }

        public String toString() {
            return S.toString(IndexInputStream.class, (Object)this);
        }
    }
}

