/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.nio.ByteBuffer;
import java.security.DigestOutputStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.gridgain.grid.internal.processors.cache.database.snapshot.DigestSnapshotOutputStream;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOutputStream;

public class DigestSnapshotOutputStreamWrapper
implements DigestSnapshotOutputStream {
    private final SnapshotOutputStream snapStream;
    private final DigestOutputStream digestStream;

    public DigestSnapshotOutputStreamWrapper(SnapshotOutputStream snapStream, DigestOutputStream digestStream) {
        this.snapStream = snapStream;
        this.digestStream = digestStream;
    }

    public void write(ByteBuffer data) throws IgniteCheckedException {
        this.snapStream.write(data);
    }

    public void plainWrite(ByteBuffer data) throws IgniteCheckedException {
        this.snapStream.plainWrite(data);
    }

    public void close() throws IgniteCheckedException {
        this.snapStream.close();
    }

    public long position() {
        return this.snapStream.position();
    }

    public byte[] digest() {
        try {
            this.close();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
        return this.digestStream.getMessageDigest().digest();
    }
}

