/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.txdr;

import java.io.Serializable;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.resources.JobContextResource;
import org.gridgain.grid.internal.txdr.TransactionalDr;
import org.gridgain.grid.internal.visor.txdr.VisorReplicationInfo;

@GridInternal
public class VisorReplicationSwitchTask
extends VisorOneNodeTask<Void, VisorReplicationInfo> {
    private static final long serialVersionUID = 0L;

    protected VisorJob<Void, VisorReplicationInfo> job(Void arg) {
        return new VisorReplicationSwitchJob(arg, this.debug);
    }

    private static class VisorReplicationSwitchJob
    extends VisorJob<Void, VisorReplicationInfo> {
        private static final long serialVersionUID = 0L;
        @JobContextResource
        private ComputeJobContext jobCtx;
        private IgniteFuture<Long> opFut;

        VisorReplicationSwitchJob(Void arg, boolean debug) {
            super((Object)arg, debug);
        }

        protected VisorReplicationInfo run(Void arg) throws IgniteException {
            if (this.opFut == null) {
                if (!(this.ignite.context().txDr() instanceof TransactionalDr)) {
                    throw new IgniteException("Transactional data center replication is not configured.");
                }
                TransactionalDr txDr = (TransactionalDr)this.ignite.context().txDr();
                try {
                    this.opFut = txDr.switchWithReplica();
                    if (!this.opFut.isDone()) {
                        this.jobCtx.holdcc();
                        this.opFut.listen((IgniteInClosure & Serializable)f -> this.jobCtx.callcc());
                        return null;
                    }
                    this.opFut.get();
                }
                catch (Exception cause) {
                    throw new IgniteException("Failed to switch the role of the cluster.", (Throwable)cause);
                }
            }
            long newSesId = (Long)this.opFut.get();
            return new VisorReplicationInfo.Builder().withSessionId(newSesId).build();
        }

        public String toString() {
            return S.toString(VisorReplicationSwitchJob.class, (Object)((Object)this));
        }
    }
}

