/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.database.snapshot;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotProgress;
import org.gridgain.grid.persistentstore.SnapshotStatus;

public class VisorSnapshotStatus
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private IgniteUuid opId;
    private VisorSnapshotInfo operation;
    private Map<UUID, SnapshotProgress> progress;
    private SnapshotOperationStage stage = SnapshotOperationStage.NONE;
    private long startStageTime;
    private long startTime;
    private int pageSize;
    private boolean notCancellable;

    public VisorSnapshotStatus() {
    }

    public VisorSnapshotStatus(IgniteEx ignite, SnapshotStatus status) {
        this.opId = status.operationId();
        this.progress = status.progress();
        this.startTime = status.startTime();
        this.startStageTime = status.getStartStageTime();
        this.stage = SnapshotOperationStage.fromOrdinal(status.getStageNum());
        this.pageSize = ignite.context().config().getDataStorageConfiguration().getPageSize();
        this.operation = VisorSnapshotInfo.Builder.fromSnapshotOperationInfo((SnapshotOperationInfoImpl)status.operation()).withClusterName(ignite.cluster().tag()).build();
        this.notCancellable = status.notCancellable();
    }

    public IgniteUuid getOperationId() {
        return this.opId;
    }

    public VisorSnapshotInfo getOperation() {
        return this.operation;
    }

    public Map<UUID, SnapshotProgress> getProgress() {
        return this.progress;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStartStageTime() {
        return this.startStageTime;
    }

    public SnapshotOperationStage getStage() {
        return this.stage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean isNotCancellable() {
        return this.notCancellable;
    }

    public byte getProtocolVersion() {
        return 3;
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeGridUuid((DataOutput)out, (IgniteUuid)this.opId);
        out.writeObject((Object)this.operation);
        U.writeMap((ObjectOutput)out, this.progress);
        out.writeLong(this.startTime);
        out.writeLong(this.startStageTime);
        out.writeInt(this.stage.ordinal());
        out.writeInt(this.pageSize);
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.opId = U.readGridUuid((DataInput)in);
        this.operation = (VisorSnapshotInfo)((Object)in.readObject());
        this.progress = U.readMap((ObjectInput)in);
        if (protoVer > 1) {
            this.startTime = in.readLong();
        }
        if (protoVer > 2) {
            this.startStageTime = in.readLong();
            this.stage = SnapshotOperationStage.fromOrdinal(in.readInt());
            this.pageSize = in.readInt();
        }
    }

    public String toString() {
        return S.toString(VisorSnapshotStatus.class, (Object)((Object)this));
    }
}

