/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.database.snapshot;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteProductVersion;
import org.gridgain.grid.internal.processors.cache.database.SnapshotUpdateOperationParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationAttrs;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotNode;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotCreateParams;
import org.gridgain.grid.persistentstore.SnapshotInfoEx;
import org.gridgain.grid.persistentstore.SnapshotOperationInfo;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotPath;
import org.jetbrains.annotations.Nullable;

public class VisorSnapshotInfo
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    public static final String SFTP_PREFIX = "sftp://";
    private long snapshotId;
    private SnapshotOperationType opType;
    private boolean fullSnapshot;
    private boolean force;
    private boolean skipCrc;
    private List<String> paths;
    private Set<String> cacheNames;
    private Set<String> excludedCacheNames;
    private String msg;
    @Nullable
    private UUID initiatorNode;
    private String clusterName;
    private int clusterSz;
    private int baselineTopologySize;
    @Nullable
    private Collection<Object> baselineConsistentIds;
    private List<VisorSnapshotNode> clusterNodes;
    private Map<Object, Map<String, String>> snapshotAttrs;
    private Map<Long, Set<String>> prevSnapshots;
    private Map<String, CacheMode> cacheModes;
    private String cacheCfgs;
    private long time;
    private boolean skipWalCopy;
    private SnapshotCommonParameters snapshotCommonParameters;
    private SnapshotCreateParameters snapshotCreateParameters;
    private SnapshotUpdateOperationParameters updateOperationParams;
    private String keyAlias;
    private long size;
    private long walSize;
    private String masterKeyName;
    private SortedSet<IgniteProductVersion> clusterNodesVersions;

    public VisorSnapshotInfo() {
    }

    private VisorSnapshotInfo(long snapshotId, boolean fullSnapshot, boolean force, boolean skipCrc, Collection<String> paths, Collection<String> cacheNames, long time, CompressionOption compression, String msg, SnapshotChainMode chainMode) {
        this.snapshotId = snapshotId;
        this.fullSnapshot = fullSnapshot;
        this.force = force;
        this.skipCrc = skipCrc;
        this.paths = VisorSnapshotInfo.toList(paths);
        this.cacheNames = this.deduplicateAndSortCacheNames(cacheNames);
        this.msg = msg;
        this.time = time;
        this.snapshotCommonParameters = new SnapshotCommonParameters();
        this.snapshotCreateParameters = new SnapshotCreateParameters(compression != null ? compression : CompressionOption.NONE, -1, 0);
        this.updateOperationParams = new SnapshotUpdateOperationParameters(chainMode != null ? chainMode : SnapshotChainMode.DEFAULT);
        this.clusterNodesVersions = Collections.emptySortedSet();
    }

    private VisorSnapshotInfo(long snapshotId, boolean fullSnapshot, boolean force, boolean skipCrc, Collection<String> paths, Collection<String> cacheNames, long time, CompressionOption compression, String msg) {
        this(snapshotId, fullSnapshot, force, skipCrc, paths, cacheNames, time, compression, msg, SnapshotChainMode.DEFAULT);
    }

    private VisorSnapshotInfo(long snapshotId, boolean fullSnapshot, boolean force, boolean skipCrc, Collection<String> paths, Collection<String> cacheNames, String msg) {
        this(snapshotId, fullSnapshot, force, skipCrc, paths, cacheNames, 0L, CompressionOption.NONE, msg);
    }

    public long getSnapshotId() {
        return this.snapshotId;
    }

    public SnapshotOperationType getOperationType() {
        return this.opType;
    }

    public boolean isFullSnapshot() {
        return this.fullSnapshot;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isSkipWalCopy() {
        return this.skipWalCopy;
    }

    public SnapshotUpdateOperationParameters getUpdateOperationParams() {
        return this.updateOperationParams;
    }

    public boolean isSkipCrc() {
        return this.skipCrc;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public List<SnapshotPath> paths() throws IgniteException {
        if (F.isEmpty(this.paths)) {
            return null;
        }
        ArrayList<SnapshotPath> convertedPath = new ArrayList<SnapshotPath>();
        for (String path : this.paths) {
            if (path.startsWith(SFTP_PREFIX)) {
                try {
                    convertedPath.add(SnapshotPath.sftp().uri(new URI(path)).keyAlias(this.keyAlias).build());
                    continue;
                }
                catch (URISyntaxException e) {
                    throw new IgniteException("Incorrect path: " + path, (Throwable)e);
                }
            }
            convertedPath.add(SnapshotPath.file().path(new File(path)).build());
        }
        return convertedPath;
    }

    public Set<String> getCacheNames() {
        return this.cacheNames;
    }

    public void setCacheNames(Set<String> cacheNames) {
        this.cacheNames = cacheNames;
    }

    public Set<String> getExcludedCacheNames() {
        return this.excludedCacheNames;
    }

    public void setExcludedCacheNames(Set<String> cacheNames) {
        this.excludedCacheNames = cacheNames;
    }

    public String getMessage() {
        return this.msg;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    @Nullable
    public UUID getInitiatorNodeId() {
        return this.initiatorNode;
    }

    public int getClusterSize() {
        return this.clusterSz;
    }

    public int getBaselineTopologySize() {
        return this.baselineTopologySize;
    }

    public Collection<Object> getBaselineConsistentIds() {
        return Objects.isNull(this.baselineConsistentIds) ? Collections.emptyList() : this.baselineConsistentIds;
    }

    public List<VisorSnapshotNode> getClusterNodes() {
        return this.clusterNodes;
    }

    public Map<String, String> getSnapshotAttributes(Object consistentId) {
        return this.snapshotAttrs == null ? null : this.snapshotAttrs.get(consistentId);
    }

    public Map<Object, Map<String, String>> attributes() {
        return this.snapshotAttrs;
    }

    public Map<Long, Set<String>> getPreviousSnapshots() {
        return this.prevSnapshots;
    }

    public Map<String, CacheMode> getCacheModes() {
        return this.cacheModes;
    }

    public SnapshotCommonParameters getSnapshotCommonParameters() {
        return this.snapshotCommonParameters;
    }

    public SnapshotCreateParameters getSnapshotCreateParameters() {
        return this.snapshotCreateParameters;
    }

    public SnapshotCreateParams getSnapshotCreateParams() {
        return SnapshotCreateParameters.convertSnapshotCreateParameters((SnapshotCreateParameters)this.snapshotCreateParameters);
    }

    public String getCacheConfigs() {
        return this.cacheCfgs;
    }

    public long getTime() {
        return this.time;
    }

    public long getSize() {
        return this.size;
    }

    public long getWalSize() {
        return this.walSize;
    }

    public String getMasterKeyName() {
        return this.masterKeyName;
    }

    public SortedSet<IgniteProductVersion> getClusterNodesVersions() {
        return this.clusterNodesVersions;
    }

    public byte getProtocolVersion() {
        return 14;
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeLong(this.snapshotId);
        IgniteUtils.writeEnum((DataOutput)out, (Enum)this.opType);
        out.writeBoolean(this.fullSnapshot);
        out.writeBoolean(this.force);
        out.writeBoolean(this.skipCrc);
        IgniteUtils.writeCollection((ObjectOutput)out, this.paths);
        IgniteUtils.writeCollection((ObjectOutput)out, this.cacheNames);
        IgniteUtils.writeCutString((DataOutput)out, (String)this.msg);
        IgniteUtils.writeCutString((DataOutput)out, (String)this.clusterName);
        IgniteUtils.writeUuid((DataOutput)out, (UUID)this.initiatorNode);
        out.writeInt(this.clusterSz);
        IgniteUtils.writeCollection((ObjectOutput)out, this.clusterNodes);
        IgniteUtils.writeMap((ObjectOutput)out, this.snapshotAttrs);
        IgniteUtils.writeMap((ObjectOutput)out, this.prevSnapshots);
        IgniteUtils.writeMap((ObjectOutput)out, this.cacheModes);
        boolean writeCacheCfgsAsLongStr = this.cacheCfgs == null || IgniteUtils.isStringTooLongForWriteHeuristically((String)this.cacheCfgs);
        IgniteUtils.writeCutString((DataOutput)out, (String)(writeCacheCfgsAsLongStr ? null : this.cacheCfgs));
        out.writeLong(this.time);
        out.writeBoolean(this.skipWalCopy);
        out.writeObject(this.snapshotCreateParameters);
        out.writeObject(this.updateOperationParams);
        out.writeObject(this.snapshotCommonParameters);
        out.writeInt(this.baselineTopologySize);
        IgniteUtils.writeCollection((ObjectOutput)out, this.baselineConsistentIds);
        IgniteUtils.writeCutString((DataOutput)out, (String)this.keyAlias);
        out.writeLong(this.size);
        out.writeLong(this.walSize);
        U.writeString((DataOutput)out, (String)this.masterKeyName);
        IgniteUtils.writeCollection((ObjectOutput)out, this.clusterNodesVersions);
        IgniteUtils.writeCollection((ObjectOutput)out, this.excludedCacheNames);
        if (writeCacheCfgsAsLongStr) {
            IgniteUtils.writeLongString((DataOutput)out, (String)this.cacheCfgs);
        }
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.snapshotId = in.readLong();
        this.opType = SnapshotOperationType.fromOrdinal((int)in.readByte());
        this.fullSnapshot = in.readBoolean();
        this.force = in.readBoolean();
        this.skipCrc = in.readBoolean();
        this.paths = IgniteUtils.readList((ObjectInput)in);
        this.cacheNames = IgniteUtils.readSet((ObjectInput)in);
        this.msg = IgniteUtils.readString((DataInput)in);
        this.clusterName = IgniteUtils.readString((DataInput)in);
        this.initiatorNode = IgniteUtils.readUuid((DataInput)in);
        this.clusterSz = in.readInt();
        this.clusterNodes = IgniteUtils.readList((ObjectInput)in);
        this.snapshotAttrs = IgniteUtils.readMap((ObjectInput)in);
        this.prevSnapshots = IgniteUtils.readMap((ObjectInput)in);
        this.cacheModes = IgniteUtils.readMap((ObjectInput)in);
        this.cacheCfgs = IgniteUtils.readString((DataInput)in);
        this.time = in.readLong();
        this.skipWalCopy = in.readBoolean();
        if (protoVer > 3) {
            this.snapshotCreateParameters = (SnapshotCreateParameters)in.readObject();
        }
        if (protoVer > 4) {
            this.updateOperationParams = (SnapshotUpdateOperationParameters)in.readObject();
        }
        if (protoVer > 5) {
            this.snapshotCommonParameters = (SnapshotCommonParameters)in.readObject();
        }
        if (protoVer > 6) {
            this.baselineTopologySize = in.readInt();
        }
        if (protoVer > 7) {
            this.baselineConsistentIds = U.readCollection((ObjectInput)in);
        }
        if (protoVer > 8) {
            this.keyAlias = IgniteUtils.readString((DataInput)in);
        }
        if (protoVer > 9) {
            this.size = in.readLong();
            this.walSize = in.readLong();
        }
        if (protoVer > 10) {
            this.masterKeyName = U.readString((DataInput)in);
        }
        List versions = protoVer > 11 ? IgniteUtils.readList((ObjectInput)in) : null;
        TreeSet treeSet = this.clusterNodesVersions = versions == null ? Collections.emptySortedSet() : new TreeSet(versions);
        if (protoVer > 12) {
            this.excludedCacheNames = U.readSet((ObjectInput)in);
        }
        if (protoVer > 13 && this.cacheCfgs == null) {
            this.cacheCfgs = IgniteUtils.readLongString((DataInput)in);
        }
    }

    public String toString() {
        return S.toString(VisorSnapshotInfo.class, (Object)((Object)this));
    }

    private LinkedHashSet<String> deduplicateAndSortCacheNames(Collection<String> cacheNames) {
        if (cacheNames != null) {
            ArrayList<String> sorted = new ArrayList<String>(cacheNames);
            Collections.sort(sorted);
            return new LinkedHashSet<String>(sorted);
        }
        return null;
    }

    public static class Builder {
        private long snapshotId;
        private SnapshotOperationType opType;
        private boolean fullSnapshot;
        private boolean force;
        private boolean skipCrc;
        private Collection<String> paths;
        private Collection<String> cacheNames;
        private Collection<String> excludedCacheNames;
        private String msg;
        private UUID initiatorNode;
        private String clusterName;
        private int clusterSz;
        private int baselineTopologySize;
        @Nullable
        private Collection<Object> baselineConsistentIds;
        private Collection<ClusterNode> clusterNodes;
        private Map<Object, Map<String, String>> snapshotAttrs;
        private Map<Long, Set<String>> prevSnapshots;
        private Map<String, CacheMode> cacheModes;
        private String cacheCfgs;
        private long time;
        private boolean skipWalCopy;
        private SnapshotCommonParameters snapshotCommonParameters = new SnapshotCommonParameters();
        private SnapshotCreateParameters snapshotCreateParameters = new SnapshotCreateParameters();
        private SnapshotChainMode chainMode;
        private Boolean deleteSources;
        private Boolean singleFileCopy;
        private String keyAlias;
        private long size;
        private long walSize;
        private String masterKeyName;
        private SortedSet<IgniteProductVersion> clusterNodesVersions;

        public Builder withSnapshotId(long id) {
            this.snapshotId = id;
            return this;
        }

        public Builder withOperationType(SnapshotOperationType type) {
            this.opType = type;
            return this;
        }

        public Builder withFullSnapshot(boolean fullSnapshot) {
            this.fullSnapshot = fullSnapshot;
            return this;
        }

        public Builder withForce(boolean force) {
            this.force = force;
            return this;
        }

        public Builder withSkipCrc(boolean skipCrc) {
            this.skipCrc = skipCrc;
            return this;
        }

        public Builder withPaths(Collection<String> paths) {
            this.paths = paths;
            return this;
        }

        public Builder withCacheNames(Collection<String> cacheNames) {
            this.cacheNames = cacheNames;
            return this;
        }

        public Builder withExcludedCacheNames(Collection<String> excludedCacheNames) {
            this.excludedCacheNames = excludedCacheNames;
            return this;
        }

        public Builder withMessage(String msg) {
            this.msg = msg;
            return this;
        }

        public Builder withClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder withInitiatorNode(UUID initiatorNode) {
            this.initiatorNode = initiatorNode;
            return this;
        }

        public Builder withClusterSize(int clusterSz) {
            this.clusterSz = clusterSz;
            return this;
        }

        public Builder withBaselineTopologySize(int baselineTopologySize) {
            this.baselineTopologySize = baselineTopologySize;
            return this;
        }

        public Builder withBaselineConsistentIds(@Nullable Collection<Object> baselineConsistentIds) {
            this.baselineConsistentIds = baselineConsistentIds;
            return this;
        }

        public Builder withClusterNodes(Collection<ClusterNode> clusterNodes) {
            this.clusterNodes = clusterNodes;
            return this;
        }

        public Builder withSnapshotAttrs(Map<Object, Map<String, String>> snapshotAttrs) {
            this.snapshotAttrs = snapshotAttrs;
            return this;
        }

        public Builder withPrevSnapshots(Map<Long, Set<String>> prevSnapshots) {
            this.prevSnapshots = prevSnapshots;
            return this;
        }

        public Builder withCacheModes(Map<String, CacheMode> cacheModes) {
            this.cacheModes = cacheModes;
            return this;
        }

        public Builder withCacheConfigurations(String cacheCfgs) {
            this.cacheCfgs = cacheCfgs;
            return this;
        }

        public Builder withTime(long time) {
            this.time = time;
            return this;
        }

        public Builder withSkipWalCopy(boolean skipWalCopy) {
            this.skipWalCopy = skipWalCopy;
            return this;
        }

        public Builder withSnapshotCommonParameters(SnapshotCommonParameters snapshotCommonParameters) {
            this.snapshotCommonParameters = snapshotCommonParameters;
            return this;
        }

        public Builder withSnapshotCreateParameters(SnapshotCreateParameters snapshotCreateParameters) {
            this.snapshotCreateParameters = snapshotCreateParameters;
            return this;
        }

        public Builder withSnapshotCreateParams(SnapshotCreateParams snapshotCreateParams) {
            this.snapshotCreateParameters = SnapshotCreateParameters.convertSnapshotCreateParams((SnapshotCreateParams)snapshotCreateParams);
            return this;
        }

        public Builder withSnapshotChainMode(SnapshotChainMode snapshotChainMode) {
            this.chainMode = snapshotChainMode;
            return this;
        }

        public Builder withDeleteSources(boolean deleteSources) {
            this.deleteSources = deleteSources;
            return this;
        }

        public Builder withSingleFileCopy(boolean singleFileCopy) {
            this.singleFileCopy = singleFileCopy;
            return this;
        }

        public Builder withKeyAlias(String keyAlias) {
            this.keyAlias = keyAlias;
            return this;
        }

        public Builder withSize(long size) {
            this.size = size;
            return this;
        }

        public Builder withWalSize(long walSize) {
            this.walSize = walSize;
            return this;
        }

        public Builder withMasterKeyName(String masterKeyName) {
            this.masterKeyName = masterKeyName;
            return this;
        }

        public Builder withClusterNodeVersions(Collection<IgniteProductVersion> clusterNodesVersions) {
            this.clusterNodesVersions = new TreeSet<IgniteProductVersion>(clusterNodesVersions);
            return this;
        }

        public static Builder fromSnapshotInfo(SnapshotInfoEx snapshotInfoEx) {
            SnapshotCreateParameters snapshotCreateParameters = new SnapshotCreateParameters(snapshotInfoEx.compressionOption(), snapshotInfoEx.compressionLevel(), 0);
            BaselineTopology baselineTop = snapshotInfoEx.baselineTopology();
            int baselineTopSize = Objects.isNull(baselineTop) ? -1 : baselineTop.size();
            Set baselineConsistentIds = Objects.isNull(baselineTop) ? null : baselineTop.consistentIds();
            SortedSet clusterNodesVersions = snapshotInfoEx.topology().stream().map(ClusterNode::version).collect(Collectors.toCollection(TreeSet::new));
            return new Builder().withSnapshotId(snapshotInfoEx.snapshotId()).withFullSnapshot(snapshotInfoEx.fullSnapshot()).withCacheNames(snapshotInfoEx.cacheNames()).withMessage(snapshotInfoEx.message()).withInitiatorNode(snapshotInfoEx.initiatorNode()).withClusterSize(snapshotInfoEx.topology().size()).withBaselineTopologySize(baselineTopSize).withBaselineConsistentIds(baselineConsistentIds).withClusterNodes(snapshotInfoEx.topology()).withSnapshotAttrs(snapshotInfoEx.snapshotAttributes()).withPrevSnapshots(snapshotInfoEx.previousSnapshots()).withCacheModes(snapshotInfoEx.cacheModes()).withSnapshotCreateParameters(snapshotCreateParameters).withSize(snapshotInfoEx.size()).withWalSize(snapshotInfoEx.walSize()).withMasterKeyName(snapshotInfoEx.masterKeyName()).withClusterNodeVersions(clusterNodesVersions);
        }

        public static Builder fromSnapshotOperationInfo(SnapshotOperationInfoImpl operationInfo) {
            SortedSet clusterNodesVersions = operationInfo.clusterNodes().stream().map(ClusterNode::version).collect(Collectors.toCollection(TreeSet::new));
            return new Builder().withSnapshotId(operationInfo.snapshotId()).withOperationType(operationInfo.snapshotOperation().type()).withFullSnapshot(Builder.unwrapBooleanExtraParameter((SnapshotOperationInfo)operationInfo)).withSkipCrc(Builder.unwrapBooleanExtraParameter((SnapshotOperationInfo)operationInfo)).withCacheNames(operationInfo.cacheNames()).withMessage(operationInfo.message()).withInitiatorNode(operationInfo.initiatorNodeId()).withClusterSize(operationInfo.clusterNodes().size()).withBaselineTopologySize(-1).withClusterNodes(operationInfo.clusterNodes()).withSnapshotAttrs(operationInfo.snapshotAttributes()).withPrevSnapshots(operationInfo.snapshotOperation().previousSnapshots()).withSnapshotCommonParameters(Builder.unwrapCommonParameters(operationInfo)).withSnapshotCreateParameters(Builder.unwrapCreateParameters(operationInfo)).withClusterNodeVersions(clusterNodesVersions);
        }

        private static SnapshotCommonParameters unwrapCommonParameters(SnapshotOperationInfoImpl operationInfo) {
            if (operationInfo.snapshotOperation().extraParameter() instanceof Map) {
                return (SnapshotCommonParameters)((Map)operationInfo.snapshotOperation().extraParameter()).get("SNAPSHOT_COMMON_PARAMETERS_KEY");
            }
            return new SnapshotCommonParameters();
        }

        private static SnapshotCreateParameters unwrapCreateParameters(SnapshotOperationInfoImpl operationInfo) {
            if (operationInfo.snapshotOperation().type() == SnapshotOperationType.CREATE && operationInfo.snapshotOperation().extraParameter() instanceof Map) {
                return (SnapshotCreateParameters)((Map)operationInfo.snapshotOperation().extraParameter()).get("SNAPSHOT_CREATE_PARAMETERS");
            }
            return new SnapshotCreateParameters();
        }

        private static boolean unwrapBooleanExtraParameter(SnapshotOperationInfo operationInfo) {
            if (operationInfo instanceof SnapshotOperationInfoImpl) {
                SnapshotOperationInfoImpl info = (SnapshotOperationInfoImpl)operationInfo;
                if (info.snapshotOperation().type() == SnapshotOperationType.CREATE) {
                    assert (info.snapshotOperation().extraParameter() != null) : "extraParameter should be present for CREATE";
                    return GridSnapshotOperationAttrs.getFullSnapshotParameter((GridSnapshotOperationEx)info.snapshotOperation());
                }
                if (info.snapshotOperation().type() == SnapshotOperationType.CHECK) {
                    return GridSnapshotOperationAttrs.getSkipCrcParameter((GridSnapshotOperationEx)info.snapshotOperation());
                }
            }
            return false;
        }

        public VisorSnapshotInfo build() {
            VisorSnapshotInfo result = new VisorSnapshotInfo();
            result.snapshotId = this.snapshotId;
            result.opType = this.opType;
            result.fullSnapshot = this.fullSnapshot;
            result.force = this.force;
            result.skipCrc = this.skipCrc;
            result.paths = VisorSnapshotInfo.toList((Collection)this.paths);
            result.cacheNames = VisorSnapshotInfo.toSet((Collection)this.cacheNames);
            result.excludedCacheNames = VisorSnapshotInfo.toSet((Collection)this.excludedCacheNames);
            result.msg = this.msg;
            result.clusterName = this.clusterName;
            result.initiatorNode = this.initiatorNode;
            result.snapshotAttrs = this.snapshotAttrs;
            result.prevSnapshots = this.prevSnapshots;
            result.cacheModes = this.cacheModes;
            result.clusterSz = this.clusterSz;
            result.baselineTopologySize = this.baselineTopologySize;
            result.baselineConsistentIds = this.baselineConsistentIds;
            if (!F.isEmpty(this.clusterNodes)) {
                result.clusterNodes = new ArrayList(this.clusterNodes.size());
                for (ClusterNode node : this.clusterNodes) {
                    result.clusterNodes.add(new VisorSnapshotNode(node));
                }
            }
            result.cacheCfgs = this.cacheCfgs;
            result.time = this.time;
            result.skipWalCopy = this.skipWalCopy;
            result.snapshotCommonParameters = this.snapshotCommonParameters;
            result.snapshotCreateParameters = this.snapshotCreateParameters;
            result.updateOperationParams = new SnapshotUpdateOperationParameters.Builder().withChainMode(this.chainMode == null ? SnapshotChainMode.DEFAULT : this.chainMode).withDeleteSources(this.deleteSources).withSingleFileCopy(this.singleFileCopy).build();
            result.keyAlias = this.keyAlias;
            result.size = this.size;
            result.walSize = this.walSize;
            result.masterKeyName = this.masterKeyName;
            result.clusterNodesVersions = this.clusterNodesVersions;
            return result;
        }
    }
}

