/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr.recovery;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.util.GridAtomicLong;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.messages.ClusterWideSnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridRecovery;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRParameters;
import org.gridgain.grid.internal.processors.cache.database.recovery.RecoveryCoordinatorLeftException;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationAttrs;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationFuture;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.gridgain.grid.internal.processors.cache.database.txdr.recovery.PITRReplicationRecoveryParameters;
import org.gridgain.grid.internal.processors.cache.database.txdr.recovery.TimeResolver;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.gridgain.grid.internal.txdr.TransactionalDr;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.jetbrains.annotations.Nullable;

public class ReplicationRecoveryFuture
extends SnapshotOperationFuture<Long> {
    private static final long RECOVERY_TIME_OUT_INTERVAL = 60000L;
    private final TransactionalDrProcessorImpl txdrProc;
    private volatile IgniteInternalFuture<?> recoveryFut;
    private ConsistentCut lastAppliedCut;
    private volatile long locMaxTime = Long.MAX_VALUE;
    private GridAtomicLong crdRecoveryTime = new GridAtomicLong(Long.MAX_VALUE);
    private volatile IgniteInternalFuture<Set<Object>> scanForLeftNodesFut;

    public ReplicationRecoveryFuture(int protoVer, IgniteUuid id, boolean initiator, UUID initiatorId, @Nullable GridFutureAdapter<Void> clientInitFut, @Nullable GridFutureAdapter<Long> clientDoneFut, GridCacheSnapshotManager snapMgr, GridCacheSharedContext cctx, SnapshotConfiguration snapConf, SnapshotMetricsMXBeanImpl snapshotMetrics) {
        super(protoVer, id, initiator, initiatorId, clientInitFut, clientDoneFut, snapMgr, cctx, snapConf, snapshotMetrics);
        GridGainImpl gg = (GridGainImpl)cctx.kernalContext().grid().plugin("GridGain");
        TransactionalDr txDr = gg.txDr();
        this.txdrProc = txDr instanceof TransactionalDrProcessorImpl ? (TransactionalDrProcessorImpl)txDr : null;
    }

    @Override
    public SnapshotOperationType type() {
        return SnapshotOperationType.REPLICATION_RECOVERY;
    }

    @Override
    protected boolean needExchangeOnFinish() {
        return this.success();
    }

    @Override
    protected boolean shouldParticipateInSnapshotOperation(UUID nodeId) {
        return super.shouldParticipateInSnapshotOperation(nodeId) && this.recoveryNodes().contains(this.cctx.localNode().id());
    }

    @Override
    protected boolean doFirstStage() throws Exception {
        if (this.nodeShouldSkipActiveActions() || !this.isRecoveryNode()) {
            return true;
        }
        this.lastAppliedCut = this.txdrProc.consistentCutStore().restore(this.txdrProc.localState().lastSuccessfullyAppliedCutId());
        this.locMaxTime = TimeResolver.getLocalMaxTime(this.log, this.snapMgr.getWalIteratorParameters(), this.txdrProc.walDir(this.lastAppliedCut.spawnId()), (FileWALPointer)this.lastAppliedCut.cutPtr());
        U.log((IgniteLogger)this.log, (Object)("Recovery local max wal time = " + this.locMaxTime));
        return true;
    }

    @Override
    protected boolean doSecondStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        this.res = this.unmarshalPayload(msg.payload());
        U.log((IgniteLogger)this.log, (Object)("Global Recovery time = " + this.res));
        if (this.isCancelled() || !this.isRecoveryNode()) {
            return true;
        }
        if ((Long)this.res > 0L) {
            GridRecovery recovery = this.recovery();
            assert (recovery != null);
            recovery.initRecovery((PITRParameters)new PITRReplicationRecoveryParameters(this.topVer, this.recoveryTime(), this.resolveAliveNodes(), this.lastAppliedCut));
            this.doneFut.listen((IgniteInClosure)new IgniteInClosure<IgniteInternalFuture>(){

                public void apply(IgniteInternalFuture fut) {
                    try {
                        fut.get();
                        ReplicationRecoveryFuture.this.recovery().onRecoveryFinish(null);
                    }
                    catch (IgniteCheckedException e) {
                        ReplicationRecoveryFuture.this.recovery().onRecoveryFinish((Throwable)e);
                    }
                }
            });
            this.scanForLeftNodesFut = recovery.scanForLeftNodes();
            this.scanForLeftNodesFut.get();
        }
        return true;
    }

    @Override
    protected boolean doThirdStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        if (this.scanForLeftNodesFut != null) {
            this.recovery().continueTxStateCommunication(this.resolveLeftNodes(), this.context(null));
        }
        return true;
    }

    @Override
    protected void doFinalStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws IgniteCheckedException {
        if (this.res == null) {
            this.res = this.unmarshalPayload(msg.payload());
            U.log((IgniteLogger)this.log, (Object)("Global Recovery time = " + this.res));
        }
        if (!this.cctx.localNode().isClient() && (Long)this.res > 0L) {
            GridRecovery recovery = this.recovery();
            final CountDownLatch latch = new CountDownLatch(1);
            GridDhtPartitionsExchangeFuture fut = this.cctx.exchange().lastTopologyFuture();
            fut.listen((IgniteInClosure)new CI1<IgniteInternalFuture>(){

                public void apply(IgniteInternalFuture f) {
                    try {
                        f.get();
                    }
                    catch (IgniteCheckedException e) {
                        U.error((IgniteLogger)ReplicationRecoveryFuture.this.log, (Object)"", (Throwable)e);
                    }
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new IgniteCheckedException("Interrupt during awaiting latch", (Throwable)e);
            }
            U.log((IgniteLogger)this.log, (Object)("Start local recovery on topVer=" + fut.exchangeId().topologyVersion()));
            IgniteInternalFuture recoveryFut0 = this.recoveryFut = recovery.recoveryLocalUpdates(this.context(null));
            while (true) {
                try {
                    recoveryFut0.get(60000L);
                }
                catch (IgniteFutureTimeoutCheckedException ignore) {
                    U.log((IgniteLogger)this.log, (Object)"Waiting for applying updates");
                    continue;
                }
                break;
            }
        }
        this.txdrProc.localCompleteStateChageOnRecovery();
    }

    @Override
    protected void onFinish(Long res, Throwable err) {
        GridSnapshotOperationEx op = this.snapshotInfo.snapshotOperation();
        this.txdrProc.localFinishStateChange(ClusterRole.REPLICA, ReplicationState.STOP_AND_RECOVERY, GridSnapshotOperationAttrs.getReplicationSessionId((GridSnapshotOperationEx)op), err, res);
        if (err != null && this.log.isInfoEnabled()) {
            this.log.info("TX DR replication recovery successfully completed [recoveryTime=" + res + "]");
        }
    }

    @Override
    protected void cancelComplete(boolean force) throws IgniteCheckedException {
        IgniteInternalFuture<?> recoveryFut0;
        if (!this.nodeShouldSkipActiveActions() && !force && (recoveryFut0 = this.recoveryFut) != null) {
            recoveryFut0.get();
        }
    }

    @Override
    protected SnapshotOperationStage nextStage(SnapshotOperationStage stage, boolean success) {
        if (!success && this.isSupportCancelProtocol()) {
            return SnapshotOperationStage.CANCELLED;
        }
        switch (stage) {
            case FIRST: {
                return SnapshotOperationStage.SECOND;
            }
            case SECOND: {
                return SnapshotOperationStage.THIRD;
            }
            case THIRD: {
                return SnapshotOperationStage.FINISH;
            }
            case CANCELLED: {
                return SnapshotOperationStage.CANCELLED;
            }
        }
        throw new AssertionError((Object)("Unexpected stage in nextStage, passed stage=" + (Object)((Object)stage)));
    }

    @Override
    protected byte[] getPayload(SnapshotOperationStage stage) throws IgniteCheckedException {
        if (stage == SnapshotOperationStage.FIRST) {
            return U.marshal((Marshaller)this.cctx.marshaller(), (Object)this.locMaxTime);
        }
        return null;
    }

    @Override
    protected void processPayloadFromNode(UUID nodeId, byte[] payload) throws IgniteCheckedException {
        if (payload != null && this.shouldParticipateInSnapshotOperation(nodeId)) {
            long unmarshal = (Long)this.unmarshalPayload(payload);
            this.crdRecoveryTime.setIfLess(unmarshal);
        }
    }

    @Override
    protected byte[] getClusterWidePayload(SnapshotOperationStage stage) throws IgniteCheckedException {
        if (stage == SnapshotOperationStage.FIRST || stage == SnapshotOperationStage.THIRD) {
            return U.marshal((Marshaller)this.cctx.marshaller(), (Object)this.crdRecoveryTime.get());
        }
        return null;
    }

    @Override
    protected void updateError0(Throwable th) {
        this.recovery().onRecoveryFinish(th);
    }

    @Override
    protected synchronized void onNodeLeft0(ClusterNode node, boolean crd) throws IgniteCheckedException {
        super.onNodeLeft0(node, crd);
        if (!this.cctx.localNode().isClient()) {
            try {
                this.recovery().onNodeLeft(node, true);
            }
            catch (RecoveryCoordinatorLeftException e) {
                throw new IgniteCheckedException("Error during handling onNodeLeft in recovery future", (Throwable)((Object)e));
            }
        }
    }

    private Set<Object> resolveLeftNodes() {
        Set<UUID> recoveryNodes = this.recoveryNodes();
        List srvNodes = this.cctx.discovery().discoCache(this.topVer).serverNodes();
        return srvNodes.stream().filter(node -> !recoveryNodes.contains(node.id())).map(ClusterNode::consistentId).collect(Collectors.toSet());
    }

    private Set<Object> resolveAliveNodes() {
        Set<UUID> recoveryNodes = this.recoveryNodes();
        List srvNodes = this.cctx.discovery().discoCache(this.topVer).serverNodes();
        return srvNodes.stream().filter(node -> recoveryNodes.contains(node.id())).map(ClusterNode::consistentId).collect(Collectors.toSet());
    }

    private long recoveryTime() {
        return (Long)this.res;
    }

    private Set<UUID> recoveryNodes() {
        return GridSnapshotOperationAttrs.getReplicationRecoveryNodes((GridSnapshotOperationEx)this.snapshotInfo.snapshotOperation());
    }

    private boolean isRecoveryNode() {
        return this.recoveryNodes().contains(this.cctx.localNode().id());
    }

    private GridRecovery recovery() {
        GridGainImpl gg = (GridGainImpl)this.cctx.kernalContext().grid().plugin("GridGain");
        return gg.provider().recovery();
    }

    private <T> T unmarshalPayload(byte[] payload) throws IgniteCheckedException {
        return (T)U.unmarshal((Marshaller)this.cctx.marshaller(), (byte[])payload, (ClassLoader)U.gridClassLoader());
    }
}

