/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.MarshallerContextImpl;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.eventstorage.DiscoveryEventListener;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyResultV2;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.util.GridAtomicLong;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskArg;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskV2;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.thread.IgniteThread;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutAppliedGloballyDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutAppliedMessage;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutApplyMessage;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutReadyMessage;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutStore;
import org.gridgain.grid.internal.processors.cache.database.txdr.DebugMode;
import org.gridgain.grid.internal.processors.cache.database.txdr.NodeLastEvents;
import org.gridgain.grid.internal.processors.cache.database.txdr.PartitionMapValidator;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationSessionDescriptor;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.jetbrains.annotations.NotNull;

public class ConsistentCutWatcher {
    private static final Boolean CONSISTENT_CUT_GC_DISABLED = Boolean.getBoolean("CONSISTENT_CUT_GC_DISABLED");
    private static final long CONSISTENT_CUTS_CHECK_FREQ = Integer.getInteger("CONSISTENT_CUTS_CHECK_FREQ", 10000).intValue();
    private static final long INVALID_CONSISTENT_CUT_ID = -1L;
    private static final long TX_DR_INACTIVITY_WARN_THRESHOLD = Integer.getInteger("TX_DR_INACTIVITY_WARN_THRESHOLD", 300000).intValue();
    private final int TX_DR_FAILED_CUTS_TO_REBALANCE_THRESHOLD = Integer.getInteger("TX_DR_FAILED_CUTS_TO_REBALANCE_THRESHOLD", 10);
    static final String THREAD_NAME_PREFIX = "cc-watcher-worker";
    private volatile ConsistentCutStore cutsStore;
    private volatile boolean startPrepared;
    private volatile IgniteLogger log;
    private ConsistentCutWatcherWorker worker;
    private boolean needGc;
    private long lastLocReadyCutId;
    private boolean firstReadyMsgToCrd;
    private volatile long roleSwitchCutId;
    private final AtomicLong lastLocAppliedCutId = new AtomicLong();
    private final long cutDeliveryFromMasterNodeTimeout;
    private final AtomicLong processedBltCutId = new AtomicLong();
    private final GridAtomicLong nextApplyingCutId = new GridAtomicLong();
    private final GridAtomicLong limitApplyingCutId = new GridAtomicLong();
    private GridFutureAdapter<Void> suspendFut;
    private volatile UUID crdNode;
    private final GridKernalContext ctx;
    private final TransactionalDrProcessorImpl txdrProc;
    private final Object mux = new Object();
    private ConcurrentSkipListMap<Long, BaselineTopology> crdBltCuts = new ConcurrentSkipListMap();
    private final Map<Object, Set<Long>> globalReadyNodesCuts = new ConcurrentHashMap<Object, Set<Long>>();
    private final NavigableMap<Long, AtomicReference<CutReadinessStatus>> globalReadyCutsIds = new ConcurrentSkipListMap<Long, AtomicReference<CutReadinessStatus>>();
    private final NavigableMap<Long, Set<Object>> globalPendingCuts = new ConcurrentSkipListMap(Collections.reverseOrder());
    private final Set<Long> globalExchangeTriggeringCuts = new GridConcurrentHashSet();
    private final AtomicBoolean triggerExchangeOnNextCutAppliedGlobally = new AtomicBoolean();
    private final Map<Long, Set<Object>> masterCutsTop = new ConcurrentHashMap<Long, Set<Object>>();
    private final NavigableMap<Long, Set<Object>> masterJoinCutsTop = new ConcurrentSkipListMap<Long, Set<Object>>();
    private final Map<Object, Long> failedNodes = new ConcurrentHashMap<Object, Long>();
    private final AtomicInteger partiallyFailedCutsCntr = new AtomicInteger();
    private volatile boolean possibleDataLost;
    private final AtomicBoolean stoppingReplication = new AtomicBoolean();
    private final Map<Integer, BinaryMetadata> binaryMetadata = new ConcurrentHashMap<Integer, BinaryMetadata>();
    private final GridAtomicLong clusterMaxLocallyAppliedCutId = new GridAtomicLong();
    private final GridAtomicLong lastGlobalReadyCutId = new GridAtomicLong();
    private final GridAtomicLong globalApplyingCutId = new GridAtomicLong();
    private volatile PartitionMapValidator partMapValidator;
    private volatile long lastInactivityWarnedCutId;
    private volatile long debugAppliedCutId;
    private volatile boolean debugPauseTriggered;
    private boolean applyingCutsDebugPauseNeeded;
    private final BlockingQueue<IgniteBiTuple<UUID, ConsistentCutReadyMessage>> reqQueue = new LinkedBlockingQueue<IgniteBiTuple<UUID, ConsistentCutReadyMessage>>();
    private final List<IgniteInClosure<Long>> readyCutsLsnrs = new CopyOnWriteArrayList<IgniteInClosure<Long>>();
    private final List<IgniteInClosure<Long>> appliedCutsLsnrs = new CopyOnWriteArrayList<IgniteInClosure<Long>>();
    private final IgniteInClosure<Long> readyCutLsnr = new IgniteInClosure<Long>(){

        public void apply(Long globalReadyCutId) {
            try {
                ConsistentCutWatcher.this.proposeBinaryMetadata();
            }
            catch (IgniteCheckedException e) {
                ConsistentCutWatcher.this.log.error("Failed to propose binary metadata:", (Throwable)e);
                throw new IgniteException((Throwable)e);
            }
            Set masterCutTop = (Set)ConsistentCutWatcher.this.masterCutsTop.get(globalReadyCutId);
            HashSet aliveNodes = new HashSet(ConsistentCutWatcher.this.ctx.discovery().aliveServerNodes());
            GridConcurrentHashSet cutPendingNodes = new GridConcurrentHashSet((Collection)masterCutTop);
            cutPendingNodes.retainAll(F.nodeConsistentIds(aliveNodes));
            ConsistentCutWatcher.this.globalPendingCuts.put(globalReadyCutId, cutPendingNodes);
            HashSet joinCutTop = (HashSet)ConsistentCutWatcher.this.masterJoinCutsTop.get(globalReadyCutId);
            if (joinCutTop != null) {
                joinCutTop = new HashSet(joinCutTop);
                joinCutTop.retainAll((Collection<?>)cutPendingNodes);
                if (!joinCutTop.isEmpty()) {
                    ConsistentCutWatcher.this.globalExchangeTriggeringCuts.add(globalReadyCutId);
                }
            }
            if (ConsistentCutWatcher.this.log.isInfoEnabled()) {
                ArrayList<Object> leftNodes = new ArrayList<Object>();
                ArrayList<Object> joinedNodes = new ArrayList<Object>();
                for (ClusterNode node : aliveNodes) {
                    Set nodes;
                    Object consistentId = node.consistentId();
                    if (!masterCutTop.contains(consistentId)) {
                        leftNodes.add(consistentId);
                    }
                    if ((nodes = (Set)ConsistentCutWatcher.this.masterJoinCutsTop.get(globalReadyCutId)) == null || !nodes.contains(consistentId)) continue;
                    joinedNodes.add(consistentId);
                }
                if (!leftNodes.isEmpty() && ConsistentCutWatcher.this.log.isInfoEnabled()) {
                    ConsistentCutWatcher.this.log.info("Some nodes left master cluster. Consistent cut won't be applied on corresponding nodes of replica cluster [cutId=" + globalReadyCutId + ", consistentIds=" + leftNodes + ']');
                }
                if (!joinedNodes.isEmpty() && ConsistentCutWatcher.this.log.isInfoEnabled()) {
                    ConsistentCutWatcher.this.log.info("Some nodes joined to master cluster. Rebalancing will be scheduled in order to dispatch missed updates to corresponding replica nodes [cutId=" + globalReadyCutId + ", consistentIds=" + joinedNodes + ']');
                }
            }
            for (ClusterNode node : aliveNodes) {
                Object consistentId = node.consistentId();
                boolean isDeadOnMaster = !masterCutTop.contains(consistentId);
                ConsistentCutApplyMessage msg = new ConsistentCutApplyMessage(globalReadyCutId, isDeadOnMaster);
                try {
                    ConsistentCutWatcher.this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_TXDR, (Message)msg, (byte)2);
                }
                catch (IgniteCheckedException e) {
                    ConsistentCutWatcher.this.log.error("Failed to send message", (Throwable)e);
                    if (!cutPendingNodes.remove(consistentId) || !cutPendingNodes.isEmpty()) continue;
                    ConsistentCutWatcher.this.onConsistentCutAppliedGlobally(globalReadyCutId);
                }
            }
        }
    };
    private final GridMessageListener msgLsnr = new GridMessageListener(){

        public void onMessage(UUID nodeId, Object msg, byte plc) {
            if (msg instanceof ConsistentCutReadyMessage) {
                ConsistentCutReadyMessage msg0 = (ConsistentCutReadyMessage)msg;
                ConsistentCutWatcher.this.reqQueue.add(new IgniteBiTuple((Object)nodeId, (Object)msg0));
                if (ConsistentCutWatcher.this.log.isDebugEnabled()) {
                    ConsistentCutWatcher.this.log.debug("New consistent cuts are ready: [nodeId=" + nodeId + ", msg=" + msg0 + ']');
                }
            } else if (msg instanceof ConsistentCutApplyMessage) {
                long locAppliedCutId;
                ConsistentCutApplyMessage msg0 = (ConsistentCutApplyMessage)msg;
                long cutId = msg0.cutId();
                if (cutId <= (locAppliedCutId = ConsistentCutWatcher.this.lastLocAppliedCutId.get())) {
                    ConsistentCutWatcher.this.log.warning("Already applied consistent cut received [cutId=" + cutId + ", lastLocAppliedCutId=" + locAppliedCutId + ']');
                    try {
                        ConsistentCutWatcher.this.sendConsistentCutAppliedMessage(cutId, false, true);
                    }
                    catch (IgniteCheckedException e) {
                        ConsistentCutWatcher.this.log.error("Failed to send ConsistentCutAppliedMessage message to coordinator [crdId=" + ConsistentCutWatcher.this.crdNode + ", cutId=" + cutId + ']');
                        throw new IgniteException((Throwable)e);
                    }
                }
                if (!ConsistentCutWatcher.this.nextApplyingCutId.setIfGreater(cutId)) {
                    ConsistentCutWatcher.this.log.warning("Already scheduled consistent cut received [cutId=" + cutId + ", nextApplyingCutId=" + ConsistentCutWatcher.this.nextApplyingCutId.get() + ']');
                } else if (msg0.isDeadOnMaster()) {
                    ConsistentCutWatcher.this.nextApplyingCutId.compareAndSet(cutId, -1L);
                }
                if (ConsistentCutWatcher.this.log.isDebugEnabled()) {
                    ConsistentCutWatcher.this.log.debug("New consistent cuts are ready for local applying: [msg=" + msg0 + ']');
                }
                ConsistentCutWatcher.this.awake();
            } else if (msg instanceof ConsistentCutAppliedMessage) {
                ConsistentCutWatcher.this.onConsistentCutApplied(nodeId, (ConsistentCutAppliedMessage)msg);
            }
        }
    };
    private final DiscoveryEventListener evtLsnr = (evt, discoCache) -> {
        assert (evt.type() == 11 || evt.type() == 12) : evt;
        this.onNodeLeft(evt.eventNode());
    };

    private void onConsistentCutApplied(UUID nodeId, ConsistentCutAppliedMessage msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Consistent cut has been applied: [nodeId=" + nodeId + ", msg=" + msg + ']');
        }
        ClusterNode node = this.ctx.discovery().node(nodeId);
        Set pendingNodes = (Set)this.globalPendingCuts.get(msg.cutId());
        if (node != null && pendingNodes != null && pendingNodes.remove(node.consistentId())) {
            if (!msg.isSuccess()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Failed to apply consistent cut [cutId=" + msg.cutId() + ", nodeId=" + node.consistentId() + ']');
                }
                this.failedNodes.put(node.consistentId(), msg.cutId());
            }
            if (msg.isRebalanceNeeded()) {
                this.globalExchangeTriggeringCuts.add(msg.cutId());
            }
            if (pendingNodes.isEmpty()) {
                this.onConsistentCutAppliedGlobally(msg.cutId());
            }
        }
    }

    ConsistentCutWatcher(TransactionalDrProcessorImpl txdrProc, GridKernalContext ctx, long cutDeliveryFromMasterNodeTimeout) {
        this.txdrProc = txdrProc;
        this.ctx = ctx;
        this.cutDeliveryFromMasterNodeTimeout = cutDeliveryFromMasterNodeTimeout;
    }

    public synchronized void prepareStart() {
        this.prepareStart(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void prepareStart(boolean suspended) {
        ReplicationSessionDescriptor state0 = this.txdrProc.localState();
        assert (state0.role() == ClusterRole.REPLICA) : "Watcher can be started on replica cluster only";
        assert (!this.ctx.isDaemon() && !this.ctx.clientNode()) : "Watcher cannot be started on daemon or client node";
        assert (!this.startPrepared) : "Attempt to start already started watcher";
        Object object = this.mux;
        synchronized (object) {
            this.crdNode = this.txdrProc.getReplicationCoordinatorNodeId();
            this.firstReadyMsgToCrd = true;
            this.lastLocReadyCutId = state0.lastSuccessfullyAppliedCutId();
            this.lastLocAppliedCutId.set(this.lastLocReadyCutId);
        }
        this.log = this.ctx.log(ConsistentCutWatcher.class);
        this.cutsStore = this.txdrProc.consistentCutStore();
        this.globalReadyNodesCuts.clear();
        this.globalReadyCutsIds.clear();
        this.failedNodes.clear();
        this.binaryMetadata.clear();
        this.masterCutsTop.clear();
        this.masterJoinCutsTop.clear();
        this.globalApplyingCutId.set(0L);
        this.lastGlobalReadyCutId.set(0L);
        this.clusterMaxLocallyAppliedCutId.set(0L);
        this.crdBltCuts.clear();
        this.roleSwitchCutId = 0L;
        this.debugAppliedCutId = this.lastLocAppliedCutId.get();
        this.limitApplyingCutId.set(suspended ? this.lastLocAppliedCutId.get() : Long.MAX_VALUE);
        this.ctx.event().addDiscoveryEventListener(this.evtLsnr, 12, new int[]{11});
        this.ctx.io().addMessageListener(GridTopic.TOPIC_TXDR, this.msgLsnr);
        this.addReadyCutsListener(this.readyCutLsnr);
        this.partMapValidator = new PartitionMapValidator(this.ctx);
        this.worker = new ConsistentCutWatcherWorker();
        this.startPrepared = true;
        if (this.log.isInfoEnabled()) {
            this.log.info("Consistent cut watcher start prepared, bootstrap session id: " + state0.sessionId());
        }
    }

    void initLastAppliedCutId(long cutId) {
        this.lastLocReadyCutId = cutId;
        this.lastLocAppliedCutId.set(cutId);
        this.txdrProc.lastAppliedConsistentCut(cutId);
    }

    public synchronized void completeStart() {
        Thread runner = this.worker.runner();
        if (runner != null && runner.isAlive()) {
            return;
        }
        new IgniteThread((GridWorker)this.worker).start();
        ReplicationSessionDescriptor state0 = this.txdrProc.localState();
        if (this.log.isInfoEnabled()) {
            this.log.info("Consistent cut watcher start completed, bootstrap session id: " + state0.sessionId());
        }
    }

    public synchronized void stop() {
        if (this.startPrepared) {
            this.startPrepared = false;
            U.cancel((GridWorker)this.worker);
            try {
                U.join((GridWorker)this.worker);
            }
            catch (IgniteInterruptedCheckedException e) {
                U.error((IgniteLogger)this.log, (Object)"Was interrupted while waiting for ConsistentCut worker shutdown.", (Throwable)e);
            }
            this.removeReadyCutsListener(this.readyCutLsnr);
            this.ctx.io().removeMessageListener((Object)this.msgLsnr);
            this.ctx.event().removeDiscoveryEventListener(this.evtLsnr, new int[]{12, 11});
            this.globalReadyNodesCuts.clear();
            this.globalReadyCutsIds.clear();
            this.masterCutsTop.clear();
            this.masterJoinCutsTop.clear();
            this.binaryMetadata.clear();
            if (this.log.isInfoEnabled()) {
                this.log.info("Consistent cut watcher stopped");
            }
        }
    }

    void awake() {
        this.reqQueue.add((IgniteBiTuple<UUID, ConsistentCutReadyMessage>)new IgniteBiTuple(null, null));
    }

    void addReadyCutsListener(IgniteInClosure<Long> lsnr) {
        this.readyCutsLsnrs.add(lsnr);
    }

    void removeReadyCutsListener(IgniteInClosure<Long> lsnr) {
        this.readyCutsLsnrs.remove(lsnr);
    }

    void addAppliedCutsListener(IgniteInClosure<Long> lsnr) {
        this.appliedCutsLsnrs.add(lsnr);
    }

    void removeAppliedCutsListener(IgniteInClosure<Long> lsnr) {
        this.appliedCutsLsnrs.remove(lsnr);
    }

    void waitForCutApplyAndSuspend(long cutId) {
        IgniteInternalFuture<Void> fut = this.limitCutApplying(cutId);
        this.awake();
        if (this.log.isInfoEnabled()) {
            this.log.info("Waiting for applying " + (cutId == 0L ? "current cut" : "cut " + cutId));
        }
        try {
            fut.get();
            if (this.log.isDebugEnabled()) {
                this.log.debug((cutId == 0L ? "Current cut" : "\u0421ut " + cutId) + " applied");
            }
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to wait for suspend future", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IgniteInternalFuture<Void> limitCutApplying(long cutId) {
        GridFutureAdapter fut;
        Object object = this.mux;
        synchronized (object) {
            this.limitApplyingCutId.set(cutId);
            fut = this.suspendFut;
            if (fut == null || fut.isDone()) {
                this.suspendFut = fut = new GridFutureAdapter();
            }
        }
        return fut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume() {
        Object object = this.mux;
        synchronized (object) {
            this.limitApplyingCutId.set(Long.MAX_VALUE);
            GridFutureAdapter<Void> fut = this.suspendFut;
            if (fut != null && !fut.isDone()) {
                fut.onDone();
            }
            this.suspendFut = null;
        }
        this.awake();
    }

    Map<Object, Set<Long>> globalReadyNodesCuts() {
        HashMap<Object, Set<Long>> cp = new HashMap<Object, Set<Long>>(U.capacity((int)this.globalReadyNodesCuts.size()));
        for (Map.Entry<Object, Set<Long>> entry : this.globalReadyNodesCuts.entrySet()) {
            cp.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        return cp;
    }

    Map<Object, Long> failedNodes() {
        return new HashMap<Object, Long>(this.failedNodes);
    }

    String globalReadyCutsIdsDump() {
        Map<Object, Set<Long>> globalReadyCutsIds0 = this.globalReadyNodesCuts();
        ClusterNode locNode = this.ctx.grid().localNode();
        TreeMap<Object, UUID> consistentIdToIdMap = new TreeMap<Object, UUID>(Comparator.comparing(Object::toString));
        for (ClusterNode node : this.ctx.discovery().aliveServerNodes()) {
            if (!globalReadyCutsIds0.keySet().contains(node.consistentId())) continue;
            consistentIdToIdMap.put(node.consistentId(), node.id());
        }
        for (Object consistentId : globalReadyCutsIds0.keySet()) {
            consistentIdToIdMap.putIfAbsent(consistentId, null);
        }
        StringBuilder sb = new StringBuilder("Ready consistent cuts dump on ").append(locNode.consistentId()).append(" [").append(locNode.id()).append("]:\n").append("Global ready consistent cut IDs:\n");
        for (Map.Entry entry : consistentIdToIdMap.entrySet()) {
            Object consistentId = entry.getKey();
            UUID id = (UUID)entry.getValue();
            ArrayList readyCutsIds = new ArrayList(globalReadyCutsIds0.get(consistentId));
            Collections.sort(readyCutsIds);
            sb.append("  ").append(consistentId).append(" [").append(id).append("] -> ").append(readyCutsIds).append('\n');
        }
        sb.append("Last applied consistent cut ID: ").append(this.clusterMaxLocallyAppliedCutId.get());
        return sb.toString();
    }

    long processedBltCutId() {
        return this.processedBltCutId.get();
    }

    private void onConsistentCutReady(UUID nodeId, ConsistentCutReadyMessage msg) {
        ClusterNode node;
        if (!this.startPrepared) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processing cuts update [node=" + nodeId + ", msg=" + msg + ']');
        }
        if ((node = this.ctx.discovery().node(nodeId)) != null && msg != null) {
            Map<Long, byte[]> bltCuts;
            long lastAppliedCutId = msg.lastAppliedCutId();
            if (msg.nodeIsLaggingBehind()) {
                this.failedNodes.putIfAbsent(node.consistentId(), lastAppliedCutId);
            }
            if (msg.switchCutId() != 0L) {
                this.roleSwitchCutId = msg.switchCutId();
            }
            if ((bltCuts = msg.baselineTopologyCuts()) != null && !bltCuts.isEmpty()) {
                long minCutId = Math.max(this.clusterMaxLocallyAppliedCutId.get(), this.lastLocAppliedCutId.get());
                bltCuts.forEach((cutId, bltArr) -> {
                    JdkMarshaller jdkMarsh = this.ctx.marshallerContext().jdkMarshaller();
                    if (cutId > minCutId && !this.crdBltCuts.containsKey(cutId)) {
                        BaselineTopology blt;
                        try {
                            blt = (BaselineTopology)jdkMarsh.unmarshal(bltArr, U.gridClassLoader());
                        }
                        catch (IgniteCheckedException e) {
                            throw new IgniteException("Failed to unmarshall baseline topology [msg=" + msg + ']', (Throwable)e);
                        }
                        this.crdBltCuts.put((Long)cutId, blt);
                    }
                });
            }
            List<Long> readyCutsIdsUpd = msg.consistentCutsIds();
            Object nodeConsistentId = node.consistentId();
            Set readyCutsIds = this.globalReadyNodesCuts.computeIfAbsent(nodeConsistentId, key -> new GridConcurrentHashSet());
            if (msg.nodesLastEventsBytes() != null) {
                try {
                    Map cutNodesLastEvts = (Map)this.ctx.marshallerContext().jdkMarshaller().unmarshal(msg.nodesLastEventsBytes(), U.gridClassLoader());
                    for (Long cutId2 : readyCutsIdsUpd) {
                        Map nodeLastEvts = (Map)cutNodesLastEvts.get(cutId2);
                        if (nodeLastEvts == null) continue;
                        this.masterCutsTop.computeIfAbsent(cutId2, key -> this.cutTopology(cutId2, nodeLastEvts));
                    }
                }
                catch (IgniteCheckedException ex) {
                    this.log.warning("Failed to unmarshal node events", (Throwable)ex);
                }
            }
            for (Long ccId2 : readyCutsIdsUpd) {
                if (readyCutsIds.contains(ccId2)) continue;
                this.globalReadyCutsIds.computeIfAbsent(ccId2, k -> new AtomicReference()).updateAndGet(prev -> prev == null ? new CutReadinessStatus(1, this.cutDeliveryFromMasterNodeTimeout) : new CutReadinessStatus(prev.nodeCnt + 1, prev.timeout));
            }
            readyCutsIds.removeIf(ccId -> ccId <= lastAppliedCutId);
            readyCutsIds.addAll(readyCutsIdsUpd);
            List<byte[]> metas = msg.binaryMetadata();
            if (metas != null) {
                for (byte[] metaArr : metas) {
                    BinaryMetadata meta;
                    try {
                        ClassLoader clsLdr = U.resolveClassLoader((IgniteConfiguration)this.ctx.cache().context().gridConfig());
                        meta = (BinaryMetadata)this.ctx.marshallerContext().jdkMarshaller().unmarshal(metaArr, clsLdr);
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException((Throwable)e);
                    }
                    this.binaryMetadata.compute(meta.typeId(), (k, v) -> BinaryUtils.mergeMetadata((BinaryMetadata)v, (BinaryMetadata)meta));
                }
            }
            if (this.clusterMaxLocallyAppliedCutId.setIfGreater(lastAppliedCutId)) {
                this.masterCutsTop.keySet().removeIf(ccId -> ccId <= lastAppliedCutId);
                this.masterJoinCutsTop.keySet().removeIf(ccId -> ccId <= lastAppliedCutId);
                this.globalReadyCutsIds.keySet().removeIf(ccId -> ccId <= lastAppliedCutId && ccId != this.roleSwitchCutId);
            }
        }
    }

    private void onConsistentCutAppliedGlobally(long cutId) {
        boolean needExchange;
        this.globalPendingCuts.keySet().removeIf(id -> id <= cutId);
        this.failedNodes.values().removeIf(id -> id < cutId);
        if (this.failedNodes.isEmpty()) {
            this.partiallyFailedCutsCntr.set(0);
        } else if (this.partiallyFailedCutsCntr.incrementAndGet() == this.TX_DR_FAILED_CUTS_TO_REBALANCE_THRESHOLD) {
            this.triggerExchangeOnNextCutAppliedGlobally.set(true);
            this.partiallyFailedCutsCntr.addAndGet(-this.TX_DR_FAILED_CUTS_TO_REBALANCE_THRESHOLD);
        }
        if (cutId == this.roleSwitchCutId) {
            try {
                GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)this.ctx.cache().context().snapshot();
                snapMgr.startGlobalReplicationStateChange(ClusterRole.REPLICA, ReplicationState.SWITCH, this.txdrProc.localState().sessionId(), this.roleSwitchCutId);
                this.roleSwitchCutId = 0L;
            }
            catch (Exception snapMgr) {
                // empty catch block
            }
        }
        if (needExchange = this.globalExchangeTriggeringCuts.removeIf(id -> id <= cutId) | this.triggerExchangeOnNextCutAppliedGlobally.compareAndSet(true, false)) {
            try {
                AffinityTopologyVersion affReadyVer = this.ctx.cache().context().exchange().readyAffinityVersion();
                this.ctx.discovery().sendCustomEvent((DiscoveryCustomMessage)new ConsistentCutAppliedGloballyDiscoveryMessage(cutId, true));
                this.partiallyFailedCutsCntr.set(0);
                if (!AffinityTopologyVersion.NONE.equals((Object)affReadyVer)) {
                    this.ctx.cache().context().exchange().affinityReadyFuture(new AffinityTopologyVersion(affReadyVer.topologyVersion(), affReadyVer.minorTopologyVersion() + 1)).get();
                }
            }
            catch (IgniteCheckedException e) {
                this.triggerExchangeOnNextCutAppliedGlobally.set(true);
                this.log.error("Failed to trigger exchange on cut " + cutId, (Throwable)e);
            }
        } else {
            ConsistentCutAppliedGloballyDiscoveryMessage msg = new ConsistentCutAppliedGloballyDiscoveryMessage(cutId, false);
            try {
                this.ctx.discovery().sendCustomEvent((DiscoveryCustomMessage)msg);
            }
            catch (IgniteCheckedException e) {
                this.log.error("Failed to send " + msg + " on cut " + cutId, (Throwable)e);
            }
        }
        this.debugAppliedCutId = cutId;
        if (this.log.isInfoEnabled()) {
            this.log.info("Consistent cut is applied globally: " + cutId);
        }
        for (IgniteInClosure<Long> lsnr : this.appliedCutsLsnrs) {
            lsnr.apply((Object)cutId);
        }
        if (this.debugMode() != DebugMode.NONE) {
            this.awake();
        }
    }

    private boolean changeBaselineTopology(BaselineTopology baselineTop, long bltCutId) {
        if (this.log.isInfoEnabled()) {
            LT.info((IgniteLogger)this.log, (String)("Changing baseline topology [baselineTop=" + baselineTop + ']'));
        }
        try {
            this.ctx.state().validateBeforeBaselineChange((Collection)baselineTop.currentBaseline());
        }
        catch (IgniteException e) {
            LT.error((IgniteLogger)this.txdrProc.essentialLogger(), (Throwable)e, (String)"Baseline topology can't be changed on REPLICA cluster due to the following reason:");
            return false;
        }
        this.processedBltCutId.set(bltCutId);
        IgniteInternalFuture fut = this.ctx.state().changeGlobalState(true, (Collection)baselineTop.currentBaseline(), true);
        try {
            fut.get();
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to change baseline topology on replica cluster.", (Throwable)e);
            throw new IgniteException((Throwable)e);
        }
        finally {
            this.processedBltCutId.set(0L);
        }
        return true;
    }

    private void warnGlobalInactivityIfNecessary() {
        long currTime = U.currentTimeMillis();
        long lastActivityTime = this.clusterMaxLocallyAppliedCutId.get();
        if (lastActivityTime != this.lastInactivityWarnedCutId && lastActivityTime != 0L && lastActivityTime + TX_DR_INACTIVITY_WARN_THRESHOLD < currTime && this.suspendFut == null) {
            this.lastInactivityWarnedCutId = lastActivityTime;
            this.txdrProc.essentialLogger().warning(this.globalReadyCutsIdsDump());
        }
    }

    private SortedSet<Long> findGlobalReadyCutsIds(long startWithCutId) {
        NavigableMap<Long, AtomicReference<CutReadinessStatus>> candidates;
        if (!this.startPrepared) {
            return Collections.emptySortedSet();
        }
        Collection aliveNodesConsistentIds = F.nodeConsistentIds((Collection)this.ctx.discovery().discoCache().aliveBaselineNodes());
        TreeSet<Long> readyCutsIds = new TreeSet<Long>();
        long minCutId = Math.max(Math.max(this.clusterMaxLocallyAppliedCutId.get(), this.lastLocAppliedCutId.get()), startWithCutId);
        if (this.crdBltCuts.isEmpty()) {
            candidates = this.globalReadyCutsIds.tailMap(minCutId, minCutId == this.roleSwitchCutId && minCutId > 0L);
        } else {
            Long bltCutId = this.crdBltCuts.firstKey();
            assert (minCutId <= bltCutId) : "[minCutId=" + minCutId + ", bltCutId=" + bltCutId + ']';
            candidates = this.globalReadyCutsIds.subMap(minCutId, false, bltCutId, true);
            if (candidates.size() > 1) {
                candidates = candidates.headMap(bltCutId, false);
            }
        }
        for (Map.Entry entry : candidates.entrySet()) {
            boolean cutTimedOut;
            Long ccId = (Long)entry.getKey();
            Set masterCutTop = this.masterCutsTop.computeIfAbsent(ccId, this::cutTopology);
            if (masterCutTop == null) continue;
            HashSet<Object> cutApplyTop = new HashSet<Object>(masterCutTop);
            cutApplyTop.retainAll(aliveNodesConsistentIds);
            CutReadinessStatus readySt = (CutReadinessStatus)((AtomicReference)entry.getValue()).get();
            assert (readySt != null);
            boolean allNodesAreReady = true;
            cutApplyTop.removeAll(this.failedNodes.keySet());
            if (cutApplyTop.size() > readySt.nodeCnt) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Cut " + ccId + " is not ready on all nodes, skipping [cutApplyTop.size=" + cutApplyTop.size() + ", readyNodesCnt=" + readySt.nodeCnt + ']');
                }
                allNodesAreReady = false;
            }
            Set<Object> notReadyNodes = this.findNodesWithoutReadyCut(ccId, cutApplyTop);
            boolean bl = cutTimedOut = U.currentTimeMillis() - readySt.lastReadyCheckTs > readySt.timeout;
            if (((allNodesAreReady &= notReadyNodes.isEmpty()) || cutTimedOut) && this.validateCutTopology(ccId, notReadyNodes)) {
                readyCutsIds.add(ccId);
                continue;
            }
            if (allNodesAreReady || !cutTimedOut) continue;
            ((AtomicReference)entry.getValue()).updateAndGet(prev -> new CutReadinessStatus(prev.nodeCnt, 2L * Math.min(prev.timeout, 0x3FFFFFFFFFFFFFFFL)));
        }
        return readyCutsIds;
    }

    @NotNull
    private Set<Object> findNodesWithoutReadyCut(Long ccId, Set<Object> targetTop) {
        HashSet<Object> res = new HashSet<Object>();
        for (Object nodeConsistentId : targetTop) {
            Set<Long> nodeCutsIds = this.globalReadyNodesCuts.get(nodeConsistentId);
            if (nodeCutsIds != null && nodeCutsIds.contains(ccId)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cut " + ccId + " is not ready on node " + nodeConsistentId);
            }
            res.add(nodeConsistentId);
        }
        return res;
    }

    private Set<Object> cutTopology(long cutId) {
        try {
            ConsistentCut cut = this.cutsStore.restore(cutId);
            return this.cutTopology(cutId, cut.bltNodesLastEvts());
        }
        catch (IgniteCheckedException ex) {
            return null;
        }
    }

    private Set<Object> cutTopology(long cutId, Map<Object, NodeLastEvents> nodeLastEvts) {
        if (F.isEmpty(nodeLastEvts)) {
            return new HashSet<Object>(F.nodeConsistentIds((Collection)this.ctx.discovery().aliveServerNodes()));
        }
        HashSet<Object> top = new HashSet<Object>();
        for (Map.Entry<Object, NodeLastEvents> entry : nodeLastEvts.entrySet()) {
            NodeLastEvents evts = entry.getValue();
            long joinCutId = evts.joinCutId();
            if (joinCutId >= evts.leftCutId() && joinCutId <= cutId || evts.leftCutId() > cutId) {
                top.add(entry.getKey());
            }
            if (joinCutId <= this.clusterMaxLocallyAppliedCutId.get()) continue;
            Set joinedNodes = this.masterJoinCutsTop.computeIfAbsent(joinCutId, key -> new GridConcurrentHashSet());
            joinedNodes.add(entry.getKey());
        }
        return top;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateCutTopology(long cutId, Set<Object> notReadyNodes) {
        long startTime = System.nanoTime();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Validate topology for cut: " + cutId);
        }
        try {
            int backupFactor = Integer.MAX_VALUE;
            for (CacheGroupDescriptor grp : this.ctx.cache().cacheGroupDescriptors().values()) {
                backupFactor = Math.min(backupFactor, grp.config().getBackups());
            }
            Set<Object> masterTop = this.masterCutsTop.get(cutId);
            assert (!F.isEmpty(masterTop)) : "Master topology is empty for cut " + cutId;
            BaselineTopology blt = this.ctx.state().clusterState().baselineTopology();
            if (blt != null) {
                int bltSize;
                int masterTopSize = masterTop.size();
                if (masterTopSize < (bltSize = blt.size()) - backupFactor) {
                    try {
                        if (!this.partMapValidator.checkPartitionsConsistency(blt, null, masterTop)) {
                            this.txdrProc.essentialLogger().error("Master cluster has lost partitions, replication can't be continued [cutId=" + cutId + ", masterTopSize=" + masterTopSize + ", bltTopSize=" + bltSize + ']');
                            this.possibleDataLost = true;
                            boolean bl = false;
                            return bl;
                        }
                    }
                    catch (IgniteCheckedException e) {
                        this.txdrProc.essentialLogger().error("More then backup factor nodes left the master cluster, replication can't be continued [cutId=" + cutId + ", masterTopSize=" + masterTop.size() + ", bltTopSize=" + blt.size() + ", backupFactor=" + backupFactor + ']');
                        this.possibleDataLost = true;
                        boolean bl = false;
                        return bl;
                    }
                }
                HashSet nodesToRebalance = new HashSet();
                for (Set joinedNodes : this.masterJoinCutsTop.headMap(cutId, true).values()) {
                    nodesToRebalance.addAll(joinedNodes);
                }
                HashSet<Object> masterApplyTop = new HashSet<Object>(masterTop);
                masterApplyTop.removeAll(nodesToRebalance);
                if (masterApplyTop.size() < blt.size() - backupFactor) {
                    try {
                        if (!this.partMapValidator.checkPartitionsConsistency(blt, null, masterApplyTop)) {
                            this.txdrProc.essentialLogger().warning("Not enough partition owners to apply cut [cutId=" + cutId + ", masterTopSize=" + masterTop.size() + ", masterApplyTopSize=" + masterApplyTop.size() + ", nodesToRebalanceSize=" + nodesToRebalance.size() + ", bltTopSize=" + blt.size() + ']');
                            boolean joinedNodes = false;
                            return joinedNodes;
                        }
                    }
                    catch (IgniteCheckedException e) {
                        this.txdrProc.essentialLogger().warning("Not enough nodes in the master cluster, to apply cut [cutId=" + cutId + ", masterTopSize=" + masterTop.size() + ", masterApplyTopSize=" + masterApplyTop.size() + ", nodesToRebalanceSize=" + nodesToRebalance.size() + ", bltTopSize=" + blt.size() + ", backupFactor=" + backupFactor + ']');
                        boolean bl = false;
                        return bl;
                    }
                }
                Collection aliveNodes = this.ctx.discovery().aliveServerNodes();
                HashSet<Object> cutApplyTop = new HashSet<Object>(F.nodeConsistentIds((Collection)aliveNodes));
                cutApplyTop.retainAll(masterApplyTop);
                cutApplyTop.removeAll(this.failedNodes.keySet());
                cutApplyTop.removeAll(notReadyNodes);
                if (cutApplyTop.size() < blt.size() - backupFactor) {
                    try {
                        if (!this.partMapValidator.checkPartitionsConsistency(blt, null, cutApplyTop)) {
                            this.txdrProc.essentialLogger().warning("Not enough partition owners to apply cut [cutId=" + cutId + ", aliveNodesSize=" + aliveNodes.size() + ", masterTopSize=" + masterTop.size() + ", masterApplyTopSize=" + masterApplyTop.size() + ", nodesToRebalanceSize=" + nodesToRebalance.size() + ", failedNodesSize=" + this.failedNodes.size() + ", cutApplyTopSize=" + cutApplyTop.size() + ", bltTopSize=" + blt.size() + ']');
                            boolean bl = false;
                            return bl;
                        }
                    }
                    catch (IgniteCheckedException e) {
                        this.txdrProc.essentialLogger().warning("Replication can't be continued with current topology [cutId=" + cutId + ", aliveNodesSize=" + aliveNodes.size() + ", masterTopSize=" + masterTop.size() + ", masterApplyTopSize=" + masterApplyTop.size() + ", nodesToRebalanceSize=" + nodesToRebalance.size() + ", failedNodesSize=" + this.failedNodes.size() + ", cutApplyTopSize=" + cutApplyTop.size() + ", bltTopSize=" + blt.size() + ", backupFactor=" + backupFactor + ']');
                        boolean bl = false;
                        return bl;
                    }
                }
                int rebalancingNodesCnt = this.rebalancingNodesCnt(aliveNodes, cutApplyTop);
                if (cutApplyTop.size() - rebalancingNodesCnt < blt.size() - backupFactor) {
                    try {
                        if (!this.partMapValidator.checkPartitionsConsistency(blt, aliveNodes, cutApplyTop)) {
                            this.txdrProc.essentialLogger().warning("Replication can't be continued with current topology, estimated data loss in partitions [cutId=" + cutId + ", aliveNodesSize=" + aliveNodes.size() + ", masterTopSize=" + masterTop.size() + ", masterApplyTopSize=" + masterApplyTop.size() + ", nodesToRebalanceSize=" + nodesToRebalance.size() + ", cutApplyTopSize=" + cutApplyTop.size() + ", failedNodesSize=" + this.failedNodes.size() + ", rebalancingNodesCnt=" + rebalancingNodesCnt + ", bltTopSize=" + blt.size() + ']');
                            boolean bl = false;
                            return bl;
                        }
                    }
                    catch (IgniteCheckedException ignore) {
                        this.txdrProc.essentialLogger().warning("Replication can't be continued with current topology [cutId=" + cutId + ", aliveNodesSize=" + aliveNodes.size() + ", masterTopSize=" + masterTop.size() + ", masterApplyTopSize=" + masterApplyTop.size() + ", nodesToRebalanceSize=" + nodesToRebalance.size() + ", cutApplyTopSize=" + cutApplyTop.size() + ", failedNodesSize=" + this.failedNodes.size() + ", rebalancingNodesCnt=" + rebalancingNodesCnt + ", bltTopSize=" + blt.size() + ", backupFactor=" + backupFactor + ']');
                        boolean bl = false;
                        return bl;
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Topology for cut " + cutId + " is valid. [aliveNodes=" + F.nodeConsistentIds((Collection)aliveNodes) + ", masterTop=" + masterTop + ", masterApplyTop=" + masterApplyTop + ", nodesToRebalance=" + nodesToRebalance + ", cutApplyTop=" + cutApplyTop + ", failedNodes=" + this.failedNodes + ", rebalancingNodesCnt=" + rebalancingNodesCnt + ", bltTop=" + blt.consistentIds() + ", backupFactor=" + backupFactor + ']');
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Validate cut topology for cut " + cutId + " took " + (System.nanoTime() - startTime) + " nano seconds");
            }
        }
    }

    private int rebalancingNodesCnt(Collection<ClusterNode> aliveNodes, Collection<Object> cutApplyTop) {
        int nodesCnt = 0;
        block0: for (ClusterNode node : aliveNodes) {
            if (!cutApplyTop.contains(node.consistentId())) continue;
            for (CacheGroupContext gctx : this.ctx.cache().cacheGroups()) {
                GridDhtPartitionMap parts = gctx.topology().partitions(node.id());
                if (parts == null || !parts.hasMovingPartitions()) continue;
                ++nodesCnt;
                continue block0;
            }
        }
        return nodesCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNodeLeft(ClusterNode node) {
        if (!this.startPrepared) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            if (F.eq((Object)this.crdNode, (Object)node.id())) {
                this.crdNode = this.txdrProc.getReplicationCoordinatorNodeId();
                this.lastLocReadyCutId = this.txdrProc.localState().lastGloballyAppliedCutId() - 1L;
                this.firstReadyMsgToCrd = true;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Coordinator node has left the cluster, ready cuts list will be resent to new coordinator [leftCrdId=" + node.id() + ", newCrdId=" + this.crdNode + ", sinceCutId=" + this.lastLocReadyCutId + ']');
                }
                if (F.eq((Object)this.ctx.localNodeId(), (Object)this.crdNode)) {
                    this.triggerExchangeOnNextCutAppliedGlobally.set(true);
                }
            }
            if (F.eq((Object)this.ctx.localNodeId(), (Object)this.crdNode)) {
                this.globalReadyNodesCuts.remove(node.consistentId());
                this.failedNodes.remove(node.consistentId());
                long appliedCutId = -1L;
                for (Map.Entry pendingCut : this.globalPendingCuts.entrySet()) {
                    Set pendingNodes = (Set)pendingCut.getValue();
                    if (!pendingNodes.remove(node.consistentId())) continue;
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Node " + node.id() + " (" + node.consistentId() + ") has left while applying cut " + pendingCut.getKey());
                    }
                    if (!pendingNodes.isEmpty()) continue;
                    appliedCutId = (Long)pendingCut.getKey();
                    break;
                }
                if (appliedCutId != -1L) {
                    this.onConsistentCutAppliedGlobally(appliedCutId);
                }
                this.reqQueue.add((IgniteBiTuple<UUID, ConsistentCutReadyMessage>)new IgniteBiTuple((Object)node.id(), null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendReadyCutsIdsToCoordinator() throws IgniteCheckedException {
        ConsistentCutReadyMessage msg;
        UUID crdNode;
        boolean firstMsgToCrd;
        long lastReadyCutId;
        if (!this.startPrepared) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            lastReadyCutId = this.lastLocReadyCutId;
            firstMsgToCrd = this.firstReadyMsgToCrd;
            crdNode = this.crdNode;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Trying to find new local ready consistent cuts [crdNode=" + crdNode + ", lastReadyCutId=" + lastReadyCutId + ']');
        }
        if ((msg = this.createConsistentCutReadyMsg(crdNode, lastReadyCutId, firstMsgToCrd)) != null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Notifying coordinator about locally ready consistent cuts [crdNode=" + crdNode + ", msg=" + msg + ']');
            }
            this.ctx.io().sendToGridTopic(crdNode, GridTopic.TOPIC_TXDR, (Message)msg, (byte)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsistentCutReadyMessage createConsistentCutReadyMsg(UUID crdId, long sinceCutId, boolean firstMsgToCrd) throws IgniteCheckedException {
        Object ptr;
        if (!this.startPrepared) {
            return null;
        }
        List<Long> ccIds = this.cutsStore.list(sinceCutId + 1L);
        Long lastReadyCutId = null;
        long switchCutId = 0L;
        ListIterator<Long> iter = ccIds.listIterator(ccIds.size());
        while (iter.hasPrevious()) {
            Long ccId = iter.previous();
            ConsistentCut cc = this.cutsStore.restore(ccId);
            if (cc.roleSwitch()) {
                switchCutId = cc.id();
            }
            ptr = (FileWALPointer)cc.cutPtr();
            if (!this.walSegmentExists(cc.spawnId(), (FileWALPointer)ptr)) continue;
            lastReadyCutId = ccId;
            break;
        }
        if (lastReadyCutId == null) {
            return null;
        }
        ArrayList<ConsistentCut> readyCuts = new ArrayList<ConsistentCut>(ccIds.size());
        HashMap<Long, byte[]> bltCuts = new HashMap<Long, byte[]>();
        JdkMarshaller jdkMarsh = this.ctx.marshallerContext().jdkMarshaller();
        for (Long ccId : ccIds) {
            if (ccId.compareTo(lastReadyCutId) > 0) continue;
            ConsistentCut cut = this.cutsStore.restore(ccId);
            readyCuts.add(cut);
            BaselineTopology baselineTop = cut.baselineTopology();
            if (baselineTop == null) continue;
            bltCuts.put(cut.id(), jdkMarsh.marshal((Object)baselineTop));
        }
        ptr = this.mux;
        synchronized (ptr) {
            if (F.eq((Object)crdId, (Object)this.crdNode)) {
                this.lastLocReadyCutId = lastReadyCutId;
                this.firstReadyMsgToCrd = false;
            } else if (this.log.isInfoEnabled()) {
                this.log.info("Coordinator was changed [oldCrd=" + crdId + ", newCrd=" + this.crdNode + "] while searching for new local ready consistent cuts");
            }
        }
        ArrayList<Long> readyCutsIds = new ArrayList<Long>(readyCuts.size());
        HashMap<Integer, BinaryMetadata> binaryMetaIds = new HashMap<Integer, BinaryMetadata>();
        ClusterNode crdNode = this.ctx.discovery().node(crdId);
        HashMap<Long, Map<Object, NodeLastEvents>> cutNodesEvts = new HashMap<Long, Map<Object, NodeLastEvents>>();
        for (ConsistentCut consistentCut : readyCuts) {
            NodeLastEvents evt;
            readyCutsIds.add(consistentCut.id());
            Map<Object, NodeLastEvents> nodesEvts = consistentCut.bltNodesLastEvts();
            if (crdNode != null && nodesEvts != null && nodesEvts.containsKey(crdNode.consistentId()) && (evt = nodesEvts.get(crdNode.consistentId())).joinCutId() >= evt.leftCutId()) {
                nodesEvts = null;
            }
            if (nodesEvts != null) {
                cutNodesEvts.put(consistentCut.id(), nodesEvts);
            }
            if (consistentCut.binaryMetadata() == null) continue;
            for (BinaryMetadata metadata : consistentCut.binaryMetadata()) {
                binaryMetaIds.compute(metadata.typeId(), (k, v) -> BinaryUtils.mergeMetadata((BinaryMetadata)v, (BinaryMetadata)metadata));
            }
        }
        ArrayList<byte[]> binaryMarsh = null;
        if (!binaryMetaIds.values().isEmpty()) {
            binaryMarsh = new ArrayList<byte[]>(binaryMetaIds.values().size());
            for (BinaryMetadata metadata : binaryMetaIds.values()) {
                binaryMarsh.add(this.ctx.marshallerContext().jdkMarshaller().marshal((Object)metadata));
            }
        }
        ReplicationSessionDescriptor replicationSessionDescriptor = this.txdrProc.localState();
        return new ConsistentCutReadyMessage(replicationSessionDescriptor.lastSuccessfullyAppliedCutId(), readyCutsIds, binaryMarsh, F.isEmpty(cutNodesEvts) ? null : this.ctx.marshallerContext().jdkMarshaller().marshal(cutNodesEvts), bltCuts, replicationSessionDescriptor.lastSuccessfullyAppliedCutId() < replicationSessionDescriptor.lastGloballyAppliedCutId() && firstMsgToCrd, switchCutId);
    }

    private boolean walSegmentExists(long spawnId, FileWALPointer ptr) {
        String walFileName = FileDescriptor.fileName((long)ptr.index());
        File walDir = this.txdrProc.walDir(spawnId);
        File walFile = new File(walDir, walFileName);
        File walFileCompressed = new File(walDir, walFileName + ".zip");
        return walFile.exists() || walFileCompressed.exists();
    }

    private void proposeBinaryMetadata() throws IgniteCheckedException {
        CacheObjectBinaryProcessorImpl binaryProcessor = (CacheObjectBinaryProcessorImpl)this.ctx.cacheObjects();
        MarshallerContextImpl marshCtx = this.ctx.marshallerContext();
        for (BinaryMetadata meta : this.binaryMetadata.values()) {
            marshCtx.registerClassName((byte)0, meta.typeId(), meta.typeName());
            binaryProcessor.addMeta(meta.typeId(), (BinaryType)meta.wrap(binaryProcessor.binaryContext()), false);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Added proposed binaryMetadata " + this.binaryMetadata.entrySet().stream().map(m -> "[typeId=" + ((BinaryMetadata)m.getValue()).typeId() + ", typeName=" + ((BinaryMetadata)m.getValue()).typeName() + ", schemas=" + ((BinaryMetadata)m.getValue()).schemas().stream().map(BinarySchema::schemaId).collect(Collectors.toList()) + "]").collect(Collectors.joining(", ", "[", "]")));
        }
        this.binaryMetadata.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyNextConsistentCut() throws IgniteCheckedException {
        long limCutId;
        long lastAppliedCutId;
        long crdCutId = this.nextApplyingCutId.get();
        if (crdCutId == -1L && !this.txdrProc.localState().laggingBehind()) {
            this.txdrProc.nodeIsLaggingBehind(true);
        }
        long toBeAppliedCutId = (lastAppliedCutId = this.lastLocAppliedCutId.get()) < (limCutId = this.limitApplyingCutId.get()) && limCutId < crdCutId ? limCutId : crdCutId;
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)this.ctx.cache().context().snapshot();
        if (toBeAppliedCutId > 0L && toBeAppliedCutId > lastAppliedCutId && toBeAppliedCutId <= limCutId) {
            boolean rebalanceNeeded = false;
            try {
                ConsistentCut cut = this.cutsStore.restore(toBeAppliedCutId);
                if (cut.bltNodesLastEvts() != null) {
                    NodeLastEvents evts = cut.bltNodesLastEvts().get(this.ctx.discovery().localNode().consistentId());
                    rebalanceNeeded = evts != null && lastAppliedCutId < evts.joinCutId() && evts.joinCutId() <= toBeAppliedCutId;
                }
            }
            catch (Throwable t) {
                this.sendConsistentCutAppliedMessage(toBeAppliedCutId, false, false);
                this.nextApplyingCutId.compareAndSet(crdCutId, 0L);
                this.txdrProc.nodeIsLaggingBehind(true);
                throw t;
            }
            if (!rebalanceNeeded) {
                List<Long> cutIds = this.cutsStore.list(lastAppliedCutId, toBeAppliedCutId - 1L);
                ArrayList<T2<FileWALPointer, Long>> ptrCuts = new ArrayList<T2<FileWALPointer, Long>>(cutIds.size());
                for (Long id : cutIds) {
                    ptrCuts.add(new T2((Object)((FileWALPointer)this.cutsStore.restore(id).cutPtr()), (Object)id));
                }
                GridDhtPartitionsExchangeFuture fut = this.ctx.cache().context().exchange().lastTopologyFuture();
                if (fut != null) {
                    fut.get();
                }
                try {
                    snapMgr.applyConsistentCut(toBeAppliedCutId, lastAppliedCutId, false, new WALPointerApplyListener(ptrCuts));
                }
                catch (Throwable t) {
                    this.sendConsistentCutAppliedMessage(toBeAppliedCutId, false, false);
                    this.nextApplyingCutId.compareAndSet(crdCutId, 0L);
                    this.txdrProc.nodeIsLaggingBehind(true);
                    throw t;
                }
            } else if (this.log.isInfoEnabled()) {
                this.log.info("Skips local cut applying up to " + toBeAppliedCutId + ", rebalance will be triggered");
            }
            this.sendConsistentCutAppliedMessage(toBeAppliedCutId, rebalanceNeeded, true);
            this.lastLocAppliedCutId.set(toBeAppliedCutId);
            this.txdrProc.lastAppliedConsistentCut(toBeAppliedCutId);
            this.txdrProc.nodeIsLaggingBehind(false);
        }
        Object object = this.mux;
        synchronized (object) {
            GridFutureAdapter<Void> fut = this.suspendFut;
            if (fut != null && !fut.isDone() && (this.lastLocAppliedCutId.get() >= this.limitApplyingCutId.get() || this.txdrProc.localState().laggingBehind())) {
                fut.onDone();
            }
        }
    }

    private void sendConsistentCutAppliedMessage(long cutId, boolean rebalanceNeeded, boolean success) throws IgniteCheckedException {
        block3: {
            try {
                ConsistentCutAppliedMessage msg = new ConsistentCutAppliedMessage(cutId, rebalanceNeeded, success);
                this.ctx.io().sendToGridTopic(this.crdNode, GridTopic.TOPIC_TXDR, (Message)msg, (byte)2);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ConsistentCutAppliedMessage sent successfully [msg=" + msg + ']');
                }
            }
            catch (IgniteCheckedException e) {
                this.log.error("Failed to send applied cut message [cutId=" + cutId + ']', (Throwable)e);
                if (!rebalanceNeeded) break block3;
                throw e;
            }
        }
    }

    private void processGlobalCutsUpdates() throws InterruptedException {
        block24: {
            Long bltCutId;
            BaselineTopology baselineTop;
            block23: {
                IgniteBiTuple tup;
                IgniteBiTuple igniteBiTuple = tup = this.needGc ? (IgniteBiTuple)this.reqQueue.poll() : this.reqQueue.poll(CONSISTENT_CUTS_CHECK_FREQ, TimeUnit.MILLISECONDS);
                while (tup != null) {
                    UUID nodeId = (UUID)tup.get1();
                    ConsistentCutReadyMessage msg = (ConsistentCutReadyMessage)tup.get2();
                    if (nodeId != null) {
                        this.onConsistentCutReady(nodeId, msg);
                    }
                    tup = (IgniteBiTuple)this.reqQueue.poll();
                }
                if (this.debugMode() == DebugMode.NONE || !this.checkApplyingCutsDebugPauseNeeded()) break block23;
                switch (this.txdrProc.getTxDrStatus().state()) {
                    case RUNNING: {
                        U.warn((IgniteLogger)this.log, (Object)"Replication debug pausing now!");
                        try {
                            if (this.crdNode.equals(this.ctx.discovery().localNode().id())) {
                                this.txdrProc.pause();
                            }
                        }
                        catch (IllegalStateException e) {
                            U.warn((IgniteLogger)this.log, (Object)"Replication pausing failed", (Throwable)e);
                            break;
                        }
                    }
                    case PAUSED: {
                        this.applyingCutsDebugPauseNeeded = false;
                    }
                }
                break block24;
            }
            SortedSet<Long> globalReadyCutsIds = this.findGlobalReadyCutsIds(this.debugMode() == DebugMode.NONE ? this.globalApplyingCutId.get() : 0L);
            if (globalReadyCutsIds.isEmpty()) {
                return;
            }
            if (globalReadyCutsIds.size() == 1 && (baselineTop = this.crdBltCuts.get(bltCutId = globalReadyCutsIds.first())) != null) {
                if (!this.globalPendingCuts.isEmpty()) {
                    return;
                }
                BaselineTopology curBaselineTop = this.ctx.state().clusterState().baselineTopology();
                assert (curBaselineTop != null) : "Current baseline topology is null on REPLICA cluster";
                if (this.crdBltCuts.containsKey(bltCutId) && this.changeBaselineTopology(baselineTop, bltCutId)) {
                    this.crdBltCuts.remove(bltCutId);
                    long startWithCutId = this.debugMode() == DebugMode.NONE ? this.globalApplyingCutId.get() : 0L;
                    globalReadyCutsIds = this.findGlobalReadyCutsIds(startWithCutId);
                    if (globalReadyCutsIds.isEmpty()) {
                        return;
                    }
                } else {
                    return;
                }
            }
            if (this.lastGlobalReadyCutId.setIfGreater(globalReadyCutsIds.last().longValue()) && this.log.isInfoEnabled()) {
                this.log.info("New consistent cut is ready globally: " + this.lastGlobalReadyCutId.get());
            }
            long globalReadyCutId = 0L;
            if (this.debugMode() == DebugMode.NONE) {
                globalReadyCutId = this.lastGlobalReadyCutId.get();
            } else {
                long firstGlobalReadyCutId = globalReadyCutsIds.first();
                Set applyingCutNodes = (Set)this.globalPendingCuts.get(this.globalApplyingCutId.get());
                if ((applyingCutNodes == null || applyingCutNodes.isEmpty()) && firstGlobalReadyCutId <= this.limitApplyingCutId.get() && this.debugAppliedCutId == 0L && this.debugPauseTriggered) {
                    globalReadyCutId = firstGlobalReadyCutId;
                }
            }
            if (this.globalApplyingCutId.setIfGreater(globalReadyCutId) || globalReadyCutId > 0L && globalReadyCutId == this.roleSwitchCutId) {
                if (this.log.isInfoEnabled() && this.debugMode() != DebugMode.NONE) {
                    this.log.info("Next global ready consistent cut will be applied: " + globalReadyCutId);
                }
                this.debugPauseTriggered = false;
                for (IgniteInClosure<Long> lsnr : this.readyCutsLsnrs) {
                    lsnr.apply((Object)globalReadyCutId);
                }
            }
        }
    }

    private void stopReplicationIfNecessary() {
        if (this.possibleDataLost) {
            if (!F.isEmpty(this.globalPendingCuts)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Can't stop replication, cuts pending to be applied: " + this.globalPendingCuts.keySet());
                }
                return;
            }
            SortedSet<Long> globalReadyCutsIds = this.findGlobalReadyCutsIds(0L);
            if (!F.isEmpty(globalReadyCutsIds)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Can't stop replication, not applied ready cuts: " + globalReadyCutsIds);
                }
                return;
            }
            if (this.limitApplyingCutId.get() != Long.MAX_VALUE) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Can't stop replication, replication is already stopping or in the PAUSE state, limitApplyingCutId=" + this.limitApplyingCutId.get());
                }
                return;
            }
            if (this.stoppingReplication.compareAndSet(false, true)) {
                this.log.warning("None of ready consistent cuts can be applied without data lost. Stopping replication.");
                try {
                    IgniteFuture<Void> stopFut = this.txdrProc.stop();
                    stopFut.listen((IgniteInClosure & Serializable)fut -> this.stoppingReplication.set(false));
                }
                catch (Exception e) {
                    this.txdrProc.essentialLogger().error("Failed to stop replication", (Throwable)e);
                    this.stoppingReplication.set(false);
                }
            }
        }
    }

    private boolean checkApplyingCutsDebugPauseNeeded() {
        if (this.applyingCutsDebugPauseNeeded) {
            return true;
        }
        long cutId = this.debugAppliedCutId;
        if (cutId == 0L || cutId < this.globalApplyingCutId.get()) {
            return false;
        }
        this.debugAppliedCutId = 0L;
        this.debugPauseTriggered = true;
        switch (this.debugMode()) {
            case PAUSE_ON_FAILURE: {
                Set caches = this.ctx.cache().cacheDescriptors().values().stream().filter(arg_0 -> TransactionalDrProcessorImpl.PUBLIC_PERSISTENT_CACHE_FILTER.apply(arg_0)).map(DynamicCacheDescriptor::cacheName).collect(Collectors.toSet());
                IdleVerifyResultV2 verifyRes = (IdleVerifyResultV2)this.ctx.grid().compute().execute(VisorIdleVerifyTaskV2.class.getName(), (Object)new VisorTaskArgument(this.crdNode, (Object)new VisorIdleVerifyTaskArg(caches), false));
                if (!verifyRes.hasConflicts()) break;
                StringBuilder builder = new StringBuilder().append("Applying of ConsistentCut[id=").append(cutId).append("] causes conflicts:\n");
                verifyRes.print(builder::append);
                U.warn((IgniteLogger)this.log, (Object)builder);
            }
            case PAUSE_ON_EVERY_CUT: {
                this.limitApplyingCutId.setIfLess(cutId);
                this.applyingCutsDebugPauseNeeded = true;
                return true;
            }
        }
        return false;
    }

    private DebugMode debugMode() {
        return Objects.requireNonNull(this.txdrProc.debugMode());
    }

    private class WALPointerApplyListener
    implements IgniteInClosure<WALPointer> {
        private static final long serialVersionUID = 0L;
        private final List<T2<FileWALPointer, Long>> ptrCuts;
        private long lastUpdatedIdx = Long.MIN_VALUE;

        public WALPointerApplyListener(List<T2<FileWALPointer, Long>> ptrCuts) {
            this.ptrCuts = ptrCuts;
        }

        public void apply(WALPointer p) {
            if (!(p instanceof FileWALPointer)) {
                return;
            }
            FileWALPointer ptr = (FileWALPointer)p;
            if (ptr.index() <= this.lastUpdatedIdx) {
                return;
            }
            this.lastUpdatedIdx = ptr.index();
            int i = Collections.binarySearch(this.ptrCuts, new T2((Object)ptr, null), Comparator.comparing(IgniteBiTuple::get1));
            if (i == -1) {
                return;
            }
            if (i < 0) {
                i = -(i + 2);
            }
            Long appliedCutId = (Long)this.ptrCuts.get(i).get2();
            if (ConsistentCutWatcher.this.lastLocAppliedCutId.get() < appliedCutId) {
                ConsistentCutWatcher.this.lastLocAppliedCutId.set(appliedCutId);
                ConsistentCutWatcher.this.txdrProc.lastAppliedConsistentCut(appliedCutId);
            }
        }
    }

    private class ConsistentCutWatcherWorker
    extends GridWorker {
        ConsistentCutWatcherWorker() {
            super(ConsistentCutWatcher.this.ctx.igniteInstanceName(), ConsistentCutWatcher.THREAD_NAME_PREFIX, ConsistentCutWatcher.this.log);
        }

        protected void body() throws InterruptedException {
            Throwable err = null;
            try {
                while (!this.isCancelled()) {
                    block17: {
                        try {
                            ConsistentCutWatcher.this.sendReadyCutsIdsToCoordinator();
                        }
                        catch (IgniteCheckedException e) {
                            U.error((IgniteLogger)this.log, (Object)"Failed to send ready consistent cuts to coordinator.", (Throwable)e);
                        }
                        try {
                            ConsistentCutWatcher.this.applyNextConsistentCut();
                        }
                        catch (Error | IgniteCheckedException e) {
                            U.error((IgniteLogger)this.log, (Object)"Failed to apply consistent cut locally.", (Throwable)e);
                            ConsistentCutWatcher.this.txdrProc.printPartitionStates(true);
                            if (!(e instanceof Error)) break block17;
                            throw (Error)e;
                        }
                    }
                    ConsistentCutWatcher.this.processGlobalCutsUpdates();
                    if (F.eq((Object)ConsistentCutWatcher.this.crdNode, (Object)ConsistentCutWatcher.this.ctx.localNodeId())) {
                        ConsistentCutWatcher.this.stopReplicationIfNecessary();
                        ConsistentCutWatcher.this.warnGlobalInactivityIfNecessary();
                    }
                    if (CONSISTENT_CUT_GC_DISABLED.booleanValue()) continue;
                    ConsistentCutWatcher.this.needGc = ConsistentCutWatcher.this.txdrProc.gc().perform();
                }
            }
            catch (Throwable t) {
                if ((t instanceof InterruptedException || t instanceof IgniteInterruptedException) && this.isCancelled()) {
                    throw t;
                }
                err = t;
            }
            finally {
                if (err == null && !this.isCancelled()) {
                    err = new IllegalStateException("Worker " + this.name() + " is terminated unexpectedly.");
                }
                if (err != null) {
                    ConsistentCutWatcher.this.txdrProc.essentialLogger().error("Worker " + this.name() + " is terminated unexpectedly.", err);
                }
                if (err instanceof OutOfMemoryError) {
                    ConsistentCutWatcher.this.ctx.failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                } else if (err != null) {
                    ConsistentCutWatcher.this.ctx.failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
                }
            }
        }
    }

    private static class CutReadinessStatus {
        final int nodeCnt;
        final long lastReadyCheckTs;
        final long timeout;

        CutReadinessStatus(int nodeCnt, long timeout) {
            this.nodeCnt = nodeCnt;
            this.lastReadyCheckTs = U.currentTimeMillis();
            this.timeout = timeout <= 0L ? Long.MAX_VALUE : timeout;
        }
    }
}

