/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CacheSnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.jetbrains.annotations.Nullable;

public class SnapshotCopySinglePartitionCopyWorkGenerator {
    private final long maxWorkBatchSize = IgniteSystemProperties.getLong((String)"GG_SNAPSHOT_COPY_MAX_WORK_BATCH_SIZE", (long)Integer.MAX_VALUE);
    private final IgniteLogger log;
    private volatile SnapshotMetadataV2 meta;
    private final int pageSize;
    private final int minimumAmountOfWork;
    private final Map<Long, String> finishedWorkOnCluster = new ConcurrentHashMap<Long, String>();
    private final Map<String, NavigableMap<Integer, Map<Long, Integer>>> notAssignedWork = new HashMap<String, NavigableMap<Integer, Map<Long, Integer>>>();
    private final Map<Long, T2<String, Integer>> workInProgressOnCluster = new HashMap<Long, T2<String, Integer>>();
    private final Set<String> receivedUpdates = new GridConcurrentHashSet();
    private final Set<String> failedNodes = new GridConcurrentHashSet();
    private final GridFutureAdapter<Void> updatesFromAllNodesReceived = new GridFutureAdapter();
    private final AtomicInteger totalCountOfPartitionsToCopy = new AtomicInteger();

    public SnapshotCopySinglePartitionCopyWorkGenerator(int minimumAmountOfWork, int pageSize, IgniteLogger log) {
        this.pageSize = pageSize;
        this.minimumAmountOfWork = minimumAmountOfWork;
        this.log = log;
    }

    public int totalCountOfPartitionsToCopy() {
        return this.totalCountOfPartitionsToCopy.get();
    }

    public int finishedCountOfPartitionsToCopy() {
        return this.finishedWorkOnCluster.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(SnapshotMetadataV2 meta) {
        assert (this.meta == null);
        int totalPartCnt = 0;
        Map<String, NavigableMap<Integer, Map<Long, Integer>>> map = this.notAssignedWork;
        synchronized (map) {
            for (Map.Entry e : meta.cacheGroupsMetadata().entrySet()) {
                int grpId = (Integer)e.getKey();
                CacheSnapshotMetadata cacheMeta = (CacheSnapshotMetadata)e.getValue();
                for (Map.Entry e0 : cacheMeta.partitionSizesPerNode().entrySet()) {
                    Integer sizeInPages;
                    Map map2 = (Map)e0.getValue();
                    if (map2.isEmpty() || (sizeInPages = (Integer)map2.values().iterator().next()) <= 0) continue;
                    int priority = map2.size();
                    long uniquePartId = SnapshotUtils.uniquePartId(grpId, (Integer)e0.getKey());
                    boolean added = false;
                    for (Map.Entry cIdAndSize : map2.entrySet()) {
                        String key = (String)cIdAndSize.getKey();
                        if (this.failedNodes.contains(key)) continue;
                        added = true;
                        NavigableMap workForCId = this.notAssignedWork.computeIfAbsent(key, k -> new TreeMap());
                        Map workWithPriority = workForCId.computeIfAbsent(priority, k -> new HashMap());
                        if (this.finishedWorkOnCluster.containsKey(uniquePartId)) break;
                        workWithPriority.put(uniquePartId, cIdAndSize.getValue());
                    }
                    if (!added) continue;
                    ++totalPartCnt;
                }
            }
        }
        this.totalCountOfPartitionsToCopy.set(totalPartCnt);
        this.meta = meta;
        this.checkThatAllNodesSentFirstAssignments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, GridLongList> onNodeFailed(String maskedCId) throws IgniteCheckedException {
        Map<String, NavigableMap<Integer, Map<Long, Integer>>> map = this.notAssignedWork;
        synchronized (map) {
            Map<Long, T2<String, Integer>> map2 = this.workInProgressOnCluster;
            synchronized (map2) {
                this.failedNodes.add(maskedCId);
                HashSet<Long> workInProgressOfFailedNode = new HashSet<Long>();
                Iterator<Map.Entry<Long, T2<String, Integer>>> iter = this.workInProgressOnCluster.entrySet().iterator();
                HashSet<String> nodesWithWorkInProgress = new HashSet<String>();
                while (iter.hasNext()) {
                    Map.Entry<Long, T2<String, Integer>> entry = iter.next();
                    if (((String)entry.getValue().get1()).equals(maskedCId)) {
                        workInProgressOfFailedNode.add(entry.getKey());
                        iter.remove();
                        continue;
                    }
                    nodesWithWorkInProgress.add((String)entry.getValue().get1());
                }
                NavigableMap<Integer, Map<Long, Integer>> notAssigned = this.notAssignedWork.remove(maskedCId);
                if (notAssigned == null) {
                    return null;
                }
                this.checkThatAllNodesSentFirstAssignments();
                SnapshotMetadataV2 meta = this.meta;
                for (Map potentialWork : notAssigned.values()) {
                    Iterator iterator = potentialWork.keySet().iterator();
                    while (iterator.hasNext()) {
                        long uniqId = (Long)iterator.next();
                        int grpId = SnapshotUtils.grpId(uniqId);
                        int partId = SnapshotUtils.partId(uniqId);
                        Set<String> owners = this.getPartitionOwners(meta, grpId, partId);
                        if (workInProgressOfFailedNode.contains(uniqId) || this.finishedWorkOnCluster.containsKey(uniqId) || this.ownersAmongActiveNodes(null, owners)) continue;
                        this.onPartitionLost(meta, maskedCId, grpId, partId);
                    }
                }
                HashMap<String, GridLongList> assignment = new HashMap<String, GridLongList>();
                Iterator iterator = workInProgressOfFailedNode.iterator();
                while (iterator.hasNext()) {
                    int partId;
                    long uniqId = (Long)iterator.next();
                    int grpId = SnapshotUtils.grpId(uniqId);
                    Set<String> owners = this.getPartitionOwners(meta, grpId, partId = SnapshotUtils.partId(uniqId));
                    if (this.ownersAmongActiveNodes(nodesWithWorkInProgress, owners)) continue;
                    boolean assigned = false;
                    ArrayList<String> maskedCIds = new ArrayList<String>(owners);
                    Collections.shuffle(maskedCIds);
                    for (String id : maskedCIds) {
                        if (!this.notAssignedWork.containsKey(id)) continue;
                        assigned = true;
                        assignment.computeIfAbsent(id, x -> new GridLongList()).add(uniqId);
                        T2<String, Integer> oldValue = this.workInProgressOnCluster.put(uniqId, (T2<String, Integer>)new T2((Object)id, (Object)this.getPartitionSize(id, meta.cacheGroupsMetadata(), uniqId)));
                        assert (oldValue == null);
                        break;
                    }
                    if (assigned) continue;
                    this.onPartitionLost(meta, maskedCId, grpId, partId);
                }
                return assignment;
            }
        }
    }

    private void onPartitionLost(SnapshotMetadataV2 meta, String leftNodeCId, int grpId, int partId) {
        this.totalCountOfPartitionsToCopy.decrementAndGet();
        assert (!this.finishedWorkOnCluster.containsKey(SnapshotUtils.uniquePartId(grpId, partId)));
        U.warn((IgniteLogger)this.log, (Object)("Partition (grpId=" + grpId + ", partId=" + partId + ") wouldn't be copied during snapshot COPY operation, because next node failed consistentId=" + leftNodeCId + ", gprOrCacheName=" + ((CacheSnapshotMetadata)meta.cacheGroupsMetadata().get(grpId)).cacheOrGroupName()));
    }

    private boolean ownersAmongActiveNodes(@Nullable Set<String> stillActiveNodes, Set<String> owners) {
        for (String id : owners) {
            if (!(stillActiveNodes == null ? !this.failedNodes.contains(id) : stillActiveNodes.contains(id))) continue;
            return true;
        }
        return false;
    }

    private Set<String> getPartitionOwners(SnapshotMetadataV2 meta, int grpId, int partId) {
        CacheSnapshotMetadata metadata = (CacheSnapshotMetadata)meta.cacheGroupsMetadata().get(grpId);
        return ((Map)metadata.partitionSizesPerNode().get(partId)).keySet();
    }

    public IgniteInternalFuture<Void> updatesFromAllNodesReceived() {
        return this.updatesFromAllNodesReceived;
    }

    public boolean workIsDone() {
        if (this.meta == null) {
            return false;
        }
        int finishedWorkOnCluster = this.finishedWorkOnCluster.size();
        int totalCount = this.totalCountOfPartitionsToCopy.get();
        assert (totalCount >= finishedWorkOnCluster) : "totalCount=" + this.totalCountOfPartitionsToCopy.get() + ", finishedWorkOnCluster=" + finishedWorkOnCluster + ", workInProgressOnCluster=" + this.workInProgressOnCluster;
        return finishedWorkOnCluster == totalCount;
    }

    public Set<Long> finishedWork() {
        return new HashSet<Long>(this.finishedWorkOnCluster.keySet());
    }

    Map<Long, String> getFinishedWorkOnCluster() {
        return new HashMap<Long, String>(this.finishedWorkOnCluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkThatAllNodesSentFirstAssignments() {
        if (this.updatesFromAllNodesReceived.isDone()) {
            return true;
        }
        Map<String, NavigableMap<Integer, Map<Long, Integer>>> map = this.notAssignedWork;
        synchronized (map) {
            if (this.meta != null && this.receivedUpdates.containsAll(this.notAssignedWork.keySet())) {
                this.updatesFromAllNodesReceived.onDone();
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, long[]> generateInitialWorkForCluster() {
        if (this.meta == null) {
            throw new IllegalStateException("Calling generateInitialWorkForCluster before WorkGenerator initialization.");
        }
        HashMap<String, long[]> map = new HashMap<String, long[]>();
        Map<String, NavigableMap<Integer, Map<Long, Integer>>> map2 = this.notAssignedWork;
        synchronized (map2) {
            Map<Long, T2<String, Integer>> map3 = this.workInProgressOnCluster;
            synchronized (map3) {
                for (Map.Entry<String, NavigableMap<Integer, Map<Long, Integer>>> entry : this.notAssignedWork.entrySet()) {
                    String maskedCId = entry.getKey();
                    NavigableMap<Integer, Map<Long, Integer>> value = entry.getValue();
                    long[] partitions = this.assignWork(maskedCId, value, null).array();
                    long[] put = map.put(maskedCId, partitions);
                    assert (put == null);
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridLongList assignWork(String maskedCId, NavigableMap<Integer, Map<Long, Integer>> workWithPriorities, long[] workInProgress) {
        long size = 0L;
        GridLongList partitions = new GridLongList();
        if (workInProgress != null) {
            for (long uniquePartId : workInProgress) {
                int sizeInPages;
                T2<String, Integer> cIdAndSize = this.workInProgressOnCluster.get(uniquePartId);
                assert (cIdAndSize != null && ((String)cIdAndSize.get1()).equals(maskedCId)) : "cIdAndSize=" + cIdAndSize + ", cId=" + maskedCId + ", uniquePartId=" + uniquePartId + ", grpId=" + SnapshotUtils.grpId(uniquePartId) + ", partId=" + SnapshotUtils.partId(uniquePartId);
                if (cIdAndSize.get2() == null) {
                    Integer sizeInPages0 = (Integer)((Map)((CacheSnapshotMetadata)this.meta.cacheGroupsMetadata().get(SnapshotUtils.grpId(uniquePartId))).partitionSizesPerNode().get(SnapshotUtils.partId(uniquePartId))).get(maskedCId);
                    assert (sizeInPages0 != null) : "sizeInPages=" + sizeInPages0 + ", maskedCId=" + maskedCId + ", uniquePartId=" + uniquePartId + ", grpId=" + SnapshotUtils.grpId(uniquePartId) + ", partId=" + SnapshotUtils.partId(uniquePartId);
                    sizeInPages = sizeInPages0;
                } else {
                    sizeInPages = (Integer)cIdAndSize.get2();
                }
                size += (long)(sizeInPages * this.pageSize / 2);
            }
        }
        Iterator entries = workWithPriorities.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry withPriority = entries.next();
            Map partitionWithSize = (Map)withPriority.getValue();
            Iterator iter = partitionWithSize.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry next = iter.next();
                int partSize = (Integer)next.getValue();
                size += (long)(partSize * this.pageSize);
                long uniquePartition = (Long)next.getKey();
                if (this.finishedWorkOnCluster.containsKey(uniquePartition)) {
                    iter.remove();
                    continue;
                }
                Map<Long, T2<String, Integer>> map = this.workInProgressOnCluster;
                synchronized (map) {
                    if (this.failedNodes.contains(maskedCId)) {
                        return new GridLongList();
                    }
                    T2<String, Integer> old = this.workInProgressOnCluster.putIfAbsent(uniquePartition, (T2<String, Integer>)new T2((Object)maskedCId, (Object)partSize));
                    if (old != null) {
                        continue;
                    }
                    if (this.finishedWorkOnCluster.containsKey(uniquePartition)) {
                        this.workInProgressOnCluster.remove(uniquePartition);
                        iter.remove();
                        continue;
                    }
                }
                iter.remove();
                partitions.add(uniquePartition);
                if (size < this.maxWorkBatchSize || partitions.size() < this.minimumAmountOfWork) continue;
                break;
            }
            if (!partitionWithSize.isEmpty()) continue;
            entries.remove();
        }
        return partitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] updateAndTryAssignWork(String maskedCId, long[] workInProgress, long[] finishedWork) throws IgniteCheckedException {
        Map<Long, T2<String, Integer>> map = this.workInProgressOnCluster;
        synchronized (map) {
            for (long uniquePartId : finishedWork) {
                this.workInProgressOnCluster.remove(uniquePartId);
                String previous = this.finishedWorkOnCluster.put(uniquePartId, maskedCId);
                if (previous == null || previous.equals(maskedCId)) continue;
                throw new IgniteCheckedException("Partition was copied twice by different nodes.");
            }
        }
        Map groupsMetadata = this.meta == null ? null : this.meta.cacheGroupsMetadata();
        Map<Long, T2<String, Integer>> map2 = this.workInProgressOnCluster;
        synchronized (map2) {
            if (this.failedNodes.contains(maskedCId)) {
                return GridLongList.EMPTY_ARRAY;
            }
            for (long uniquePartId : workInProgress) {
                int grpId = SnapshotUtils.grpId(uniquePartId);
                Integer partSize = this.getPartitionSize(maskedCId, groupsMetadata, uniquePartId);
                T2<String, Integer> oldVal = this.workInProgressOnCluster.putIfAbsent(uniquePartId, (T2<String, Integer>)new T2((Object)maskedCId, (Object)partSize));
                if (oldVal != null && !((String)oldVal.get1()).equals(maskedCId)) {
                    throw new IgniteCheckedException("Received work in progress for partition which already was taken by another node! Old node = " + (String)oldVal.get1() + ", new node = " + maskedCId + ", partId=" + SnapshotUtils.partId(uniquePartId) + ", grpId=" + grpId + ", initialAssignment? " + !this.updatesFromAllNodesReceived.isDone() + ", workInProgressOnCluster=" + this.workInProgressOnCluster);
                }
                if (!this.finishedWorkOnCluster.containsKey(uniquePartId)) continue;
                throw new IgniteCheckedException("Reported work in progress which was already done: finished work node -" + this.finishedWorkOnCluster.get(uniquePartId) + ", problem node=" + maskedCId + ", partId=" + SnapshotUtils.partId(uniquePartId) + ", grpId=" + grpId + ", initialAssignment? " + !this.updatesFromAllNodesReceived.isDone() + ", workInProgressOnCluster=" + this.workInProgressOnCluster);
            }
        }
        this.receivedUpdates.add(maskedCId);
        if (this.checkThatAllNodesSentFirstAssignments()) {
            return this.assignWork(maskedCId, workInProgress).array();
        }
        return null;
    }

    @Nullable
    private Integer getPartitionSize(String maskedCId, Map<Integer, CacheSnapshotMetadata> groupsMetadata, long uniquePartId) {
        Integer size = null;
        if (groupsMetadata != null) {
            CacheSnapshotMetadata groupMetadata = groupsMetadata.get(SnapshotUtils.grpId(uniquePartId));
            size = (Integer)((Map)groupMetadata.partitionSizesPerNode().get(SnapshotUtils.partId(uniquePartId))).get(maskedCId);
        }
        return size;
    }

    private GridLongList assignWork(String maskedCId, long[] workInProgress) {
        return this.assignWork(maskedCId, this.notAssignedWork.get(maskedCId), workInProgress);
    }

    public GridLongList generateInitialWorkLocally(SnapshotMetadataV2 metadata, ClusterNode localNodeInMeta, GridCacheSharedContext cctx) throws IgniteCheckedException {
        TreeMap<Integer, List> cfgsWithBackupFactor = new TreeMap<Integer, List>();
        for (CacheSnapshotMetadata snapshotMetadata : metadata.cacheGroupsMetadata().values()) {
            CacheConfiguration firstCfg = (CacheConfiguration)snapshotMetadata.cacheConfigurations().iterator().next();
            int backupFactor = firstCfg.getCacheMode() == CacheMode.REPLICATED ? Integer.MAX_VALUE : firstCfg.getBackups();
            cfgsWithBackupFactor.computeIfAbsent(backupFactor, x -> new ArrayList()).add(snapshotMetadata);
        }
        GridLongList workInProgress = new GridLongList();
        long size = 0L;
        block1: for (Map.Entry e : cfgsWithBackupFactor.entrySet()) {
            List cfgs = (List)e.getValue();
            for (CacheSnapshotMetadata cacheMeta : cfgs) {
                CacheConfiguration cfg = (CacheConfiguration)cacheMeta.cacheConfigurations().iterator().next();
                if (!CU.affinityNode((ClusterNode)localNodeInMeta, (IgnitePredicate)cfg.getNodeFilter())) continue;
                List view = metadata.baselineTopology().createBaselineView(Collections.emptyList(), cfg.getNodeFilter());
                List<List<ClusterNode>> assignment = SnapshotUtils.calcAffinityAssignment(cctx.kernalContext().resource(), view, cfg, metadata.topologyVersion());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Cluster for calculating partition assigmnent for grpId=" + cacheMeta.groupId() + ": " + view);
                }
                for (int partId = 0; partId < assignment.size(); ++partId) {
                    Map map;
                    Integer sizeInPage;
                    List<ClusterNode> nodes = assignment.get(partId);
                    if (nodes == null || nodes.isEmpty() || !nodes.get(0).consistentId().equals(localNodeInMeta.consistentId()) || (sizeInPage = (Integer)(map = (Map)cacheMeta.partitionSizesPerNode().get(partId)).get(U.maskForFileName((CharSequence)localNodeInMeta.consistentId().toString()))) == null) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Local node is primary for partId=" + partId + ", grpId=" + cacheMeta.groupId());
                    }
                    if (sizeInPage <= 0) continue;
                    workInProgress.add(SnapshotUtils.uniquePartId(cacheMeta.groupId(), partId));
                    if ((size += (long)(sizeInPage * metadata.pageSize())) >= this.maxWorkBatchSize && workInProgress.size() >= this.minimumAmountOfWork) break block1;
                }
            }
        }
        return workInProgress;
    }

    public SnapshotMetadataV2 getUpdatedMetadata() {
        SnapshotMetadataV2 metadata = this.meta;
        if (metadata == null) {
            throw new IllegalStateException("Calling createMetadataBefore before WorkGenerator initialization.");
        }
        if (!this.workIsDone()) {
            throw new IllegalStateException("Calling createMetadataBefore before work is finished.");
        }
        HashMap<Integer, CacheSnapshotMetadata> updated = new HashMap<Integer, CacheSnapshotMetadata>();
        long snapshotSize = 0L;
        for (CacheSnapshotMetadata meta : metadata.cacheGroupsMetadata().values()) {
            Map partSizesPerNode = meta.partitionSizesPerNode();
            HashMap<Integer, Map> newPartSizes = new HashMap<Integer, Map>();
            HashMap<String, Long> prevSnapshotIds = new HashMap<String, Long>();
            for (Map.Entry e : partSizesPerNode.entrySet()) {
                Map consistentIdToPageCntMapping = (Map)e.getValue();
                Integer partId = (Integer)e.getKey();
                long uniquePartId = SnapshotUtils.uniquePartId(meta.groupId(), partId);
                String maskedCId = this.finishedWorkOnCluster.get(uniquePartId);
                if (maskedCId == null) {
                    if (!this.failedNodes.isEmpty() && this.failedNodes.containsAll(consistentIdToPageCntMapping.keySet())) continue;
                    assert ((Integer)consistentIdToPageCntMapping.values().iterator().next() == 0);
                    newPartSizes.put(partId, consistentIdToPageCntMapping);
                    continue;
                }
                Long prevSnapshotId = meta.previousSnapshotId(maskedCId);
                if (prevSnapshotId != null) {
                    Long cachedPrevSnapshotId = (Long)prevSnapshotIds.get(maskedCId);
                    assert (cachedPrevSnapshotId == null || Objects.equals(cachedPrevSnapshotId, prevSnapshotId)) : S.toString((String)"Same consistent id should map to the same previous snapshot for all its partitions inside of the given cache group.", (String)"groupId", (Object)meta.groupId(), (boolean)false, (String)"partId", (Object)partId, (boolean)false, (String)"maskedConsistentId", (Object)maskedCId, (boolean)false, (String)"prevSnapshotId", (Object)prevSnapshotId, (boolean)false, (String)"cachedPrevSnapshotId", (Object)cachedPrevSnapshotId, (boolean)false);
                } else {
                    prevSnapshotIds.put(maskedCId, prevSnapshotId);
                }
                HashMap<String, Integer> newCidWithSizes = new HashMap<String, Integer>();
                for (Map.Entry entry : consistentIdToPageCntMapping.entrySet()) {
                    if (((String)entry.getKey()).equals(maskedCId)) {
                        Integer size = (Integer)entry.getValue();
                        snapshotSize += (long)size.intValue();
                        newCidWithSizes.put(maskedCId, size);
                        continue;
                    }
                    newCidWithSizes.put((String)entry.getKey(), -1);
                }
                newPartSizes.put(partId, newCidWithSizes);
            }
            Map partCounters = meta.partitionCounters();
            updated.put(meta.groupId(), new CacheSnapshotMetadata(meta.storedCacheDataList(), meta.groupId(), meta.cacheOrGroupName(), prevSnapshotIds, newPartSizes, (Map)(partCounters == null ? null : new HashMap(partCounters))));
        }
        Map<String, Long> pages = Collections.singletonMap("<MERGED>", snapshotSize);
        return new SnapshotMetadataV2(metadata.id(), metadata.initiatorNodeId(), metadata.pageSize(), metadata.typeMap(), metadata.binaryMetadataMap(), metadata.fullSnapshot(), metadata.forceFullSnapshot(), metadata.topologyVersion(), metadata.topology(), updated, pages, pages, metadata.pointInTimeRecoveryEnabled(), metadata.walPoints(), metadata.baselineTopology(), metadata.message(), metadata.compressionOption(), metadata.compressionLevel(), true, metadata.exchangelessSnapshot(), metadata.encryptionOptions(), metadata.consistentCutMetas());
    }
}

