/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.SupportFeaturesUtils;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedEnumProperty;
import org.apache.ignite.internal.processors.configuration.distributed.SimpleDistributedProperty;
import org.apache.ignite.internal.processors.metastorage.ReadableDistributedMetaStorage;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteInClosure;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDigestException;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;

public class DistributedSnapshotSecurityLevel {
    private static final DateTimeFormatter FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH:mm:ss.SSS", Locale.US).withZone(ZoneId.systemDefault());
    private static final String SECURITY_LEVEL_DISTRIBUTED_PROPERTY_NAME = "snapshotSecurityLevel";
    private final GridKernalContext ctx;
    private final SnapshotSecurityLevel initLevel;
    private final DistributedChangeableProperty<SnapshotSecurityLevel> securityLevel = new SimpleDistributedProperty("snapshotSecurityLevel", DistributedEnumProperty.parseEnum(SnapshotSecurityLevel.class));
    private final IgniteLogger log;

    public DistributedSnapshotSecurityLevel(GridKernalContext ctx) {
        this.ctx = ctx;
        this.log = ctx.log(this.getClass());
        this.initLevel = this.resolveInitialSecurityLevel();
        if (SupportFeaturesUtils.isFeatureEnabled((String)"GG_SNAPSHOT_SECURITY_FEATURE")) {
            ctx.internalSubscriptionProcessor().registerDistributedConfigurationListener(dispatcher -> {
                this.securityLevel.addListener((name, oldVal, newVal) -> this.writeToAuditLog("Security level state was updated [oldVal=" + oldVal + ", newVal=" + newVal + "]"));
                dispatcher.registerProperty(this.securityLevel);
            });
        }
    }

    public void onActivate(GridKernalContext ctx) {
        if (this.initLevel.compareTo((Enum)SnapshotSecurityLevel.DISABLED) > 0 && this.securityLevel.get() == null && IgniteUtils.isLocalNodeCoordinator((GridDiscoveryManager)ctx.discovery()) && ReadableDistributedMetaStorage.isSupported((GridKernalContext)ctx) && SupportFeaturesUtils.isFeatureEnabled((String)"GG_SNAPSHOT_SECURITY_FEATURE")) {
            this.migrate();
        }
    }

    public void onNodeLeft(ClusterNode node) {
        if (this.initLevel.compareTo((Enum)SnapshotSecurityLevel.DISABLED) > 0 && this.securityLevel.get() == null && IgniteUtils.isLocalNodeCoordinator((GridDiscoveryManager)this.ctx.discovery()) && this.ctx.state().clusterState().active() && this.ctx.state().isBaselineAutoAdjustEnabled() && !IgniteFeatures.nodeSupports((GridKernalContext)this.ctx, (ClusterNode)node, (IgniteFeatures)IgniteFeatures.DISTRIBUTED_METASTORAGE) && ReadableDistributedMetaStorage.isSupported((GridKernalContext)this.ctx) && SupportFeaturesUtils.isFeatureEnabled((String)"GG_SNAPSHOT_SECURITY_FEATURE")) {
            this.migrate();
        }
    }

    public SnapshotSecurityLevel get() {
        if (!SupportFeaturesUtils.isFeatureEnabled((String)"GG_SNAPSHOT_SECURITY_FEATURE")) {
            return this.initLevel;
        }
        return (SnapshotSecurityLevel)this.securityLevel.getOrDefault((Serializable)this.initLevel);
    }

    private void migrate() {
        if (!SupportFeaturesUtils.isFeatureEnabled((String)"GG_SNAPSHOT_SECURITY_FEATURE")) {
            this.writeToAuditLog("Migration skipped: " + DistributedSnapshotSecurityLevel.disabledSecurityFeatureMessage());
            return;
        }
        this.writeToAuditLog("Initializing snapshot security level in distributed metastore. [level=" + this.initLevel + "]");
        try {
            this.securityLevel.propagateAsync((Serializable)this.initLevel).listen((IgniteInClosure & Serializable)f -> {
                assert (f.isDone());
                Throwable t = f.error();
                if (t != null) {
                    this.log.error("Failed to initialize snapshot security level in distributed metastore.", t);
                }
            });
        }
        catch (IgniteCheckedException e) {
            this.log.error("Distributed metastore can't propagate value.", (Throwable)e);
        }
    }

    public void update(SnapshotSecurityLevel lvl) throws IgniteCheckedException {
        if (!SupportFeaturesUtils.isFeatureEnabled((String)"GG_SNAPSHOT_SECURITY_FEATURE")) {
            throw new IgniteCheckedException(String.format("Can't change security level to %s: %s", lvl, DistributedSnapshotSecurityLevel.disabledSecurityFeatureMessage()));
        }
        this.writeToAuditLog("Change of security level to " + lvl);
        this.securityLevel.propagate((Serializable)lvl);
    }

    private SnapshotSecurityLevel resolveInitialSecurityLevel() {
        String valName = IgniteSystemProperties.getString((String)"GG_SNAPSHOT_SECURITY_LEVEL", (String)SnapshotSecurityLevel.DISABLED.name()).toUpperCase();
        try {
            return SnapshotSecurityLevel.valueOf((String)valName);
        }
        catch (IllegalArgumentException e) {
            throw new SnapshotDigestException("Failed to resolve snapshot security level using system property (are there any misspellings?).[name=GG_SNAPSHOT_SECURITY_LEVEL, value=" + valName + ']', e);
        }
    }

    private void writeToAuditLog(String msg) {
        String filePath;
        if (this.log.isInfoEnabled()) {
            this.log.info(msg);
        }
        if (!F.isEmpty((String)(filePath = IgniteSystemProperties.getString((String)"GG_SNAPSHOT_SECURITY_LEVEL_AUDIT_LOG")))) {
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(filePath, true));){
                bw.write(FMT.format(Instant.now()) + "\t" + msg + "\n");
            }
            catch (IOException e) {
                this.log.error("Failed to log a message to audit log [filePath='" + filePath + "'].", (Throwable)e);
            }
        }
    }

    private static String disabledSecurityFeatureMessage() {
        return "snapshot security feature is disabled. To enable the feature, restart the node with property -DGG_SNAPSHOT_SECURITY_FEATURE=true.";
    }
}

