/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;

public class BrokenTrackingPageLogger {
    private static final String LOG_PREFIX = "Failed to calculate set of changed pages for incremental snapshot, full page set will be written to snapshot instead nextSnapshotTag";
    private IgniteLogger log;
    private final int batchSize = IgniteSystemProperties.getInteger((String)"IGNITE_BROKEN_TRACKING_PAGE_LOG_BATCH_SIZE", (int)0);
    private final AtomicInteger entrySize = new AtomicInteger();
    private final Queue<LogEntry> entries = new ConcurrentLinkedQueue<LogEntry>();
    private final Lock writeEntriesLock = new ReentrantLock();

    public void setLog(IgniteLogger log) {
        assert (Objects.nonNull(log));
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(int grpId, int partId, long trackingPageId, long lastSavedSnapshotTag, long nextSnapshotTag) {
        if (this.batchSize <= 0) {
            if (this.entrySize.compareAndSet(0, 1)) {
                this.log.warning("Failed to calculate set of changed pages for incremental snapshot, full page set will be written to snapshot instead nextSnapshotTag. For more information set IGNITE_BROKEN_TRACKING_PAGE_LOG_BATCH_SIZE more than zero.");
            }
        } else {
            this.entries.add(new LogEntry(grpId, partId, trackingPageId, lastSavedSnapshotTag, nextSnapshotTag));
            int size = this.entrySize.incrementAndGet();
            if (size >= this.batchSize && this.writeEntriesLock.tryLock()) {
                HashMap<Integer, List> byGrpId = new HashMap<Integer, List>();
                try {
                    LogEntry logEntry;
                    int i = 0;
                    while (Objects.nonNull(logEntry = this.entries.poll()) && i++ < this.batchSize) {
                        byGrpId.computeIfAbsent(logEntry.grpId, integer -> new ArrayList()).add(logEntry);
                    }
                    this.entrySize.addAndGet(-i);
                }
                finally {
                    this.writeEntriesLock.unlock();
                }
                String grpInfos = byGrpId.entrySet().stream().map(entry -> {
                    List logEntries = (List)entry.getValue();
                    Set partIds = logEntries.stream().map(e -> e.partId).collect(Collectors.toSet());
                    Set trackPgIds = logEntries.stream().map(e -> IgniteUtils.hexLong((long)e.trackingPageId)).collect(Collectors.toSet());
                    Set lastSavedTags = logEntries.stream().map(e -> e.lastSavedSnapshotTag).collect(Collectors.toSet());
                    Set nextSnapshotTags = logEntries.stream().map(e -> e.nextSnapshotTag).collect(Collectors.toSet());
                    return "[grpId=" + entry.getKey() + ", partitions=" + GridToStringBuilder.compact(partIds) + ", trackingPageIds=" + trackPgIds + ", lastSavedTags=" + GridToStringBuilder.compact(lastSavedTags, l -> l + 1L) + ", nextSnapshotTags=" + GridToStringBuilder.compact(nextSnapshotTags, l -> l + 1L) + ']';
                }).collect(Collectors.joining(", "));
                this.log.warning("Failed to calculate set of changed pages for incremental snapshot, full page set will be written to snapshot instead nextSnapshotTag " + grpInfos);
            }
        }
    }

    private static class LogEntry {
        final int grpId;
        final int partId;
        final long trackingPageId;
        final long lastSavedSnapshotTag;
        final long nextSnapshotTag;

        public LogEntry(int grpId, int partId, long trackingPageId, long lastSavedSnapshotTag, long nextSnapshotTag) {
            this.grpId = grpId;
            this.partId = partId;
            this.trackingPageId = trackingPageId;
            this.lastSavedSnapshotTag = lastSavedSnapshotTag;
            this.nextSnapshotTag = nextSnapshotTag;
        }
    }
}

