/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class TxStateRequest
implements Message {
    private static final long serialVersionUID = 0L;
    @GridDirectCollection(value=GridCacheVersion.class)
    List<GridCacheVersion> preparedTxs;
    @GridDirectCollection(value=GridCacheVersion.class)
    List<GridCacheVersion> skipTxs;

    public TxStateRequest() {
    }

    TxStateRequest(List<GridCacheVersion> preparedTxs, List<GridCacheVersion> skipTxs) {
        this.preparedTxs = preparedTxs;
        this.skipTxs = skipTxs;
    }

    public List<GridCacheVersion> getPreparedTxs() {
        return this.preparedTxs;
    }

    public List<GridCacheVersion> getSkipTxs() {
        return this.skipTxs;
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeCollection("preparedTxs", this.preparedTxs, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeCollection("skipTxs", this.skipTxs, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.preparedTxs = (List)reader.readCollection("preparedTxs", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.skipTxs = (List)reader.readCollection("skipTxs", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TxStateRequest.class);
    }

    public short directType() {
        return 2056;
    }

    public byte fieldsCount() {
        return 2;
    }

    public void onAckReceived() {
    }
}

