/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.jetbrains.annotations.Nullable;

public abstract class SnapshotTaskBase<T, R>
extends ComputeTaskAdapter<T, R> {
    public static final DateTimeFormatter LOG_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss").withZone(ZoneId.systemDefault());
    @IgniteInstanceResource
    protected IgniteEx ignite;

    public static String buildInitiatorMessage(UUID localId, UUID initiatorId) {
        return "initiatorId=" + initiatorId + (localId.equals(initiatorId) ? " (current node)" : "");
    }

    @Nullable
    protected GridCacheSnapshotManager getSnapShotManager() {
        IgniteCacheSnapshotManager dbMgr = this.getKernalContext().cache().context().snapshot();
        return dbMgr instanceof GridCacheSnapshotManager ? (GridCacheSnapshotManager)dbMgr : null;
    }

    protected GridKernalContext getKernalContext() {
        assert (this.ignite instanceof IgniteKernal);
        return this.ignite.context();
    }

    protected IgniteLogger getLog() {
        return this.ignite.log().getLogger(((Object)((Object)this)).getClass());
    }
}

