/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheAffinityChangeMessage;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.StateChangeRequest;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateFinishMessage;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateMessage;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.cluster.GridClusterStateProcessor;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.jetbrains.annotations.Nullable;

public class GridSnapshotAwareClusterStateProcessorImpl
extends GridClusterStateProcessor {
    public static final String DELAYED_SNAPSHOT_CREATION_MSG = "[src=PITR, user=CLUSTER, comment=Auto created snapshot on cluster activation for PITR]";
    private final AtomicReference<StateChangeSession> ses = new AtomicReference();

    public GridSnapshotAwareClusterStateProcessorImpl(GridKernalContext ctx) {
        super(ctx);
        if (IgniteSystemProperties.getBoolean((String)"GG_DISABLE_SNAPSHOT_ON_BASELINE_CHANGE_WITH_ENABLED_PITR", (boolean)false)) {
            ctx.addNodeAttribute("org.gridgain.snapshot.disableOnBaselineChanged", (Object)true);
        }
    }

    public boolean onStateChangeMessage(AffinityTopologyVersion topVer, ChangeGlobalStateMessage msg, DiscoCache discoCache) {
        DiscoveryDataClusterState prevState = this.clusterState();
        boolean msgApplied = super.onStateChangeMessage(topVer, msg, discoCache);
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)this.ctx.cache().context().snapshot();
        if (snapMgr.pointInTimeRecoveryEnabled() && (msgApplied || prevState.transition() && GridSnapshotAwareClusterStateProcessorImpl.isEquivalent((ChangeGlobalStateMessage)msg, (DiscoveryDataClusterState)prevState))) {
            StateChangeSession curSes;
            block16: {
                long snapshotId = msg.timestamp();
                while (true) {
                    StateChangeSession newSes;
                    if ((curSes = this.ses.get()) == null) {
                        newSes = new StateChangeSession(msg.initiatorNodeId(), snapshotId, this.pendingState(msg));
                        if (!this.ses.compareAndSet(null, newSes)) continue;
                        curSes = newSes;
                        break block16;
                    }
                    if (!msgApplied && curSes.operationId.get() != null) {
                        return false;
                    }
                    if (curSes.snapshotId == snapshotId) break block16;
                    if (curSes.operationId.get() == null) {
                        newSes = new StateChangeSession(msg.initiatorNodeId(), snapshotId, this.pendingState(msg));
                        if (this.ses.compareAndSet(curSes, newSes)) {
                            DiscoveryDataClusterState targetDiscoClusterState = curSes.targetState;
                            if (GridSnapshotAwareClusterStateProcessorImpl.isEquivalent((ChangeGlobalStateMessage)msg, (DiscoveryDataClusterState)targetDiscoClusterState)) {
                                StateChangeSession ses0 = curSes;
                                newSes.publicFut.listen((IgniteInClosure & Serializable)fut -> this.completeFuture((GridFutureAdapter<Void>)ses0.publicFut, (IgniteInternalFuture)fut));
                            } else {
                                curSes.publicFut.onDone((Throwable)this.concurrentStateChangeError(msg.state(), targetDiscoClusterState.state()));
                            }
                            curSes = newSes;
                            break block16;
                        }
                        assert (false) : "StateChangeSession was concurrently modified during exchange: " + curSes;
                        continue;
                    }
                    if (!$assertionsDisabled) break;
                }
                throw new AssertionError((Object)("StateChangeSession was concurrently modified during exchange: " + curSes));
            }
            boolean set = curSes.operationId.compareAndSet(null, msg.id());
            assert (set) : "StateChangeSession was concurrently modified during exchange: " + curSes;
            boolean bltSame = BaselineTopology.equals((BaselineTopology)msg.baselineTopology(), (BaselineTopology)prevState.baselineTopology());
            boolean disableSnapshot = this.disableSnapshotOnBaselineChange(topVer);
            if (!msg.activate() || bltSame || disableSnapshot) {
                if (msg.activate() && !bltSame && disableSnapshot) {
                    this.warnSnapshotDisabledOnBaselineChange(topVer);
                }
                this.ses.compareAndSet(curSes, null);
                curSes.publicFut.onDone();
            } else {
                try {
                    IgniteInternalFuture snapFut = snapMgr.prepareDelayedSnapshotCreation(msg.id(), msg.initiatorNodeId(), topVer);
                    StateChangeSession ses0 = curSes;
                    snapFut.listen((IgniteInClosure & Serializable)fut -> {
                        this.ses.compareAndSet(ses0, null);
                        this.completeFuture((GridFutureAdapter<Void>)ses0.publicFut, (IgniteInternalFuture)fut);
                    });
                }
                catch (IllegalStateException ex) {
                    DiscoveryDataClusterState state = this.clusterState();
                    assert (state.transition());
                    state.transitionError((Exception)ex);
                }
            }
        }
        return msgApplied;
    }

    private boolean disableSnapshotOnBaselineChange(AffinityTopologyVersion topVer) {
        boolean disableSnapshot = this.ctx.discovery().nodes(topVer).stream().filter(node -> !node.isClient()).anyMatch(node -> Boolean.TRUE.equals(node.attribute("org.gridgain.snapshot.disableOnBaselineChanged")));
        if (disableSnapshot) {
            return true;
        }
        if (this.ctx.txDr() instanceof TransactionalDrProcessorImpl) {
            TransactionalDrProcessorImpl txDr = (TransactionalDrProcessorImpl)this.ctx.txDr();
            return txDr.disableSnasphotOnBaselineChange();
        }
        return false;
    }

    private void warnSnapshotDisabledOnBaselineChange(AffinityTopologyVersion topVer) {
        List nodes = this.ctx.discovery().nodes(topVer).stream().filter(node -> !node.isClient()).filter(node -> Boolean.TRUE.equals(node.attribute("org.gridgain.snapshot.disableOnBaselineChanged"))).map(ClusterNode::consistentId).map(Objects::toString).collect(Collectors.toList());
        if (!nodes.isEmpty()) {
            this.log.warning("Automatic snapshot disabled by 'org.gridgain.snapshot.disableOnBaselineChanged' property on nodes " + nodes);
        }
    }

    protected boolean isApplicable(ChangeGlobalStateMessage msg, DiscoveryDataClusterState state) {
        if (!super.isApplicable(msg, state)) {
            return false;
        }
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)this.ctx.cache().context().snapshot();
        if (snapMgr.pointInTimeRecoveryEnabled()) {
            IgniteUuid opId;
            StateChangeSession curSes = this.ses.get();
            IgniteUuid igniteUuid = opId = curSes != null ? (IgniteUuid)curSes.operationId.get() : null;
            if (curSes != null && opId != null && !opId.equals((Object)msg.id())) {
                this.log.error("Failed to change cluster state, because another state change operation hasn't finished all stages yet.");
                return false;
            }
        }
        return true;
    }

    @Nullable
    public Long startSnapshot(DiscoveryCustomMessage msg) {
        StateChangeSession ses = this.ses.get();
        if (ses != null && msg instanceof CacheAffinityChangeMessage) {
            return ses.snapshotId;
        }
        return null;
    }

    protected IgniteInternalFuture<?> wrapStateChangeFuture(IgniteInternalFuture fut, ChangeGlobalStateMessage msg) {
        StateChangeSession ses;
        block5: {
            GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)this.ctx.cache().context().snapshot();
            if (!msg.activate() || msg.baselineTopology() == null || !snapMgr.pointInTimeRecoveryEnabled()) {
                return fut;
            }
            long snapshotId = msg.timestamp();
            while ((ses = this.ses.get()) == null) {
                ses = new StateChangeSession(this.ctx.localNodeId(), snapshotId, this.pendingState(msg));
                if (!this.ses.compareAndSet(null, ses)) continue;
                break block5;
            }
            if (!GridSnapshotAwareClusterStateProcessorImpl.isEquivalent((ChangeGlobalStateMessage)msg, (DiscoveryDataClusterState)ses.targetState)) {
                this.log.error("Failed to change cluster state, because another state change operation hasn't finished all stages yet.");
                return new GridFinishedFuture((Throwable)new IgniteCheckedException("Failed to change cluster state, because another state change operation hasn't finished all stages yet."));
            }
        }
        if (ses.publicFut.isDone()) {
            return fut;
        }
        if (this.log != null && this.log.isInfoEnabled()) {
            this.log.info("Point in time recovery is enabled, snapshot will be created after cluster changed state.");
        }
        GridCompoundFuture resFut = new GridCompoundFuture();
        resFut.add(fut);
        resFut.add((IgniteInternalFuture)ses.publicFut);
        resFut.markInitialized();
        return resFut;
    }

    public void onExchangeFinishedOnCoordinator(IgniteInternalFuture exchangeFut, boolean hasMovingPartitions) {
        if (hasMovingPartitions) {
            return;
        }
        StateChangeSession ses0 = this.ses.get();
        if (ses0 != null) {
            exchangeFut.listen((IgniteInClosure & Serializable)fut -> {
                try {
                    GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)this.ctx.cache().context().snapshot();
                    Set cacheNames = GridSnapshotManager.getAllCachesForSnapshot(this.ctx.cache().cacheDescriptors().values());
                    IgniteUuid opId = (IgniteUuid)ses0.operationId.get();
                    assert (opId != null);
                    if (!cacheNames.isEmpty()) {
                        snapMgr.startGlobalSnapshotCreation(new HashSet<String>(cacheNames), null, true, null, DELAYED_SNAPSHOT_CREATION_MSG, opId, new SnapshotCommonParameters(snapMgr.config().getSnapshotOperationParallelism()), new SnapshotCreateParameters(snapMgr.config().getCompressionOption(), snapMgr.config().getCompressionLevel(), 0, false));
                    } else {
                        snapMgr.cancelGlobalDelayedSnapshotCreation(ses0.snapshotId).listen((IgniteInClosure & Serializable)fut0 -> {
                            this.ses.compareAndSet(ses0, null);
                            this.completeFuture((GridFutureAdapter<Void>)ses0.publicFut, (IgniteInternalFuture)fut0);
                        });
                    }
                }
                catch (Throwable t) {
                    this.ses.compareAndSet(ses0, null);
                    ses0.publicFut.onDone(t);
                    throw t;
                }
            });
        }
    }

    public boolean evictionsAllowed() {
        return this.ses.get() == null && !this.ctx.cache().context().snapshot().partitionsAreFrozen(null);
    }

    protected void afterStateChangeFinished(IgniteUuid msgId, boolean success) {
        StateChangeSession ses;
        if (!success && (ses = this.ses.get()) != null && msgId.equals(ses.operationId.get())) {
            boolean b = this.ses.compareAndSet(ses, null);
            assert (b);
        }
    }

    public void onStateChangeError(Map<UUID, Exception> errs, StateChangeRequest req) {
        StateChangeSession ses = this.ses.get();
        if (ses != null && req.id().equals(ses.operationId.get())) {
            boolean b = this.ses.compareAndSet(ses, null);
            assert (b);
        }
        super.onStateChangeError(errs, req);
    }

    @Nullable
    public ChangeGlobalStateFinishMessage onNodeLeft(ClusterNode node) {
        StateChangeSession ses = this.ses.get();
        if (ses != null && ses.initiatorId.equals(node.id())) {
            GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)this.ctx.cache().context().snapshot();
            snapMgr.cancelGlobalDelayedSnapshotCreation(ses.snapshotId);
        }
        return super.onNodeLeft(node);
    }

    private void completeFuture(GridFutureAdapter<Void> publicFut, IgniteInternalFuture fut) {
        Throwable err = fut.error();
        if (err != null && !"Snapshot operation has been cancelled".equals(err.getMessage())) {
            publicFut.onDone(fut.error());
        } else {
            publicFut.onDone();
        }
    }

    private boolean isPersistentUserCache(DynamicCacheDescriptor desc) {
        return desc.cacheType().userCache() && desc.groupDescriptor().persistenceEnabled();
    }

    private static class StateChangeSession {
        private final UUID initiatorId;
        private final long snapshotId;
        private final AtomicReference<IgniteUuid> operationId = new AtomicReference();
        private final GridFutureAdapter<Void> publicFut = new GridFutureAdapter();
        private final DiscoveryDataClusterState targetState;

        public StateChangeSession(UUID initiatorId, long snapshotId, DiscoveryDataClusterState targetState) {
            this.initiatorId = initiatorId;
            this.snapshotId = snapshotId;
            this.targetState = targetState;
        }
    }
}

