/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskNoResultCache;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.gridgain.grid.internal.processors.cache.database.CollectSnapshotPartitionDistributionTask;
import org.gridgain.grid.internal.processors.cache.database.SnapshotTaskBase;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CacheSnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotRemotePath;
import org.gridgain.grid.persistentstore.snapshot.file.FileSnapshot;
import org.gridgain.grid.persistentstore.snapshot.file.remote.SnapshotPathFactory;

@GridInternal
@ComputeTaskNoResultCache
public class CollectSnapshotPartitionDistributionTaskV3
extends SnapshotTaskBase<CollectSnapshotPartitionDistributionV3Params, CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionTaskResult> {
    private static final long serialVersionUID = 0L;
    private final ConcurrentHashMap<UUID, CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionJobResult> result = new ConcurrentHashMap();

    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, CollectSnapshotPartitionDistributionV3Params arg) throws IgniteException {
        assert (arg != null);
        HashMap<CollectSnapshotPartitionDistributionJob, ClusterNode> jobs = new HashMap<CollectSnapshotPartitionDistributionJob, ClusterNode>();
        Collection baselineNodes = this.ignite.context().discovery().discoCache().aliveBaselineNodes();
        Collection<Object> nodes = baselineNodes == null ? subgrid : baselineNodes;
        for (ClusterNode clusterNode : nodes) {
            if (clusterNode.isClient() || clusterNode.isDaemon()) continue;
            jobs.put(new CollectSnapshotPartitionDistributionJob(arg), clusterNode);
        }
        return jobs;
    }

    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) throws IgniteException {
        if (res.getException() != null) {
            return super.result(res, rcvd);
        }
        Object data = res.getData();
        if (data instanceof CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionJobResult) {
            CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionJobResult r = (CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionJobResult)data;
            this.result.put(res.getNode().id(), r);
        }
        return ComputeJobResultPolicy.WAIT;
    }

    public CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionTaskResult reduce(List<ComputeJobResult> results) throws IgniteException {
        return new CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionTaskResult(this.result);
    }

    @GridInternal
    private static class CollectSnapshotPartitionDistributionJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        protected Ignite ignite;

        public CollectSnapshotPartitionDistributionJob(CollectSnapshotPartitionDistributionV3Params params) {
            super((Object)params);
            assert (params != null) : "Job params must not be null";
        }

        public Object execute() throws IgniteException {
            SnapshotMetadataV2 metadata;
            FileSnapshot snapshot;
            if (this.ignite == null) {
                throw new IgniteException("Ignite instance was not injected");
            }
            IgniteEx ig = (IgniteEx)this.ignite;
            CollectSnapshotPartitionDistributionV3Params params = this.params();
            GridCacheSnapshotManager snapshotMgr = (GridCacheSnapshotManager)ig.context().cache().context().snapshot();
            IgniteLogger log = ig.log().getLogger(CollectSnapshotPartitionDistributionTaskV3.class);
            if (log != null && log.isInfoEnabled()) {
                log.info("Starting CollectSnapshotPartitionDistributionJob: snapshotId = " + params.snapshotId + ", path = " + params.paths);
            }
            if (params.c != null) {
                try {
                    ((IgniteEx)this.ignite).context().resource().injectGeneric((Object)params.c);
                }
                catch (IgniteCheckedException e) {
                    U.error((IgniteLogger)log, (Object)"Error during injecting resources to cache configuration transformer", (Throwable)e);
                }
            }
            if ((snapshot = (FileSnapshot)snapshotMgr.snapshotSpi().snapshot(params.snapshotId, SnapshotPathFactory.create(params.paths, log, snapshotMgr.config().getSftpConfiguration()), params.c, true, null, false)) == null || (metadata = snapshot.metadata()) == null) {
                return new CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionJobResult(null, null, null);
            }
            boolean snapshotIsInSharedFolder = !snapshot.isDefaultPath() && this.calcSnapshotInSharedFolder(metadata);
            return new CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionJobResult(snapshotIsInSharedFolder, snapshotIsInSharedFolder ? null : this.getPartitionsForGroups(ig.localNode().consistentId().toString(), metadata), metadata.cacheNamesWithGroups());
        }

        private CollectSnapshotPartitionDistributionV3Params params() {
            return (CollectSnapshotPartitionDistributionV3Params)((Object)this.argument(0));
        }

        private Map<Integer, T2<Integer, Set<Integer>>> getPartitionsForGroups(String consistentId, SnapshotMetadataV2 metadata) {
            HashMap<Integer, T2<Integer, Set<Integer>>> res = new HashMap<Integer, T2<Integer, Set<Integer>>>();
            String fileName = U.maskForFileName((CharSequence)consistentId);
            for (Integer grpId : this.getGroupIds(metadata)) {
                CacheSnapshotMetadata cacheSnapMetadata = (CacheSnapshotMetadata)metadata.cacheGroupsMetadata().get(grpId);
                Map partCnt = cacheSnapMetadata.partitionSizesPerNode();
                for (Map.Entry e0 : partCnt.entrySet()) {
                    Integer part = (Integer)e0.getKey();
                    if (F.isEmpty((Map)((Map)e0.getValue())) || !((Map)e0.getValue()).containsKey(fileName)) continue;
                    T2 parts = (T2)res.get(grpId);
                    if (parts == null) {
                        if (cacheSnapMetadata.cacheConfigurations().isEmpty()) continue;
                        parts = new T2((Object)((CacheConfiguration)cacheSnapMetadata.cacheConfigurations().iterator().next()).getAffinity().partitions(), new HashSet());
                        res.put(grpId, (T2<Integer, Set<Integer>>)parts);
                    }
                    ((Set)parts.get2()).add(part);
                }
            }
            return res;
        }

        private boolean calcSnapshotInSharedFolder(SnapshotMetadataV2 metadata) {
            for (Map.Entry e : metadata.cacheGroupsMetadata().entrySet()) {
                CacheSnapshotMetadata meta = (CacheSnapshotMetadata)e.getValue();
                if (!meta.hasCacheConfiguration()) {
                    throw new IgniteException("Snapshot couldn't be restored because cache configuration couldn't be unmarshalled");
                }
                if (meta.checkPartitions()) continue;
                return false;
            }
            return true;
        }

        private Set<Integer> getGroupIds(SnapshotMetadataV2 metadata) {
            CollectSnapshotPartitionDistributionV3Params params = this.params();
            assert (params.inclusionMode || params.cachesOrGroups != null) : "When in exclusion mode caches or groups must be provided.";
            if (params.inclusionMode && params.cachesOrGroups == null) {
                return metadata.cacheGroupIds();
            }
            Set allGrpIds = metadata.cacheGroupIds();
            HashSet<Integer> cacheGrpIds = params.inclusionMode ? new HashSet() : metadata.cacheGroupIds();
            Map cachesWithGrps = metadata.cacheNamesWithGroups();
            for (String cacheOrGroup : params.cachesOrGroups) {
                Integer grpId = CU.cacheId((String)cacheOrGroup);
                if (!allGrpIds.contains(grpId) && (grpId = (Integer)cachesWithGrps.get(cacheOrGroup)) == null) continue;
                if (params.inclusionMode) {
                    cacheGrpIds.add(grpId);
                    continue;
                }
                cacheGrpIds.remove(grpId);
            }
            return cacheGrpIds;
        }
    }

    public static class CollectSnapshotPartitionDistributionV3Params
    extends IgniteDataTransferObject {
        private static final long serialVersionUID = 0L;
        private Set<String> cachesOrGroups;
        private long snapshotId;
        private boolean inclusionMode;
        private Collection<SnapshotRemotePath> paths;
        private IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c;

        public CollectSnapshotPartitionDistributionV3Params() {
        }

        public CollectSnapshotPartitionDistributionV3Params(long snapshotId, Set<String> cachesOrGroups, boolean inclusionMode, Collection<SnapshotRemotePath> paths, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c) {
            this.snapshotId = snapshotId;
            this.cachesOrGroups = cachesOrGroups;
            this.inclusionMode = inclusionMode;
            this.paths = paths;
            this.c = c;
        }

        protected void writeExternalData(ObjectOutput out) throws IOException {
            out.writeObject(this.cachesOrGroups);
            out.writeLong(this.snapshotId);
            out.writeBoolean(this.inclusionMode);
            out.writeObject(this.paths);
            out.writeObject(this.c);
        }

        protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
            this.cachesOrGroups = (Set)in.readObject();
            this.snapshotId = in.readLong();
            this.inclusionMode = in.readBoolean();
            this.paths = (Collection)in.readObject();
            this.c = (IgniteBiClosure)in.readObject();
        }
    }
}

