/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskNoResultCache;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.T5;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTaskResult;
import org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTaskResultV2;
import org.gridgain.grid.internal.processors.cache.database.SnapshotCompatibilityJob;
import org.gridgain.grid.internal.processors.cache.database.SnapshotTaskBase;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompatibleSnapshotDescriptor;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.Snapshot;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDescriptor;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDescriptorV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotInfoExtended;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotRemotePath;
import org.gridgain.grid.persistentstore.snapshot.file.FileSnapshot;
import org.gridgain.grid.persistentstore.snapshot.file.remote.SnapshotPathFactory;
import org.jetbrains.annotations.Nullable;

@Deprecated
@GridInternal
public class CollectSnapshotInfoTask
extends SnapshotTaskBase<T3<Long, Collection<File>, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration>>, CollectSnapshotInfoTaskResultV2> {
    private static final long serialVersionUID = 0L;

    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, T3<Long, Collection<File>, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration>> p) throws IgniteException {
        if (p.get1() == null) {
            throw new IgniteException("Snapshot ID is null: " + p);
        }
        Collection baselineNodes = this.ignite.context().discovery().discoCache().aliveBaselineNodes();
        Collection<Object> nodes = baselineNodes == null ? subgrid : baselineNodes;
        Map<ComputeJob, ClusterNode> jobs = nodes.stream().filter(n -> !n.isClient() && !n.isDaemon()).collect(Collectors.toMap(n -> new CollectShortSnapshotInfoCompatibleJob((Long)p.get1(), (Collection)p.get2(), (IgniteBiClosure)p.get3()), Function.identity()));
        IgniteLogger log = this.getLog();
        if (log != null && log.isInfoEnabled()) {
            log.info("Sent CollectSnapshotInfoJob to " + jobs.size() + " nodes");
        }
        return jobs;
    }

    @Nullable
    public CollectSnapshotInfoTaskResultV2 reduce(List<ComputeJobResult> results) throws IgniteException {
        IgniteLogger log = this.getLog();
        if (log != null && log.isInfoEnabled()) {
            log.info("Starting reducing CollectSnapshotInfoTaskResult, count = " + results.size());
        }
        CollectSnapshotInfoTaskResultV2 taskRes = null;
        JdkMarshaller jdkMarshaller = new JdkMarshaller();
        for (ComputeJobResult result : results) {
            Object data0;
            block7: {
                data0 = result.getData();
                try {
                    if (!(data0 instanceof byte[])) break block7;
                    data0 = jdkMarshaller.unmarshal((byte[])data0, U.resolveClassLoader((IgniteConfiguration)this.ignite.configuration()));
                }
                catch (IgniteCheckedException e) {
                    U.error((IgniteLogger)log, (Object)("Failed to deserialize job execution result (will skip the node): " + U.toShortString((ClusterNode)result.getNode())), (Throwable)e);
                    continue;
                }
            }
            if (!(data0 instanceof CollectSnapshotInfoTaskResultV2)) {
                throw new AssertionError((Object)("Not expected class was received : " + data0.getClass().getName()));
            }
            CollectSnapshotInfoTaskResultV2 data = (CollectSnapshotInfoTaskResultV2)data0;
            if (taskRes == null) {
                taskRes = data;
                continue;
            }
            taskRes.merge(data);
        }
        if (log != null) {
            log.info("Finished reducing CollectSnapshotInfoTaskResult");
        }
        return taskRes;
    }

    @Nullable
    static Object collectFullSnapshotInfo(Ignite ignite, @Nullable Collection<SnapshotRemotePath> optSearchPaths, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, long snapId, boolean compat, boolean newMeta) {
        GridCacheSharedContext sharedCtx = ((IgniteEx)ignite).context().cache().context();
        IgniteCacheSnapshotManager mgr = sharedCtx.snapshot();
        if (!(mgr instanceof GridCacheSnapshotManager)) {
            return null;
        }
        IgniteLogger log = ignite.log().getLogger(CollectSnapshotInfoTask.class);
        if (log != null && log.isInfoEnabled()) {
            log.info("Starting CollectSnapshotInfoJob: snapshotId = " + snapId + ", path = " + optSearchPaths);
        }
        GridCacheSnapshotManager snapshotMgr = (GridCacheSnapshotManager)mgr;
        ClusterNode crd = SnapshotUtils.getSnapshotCrd(AffinityTopologyVersion.NONE, sharedCtx);
        try {
            Snapshot global = null;
            if (crd != null && crd.isLocal() && !F.isEmpty(optSearchPaths)) {
                if (log != null && log.isInfoEnabled()) {
                    log.info("CollectSnapshotInfoJob: Starting reading snapshot from remote store, snapshotId = " + snapId + ", path = " + optSearchPaths);
                }
                global = snapshotMgr.snapshotSpi().snapshot(snapId, SnapshotPathFactory.create(optSearchPaths, log, snapshotMgr.config().getSftpConfiguration()), c, true, null, false);
                if (log != null && log.isInfoEnabled()) {
                    log.info("CollectSnapshotInfoJob: Finished reading snapshot from remote store, snapshotId = " + snapId + ", path = " + optSearchPaths);
                }
            }
            CollectSnapshotInfoTaskResult snapshotInfo = snapshotMgr.getLocalSnapshotInfo(snapId, c, compat, newMeta);
            if (log != null && log.isInfoEnabled()) {
                log.info("CollectSnapshotInfoJob: Finished reading snapshot from local store, snapshotId = " + snapId);
            }
            if (global != null) {
                if (newMeta) {
                    Map<UUID, SnapshotDescriptorV2> nodeMap = snapshotInfo.descriptorForNodeV2();
                    SnapshotDescriptorV2 desc = nodeMap.get(crd.id());
                    SnapshotDescriptorV2 globalDesc = new SnapshotDescriptorV2(global.metadata());
                    if (global instanceof FileSnapshot) {
                        globalDesc.addAttribute((Object)"<CLUSTER_WIDE>", "SNAPSHOT_DIR", ((FileSnapshot)global).snapshotDirectory().toString());
                    }
                    if (desc == null) {
                        nodeMap.put(crd.id(), globalDesc);
                    } else {
                        nodeMap.put(crd.id(), globalDesc.merge(desc));
                    }
                } else {
                    CompatibleSnapshotDescriptor globalDesc;
                    Map<UUID, SnapshotDescriptor> nodeMap = snapshotInfo.descriptorForNode();
                    SnapshotDescriptor desc = nodeMap.get(crd.id());
                    Object object = globalDesc = compat ? new CompatibleSnapshotDescriptor(global.metadata().toOldMetadata()) : new SnapshotDescriptor(global.metadata().toOldMetadata());
                    if (global instanceof FileSnapshot) {
                        globalDesc.addAttribute((Object)"<CLUSTER_WIDE>", "SNAPSHOT_DIR", ((FileSnapshot)global).snapshotDirectory().toString());
                    }
                    if (desc == null) {
                        nodeMap.put(crd.id(), (SnapshotDescriptor)globalDesc);
                    } else {
                        nodeMap.put(crd.id(), globalDesc.merge(desc));
                    }
                }
            }
            return snapshotInfo;
        }
        catch (IgniteException e) {
            U.error((IgniteLogger)log, (Object)"Exception in CollectSnapshotInfoJob", (Throwable)e);
            if (e.getMessage() != null && e.getMessage().startsWith("Failed to merge snapshot metadata [oldMeta=")) {
                return new CollectSnapshotInfoTaskResult(snapId);
            }
            throw e;
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)log, (Object)"Exception in CollectSnapshotInfoJob", (Throwable)e);
            throw new IgniteException((Throwable)e);
        }
    }

    static Object collectShortSnapshotInfo(Ignite ignite, @Nullable Collection<SnapshotRemotePath> optSearchPaths, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, long snapId) {
        GridCacheSharedContext sharedCtx = ((IgniteEx)ignite).context().cache().context();
        IgniteCacheSnapshotManager mgr = sharedCtx.snapshot();
        if (!(mgr instanceof GridCacheSnapshotManager)) {
            return null;
        }
        IgniteLogger log = ignite.log().getLogger(CollectSnapshotInfoTask.class);
        if (log != null && log.isInfoEnabled()) {
            log.info("Starting CollectSnapshotInfoJob: snapshotId = " + snapId + ", path = " + optSearchPaths);
        }
        GridCacheSnapshotManager snapshotMgr = (GridCacheSnapshotManager)mgr;
        ClusterNode snapshotCrd = SnapshotUtils.getSnapshotCrd(AffinityTopologyVersion.NONE, sharedCtx);
        try {
            CollectSnapshotInfoTaskResultV2 taskRes = snapshotMgr.getLocalSnapshotInfoV2(snapId, c);
            if (log != null && log.isInfoEnabled()) {
                log.info("CollectSnapshotInfoJob: Finished reading snapshot from local store, snapshotId = " + snapId);
            }
            if (snapshotCrd != null && snapshotCrd.isLocal() && !F.isEmpty(optSearchPaths)) {
                if (log != null && log.isInfoEnabled()) {
                    log.info("CollectSnapshotInfoJob: Starting reading snapshot from remote store, snapshotId = " + snapId + ", path = " + optSearchPaths);
                }
                Collection<SnapshotPath> paths = SnapshotPathFactory.create(optSearchPaths, log, snapshotMgr.config().getSftpConfiguration());
                for (SnapshotPath path : paths) {
                    Snapshot global = snapshotMgr.snapshotSpi().snapshot(snapId, Collections.singleton(path), c, true, null, false);
                    if (global == null || CollectSnapshotInfoTask.isLocal(snapshotMgr, (FileSnapshot)global)) continue;
                    Map<UUID, SnapshotInfoExtended> nodeMap = taskRes.descriptorForNode();
                    SnapshotInfoExtended desc = nodeMap.get(snapshotCrd.id());
                    if (desc == null) {
                        nodeMap.put(snapshotCrd.id(), new SnapshotInfoExtended(global.metadata(), CollectSnapshotInfoTask.getAttr(global), snapshotMgr.snapshotSpi().remoteSnapshotWalSizes(path, global.id())));
                        continue;
                    }
                    assert (desc.snapshotAttributes() != null);
                    assert (global instanceof FileSnapshot);
                    desc.snapshotAttributes().computeIfAbsent("<CLUSTER_WIDE>", x -> new HashMap()).put(((FileSnapshot)global).snapshotDirectory().toString(), "SNAPSHOT_DIR");
                }
                if (log != null && log.isInfoEnabled()) {
                    log.info("CollectSnapshotInfoJob: Finished reading snapshot from remote store, snapshotId = " + snapId + ", path = " + optSearchPaths);
                }
            }
            return taskRes;
        }
        catch (IgniteException e) {
            U.error((IgniteLogger)log, (Object)"Exception in CollectSnapshotInfoJob", (Throwable)e);
            if (e.getMessage() != null && e.getMessage().startsWith("Failed to merge snapshot metadata [oldMeta=")) {
                return new CollectSnapshotInfoTaskResult(snapId);
            }
            throw e;
        }
    }

    static Map<Object, Map<String, String>> getAttr(Snapshot snapshot) {
        assert (snapshot instanceof FileSnapshot) : snapshot.getClass();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(((FileSnapshot)snapshot).snapshotDirectory().toString(), "SNAPSHOT_DIR");
        HashMap<Object, Map<String, String>> attrs = new HashMap<Object, Map<String, String>>();
        attrs.put("<CLUSTER_WIDE>", map);
        return attrs;
    }

    static boolean isLocal(GridCacheSnapshotManager snapshotMgr, FileSnapshot global) {
        return global.snapshotDirectory().getAbsolutePath().startsWith(snapshotMgr.snapshotSpi().snapshotWorkingDirectory().getAbsolutePath());
    }

    static List<ClusterNode> calculateTaskSubgrid(List<ClusterNode> subgrid, Set<UUID> respondedNodes, Integer maxNodes) {
        ArrayList<ClusterNode> shuffledSubgrid = new ArrayList<ClusterNode>(subgrid);
        Collections.shuffle(shuffledSubgrid);
        List<ClusterNode> taskNodes = shuffledSubgrid.stream().filter(n -> !n.isClient() && !n.isDaemon() && !respondedNodes.contains(n.id())).limit(maxNodes.intValue()).collect(Collectors.toList());
        if (taskNodes.isEmpty()) {
            throw new ClusterTopologyException("No more nodes left to map CollectSnapshotDescriptorTask");
        }
        return taskNodes;
    }

    public static class SnapshotDescriptorOptional {
        private Set<UUID> nodes = new HashSet<UUID>();
        @Nullable
        private SnapshotDescriptor desc;

        public synchronized void merge(SnapshotDescriptor desc) throws IgniteCheckedException {
            if (this.desc != null) {
                this.desc.merge(desc);
            } else {
                this.desc = desc;
            }
        }

        public synchronized void reportMissOnNode(UUID node) {
            this.nodes.add(node);
        }

        public synchronized SnapshotDescriptor descriptor() {
            return this.desc;
        }

        public synchronized boolean isPresent() {
            return this.descriptor() != null;
        }

        public synchronized Set<UUID> nodes() {
            return Collections.unmodifiableSet(new HashSet<UUID>(this.nodes));
        }
    }

    @GridInternal
    private static class CollectShortSnapshotInfoCompatibleJob
    extends SnapshotCompatibilityJob {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        protected Ignite ignite;
        @Nullable
        private final Collection<File> optSearchPaths;
        @Nullable
        private final IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c;
        private final long snapshotId;

        private CollectShortSnapshotInfoCompatibleJob(long snapshotId, @Nullable Collection<File> optSearchPaths, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c) {
            this.snapshotId = snapshotId;
            this.optSearchPaths = optSearchPaths;
            this.c = c;
        }

        @Override
        @Nullable
        public Object executeCompatible() throws IgniteException {
            return CollectSnapshotInfoTask.collectShortSnapshotInfo(this.ignite, SnapshotRemotePath.convertToSnapshotPathCollection(this.optSearchPaths), this.c, this.snapshotId);
        }
    }

    @GridInternal
    private static class CollectFullSnapshotInfoCompatibleJob
    extends SnapshotCompatibilityJob {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        protected Ignite ignite;
        @Nullable
        private final Collection<File> optSearchPaths;
        @Nullable
        private final IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c;
        private final long snapshotId;

        private CollectFullSnapshotInfoCompatibleJob(long snapshotId, @Nullable Collection<File> optSearchPaths, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c) {
            this.snapshotId = snapshotId;
            this.optSearchPaths = optSearchPaths;
            this.c = c;
        }

        @Override
        @Nullable
        public Object executeCompatible() throws IgniteException {
            return CollectSnapshotInfoTask.collectFullSnapshotInfo(this.ignite, SnapshotRemotePath.convertToSnapshotPathCollection(this.optSearchPaths), this.c, this.snapshotId, true, false);
        }
    }

    @ComputeTaskNoResultCache
    public static class CollectSnapshotDescriptorTask
    extends SnapshotTaskBase<T5<Long, Collection<File>, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration>, Set<UUID>, Integer>, SnapshotDescriptorOptional> {
        private static final long serialVersionUID = 0L;
        private final SnapshotDescriptorOptional taskRes = new SnapshotDescriptorOptional();

        public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, T5<Long, Collection<File>, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration>, Set<UUID>, Integer> p) throws IgniteException {
            if (p.get1() == null) {
                throw new IgniteException("Snapshot ID is null: " + p);
            }
            HashSet<UUID> respondedNodes = p.get4() == null ? new HashSet() : (Set)p.get4();
            Integer maxNodes = (Integer)p.get5();
            Map<ComputeJob, ClusterNode> jobs = CollectSnapshotInfoTask.calculateTaskSubgrid(subgrid, respondedNodes, maxNodes).stream().collect(Collectors.toMap(n -> new CollectFullSnapshotInfoCompatibleJob((Long)p.get1(), (Collection)p.get2(), (IgniteBiClosure)p.get3()), Function.identity()));
            IgniteLogger log = this.getLog();
            if (log != null && log.isInfoEnabled()) {
                log.info("Send CollectSnapshotInfoJob on " + jobs.size() + " nodes");
            }
            return jobs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) throws IgniteException {
            CollectSnapshotInfoTaskResult data;
            if (res.getException() != null) {
                return super.result(res, rcvd);
            }
            JdkMarshaller jdkMarshaller = new JdkMarshaller();
            IgniteLogger log = this.getLog();
            Object data0 = res.getData();
            if (data0 instanceof byte[]) {
                try {
                    data = (CollectSnapshotInfoTaskResult)jdkMarshaller.unmarshal((byte[])data0, U.resolveClassLoader((IgniteConfiguration)this.ignite.configuration()));
                }
                catch (IgniteCheckedException e) {
                    U.error((IgniteLogger)log, (Object)("Failed to deserialize job execution result (will skip the node): " + U.toShortString((ClusterNode)res.getNode())), (Throwable)e);
                    return ComputeJobResultPolicy.WAIT;
                }
            } else {
                data = (CollectSnapshotInfoTaskResult)data0;
            }
            SnapshotDescriptorOptional e = this.taskRes;
            synchronized (e) {
                if (!this.taskRes.isPresent() && log != null && log.isInfoEnabled()) {
                    log.info("Starting reducing CollectSnapshotInfoTaskResult");
                }
            }
            if (data == null || data.descriptorForNode().isEmpty()) {
                this.taskRes.reportMissOnNode(res.getNode().id());
            } else {
                try {
                    for (Map.Entry entry : data.descriptorForNode().entrySet()) {
                        this.taskRes.merge((SnapshotDescriptor)entry.getValue());
                    }
                }
                catch (IgniteCheckedException e2) {
                    throw new IgniteException((Throwable)e2);
                }
            }
            return ComputeJobResultPolicy.WAIT;
        }

        public SnapshotDescriptorOptional reduce(List<ComputeJobResult> results) throws IgniteException {
            IgniteLogger log = this.getLog();
            if (log != null && log.isInfoEnabled()) {
                log.info("Finished reducing CollectSnapshotDescriptorTask");
            }
            return this.taskRes;
        }
    }
}

