/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.gridgain.grid.internal.processors.cache.database.SnapshotTaskBase;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class CollectDependantSnapshotSetTask
extends SnapshotTaskBase<T2<Long, Set<Integer>>, NavigableSet<Long>> {
    private static final long serialVersionUID = 0L;

    @Nullable
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable T2<Long, Set<Integer>> snapshotIdWithCaches) throws IgniteException {
        HashMap<CollectDependantSnapshotSetJob, ClusterNode> jobs = new HashMap<CollectDependantSnapshotSetJob, ClusterNode>();
        Collection baselineNodes = this.ignite.context().discovery().discoCache().aliveBaselineNodes();
        Collection<Object> nodes = baselineNodes == null ? subgrid : baselineNodes;
        for (ClusterNode clusterNode : nodes) {
            if (clusterNode.isClient() || clusterNode.isDaemon()) continue;
            jobs.put(new CollectDependantSnapshotSetJob((Long)snapshotIdWithCaches.get1(), (Collection)snapshotIdWithCaches.get2()), clusterNode);
        }
        return jobs;
    }

    @Nullable
    public NavigableSet<Long> reduce(List<ComputeJobResult> results) throws IgniteException {
        TreeSet<Long> taskResult = new TreeSet<Long>(Collections.reverseOrder());
        for (ComputeJobResult result : results) {
            taskResult.addAll((Collection)result.getData());
        }
        return taskResult;
    }

    @GridInternal
    private static class CollectDependantSnapshotSetJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        protected Ignite ignite;
        private final long snapshotId;
        private final Collection<Integer> cacheGrpIds;

        private CollectDependantSnapshotSetJob(Long snapshotId, Collection<Integer> cacheGrpIds) {
            this.snapshotId = snapshotId;
            this.cacheGrpIds = cacheGrpIds;
        }

        @Nullable
        public Object execute() throws IgniteException {
            IgniteCacheSnapshotManager snpMgr = ((IgniteEx)this.ignite).context().cache().context().snapshot();
            if (!(snpMgr instanceof GridCacheSnapshotManager)) {
                return null;
            }
            GridCacheSnapshotManager snapshotMgr = (GridCacheSnapshotManager)snpMgr;
            try {
                return snapshotMgr.collectDependentSnapshotIds(this.snapshotId, this.cacheGrpIds);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException((Throwable)e);
            }
        }
    }
}

