/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.gridgain.grid.internal.io.SnapshotReadableByteChannel;

public class GridReadableByteChannel
extends AbstractInterruptibleChannel
implements SnapshotReadableByteChannel {
    private static final int TRANSFER_SIZE = 8192;
    private static final ThreadLocal<byte[]> BUFFER = ThreadLocal.withInitial(() -> new byte[8192]);
    private final InputStream in;
    private final Object readLock = new Object();

    public GridReadableByteChannel(InputStream in) {
        this.in = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        int len = dst.remaining();
        byte[] buf = BUFFER.get();
        int bytesRead = 0;
        Object object = this.readLock;
        synchronized (object) {
            int totalRead;
            for (totalRead = 0; totalRead < len; totalRead += bytesRead) {
                int bytesToRead = Math.min(len - totalRead, 8192);
                if (buf.length < bytesToRead) {
                    buf = new byte[bytesToRead];
                }
                if (totalRead > 0 && this.in.available() <= 0) break;
                try {
                    this.begin();
                    bytesRead = this.in.read(buf, 0, bytesToRead);
                    this.end(bytesRead > 0);
                }
                catch (Throwable throwable) {
                    this.end(bytesRead > 0);
                    throw throwable;
                }
                if (bytesRead < 0) break;
                dst.put(buf, 0, bytesRead);
            }
            if (bytesRead < 0 && totalRead == 0) {
                return -1;
            }
            return totalRead;
        }
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.in.close();
    }
}

