/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import junit.framework.TestCase;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.gridgain.grid.internal.processors.cache.database.snapshot.FutureTaskQueue;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotProgressCalculator;
import org.gridgain.grid.persistentstore.SnapshotOperationInfo;
import org.mockito.Mockito;

public class FutureTaskQueueTest
extends TestCase {
    volatile boolean cancelled;
    SnapshotOperationContext snapshotOperationContext = new SnapshotOperationContext(){

        public boolean isCancelled() {
            return FutureTaskQueueTest.this.cancelled;
        }

        public void setProgressCalculator(SnapshotProgressCalculator snapshotProgressCalculator) {
        }

        public void progress(long processed, long total) {
        }

        public void reportWork(long amountOfWork) {
        }

        public SnapshotOperationInfo snapshotOperationInfo() {
            return null;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAwaitCompletion() {
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(4);
        try {
            FutureTaskQueue futureTaskQueue = new FutureTaskQueue((ExecutorService)executorService, (IgniteLogger)Mockito.mock(IgniteLogger.class));
            futureTaskQueue.setTaskProcessor((Function)new Function<Integer, Runnable>(){

                @Override
                public Runnable apply(Integer integer) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    };
                }
            });
            futureTaskQueue.submitTask((Object)1);
            executorService.schedule(new Runnable(){

                @Override
                public void run() {
                    FutureTaskQueueTest.this.cancelled = true;
                }
            }, 1L, TimeUnit.SECONDS);
            try {
                futureTaskQueue.awaitCompletion(this.snapshotOperationContext);
                FutureTaskQueueTest.fail((String)"awaitCompletion should interrupt with operation cancelled exception!");
            }
            catch (IgniteCheckedException e) {
                FutureTaskQueueTest.assertEquals((String)"Snapshot operation has been cancelled", (String)e.getMessage());
            }
            try {
                futureTaskQueue.awaitCompletionWithShutdown(this.snapshotOperationContext, false);
                FutureTaskQueueTest.fail((String)"awaitCompletion should interrupt with operation cancelled exception!");
            }
            catch (IgniteCheckedException e) {
                FutureTaskQueueTest.assertEquals((String)"Snapshot operation has been cancelled", (String)e.getMessage());
            }
        }
        finally {
            executorService.shutdownNow();
        }
    }
}

