/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.RecoveryParams;
import org.gridgain.grid.persistentstore.MoveSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotPath;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GridSimpleRecoverySelfTest
extends GridCommonAbstractTest {
    private static final long SNAPSHOT_FUTURE_TIME_OUT = 60000L;
    @Parameterized.Parameter
    public boolean dfltSnapshotDir;
    @Parameterized.Parameter(value=1)
    public boolean incSnapshot;

    @Parameterized.Parameters(name="dfltSnapshotDir={0}, incSnapshot={1}")
    public static Collection<Object[]> testParameters() {
        return Arrays.asList({true, false}, {true, true}, {false, false}, {false, true});
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void cleanPersistenceDir() throws Exception {
        super.cleanPersistenceDir();
        File workDir = new File(U.defaultWorkDirectory());
        for (File snapshotDir : F.asList((Object[])workDir.listFiles(p -> p.getName().startsWith("snapshot")))) {
            U.delete((File)snapshotDir);
        }
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        String nodeId = igniteInstanceName.replace(this.getTestIgniteInstanceName(), "").trim();
        return super.getConfiguration(igniteInstanceName).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("default").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 4))}).setDataStorageConfiguration(new DataStorageConfiguration().setWalMode(WALMode.LOG_ONLY).setCheckpointFrequency(60000L).setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x6400000L).setPersistenceEnabled(true))).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration().setPointInTimeRecoveryEnabled(true).setSnapshotsPath("snapshot" + (this.dfltSnapshotDir ? "" : nodeId)))});
    }

    @Test
    public void testLocalOnly() throws Exception {
        IgniteEx n = this.startCluster(2);
        this.putRange(n, 0, 10);
        GridSnapshotEx snapshotEx = this.snapshotEx(n);
        snapshotEx.createFullSnapshot(null, "full").get(60000L);
        if (!this.incSnapshot) {
            this.putRange(n, 10, 20);
        } else {
            this.putRange(n, 10, 15);
            snapshotEx.createSnapshot(null, "inc").get(60000L);
            this.putRange(n, 15, 20);
        }
        this.forceCheckpoint();
        long pitr = System.currentTimeMillis();
        Thread.sleep(1000L);
        this.putRange(n, 20, 30);
        GridSimpleRecoverySelfTest.assertEquals((int)30, (int)this.totalCacheSize(n));
        snapshotEx.recoveryTo(new RecoveryParams().time(pitr)).get(60000L);
        GridSimpleRecoverySelfTest.assertEquals((int)20, (int)this.totalCacheSize(n));
    }

    @Test
    public void testOneShared() throws Exception {
        IgniteEx n = this.startCluster(2);
        this.putRange(n, 0, 10);
        GridSnapshotEx snapshotEx = this.snapshotEx(n);
        SnapshotFuture fullFut = snapshotEx.createFullSnapshot(null, "full");
        fullFut.get(60000L);
        this.putRange(n, 10, 12);
        SnapshotFuture incFut = snapshotEx.createSnapshot(null, "inc0");
        incFut.get(60000L);
        this.putRange(n, 12, 15);
        snapshotEx.createSnapshot(null, "inc1").get(60000L);
        this.putRange(n, 15, 20);
        this.forceCheckpoint();
        long pitr = System.currentTimeMillis();
        Thread.sleep(1000L);
        this.putRange(n, 20, 30);
        GridSimpleRecoverySelfTest.assertEquals((int)30, (int)this.totalCacheSize(n));
        long id = (this.incSnapshot ? incFut : fullFut).snapshotOperation().snapshotId();
        File moveDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshotmove", (boolean)false);
        SnapshotPath snapshotPath = SnapshotPath.file().path(moveDir).build();
        snapshotEx.move(new MoveSnapshotParams().chainMode(SnapshotChainMode.SINGLE).snapshotId(id).destinationPath(snapshotPath).deleteSources(true)).get(60000L);
        snapshotEx.recoveryTo(new RecoveryParams().time(pitr).optionalSearchPaths((Collection)F.asList((Object)snapshotPath))).get(60000L);
        GridSimpleRecoverySelfTest.assertEquals((int)20, (int)this.totalCacheSize(n));
    }

    private IgniteEx startCluster(int cnt) throws Exception {
        IgniteEx n = this.startGrids(cnt);
        n.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        return n;
    }

    private GridSnapshotEx snapshotEx(IgniteEx n) {
        return (GridSnapshotEx)((GridGain)n.plugin("GridGain")).snapshot();
    }

    private void putRange(IgniteEx n, int s, int e) {
        for (int i = s; i < e; ++i) {
            n.cache("default").put((Object)i, (Object)("String" + Integer.toHexString(i)));
        }
    }

    private int totalCacheSize(IgniteEx n) {
        return n.cache("default").size(new CachePeekMode[0]);
    }
}

