/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.ignite.Ignite;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemandMessage;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.testframework.junits.SystemPropertiesList;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.junit.Test;

@SystemPropertiesList(value={@WithSystemProperty(key="recording-communication-spi", value="true"), @WithSystemProperty(key="IGNITE_DISABLE_REBALANCING_CANCELLATION_OPTIMIZATION", value="false")})
public class SnapshotWithRebalanceTest
extends AbstractSnapshotTest {
    protected static IgniteEx ignite;
    protected static GridGain gg;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.stopAllGrids();
        this.cleanSnapshotDirs();
        ignite = this.startGrids(3);
        ignite.active(true);
        gg = (GridGain)ignite.plugin("GridGain");
        this.load((Ignite)ignite);
    }

    @Override
    protected int getBackupCount() {
        return 1;
    }

    @Test
    public void snasphotNotScheduleRebalance() throws Exception {
        this.notScheduleRebalance((IgniteRunnable & Serializable)() -> {
            Void cfr_ignored_0 = (Void)gg.snapshot().createFullSnapshot(null, "Test full snasphot").get();
        });
    }

    @Test
    public void incrementalSnasphotAfterFullNotScheduleRebalance() throws Exception {
        this.notScheduleRebalance((IgniteRunnable & Serializable)() -> {
            gg.snapshot().createFullSnapshot(null, "Test full snasphot").get();
            gg.snapshot().createSnapshot(null, "Test incremental snasphot").get();
        });
    }

    public void notScheduleRebalance(IgniteRunnable closure) throws Exception {
        int i;
        this.grid(1).close();
        this.load((Ignite)ignite, 1);
        TestRecordingCommunicationSpi commSpi1 = this.startNodeWithBlockingRebalance(this.getTestIgniteInstanceName(1));
        commSpi1.waitForBlocked();
        ArrayList<IgniteInternalFuture<Boolean>> beforeCreateFutures = this.getAllRebalanceFutures(this.grid(1));
        closure.run();
        ArrayList<IgniteInternalFuture<Boolean>> afterCreateFutures = this.getAllRebalanceFutures(this.grid(1));
        SnapshotWithRebalanceTest.assertTrue((String)("Before: " + beforeCreateFutures.size() + " after: " + afterCreateFutures.size()), (beforeCreateFutures.size() == afterCreateFutures.size() ? 1 : 0) != 0);
        for (i = 0; i < beforeCreateFutures.size(); ++i) {
            SnapshotWithRebalanceTest.assertSame(beforeCreateFutures.get(i), afterCreateFutures.get(i));
        }
        commSpi1.stopBlock();
        this.awaitPartitionMapExchange();
        for (i = 0; i < beforeCreateFutures.size(); ++i) {
            SnapshotWithRebalanceTest.assertTrue((String)this.futInfoString(beforeCreateFutures.get(i)), (beforeCreateFutures.get(i).isDone() && (Boolean)beforeCreateFutures.get(i).get() != false ? 1 : 0) != 0);
        }
    }

    private String futInfoString(IgniteInternalFuture<Boolean> rebalanceFuture) {
        return "Fut: " + rebalanceFuture + " is done: " + rebalanceFuture.isDone() + " result: " + (rebalanceFuture.isDone() ? (Serializable)rebalanceFuture.result() : "NoN");
    }

    private TestRecordingCommunicationSpi startNodeWithBlockingRebalance(String name) throws Exception {
        IgniteConfiguration cfg = this.optimize(this.getConfiguration(name));
        TestRecordingCommunicationSpi communicationSpi = (TestRecordingCommunicationSpi)cfg.getCommunicationSpi();
        communicationSpi.blockMessages((IgniteBiPredicate & Serializable)(node, msg) -> {
            if (msg instanceof GridDhtPartitionDemandMessage) {
                GridDhtPartitionDemandMessage demandMessage = (GridDhtPartitionDemandMessage)msg;
                if (CU.cacheId((String)"Group2") != demandMessage.groupId() && CU.cacheId((String)"cache1") != demandMessage.groupId()) {
                    return false;
                }
                this.info("Message was caught: " + msg.getClass().getSimpleName() + " rebalanceId = " + U.field((Object)demandMessage, (String)"rebalanceId") + " to: " + node.consistentId() + " by cache id: " + demandMessage.groupId());
                return true;
            }
            return false;
        });
        this.startGrid(cfg);
        return communicationSpi;
    }

    private ArrayList<IgniteInternalFuture<Boolean>> getAllRebalanceFutures(IgniteEx ignite) {
        ArrayList<IgniteInternalFuture<Boolean>> futs = new ArrayList<IgniteInternalFuture<Boolean>>();
        for (CacheGroupContext grp : ignite.context().cache().cacheGroups()) {
            if (!"Group2".equals(grp.cacheOrGroupName()) && !"cache1".equals(grp.cacheOrGroupName())) continue;
            IgniteInternalFuture fut = grp.preloader().rebalanceFuture();
            futs.add((IgniteInternalFuture<Boolean>)fut);
            SnapshotWithRebalanceTest.assertFalse((String)("Rebalance future for group " + grp.cacheOrGroupName() + " is already done."), (boolean)fut.isDone());
        }
        return futs;
    }
}

