/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCacheRestartingException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsFullMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsSingleMessage;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class SnapshotRestartCacheProxyTest
extends AbstractSnapshotTest {
    private static final String CACHE_NAME = "cache1";
    private static final int ENTRIES_COUNT = 5000;
    private static final int PARTS = 16;
    private static final int GRID_COUNT = 3;
    private Set<String> snapshotDirs = new HashSet<String>();
    private volatile CountDownLatch singleMsgLatch;
    private volatile CountDownLatch fullMapLatch;
    private volatile boolean skipMessageProcessing = true;
    private CacheConfiguration cacheCfg;

    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        this.cacheCfg = new CacheConfiguration();
        this.cacheCfg.setName(CACHE_NAME);
        this.cacheCfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        this.cacheCfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        this.cacheCfg.setCacheMode(CacheMode.PARTITIONED);
        this.cacheCfg.setBackups(1);
        this.cacheCfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 16));
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheCfg});
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        SnapshotConfiguration ggDbCfg = new SnapshotConfiguration();
        ggCfg.setSnapshotConfiguration(ggDbCfg);
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        cfg.setDataStorageConfiguration(cfg.getDataStorageConfiguration().setWalMode(WALMode.LOG_ONLY).setCheckpointFrequency(1000L));
        cfg.setConsistentId((Serializable)((Object)gridName));
        cfg.setCommunicationSpi((CommunicationSpi)new TestCommunicationSpi());
        this.snapshotDirs.add(gridName);
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.singleMsgLatch = new CountDownLatch(2);
        this.fullMapLatch = new CountDownLatch(1);
        this.stopAllGrids();
        this.deleteWorkFiles();
    }

    @Override
    protected void afterTest() throws Exception {
        for (int i = 0; i < 2; ++i) {
            this.singleMsgLatch.countDown();
        }
        this.fullMapLatch.countDown();
        this.stopAllGrids();
        this.deleteWorkFiles();
    }

    @Test
    public void testRestartProxy() throws Exception {
        CountDownLatch restorePauseLatch = new CountDownLatch(1);
        CountDownLatch restoreStartLatch = this.nextRestoreShouldAwait(restorePauseLatch);
        this.startGrids(3);
        IgniteEx ig = this.ignite(0);
        ig.cluster().active(true);
        this.awaitPartitionMapExchange();
        final IgniteCache cache = ig.getOrCreateCache(CACHE_NAME);
        for (int i = 0; i < 5000; ++i) {
            cache.put((Object)i, (Object)i);
        }
        GridGain gg = (GridGain)ig.plugin("GridGain");
        SnapshotFuture snapshotFut = gg.snapshot().createFullSnapshot(null, null);
        snapshotFut.get();
        SnapshotFuture restoreFut = gg.snapshot().restoreSnapshot(snapshotFut.snapshotOperation().snapshotId(), null, null);
        SnapshotRestartCacheProxyTest.assertTrue((boolean)restoreStartLatch.await(this.getTestTimeout(), TimeUnit.MILLISECONDS));
        this.skipMessageProcessing = false;
        GridTestUtils.assertThrows(null, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                cache.put((Object)-1, (Object)-1);
                return null;
            }
        }, IgniteCacheRestartingException.class, null);
        restorePauseLatch.countDown();
        this.singleMsgLatch.await();
        try {
            cache.put((Object)0, (Object)0);
            SnapshotRestartCacheProxyTest.fail();
        }
        catch (IgniteCacheRestartingException igniteCacheRestartingException) {
            // empty catch block
        }
        for (int i = 0; i < 3; ++i) {
            try {
                this.ignite(i).getOrCreateCache(CACHE_NAME).put((Object)(-i), (Object)(-i));
                SnapshotRestartCacheProxyTest.fail();
                continue;
            }
            catch (IgniteCacheRestartingException igniteCacheRestartingException) {
                // empty catch block
            }
        }
        SnapshotRestartCacheProxyTest.assertFalse((boolean)restoreFut.isDone());
        this.fullMapLatch.countDown();
        restoreFut.get();
    }

    @Test
    public void testDeferredRestartProxy() throws Exception {
        int i;
        this.startGrids(3);
        IgniteEx ig = this.ignite(0);
        ig.active(true);
        this.awaitPartitionMapExchange();
        final IgniteCache cache = ig.getOrCreateCache(CACHE_NAME);
        for (int i2 = 0; i2 < 5000; ++i2) {
            cache.put((Object)i2, (Object)i2);
        }
        IgniteUuid restartId = IgniteUuid.randomUuid();
        IgniteInternalFuture stopFut = ig.context().cache().dynamicDestroyCache(CACHE_NAME, false, false, true, restartId);
        stopFut.get();
        this.skipMessageProcessing = false;
        IgniteInternalFuture startFut = ig.context().cache().dynamicStartCachesByStoredConf(Collections.singleton(new StoredCacheData(this.cacheCfg)), true, true, true, restartId, true);
        this.singleMsgLatch.await();
        GridTestUtils.assertThrows(null, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                cache.put((Object)-1, (Object)-1);
                return null;
            }
        }, IgniteCacheRestartingException.class, null);
        this.fullMapLatch.countDown();
        startFut.get();
        Thread.sleep(5000L);
        GridTestUtils.assertThrows(null, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                cache.put((Object)-1, (Object)-1);
                return null;
            }
        }, IgniteCacheRestartingException.class, null);
        for (i = 0; i < 3; ++i) {
            this.ignite(i).context().cache().restartProxies();
        }
        cache.put((Object)0, (Object)0);
        for (i = 0; i < 3; ++i) {
            this.ignite(i).getOrCreateCache(CACHE_NAME).put((Object)(-i), (Object)(-i));
        }
    }

    private void deleteWorkFiles() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
        for (String snapshotDir : this.snapshotDirs) {
            U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)snapshotDir, (boolean)false));
        }
    }

    private class TestCommunicationSpi
    extends TcpCommunicationSpi {
        private TestCommunicationSpi() {
        }

        public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) throws IgniteSpiException {
            if (msg instanceof GridIoMessage) {
                this.onSendMessage(node, ((GridIoMessage)msg).message());
            }
            super.sendMessage(node, msg, ackC);
        }

        public void sendMessage(ClusterNode node, Message msg) throws IgniteSpiException {
            if (msg instanceof GridIoMessage) {
                this.onSendMessage(node, ((GridIoMessage)msg).message());
            }
            super.sendMessage(node, msg);
        }

        private void onSendMessage(ClusterNode node, Message msg) {
            if (SnapshotRestartCacheProxyTest.this.skipMessageProcessing) {
                return;
            }
            if (msg instanceof GridDhtPartitionsSingleMessage) {
                SnapshotRestartCacheProxyTest.this.singleMsgLatch.countDown();
            } else if (msg instanceof GridDhtPartitionsFullMessage) {
                try {
                    SnapshotRestartCacheProxyTest.this.fullMapLatch.await();
                }
                catch (InterruptedException e) {
                    throw new IgniteInterruptedException(e);
                }
            }
        }
    }
}

