/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class IgniteDbSnasphotWithPartitionMoreThan2Gigabyte
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        TcpDiscoverySpi discoverySpi = (TcpDiscoverySpi)cfg.getDiscoverySpi();
        discoverySpi.setIpFinder(ipFinder);
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(1048576000L).setPersistenceEnabled(true)).setWalMode(WALMode.LOG_ONLY);
        cfg.setDataStorageConfiguration(memCfg);
        CacheConfiguration ccfg = new CacheConfiguration();
        ccfg.setName("default");
        ccfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 1));
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        SnapshotConfiguration ggDbCfg = new SnapshotConfiguration();
        ggCfg.setSnapshotConfiguration(ggDbCfg);
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        cfg.setConsistentId((Serializable)((Object)gridName));
        return cfg;
    }

    @Test
    public void testMain() throws Exception {
        IgniteEx ig = this.startGrid(0);
        ig.active(true);
        byte[] b = new byte[0x100000];
        try (IgniteDataStreamer ldr = ig.dataStreamer("default");){
            HashMap<Integer, byte[]> map = new HashMap<Integer, byte[]>();
            for (int i = 0; i < 2500; ++i) {
                map.put(i, b);
            }
            ldr.addData(map);
        }
        GridGain gg = (GridGain)ig.plugin("GridGain");
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), null, null).get();
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.deleteWorkFiles();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.deleteWorkFiles();
    }

    private void deleteWorkFiles() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
    }
}

