/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipInputStream;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.managers.discovery.CustomEventListener;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.file.AsyncFileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.MarkerPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.ByteBufferExpander;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.FastCrc;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.FileInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SimpleFileInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactoryImpl;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyResultV2;
import org.apache.ignite.internal.processors.cache.verify.VerifyBackupPartitionsTaskV2;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.verify.CacheFilterEnum;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskArg;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.junits.GridAbstractTest;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionOptimisticException;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.messages.CancelSnapshotOperationMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.SnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.StartSnapshotOperationAckDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotIssue;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.junit.Test;

public class IgniteDbSnapshotWithoutExchangeTest
extends GridCommonAbstractTest {
    private static final int NODES_COUNT = 4;
    private static final int KEYS_CNT = 100;
    private static final String ATOMIC_CACHE_NAME = "test-atomic-cache";
    private static IgniteEx ignite;
    private static GridGain gg;
    private final AtomicBoolean txRun = new AtomicBoolean(false);
    protected static final Set<String> snapshotDirs;
    private LogListener partValidationFailedLsnr = LogListener.matches((String)"Partition states validation has failed for group").build();
    private final ListeningTestLogger testLog = new ListeningTestLogger(this.log(), new LogListener[]{this.partValidationFailedLsnr});
    private final AtomicBoolean atomicRun = new AtomicBoolean(false);

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        FileDatabaseSnapshotSpi spi = new FileDatabaseSnapshotSpi();
        String cId = "consistentId-" + igniteInstanceName;
        String dir = new File(this.snapshotsDir(), cId).getPath();
        snapshotDirs.add(dir);
        spi.setSnapshotDirectory(dir);
        if (GridCacheSnapshotManager.TEST_SNAPSHOT_SPI.get() == null) {
            GridCacheSnapshotManager.TEST_SNAPSHOT_SPI.set(spi);
        }
        return super.getConfiguration(igniteInstanceName).setConsistentId((Serializable)((Object)cId)).setCommunicationSpi((CommunicationSpi)new TestRecordingCommunicationSpi()).setClientMode(igniteInstanceName.contains("client")).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("default").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 100)).setBackups(2), new CacheConfiguration(ATOMIC_CACHE_NAME).setAtomicityMode(CacheAtomicityMode.ATOMIC).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 16)).setBackups(2)}).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration().setSnapshotsPath(this.snapshotsDir().getPath()))}).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true))).setGridLogger((IgniteLogger)this.testLog);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        for (String dir : snapshotDirs) {
            U.delete((File)new File(dir));
        }
        snapshotDirs.clear();
        this.partValidationFailedLsnr.reset();
    }

    protected void afterTest() throws Exception {
        for (String dir : snapshotDirs) {
            U.delete((File)new File(dir));
        }
        snapshotDirs.clear();
        this.partValidationFailedLsnr.reset();
        super.afterTest();
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.cleanIgniteWorkDir();
        ignite = this.startGrids(4);
        ignite.cluster().state(ClusterState.ACTIVE);
        gg = (GridGain)ignite.plugin("GridGain");
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        this.cleanIgniteWorkDir();
        super.afterTestsStopped();
    }

    private void cleanIgniteWorkDir() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)this.snapshotsDir());
    }

    private File snapshotsDir() throws IgniteCheckedException {
        return U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshots", (boolean)false);
    }

    private long testCreateSnapshot(boolean exchangelessSnapshot, boolean compression, CorruptType corruptBeforeCheck) throws Exception {
        int beforeCreateVer = ignite.context().discovery().topologyVersionEx().minorTopologyVersion();
        ConsistentCutTestListener cutLsnr = new ConsistentCutTestListener();
        ((GridCacheSnapshotManager)ignite.context().cache().context().snapshot()).registerConsistentCutStoreListener((IgniteInClosure)cutLsnr);
        ((GridCacheDatabaseSharedManager)ignite.context().cache().context().database()).addCheckpointListener((CheckpointListener)new CheckpointDelayListener());
        IgniteInternalFuture<Long> txFut = this.txLoad(5);
        IgniteInternalFuture<Long> atomicFut = this.atomicLoad(5);
        IgniteDbSnapshotWithoutExchangeTest.doSleep((long)3000L);
        SnapshotCreateParameters createParams = compression ? new SnapshotCreateParameters(CompressionOption.ZIP, 1) : new SnapshotCreateParameters(CompressionOption.NONE, -1, 0);
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(new HashSet<String>(Arrays.asList("default", ATOMIC_CACHE_NAME)), null, createParams, null);
        long snapshotId = fut.snapshotOperation().snapshotId();
        fut.get();
        this.txRun.set(false);
        this.atomicRun.set(false);
        txFut.get();
        atomicFut.get();
        int afterCreateVer = ignite.context().discovery().topologyVersionEx().minorTopologyVersion();
        IgniteDbSnapshotWithoutExchangeTest.assertEquals((boolean)exchangelessSnapshot, (beforeCreateVer == afterCreateVer ? 1 : 0) != 0);
        this.checkSnapshot(ignite, snapshotId, exchangelessSnapshot, corruptBeforeCheck, cutLsnr.consistentCut(), compression, exchangelessSnapshot);
        if (corruptBeforeCheck == CorruptType.NONE) {
            beforeCreateVer = ignite.context().discovery().topologyVersionEx().minorTopologyVersion();
            fut = gg.snapshot().createSnapshot(Collections.singleton("default"), null);
            fut.get();
            afterCreateVer = ignite.context().discovery().topologyVersionEx().minorTopologyVersion();
            IgniteDbSnapshotWithoutExchangeTest.assertEquals((boolean)exchangelessSnapshot, (beforeCreateVer == afterCreateVer ? 1 : 0) != 0);
        }
        return snapshotId;
    }

    private int calcCrcForBufInFile(File file, int off, int bufSize) throws IOException {
        try (RandomAccessFile f = new RandomAccessFile(file, "r");){
            byte[] bytes = new byte[bufSize];
            f.seek(off);
            f.read(bytes);
            int n = FastCrc.calcCrc((ByteBuffer)ByteBuffer.wrap(bytes), (int)bufSize);
            return n;
        }
    }

    private void writeBytesToFile(File file, int off, byte[] v) throws IOException {
        try (RandomAccessFile f = new RandomAccessFile(file, "rw");){
            f.seek(off);
            f.write(v);
        }
    }

    private byte[] trashBytes(int len) {
        byte[] trash = new byte[len];
        ThreadLocalRandom.current().nextBytes(trash);
        return trash;
    }

    private ByteBuffer wrapInt(int v) {
        return ByteBuffer.allocate(4).order(ByteOrder.nativeOrder()).putInt(v);
    }

    private void corruptFiles(long snapshotId, CorruptType corruptBeforeCheck, boolean compression, boolean exchangeless) throws IOException, IgniteCheckedException {
        int pageSize = ignite.context().config().getDataStorageConfiguration().getPageSize();
        ClusterNode clusterNode = ignite.cluster().localNode();
        int partId = ignite.affinity("default").allPartitions(clusterNode)[0];
        Path path = SnapshotUtils.buildPartitionPath((Path)this.getSnapshotFolder(clusterNode.consistentId(), snapshotId).toPath(), (int)CU.cacheId((String)"default"), (int)partId);
        IgniteDbSnapshotWithoutExchangeTest.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
        log.warning("Test: corrupting partition [nodeId=" + clusterNode.id() + ", cacheName=" + "default" + ", partId=" + partId + ", corruptType=" + (Object)((Object)corruptBeforeCheck) + "]");
        if (corruptBeforeCheck == CorruptType.CORRUPT_PAGE) {
            this.writeBytesToFile(path.toFile(), 0, this.trashBytes(10));
        } else if (corruptBeforeCheck == CorruptType.CORRUPT_WAL) {
            int off = this.walRecordsOffset((ReadableByteChannel)this.fileChannel((Path)path, (boolean)compression), (int)pageSize).walRecordsOff;
            if (exchangeless && off != -1) {
                this.writeBytesToFile(path.toFile(), off + 1 + 12, new byte[10]);
            } else {
                log.warning("Test: partition corruption cancelled: snapshot is not exchangeless and corrupt type is " + (Object)((Object)corruptBeforeCheck));
            }
        } else if (corruptBeforeCheck == CorruptType.CORRUPT_WAL_REC_CNT) {
            MarkerInfo markerInfo = this.walRecordsOffset(this.fileChannel(path, compression), pageSize);
            this.writeBytesToFile(path.toFile(), markerInfo.walRecordsOff - pageSize + 48, this.trashBytes(4));
            int crcOff = markerInfo.walRecordsOff - pageSize + 4;
            this.writeBytesToFile(path.toFile(), crcOff, this.wrapInt(0).array());
            int newCrc = this.calcCrcForBufInFile(path.toFile(), markerInfo.walRecordsOff - pageSize, pageSize);
            this.writeBytesToFile(path.toFile(), crcOff, this.wrapInt(newCrc).array());
            log.info("Test: CRC has been rewritten [cache=default, partId=" + partId + ", offset=" + crcOff + ", len=" + pageSize + ", crc=" + newCrc + "]");
        } else if (corruptBeforeCheck == CorruptType.CORRUPT_MARKER_PAGE) {
            int off = this.walRecordsOffset((ReadableByteChannel)this.fileChannel((Path)path, (boolean)compression), (int)pageSize).walRecordsOff;
            this.writeBytesToFile(path.toFile(), off - pageSize + 0, new byte[]{-1, -1});
            this.writeBytesToFile(path.toFile(), off - pageSize + 2, new byte[]{-1, -1});
        }
    }

    private void checkSnapshot(IgniteEx ignite, long snapshotId, boolean checkFiles, CorruptType corruptBeforeCheck, ConsistentCut cut, boolean compression, boolean exchangeless) throws IgniteCheckedException, IOException {
        if (corruptBeforeCheck != CorruptType.NONE) {
            this.corruptFiles(snapshotId, corruptBeforeCheck, compression, exchangeless);
        }
        SnapshotFuture fut = gg.snapshot().checkSnapshot(snapshotId, Collections.singleton(this.snapshotsDir()), false, null);
        List issues = (List)fut.get();
        IgniteDbSnapshotWithoutExchangeTest.assertEquals((String)("issues=" + issues + ", corruptBeforeCheck=" + (Object)((Object)corruptBeforeCheck) + ", exchangeless=" + exchangeless), (boolean)GridFunc.isEmpty((Collection)issues), (corruptBeforeCheck == CorruptType.NONE || corruptBeforeCheck.walRelatedCorruption() && !exchangeless ? 1 : 0) != 0);
        if (!GridFunc.isEmpty((Collection)issues)) {
            for (SnapshotIssue issue : issues) {
                log.error(issue.toString());
                this.checkIssue(corruptBeforeCheck, issue);
            }
            if (corruptBeforeCheck == CorruptType.NONE) {
                IgniteDbSnapshotWithoutExchangeTest.fail();
            }
        }
        if (checkFiles && corruptBeforeCheck == CorruptType.NONE) {
            this.checkSnapshotFiles(ignite, fut.snapshotOperation().snapshotId(), cut, compression);
        }
    }

    private void checkIssue(CorruptType corruptType, SnapshotIssue issue) {
        if (corruptType == CorruptType.CORRUPT_WAL) {
            GridTestUtils.assertContains((IgniteLogger)log, (String)issue.getIssue(), (String)"Error occured when reading WAL from snapshot file");
        } else if (corruptType == CorruptType.CORRUPT_WAL_REC_CNT) {
            GridTestUtils.assertContains((IgniteLogger)log, (String)issue.getIssue(), (String)"WAL records count from marker page and actual records count are different, partition is possibly corrupted");
        } else if (corruptType == CorruptType.CORRUPT_MARKER_PAGE) {
            GridTestUtils.assertContains((IgniteLogger)log, (String)issue.getIssue(), (String)"Unexpected negative page index found, page is corrupted");
        }
    }

    private IgniteInternalFuture<Long> txLoad(int threads) {
        IgniteEx ignite = this.grid(ThreadLocalRandom.current().nextInt(4));
        IgniteCache cache = ignite.cache("default");
        cache.clear();
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)i, (Object)(ThreadLocalRandom.current().nextInt(1000) + 1000));
        }
        this.txRun.set(true);
        return GridTestUtils.runMultiThreadedAsync(() -> this.lambda$txLoad$0((Ignite)ignite, cache), (int)threads, (String)"tx-load-thread");
    }

    private IgniteInternalFuture<Long> atomicLoad(int threads) {
        IgniteEx ignite = this.grid(ThreadLocalRandom.current().nextInt(4));
        IgniteCache cache = ignite.cache(ATOMIC_CACHE_NAME);
        cache.clear();
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)i, (Object)(ThreadLocalRandom.current().nextInt(1000) + 1000));
        }
        this.atomicRun.set(true);
        return GridTestUtils.runMultiThreadedAsync(() -> {
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            while (this.atomicRun.get()) {
                int op = rnd.nextInt(10);
                if (op == 0) {
                    cache.remove((Object)rnd.nextInt(100));
                    continue;
                }
                if (op < 2) {
                    TreeMap<Integer, Integer> updates = new TreeMap<Integer, Integer>();
                    for (int i = 0; i < 7; ++i) {
                        updates.put(rnd.nextInt(100), rnd.nextInt(1000));
                    }
                    cache.putAll(updates);
                    continue;
                }
                cache.put((Object)rnd.nextInt(100), (Object)rnd.nextInt(1000));
            }
        }, (int)threads, (String)"atomic-load-thread");
    }

    /*
     * Unable to fully structure code
     */
    private void checkSnapshotFiles(IgniteEx ignite, long snapshotId, ConsistentCut cut, boolean compression) throws IgniteCheckedException, IOException {
        pageSize = ignite.context().config().getDataStorageConfiguration().getPageSize();
        bufSize = ignite.context().config().getDataStorageConfiguration().getWalRecordIteratorBufferSize();
        serializer = this.getRecordSerializer(ignite);
        clusterNodes = ignite.cluster().nodes();
        keysFound = new HashSet<Integer>();
        walRecCntrs = new HashMap<Integer, Integer>();
        for (ClusterNode clusterNode : clusterNodes) {
            for (partId = 0; partId < ignite.context().cache().cache("default").affinity().partitions(); ++partId) {
                affinityNodes = ignite.affinity("default").mapPartitionToPrimaryAndBackups(partId);
                if (!affinityNodes.contains(clusterNode)) continue;
                path = SnapshotUtils.buildPartitionPath((Path)this.getSnapshotFolder(clusterNode.consistentId(), snapshotId).toPath(), (int)CU.cacheId((String)"default"), (int)partId);
                ch = this.fileChannel(path, compression);
                off = this.walRecordsOffset((ReadableByteChannel)ch, (int)pageSize).walRecordsOff;
                if (off == -1) continue;
                fileIO = new AsyncFileIOFactory().create(path.toFile());
                expander = new ByteBufferExpander(bufSize, ByteOrder.nativeOrder());
                var21_20 = null;
                try {
                    fileInput = new SimpleFileInput(fileIO, expander);
                    fileInput.seek((long)off);
                    try {
                        block14: while (true) {
                            startPtr = new FileWALPointer(0L, off, 0);
                            rec = serializer.readRecord((FileInput)fileInput, (WALPointer)startPtr);
                            off += rec.size();
                            walRecCntrs.put(partId, walRecCntrs.getOrDefault(partId, 0) + 1);
                            if (rec.type() != WALRecord.RecordType.DATA_RECORD_V2) continue;
                            dataRecord = (DataRecord)rec;
                            var26_29 = dataRecord.writeEntries().iterator();
                            while (true) {
                                if (var26_29.hasNext()) ** break;
                                continue block14;
                                dataEntry = (DataEntry)var26_29.next();
                                key = (Integer)dataEntry.key().value(null, false);
                                keysFound.add(key);
                                correctNodes = ignite.affinity("default").mapKeyToPrimaryAndBackups((Object)key);
                                IgniteDbSnapshotWithoutExchangeTest.assertTrue((boolean)correctNodes.contains(clusterNode));
                                correctPartId = ignite.affinity("default").partition((Object)key);
                                IgniteDbSnapshotWithoutExchangeTest.assertEquals((int)correctPartId, (int)partId);
                                IgniteDbSnapshotWithoutExchangeTest.assertFalse((boolean)cut.skipTxs().contains(dataEntry.nearXidVersion()));
                            }
                            break;
                        }
                    }
                    catch (EOFException e) {
                        continue;
                    }
                    catch (Exception e) {
                        throw new IgniteException("Error occured when reading snapshot file [file=" + path.toString() + ", offset=" + off + "]", (Throwable)e);
                    }
                }
                catch (Throwable var22_23) {
                    var21_20 = var22_23;
                    throw var22_23;
                }
                finally {
                    if (expander != null) {
                        if (var21_20 != null) {
                            try {
                                expander.close();
                            }
                            catch (Throwable var22_22) {
                                var21_20.addSuppressed(var22_22);
                            }
                        } else {
                            expander.close();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MarkerInfo walRecordsOffset(ReadableByteChannel ch, int pageSize) throws IOException, IgniteCheckedException {
        boolean markerFound = false;
        int off = 0;
        int walRecsCnt = -1;
        ByteBuffer buf = GridUnsafe.allocateBuffer((int)pageSize);
        try {
            long addr = GridUnsafe.bufferAddress((ByteBuffer)buf);
            while (IgniteDbSnapshotWithoutExchangeTest.readNextPage(buf, ch, pageSize)) {
                buf.rewind();
                off += pageSize;
                int pageType = PageIO.getType((long)addr);
                if (pageType != 33) continue;
                MarkerPageIO io = (MarkerPageIO)PageIO.getPageIO((ByteBuffer)buf);
                walRecsCnt = io.walRecordsCnt(buf);
                markerFound = true;
                break;
            }
        }
        finally {
            GridUnsafe.freeBuffer((ByteBuffer)buf);
        }
        return new MarkerInfo(markerFound ? off : -1, walRecsCnt);
    }

    private ReadableByteChannel fileChannel(Path path, boolean compression) throws FileNotFoundException {
        ReadableByteChannel ch;
        if (compression) {
            path = path.resolve(path.toString() + ".zip");
            ch = Channels.newChannel(new ZipInputStream(new BufferedInputStream(new FileInputStream(path.toFile()))));
        } else {
            ch = new RandomAccessFile(path.toFile(), "r").getChannel();
        }
        return ch;
    }

    private RecordSerializer getRecordSerializer(IgniteEx node) throws IgniteCheckedException {
        return new RecordSerializerFactoryImpl(node.context().cache().context()).createSerializer(IgniteSystemProperties.getInteger((String)"IGNITE_WAL_SERIALIZER_VERSION", (int)2));
    }

    private static boolean readNextPage(ByteBuffer buf, ReadableByteChannel ch, int pageSize) throws IOException {
        assert (buf.remaining() == pageSize);
        while (ch.read(buf) != -1 && buf.hasRemaining()) {
        }
        if (!buf.hasRemaining() && PageIO.getPageId((ByteBuffer)buf) != 0L) {
            return true;
        }
        if (buf.remaining() == pageSize) {
            return false;
        }
        throw new IgniteException("Corrupted page in partitionId , readByte=" + buf.position() + ", pageSize=" + pageSize);
    }

    private File getSnapshotFolder(Object consistentId, long snapshotId) throws IgniteCheckedException {
        File snapshotFolder = new File(new File(this.snapshotsDir(), consistentId.toString()), FileDatabaseSnapshotSpi.generateSnapshotDirName((long)snapshotId, null));
        return new File(snapshotFolder, U.maskForFileName((CharSequence)consistentId.toString()));
    }

    private void idleVerify() {
        HashSet<UUID> nodeIds = new HashSet<UUID>();
        for (int i = 0; i < 4; ++i) {
            nodeIds.add(this.grid(i).localNode().id());
        }
        VisorIdleVerifyTaskArg taskArg = new VisorIdleVerifyTaskArg(new HashSet<String>(Arrays.asList("default", ATOMIC_CACHE_NAME)), new HashSet(), false, CacheFilterEnum.ALL, true);
        IdleVerifyResultV2 taskRes = (IdleVerifyResultV2)ignite.compute().execute(VerifyBackupPartitionsTaskV2.class.getName(), (Object)taskArg);
        taskRes.print(s -> log.error(s));
        IgniteDbSnapshotWithoutExchangeTest.assertTrue((boolean)taskRes.exceptions().isEmpty());
        IgniteDbSnapshotWithoutExchangeTest.assertFalse((boolean)taskRes.hasConflicts());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInitFuture(Callable<Ignite> nodeSupplier) throws Exception {
        Ignite node = nodeSupplier.call();
        try {
            GridGain nodeGG = (GridGain)node.plugin("GridGain");
            String atomicCacheName = "atomic-cache-1";
            String txCacheName = "tx-cache-1";
            IgniteCache atomicCache = ignite.getOrCreateCache(new CacheConfiguration("atomic-cache-1").setAtomicityMode(CacheAtomicityMode.ATOMIC).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 10)).setBackups(2));
            IgniteCache txCache = ignite.getOrCreateCache(new CacheConfiguration("tx-cache-1").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 10)).setBackups(2));
            atomicCache.clear();
            txCache.clear();
            AtomicInteger atomicCacheKey = new AtomicInteger(0);
            AtomicInteger txCacheKey = new AtomicInteger(0);
            AtomicBoolean runCacheFill = new AtomicBoolean(true);
            AtomicBoolean absentKeysSet = new AtomicBoolean(false);
            CountDownLatch atomicLatch = new CountDownLatch(1);
            CountDownLatch txLatch = new CountDownLatch(1);
            IgniteInternalFuture txFillFut = GridTestUtils.runMultiThreadedAsync(() -> {
                while (runCacheFill.get()) {
                    try (Transaction tx = ignite.transactions().txStart();){
                        txCache.put((Object)txCacheKey.incrementAndGet(), (Object)0);
                        tx.commit();
                    }
                    if (!absentKeysSet.get()) continue;
                    txLatch.countDown();
                }
            }, (int)1, (String)"tx-cache-fill");
            IgniteInternalFuture atomicFillFut = GridTestUtils.runMultiThreadedAsync(() -> {
                while (runCacheFill.get()) {
                    atomicCache.put((Object)atomicCacheKey.incrementAndGet(), (Object)0);
                    if (!absentKeysSet.get()) continue;
                    atomicLatch.countDown();
                }
            }, (int)1, (String)"atomic-cache-fill");
            IgniteDbSnapshotWithoutExchangeTest.doSleep((long)500L);
            SnapshotFuture fut = nodeGG.snapshot().createFullSnapshot(new HashSet<String>(Arrays.asList("atomic-cache-1", "tx-cache-1")), null);
            AtomicInteger atomicAbsentKeyInSnapshot = new AtomicInteger();
            AtomicInteger txAbsentKeyInSnapshot = new AtomicInteger();
            fut.initFuture().listen((IgniteInClosure & Serializable)r -> {
                atomicAbsentKeyInSnapshot.set(atomicCacheKey.get() + 1);
                txAbsentKeyInSnapshot.set(txCacheKey.get() + 1);
                absentKeysSet.set(true);
            });
            fut.initFuture().get();
            atomicLatch.await();
            txLatch.await();
            IgniteDbSnapshotWithoutExchangeTest.doSleep((long)500L);
            runCacheFill.set(false);
            atomicFillFut.get();
            txFillFut.get();
            IgniteDbSnapshotWithoutExchangeTest.assertTrue((atomicAbsentKeyInSnapshot.get() < atomicCacheKey.get() ? 1 : 0) != 0);
            IgniteDbSnapshotWithoutExchangeTest.assertTrue((txAbsentKeyInSnapshot.get() < txCacheKey.get() ? 1 : 0) != 0);
            long snapshotId = fut.snapshotOperation().snapshotId();
            fut.get();
            IgniteDbSnapshotWithoutExchangeTest.assertNotNull((Object)atomicCache.get((Object)atomicAbsentKeyInSnapshot.get()));
            IgniteDbSnapshotWithoutExchangeTest.assertNotNull((Object)txCache.get((Object)txAbsentKeyInSnapshot.get()));
            this.stopGridAndRestoreFromSnapshot(snapshotId, new HashSet<String>(Arrays.asList("atomic-cache-1", "tx-cache-1")));
            IgniteDbSnapshotWithoutExchangeTest.assertNotNull((Object)ignite.cache("atomic-cache-1").get((Object)1));
            IgniteDbSnapshotWithoutExchangeTest.assertNotNull((Object)ignite.cache("tx-cache-1").get((Object)1));
            IgniteDbSnapshotWithoutExchangeTest.assertNull((Object)ignite.cache("atomic-cache-1").get((Object)atomicAbsentKeyInSnapshot.get()));
            IgniteDbSnapshotWithoutExchangeTest.assertNull((Object)ignite.cache("tx-cache-1").get((Object)txAbsentKeyInSnapshot.get()));
        }
        finally {
            this.stopGrid(node.name());
        }
    }

    @Test
    @WithSystemProperty(key="GG_EXCHANGELESS_SNAPSHOT_CREATION", value="true")
    public void testCreateSnapshotWithoutExchange() throws Exception {
        this.testCreateSnapshot(true, false, CorruptType.NONE);
    }

    @Test
    @WithSystemProperty(key="GG_EXCHANGELESS_SNAPSHOT_CREATION", value="false")
    public void testCreateSnapshotWithExchange() throws Exception {
        this.testCreateSnapshot(false, false, CorruptType.NONE);
    }

    @Test
    public void testCreateSnapshotDefault() throws Exception {
        this.testCreateSnapshot(true, false, CorruptType.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSnapshotFail() {
        int maxAttempts = SnapshotCreateFuture.MAX_ATTEMPTS_CREATING_IMPLICIT_CONSISTENT_CUT;
        TestRecordingCommunicationSpi spi = TestRecordingCommunicationSpi.spi((Ignite)this.grid(3));
        AtomicReference err = new AtomicReference();
        AtomicInteger startedCachesCnt = new AtomicInteger();
        CopyOnWriteArrayList<IgniteCache> caches = new CopyOnWriteArrayList<IgniteCache>();
        try {
            Runnable cacheStarter = () -> {
                try {
                    caches.add(this.grid(0).getOrCreateCache("test-cache-" + startedCachesCnt.incrementAndGet()));
                    spi.stopBlock(true, null, false, true);
                }
                catch (Throwable e) {
                    err.compareAndSet(null, e);
                }
            };
            spi.blockMessages((IgniteBiPredicate & Serializable)(node, msg) -> {
                SnapshotOperationStageFinishedMessage snapMsg;
                if (msg instanceof SnapshotOperationStageFinishedMessage && SnapshotOperationStage.SECOND == (snapMsg = (SnapshotOperationStageFinishedMessage)msg).stage()) {
                    GridTestUtils.runAsync((Runnable)cacheStarter);
                    return true;
                }
                return false;
            });
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(new HashSet<String>(Arrays.asList("default", ATOMIC_CACHE_NAME)), null);
            GridTestUtils.assertThrows((IgniteLogger)log, () -> (Void)fut.get(60L, TimeUnit.SECONDS), IgniteException.class, null);
            IgniteDbSnapshotWithoutExchangeTest.assertEquals((String)("Max number of attempts to create a consistent cut must be equal to " + maxAttempts), (int)maxAttempts, (int)startedCachesCnt.get());
            IgniteDbSnapshotWithoutExchangeTest.assertNull((String)"Unexpected exception on client start.", err.get());
        }
        finally {
            spi.stopBlock();
            caches.forEach(c -> this.grid(0).destroyCache(c.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSnapshotShouldNotFailIfClientNodeStarts() {
        TestRecordingCommunicationSpi spi = TestRecordingCommunicationSpi.spi((Ignite)this.grid(3));
        AtomicReference err = new AtomicReference();
        AtomicInteger startedClientsCnt = new AtomicInteger();
        CopyOnWriteArrayList<IgniteEx> clients = new CopyOnWriteArrayList<IgniteEx>();
        try {
            Runnable clientRunner = () -> {
                try {
                    this.startClientGrid(G.allGrids().size());
                    startedClientsCnt.incrementAndGet();
                    spi.stopBlock(true, null, false, true);
                }
                catch (Throwable e) {
                    err.compareAndSet(null, e);
                }
            };
            spi.blockMessages((IgniteBiPredicate & Serializable)(node, msg) -> {
                SnapshotOperationStageFinishedMessage snapMsg;
                if (msg instanceof SnapshotOperationStageFinishedMessage && SnapshotOperationStage.SECOND == (snapMsg = (SnapshotOperationStageFinishedMessage)msg).stage()) {
                    GridTestUtils.runAsync((Runnable)clientRunner);
                    return true;
                }
                return false;
            });
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(new HashSet<String>(Arrays.asList("default", ATOMIC_CACHE_NAME)), null);
            fut.get(60L, TimeUnit.SECONDS);
            IgniteDbSnapshotWithoutExchangeTest.assertEquals((String)"Max number of attempts to create a consistent cut must be equal to 1.", (int)1, (int)startedClientsCnt.get());
            IgniteDbSnapshotWithoutExchangeTest.assertNull((String)"Unexpected exception on client start.", err.get());
        }
        finally {
            spi.stopBlock();
            clients.forEach(grid -> this.stopGrid(grid.configuration().getIgniteInstanceName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConsistentCutShoulNotBeInitiatedBeforeCreateSnapshotFutureIsPrepared() throws Exception {
        IgniteEx nonCrd = this.grid(3);
        final AtomicReference err = new AtomicReference();
        final CountDownLatch consistentCutLatch = new CountDownLatch(1);
        GridCacheDatabaseSharedManager dbMgr = (GridCacheDatabaseSharedManager)nonCrd.context().cache().context().database();
        CheckpointListener checkpointLsnr = new CheckpointListener(){

            public void onMarkCheckpointBegin(CheckpointListener.Context ctx) throws IgniteCheckedException {
                try {
                    if (!ctx.nextSnapshot() || !ctx.needToSnapshot(IgniteDbSnapshotWithoutExchangeTest.ATOMIC_CACHE_NAME)) {
                        throw new IgniteCheckedException("Checkpoint is not related to a snapshot creating.");
                    }
                    consistentCutLatch.await(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | IgniteCheckedException e) {
                    err.compareAndSet(null, e);
                }
            }

            public void onCheckpointBegin(CheckpointListener.Context ctx) throws IgniteCheckedException {
            }

            public void beforeCheckpointBegin(CheckpointListener.Context ctx) throws IgniteCheckedException {
            }
        };
        try {
            dbMgr.addCheckpointListener(checkpointLsnr);
            TestRecordingCommunicationSpi spi = TestRecordingCommunicationSpi.spi((Ignite)nonCrd);
            spi.record((IgniteBiPredicate & Serializable)(node, msg) -> msg instanceof CancelSnapshotOperationMessage);
            nonCrd.context().discovery().setCustomEventListener(StartSnapshotOperationAckDiscoveryMessage.class, (CustomEventListener)new CustomEventListener<StartSnapshotOperationAckDiscoveryMessage>(){

                public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, StartSnapshotOperationAckDiscoveryMessage msg) {
                    if (msg.snapshotOperation().type() == SnapshotOperationType.CONSISTENT_CUT) {
                        try {
                            U.sleep((long)5000L);
                        }
                        catch (IgniteInterruptedCheckedException igniteInterruptedCheckedException) {
                            // empty catch block
                        }
                        consistentCutLatch.countDown();
                    }
                }
            });
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(new HashSet<String>(Arrays.asList("default", ATOMIC_CACHE_NAME)), "test-exchangeless-snapshot");
            try {
                fut.get(60L, TimeUnit.SECONDS);
            }
            catch (IgniteException e) {
                IgniteDbSnapshotWithoutExchangeTest.assertFalse((String)("Snapshot cannot be created [err=" + (Object)((Object)e) + ']'), (boolean)true);
            }
            IgniteDbSnapshotWithoutExchangeTest.assertNull((String)("Checkpoint error [err=" + err.get() + ']'), err.get());
            List recorderedMsgs = spi.recordedMessages(true);
            IgniteDbSnapshotWithoutExchangeTest.assertEquals((String)("There is an unexpected cancel message [size=" + recorderedMsgs.size() + ", firstMsg=" + (recorderedMsgs.isEmpty() ? null : recorderedMsgs.get(0)) + ']'), (int)0, (int)recorderedMsgs.size());
        }
        finally {
            dbMgr.removeCheckpointListener(checkpointLsnr);
        }
    }

    public void testCreateAndRestoreSnapshot(boolean exchangelessSnapshot, boolean compression) throws Exception {
        long snapshotId = this.testCreateSnapshot(exchangelessSnapshot, compression, CorruptType.NONE);
        this.stopGridAndRestoreFromSnapshot(snapshotId, new HashSet<String>(Arrays.asList("default", ATOMIC_CACHE_NAME)));
        this.idleVerify();
        IgniteDbSnapshotWithoutExchangeTest.assertFalse((boolean)this.partValidationFailedLsnr.check());
    }

    private void stopGridAndRestoreFromSnapshot(long snapshotId, Set<String> cacheNames) throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        ignite = this.startGrids(4);
        ignite.cluster().state(ClusterState.ACTIVE);
        gg = (GridGain)ignite.plugin("GridGain");
        gg.snapshot().restoreSnapshot(snapshotId, cacheNames, null).get();
        this.awaitPartitionMapExchange(true, true, null);
    }

    @Test
    public void testCreateSnapshotWithoutExchangeWithRestore() throws Exception {
        this.testCreateAndRestoreSnapshot(true, false);
    }

    @Test
    public void testCreateSnapshotWithoutExchangeWithCompressionAndRestore() throws Exception {
        this.testCreateAndRestoreSnapshot(true, true);
    }

    @Test
    public void testInitFutureWithClientNodeExchangeless() throws Exception {
        this.testInitFuture(() -> this.startGrid("client"));
    }

    @Test
    public void testInitFutureWithNotBaselineNodeExchangeless() throws Exception {
        this.testInitFuture(() -> this.startGrid("nodeNotInBaseline"));
    }

    @Test
    @WithSystemProperty(key="GG_EXCHANGELESS_SNAPSHOT_CREATION", value="false")
    public void testInitFutureWithClientNode() throws Exception {
        this.testInitFuture(() -> this.startGrid("client"));
    }

    @Test
    @WithSystemProperty(key="GG_EXCHANGELESS_SNAPSHOT_CREATION", value="false")
    public void testInitFutureWithNotBaselineNode() throws Exception {
        this.testInitFuture(() -> this.startGrid("nodeNotInBaseline"));
    }

    @Test
    @WithSystemProperty(key="GG_EXCHANGELESS_SNAPSHOT_CREATION", value="true")
    public void testCheckExchangelessSnapshotWithPageCorrupt() throws Exception {
        this.testCreateSnapshot(true, false, CorruptType.CORRUPT_PAGE);
    }

    @Test
    @WithSystemProperty(key="GG_EXCHANGELESS_SNAPSHOT_CREATION", value="true")
    public void testCheckExchangelessSnapshotWithWalCorrupt() throws Exception {
        this.testCreateSnapshot(true, false, CorruptType.CORRUPT_WAL);
    }

    @Test
    @WithSystemProperty(key="GG_EXCHANGELESS_SNAPSHOT_CREATION", value="true")
    public void testCheckExchangelessSnapshotWithWalCntCorrupt() throws Exception {
        this.testCreateSnapshot(true, false, CorruptType.CORRUPT_WAL_REC_CNT);
    }

    @Test
    @WithSystemProperty(key="GG_EXCHANGELESS_SNAPSHOT_CREATION", value="true")
    public void testCheckExchangelessSnapshotWithMarkerPageCorrupted() throws Exception {
        this.testCreateSnapshot(true, false, CorruptType.CORRUPT_MARKER_PAGE);
    }

    @Test
    @WithSystemProperty(key="GG_EXCHANGELESS_SNAPSHOT_CREATION", value="false")
    public void testCheckPMESnapshotWithPageCorrupt() throws Exception {
        this.testCreateSnapshot(false, false, CorruptType.CORRUPT_PAGE);
    }

    @Test
    @WithSystemProperty(key="GG_EXCHANGELESS_SNAPSHOT_CREATION", value="false")
    public void testCheckPMESnapshotWithWalCorrupt() throws Exception {
        this.testCreateSnapshot(false, false, CorruptType.CORRUPT_WAL);
    }

    @Test
    @WithSystemProperty(key="GG_EXCHANGELESS_SNAPSHOT_CREATION", value="true")
    public void testCreateSnapshotWithoutLoad() throws Exception {
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(new HashSet<String>(Arrays.asList("default", ATOMIC_CACHE_NAME)), null);
        long snapshotId = fut.snapshotOperation().snapshotId();
        fut.get();
        this.checkSnapshot(ignite, snapshotId, false, CorruptType.NONE, null, false, true);
        this.stopGridAndRestoreFromSnapshot(snapshotId, new HashSet<String>(Arrays.asList("default", ATOMIC_CACHE_NAME)));
        this.idleVerify();
        IgniteDbSnapshotWithoutExchangeTest.assertFalse((boolean)this.partValidationFailedLsnr.check());
    }

    private /* synthetic */ void lambda$txLoad$0(Ignite ignite, IgniteCache cache) {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        while (this.txRun.get()) {
            TransactionConcurrency concurrency = rnd.nextBoolean() ? TransactionConcurrency.PESSIMISTIC : TransactionConcurrency.OPTIMISTIC;
            TransactionIsolation isolation = concurrency == TransactionConcurrency.PESSIMISTIC ? TransactionIsolation.REPEATABLE_READ : TransactionIsolation.SERIALIZABLE;
            try {
                Transaction tx = ignite.transactions().txStart(concurrency, isolation, 0L, 100);
                Throwable throwable = null;
                try {
                    int acc1;
                    int acc0 = rnd.nextInt(100);
                    while ((acc1 = rnd.nextInt(100)) == acc0) {
                    }
                    if (acc0 > acc1) {
                        int tmp = acc0;
                        acc0 = acc1;
                        acc1 = tmp;
                    }
                    int val0 = (Integer)cache.get((Object)acc0);
                    int val1 = (Integer)cache.get((Object)acc1);
                    int delta = rnd.nextInt(Math.max(val0, val1));
                    if (val0 < val1) {
                        cache.put((Object)acc0, (Object)(val0 + delta));
                        cache.put((Object)acc1, (Object)(val1 - delta));
                    } else {
                        cache.put((Object)acc0, (Object)(val0 - delta));
                        cache.put((Object)acc1, (Object)(val1 + delta));
                    }
                    if (rnd.nextInt(10) == 0) {
                        tx.rollback();
                        continue;
                    }
                    tx.commit();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
            catch (Throwable e) {
                if (e instanceof TransactionOptimisticException) continue;
                log.error("Unexpected error: " + e);
            }
        }
    }

    static {
        snapshotDirs = new HashSet<String>();
    }

    private static class MarkerInfo {
        public final int walRecordsOff;
        public final int walRecordsCnt;

        public MarkerInfo(int walRecordsOff, int walRecordsCnt) {
            this.walRecordsOff = walRecordsOff;
            this.walRecordsCnt = walRecordsCnt;
        }
    }

    private static enum CorruptType {
        NONE,
        CORRUPT_PAGE,
        CORRUPT_WAL,
        CORRUPT_WAL_REC_CNT,
        CORRUPT_MARKER_PAGE;


        public boolean walRelatedCorruption() {
            return this == CORRUPT_WAL || this == CORRUPT_WAL_REC_CNT || this == CORRUPT_MARKER_PAGE;
        }
    }

    private static class CheckpointDelayListener
    implements CheckpointListener {
        private CheckpointDelayListener() {
        }

        public void onMarkCheckpointBegin(CheckpointListener.Context ctx) throws IgniteCheckedException {
        }

        public void onCheckpointBegin(CheckpointListener.Context ctx) throws IgniteCheckedException {
        }

        public void beforeCheckpointBegin(CheckpointListener.Context ctx) throws IgniteCheckedException {
            GridAbstractTest.doSleep((long)500L);
        }
    }

    private static class ConsistentCutTestListener
    implements IgniteInClosure<ConsistentCut> {
        private volatile ConsistentCut cut;

        private ConsistentCutTestListener() {
        }

        public void apply(ConsistentCut cut) {
            this.cut = cut;
        }

        public ConsistentCut consistentCut() {
            return this.cut;
        }
    }
}

