/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.encryption.keystore.KeystoreEncryptionSpi;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.IgniteDbSnapshotSameTopologyTest;
import org.gridgain.grid.internal.processors.cache.database.IgniteDbSnapshotSameTopologyWithEncryptionTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.DatabaseSnapshotSpi;
import org.gridgain.grid.internal.processors.cache.database.snapshot.FutureTaskQueue;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotEncryptionOptions;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOutputStream;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotSession;
import org.gridgain.grid.persistentstore.MessageDigestFactory;
import org.gridgain.grid.persistentstore.SnapshotCommonParams;
import org.gridgain.grid.persistentstore.SnapshotCreateParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.jetbrains.annotations.Nullable;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public abstract class IgniteDbSnapshotSameTopologyTestWithCompression
extends IgniteDbSnapshotSameTopologyTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private final CompressionOption compressionOption;
    private final boolean encryptionEnabled;

    protected IgniteDbSnapshotSameTopologyTestWithCompression(CompressionOption option, boolean enabled) {
        this.encryptionEnabled = enabled;
        this.compressionOption = option;
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        SnapshotSessionWithListenersWrapper.onPartFinishedListener = null;
        SnapshotSessionWithListenersWrapper.onPartFinishedTaskStartedListener = null;
    }

    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        GridGainConfiguration ggCfg = null;
        for (PluginConfiguration pCfg : cfg.getPluginConfigurations()) {
            if (!(pCfg instanceof GridGainConfiguration)) continue;
            ggCfg = (GridGainConfiguration)pCfg;
            break;
        }
        assert (ggCfg != null);
        ggCfg.getSnapshotConfiguration().setCompressionOption(this.compressionOption);
        ggCfg.getSnapshotConfiguration().setCompressionLevel(this.compressionOption.defaultCompressionLevel());
        if (this.encryptionEnabled) {
            KeystoreEncryptionSpi encSpi = new KeystoreEncryptionSpi();
            encSpi.setKeyStorePath(IgniteDbSnapshotSameTopologyWithEncryptionTest.KEYSTORE_PATH);
            encSpi.setKeyStorePassword(IgniteDbSnapshotSameTopologyWithEncryptionTest.KEYSTORE_PASSWORD);
            encSpi.setMasterKeyName("ignite.master.key");
            cfg.setEncryptionSpi((EncryptionSpi)encSpi);
        }
        return cfg;
    }

    @Override
    protected CacheConfiguration<?, ?> getCacheConfig(String cacheName) {
        return super.getCacheConfig(cacheName).setEncryptionEnabled(!cacheName.equals("noPersistence") && this.encryptionEnabled);
    }

    @Override
    protected DatabaseSnapshotSpi wrapDataBaseSnapshotSpi(DatabaseSnapshotSpi original) {
        return new RestorePauseSnapshotWithSessionListenersSpiWrapper(original);
    }

    @Override
    protected SnapshotCreateParams createSnapshotParams(CompressionOption compressionOption, int compressionLevel, int threshold) {
        if (this.encryptionEnabled) {
            return new SnapshotCreateParams(compressionOption, compressionLevel, threshold, IgniteSystemProperties.getBoolean((String)"GG_EXCHANGELESS_SNAPSHOT_CREATION", (boolean)true), null, "ignite.master.key");
        }
        return super.createSnapshotParams(compressionOption, compressionLevel, threshold);
    }

    @Override
    public void testChecking_ChecksumIssue() throws Exception {
        Assume.assumeFalse((String)"Corruption of CRC in encrypted partitions is not implemented in tests", (boolean)this.encryptionEnabled);
        super.testChecking_ChecksumIssue();
    }

    @Override
    public void testChecking_ChecksumIssue_WhenOneTargetCacheFileWasCorrupted() throws Exception {
        Assume.assumeFalse((String)"Corruption of CRC in encrypted partitions is not implemented in tests", (boolean)this.encryptionEnabled);
        super.testChecking_ChecksumIssue_WhenOneTargetCacheFileWasCorrupted();
    }

    @Override
    public void testChecking_CheckSnapshotByCacheName() throws Exception {
        Assume.assumeFalse((String)"Corruption of CRC in encrypted partitions is not implemented in tests", (boolean)this.encryptionEnabled);
        super.testChecking_CheckSnapshotByCacheName();
    }

    @Override
    public void testSnapshotMetricsMXBeanOnSnapshotCreate() throws Exception {
        Assume.assumeFalse((String)"Real compressed files have unpredictable sizes, test is unstable", (boolean)this.encryptionEnabled);
        super.testSnapshotMetricsMXBeanOnSnapshotCreate();
    }

    @Override
    public void testThatClientLeftDoesNotFailSnapshotRestore() throws Exception {
        Assume.assumeFalse((String)"https://ggsystems.atlassian.net/browse/GG-40376", (boolean)this.encryptionEnabled);
        super.testThatClientLeftDoesNotFailSnapshotRestore();
    }

    @Override
    public void testCreateSnapshotToSpecificPathCompression() throws Exception {
        this.createSnapshotToSpecificPathAndParallelism(8, this.compressionOption, Math.min(5, this.compressionOption.maxCompressionLevel()));
    }

    @Override
    public void testCreateSnapshotToSpecificPathCompressionAndParallelism() throws Exception {
        this.createSnapshotToSpecificPathAndParallelism(2, this.compressionOption, -1);
    }

    @Test
    public void testCompressionTaskDontWaitUntilUncompressedSnapshotCompleted() throws InterruptedException, IgniteInterruptedCheckedException {
        if (this.encryptionEnabled) {
            return;
        }
        AtomicBoolean firstPartCopied = new AtomicBoolean(false);
        CountDownLatch compressionStarted = new CountDownLatch(1);
        SnapshotSessionWithListenersWrapper.onPartFinishedListener = groupPartitionId -> {
            if (!firstPartCopied.compareAndSet(false, true)) {
                try {
                    if (!compressionStarted.await(5L, TimeUnit.SECONDS)) {
                        throw new AssertionError((Object)"Compression task expected to run in parallel");
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        SnapshotSessionWithListenersWrapper.onPartFinishedTaskStartedListener = groupPartitionId -> compressionStarted.countDown();
        try (IgniteDataStreamer ldr = ignite.dataStreamer(this.getOrCreateDefaultCacheName((Ignite)ignite));){
            ldr.allowOverwrite(true);
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            for (int i = 0; i < 300; ++i) {
                map.put(i, i);
            }
            ldr.addData(map);
        }
        SnapshotFuture snapFut = gg.snapshot().createFullSnapshot(F.asSet((Object)this.getOrCreateDefaultCacheName((Ignite)ignite)), null, new SnapshotCommonParams(4), this.createSnapshotParams(this.compressionOption, this.compressionOption.defaultCompressionLevel(), 0), null);
        IgniteDbSnapshotSameTopologyTestWithCompression.assertTrue((boolean)compressionStarted.await(1L, TimeUnit.MINUTES));
        snapFut.get();
    }

    protected static class SnapshotSessionWithListenersWrapper
    implements SnapshotSession {
        protected static volatile Consumer<GroupPartitionId> onPartFinishedListener = null;
        protected static volatile Consumer<GroupPartitionId> onPartFinishedTaskStartedListener = null;
        final SnapshotSession delegate;

        public SnapshotSessionWithListenersWrapper(SnapshotSession delegate) {
            this.delegate = delegate;
        }

        public SnapshotEncryptionOptions snapshotEncryptionOptions() {
            return this.delegate.snapshotEncryptionOptions();
        }

        public SnapshotOutputStream getOrOpenForFile(int grpId, int partId) throws IgniteCheckedException {
            return this.delegate.getOrOpenForFile(grpId, partId);
        }

        public void writeMetadata(ByteBuffer metadata) throws IgniteCheckedException {
            this.delegate.writeMetadata(metadata);
        }

        public void writeRegistry(ByteBuffer registry) throws IgniteCheckedException {
            this.delegate.writeRegistry(registry);
        }

        public void cancel() throws IgniteException {
            this.delegate.cancel();
        }

        public void close() throws IgniteException {
            this.delegate.close();
        }

        public Runnable onPartitionFinished(final GroupPartitionId groupPartitionId) throws IgniteCheckedException {
            final Runnable originalTask = this.delegate.onPartitionFinished(groupPartitionId);
            if (onPartFinishedListener != null) {
                onPartFinishedListener.accept(groupPartitionId);
            }
            return new Runnable(){

                @Override
                public void run() {
                    if (onPartFinishedTaskStartedListener != null) {
                        onPartFinishedTaskStartedListener.accept(groupPartitionId);
                    }
                    if (originalTask != null) {
                        originalTask.run();
                    }
                }
            };
        }
    }

    public class RestorePauseSnapshotWithSessionListenersSpiWrapper
    extends AbstractSnapshotTest.RestorePauseSnapshotSpiWrapper {
        RestorePauseSnapshotWithSessionListenersSpiWrapper(DatabaseSnapshotSpi delegate) {
            super(IgniteDbSnapshotSameTopologyTestWithCompression.this, delegate);
        }

        @Override
        public SnapshotSession sessionForSnapshotCreation(long id, boolean fullSnapshot, @Nullable File storePath, CompressionOption compression, int compressionLevel, FutureTaskQueue<GroupPartitionId> futureTaskQueue, SnapshotOperationContext snapshotOperationContext, @Nullable MessageDigestFactory msgDigestFactory, @Nullable SnapshotEncryptionOptions encryptionOptions) throws IgniteCheckedException {
            return new SnapshotSessionWithListenersWrapper(super.sessionForSnapshotCreation(id, fullSnapshot, storePath, compression, compressionLevel, futureTaskQueue, snapshotOperationContext, msgDigestFactory, encryptionOptions));
        }
    }

    public static class SnappyEncrypted
    extends IgniteDbSnapshotSameTopologyTestWithCompression {
        public SnappyEncrypted() {
            super(CompressionOption.SNAPPY, true);
        }
    }

    public static class ZstdEncrypted
    extends IgniteDbSnapshotSameTopologyTestWithCompression {
        public ZstdEncrypted() {
            super(CompressionOption.ZSTD, true);
        }
    }

    public static class ZipEncrypted
    extends IgniteDbSnapshotSameTopologyTestWithCompression {
        public ZipEncrypted() {
            super(CompressionOption.ZIP, true);
        }
    }

    public static class Snappy
    extends IgniteDbSnapshotSameTopologyTestWithCompression {
        public Snappy() {
            super(CompressionOption.SNAPPY, false);
        }
    }

    public static class Lz4
    extends IgniteDbSnapshotSameTopologyTestWithCompression {
        public Lz4() {
            super(CompressionOption.LZ4, false);
        }
    }

    public static class Zstd
    extends IgniteDbSnapshotSameTopologyTestWithCompression {
        public Zstd() {
            super(CompressionOption.ZSTD, false);
        }
    }

    public static class Zip
    extends IgniteDbSnapshotSameTopologyTestWithCompression {
        public Zip() {
            super(CompressionOption.ZIP, false);
        }
    }
}

