/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.IgniteDbSnapshotSameTopologyTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.junit.Test;

public class IgniteDbSnapshotSameTopologyTestWalModeNone
extends IgniteDbSnapshotSameTopologyTest {
    private final LogListener lsnrMessageOnStart = LogListener.matches((String)GridCacheSnapshotManager.WAL_MODE_NONE_WARNING_ON_START).build();
    private final LogListener lsnrMessageOnSnapshotCreate = LogListener.matches((String)GridCacheSnapshotManager.WAL_MODE_NONE_MESSAGE_ON_CREATION).build();
    private final IgniteLogger testLog = new ListeningTestLogger(log, new LogListener[]{this.lsnrMessageOnStart, this.lsnrMessageOnSnapshotCreate});

    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName).setGridLogger(this.testLog);
        cfg.getDataStorageConfiguration().setWalMode(WALMode.NONE);
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSwitchToLegacySnapshot() throws Exception {
        IgniteEx node = this.startGrid();
        try {
            GridGain nodeGG = (GridGain)node.plugin("GridGain");
            IgniteDbSnapshotSameTopologyTestWalModeNone.assertTrue((boolean)this.lsnrMessageOnStart.check());
            int beforeCreateVer = ignite.context().discovery().topologyVersionEx().minorTopologyVersion();
            nodeGG.snapshot().createFullSnapshot(null, null).get();
            int afterCreateVer = ignite.context().discovery().topologyVersionEx().minorTopologyVersion();
            IgniteDbSnapshotSameTopologyTestWalModeNone.assertTrue((boolean)this.lsnrMessageOnSnapshotCreate.check());
            IgniteDbSnapshotSameTopologyTestWalModeNone.assertEquals((int)(beforeCreateVer + 1), (int)afterCreateVer);
        }
        finally {
            this.stopGrid(node.name());
        }
    }
}

