/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Random;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.jetbrains.annotations.NotNull;
import org.junit.Ignore;
import org.junit.Test;

public class IgniteDbSnapshotRestoreChangeCacheNameTest
extends GridCommonAbstractTest
implements Serializable {
    private static final int ENTRIES_COUNT = 100;
    private static final String INITIAL_CLUSTER_NODE_ID = "initNodeId";
    private static final String NEW_CLUSTER_NODE_ID = "newNodeId";

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0xC800000L).setPersistenceEnabled(true)).setWalMode(WALMode.LOG_ONLY);
        cfg.setDataStorageConfiguration(memCfg);
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        ggCfg.setSnapshotConfiguration(new SnapshotConfiguration().setSnapshotsPath("snapshot/" + gridName));
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        cfg.setConsistentId((Serializable)((Object)gridName));
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.cleanIgniteWorkDir();
        this.cleanMoveDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanIgniteWorkDir();
        this.cleanMoveDir();
    }

    @Test
    public void testRestoreSimpleCacheWithNewNameSucceed() throws Exception {
        SimpleCacheDataHarness dataHarness = new SimpleCacheDataHarness();
        Long snapshotId = this.prepareMovedSnapshot(dataHarness);
        IgniteEx ig = this.startGrid(NEW_CLUSTER_NODE_ID);
        ig.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ig.plugin("GridGain");
        gg.snapshot().restoreSnapshot(snapshotId.longValue(), Collections.singleton(this.getOrCreateMoveDir()), null, ((TestDataHarness)dataHarness).configurationConverter(), null).get();
        this.awaitPartitionMapExchange();
        ((TestDataHarness)dataHarness).verifyData(ig);
    }

    @Test
    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-36853")
    public void testRestoreCacheGroupWithCacheNameChangeFails() throws Exception {
        CacheGroupDataHarness dataHarness = new CacheGroupDataHarness();
        Long snapshotId = this.prepareMovedSnapshot(dataHarness);
        IgniteEx ig = this.startGrid(NEW_CLUSTER_NODE_ID);
        ig.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ig.plugin("GridGain");
        gg.snapshot().restoreSnapshot(snapshotId.longValue(), Collections.singleton(this.getOrCreateMoveDir()), null, ((TestDataHarness)dataHarness).configurationConverter(), null).get();
    }

    private Long prepareMovedSnapshot(TestDataHarness dataHarness) throws Exception {
        IgniteEx ig = this.startGrid(INITIAL_CLUSTER_NODE_ID);
        ig.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ig.plugin("GridGain");
        dataHarness.generateData(ig);
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        File moveDir = this.getOrCreateMoveDir();
        gg.snapshot().moveSnapshot(fut.snapshotOperation().snapshotId(), moveDir, null).get();
        this.stopAllGrids();
        this.cleanIgniteWorkDir();
        return fut.snapshotOperation().snapshotId();
    }

    private void cleanIgniteWorkDir() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
    }

    @NotNull
    private File getOrCreateMoveDir() throws IgniteCheckedException {
        File moveDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"move_test", (boolean)false);
        if (!moveDir.exists()) {
            moveDir.mkdirs();
        }
        return moveDir;
    }

    private void cleanMoveDir() throws IgniteCheckedException {
        File moveDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"move_test", (boolean)false);
        U.delete((File)moveDir);
    }

    private static class CacheGroupDataHarness
    extends TestDataHarness {
        private static final String CACHE_GROUP_NAME = "commonGroupName";
        private static final String UNALTERED_CACHE_NAME = "unalteredName";
        private static final String INITIAL_CACHE_NAME = "initialName";
        private static final String CHANGED_CACHE_NAME = "changedName";

        private CacheGroupDataHarness() {
        }

        @Override
        public void generateData(IgniteEx ig) {
            ig.createCache(this.cacheConfiguration(UNALTERED_CACHE_NAME, CACHE_GROUP_NAME));
            ig.createCache(this.cacheConfiguration(INITIAL_CACHE_NAME, CACHE_GROUP_NAME));
            try (IgniteDataStreamer st0 = ig.dataStreamer(UNALTERED_CACHE_NAME);
                 IgniteDataStreamer st1 = ig.dataStreamer(INITIAL_CACHE_NAME);){
                for (int k = 0; k < 100; ++k) {
                    st0.addData((Object)k, (Object)new DataObject(k));
                    st1.addData((Object)(100 + k), (Object)new DataObject(100 + k));
                }
            }
        }

        @Override
        public IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> configurationConverter() {
            return new CacheWithinAGroupClosure();
        }

        @Override
        public void verifyData(IgniteEx ig) {
        }

        private static class CacheWithinAGroupClosure
        implements IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> {
            private CacheWithinAGroupClosure() {
            }

            public CacheConfiguration apply(String s, CacheConfiguration conf) {
                if (CacheGroupDataHarness.UNALTERED_CACHE_NAME.equals(conf.getName())) {
                    return conf;
                }
                return conf.setName(CacheGroupDataHarness.CHANGED_CACHE_NAME);
            }
        }
    }

    private static class SimpleCacheDataHarness
    extends TestDataHarness {
        private static final String INITIAL_CACHE_NAME = "initialName";
        private static final String CHANGED_CACHE_NAME = "changedName";

        private SimpleCacheDataHarness() {
        }

        @Override
        public void generateData(IgniteEx ig) {
            ig.createCache(this.cacheConfiguration(INITIAL_CACHE_NAME, null));
            try (IgniteDataStreamer streamer = ig.dataStreamer(INITIAL_CACHE_NAME);){
                for (int k = 0; k < 100; ++k) {
                    streamer.addData((Object)k, (Object)new DataObject(k));
                }
            }
        }

        @Override
        public IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> configurationConverter() {
            return new SingleCacheClosure();
        }

        @Override
        public void verifyData(IgniteEx ig) {
            IgniteDbSnapshotRestoreChangeCacheNameTest.assertTrue((boolean)ig.cacheNames().contains(CHANGED_CACHE_NAME));
            IgniteDbSnapshotRestoreChangeCacheNameTest.assertFalse((boolean)ig.cacheNames().contains(INITIAL_CACHE_NAME));
            IgniteCache changedCacheName = ig.cache(CHANGED_CACHE_NAME);
            for (int k = 0; k < 100; ++k) {
                IgniteDbSnapshotRestoreChangeCacheNameTest.assertEquals((int)k, (int)((DataObject)changedCacheName.get((Object)k)).idx());
            }
        }

        private static class SingleCacheClosure
        implements IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> {
            private SingleCacheClosure() {
            }

            public CacheConfiguration apply(String s, CacheConfiguration conf) {
                return conf.setName(SimpleCacheDataHarness.CHANGED_CACHE_NAME);
            }
        }
    }

    private static abstract class TestDataHarness {
        private TestDataHarness() {
        }

        CacheConfiguration cacheConfiguration(String cacheName, String cacheGroupName) {
            CacheConfiguration ccfg = new CacheConfiguration();
            ccfg.setName(cacheName);
            ccfg.setGroupName(cacheGroupName);
            return ccfg;
        }

        public abstract void generateData(IgniteEx var1);

        abstract IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> configurationConverter();

        public abstract void verifyData(IgniteEx var1);
    }

    public static class DataObject {
        final Integer idx;
        final byte[] data;

        DataObject(Integer idx) {
            this.idx = idx;
            Random rnd = new Random();
            this.data = new byte[1024];
            rnd.nextBytes(this.data);
        }

        public Integer idx() {
            return this.idx;
        }

        public byte[] data() {
            return this.data;
        }
    }
}

