/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.database.IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;

public class IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTestMultiNode
extends IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest {
    private static final Set<String> allSnapshotDirs = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> snapshotDirs = new HashSet<String>();

    @Override
    protected String snapshotPathForNode(String gridName) {
        allSnapshotDirs.add(gridName);
        this.snapshotDirs.add(gridName);
        return gridName;
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.snapshotDirs.clear();
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        for (String snapshotDir : allSnapshotDirs) {
            U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)snapshotDir, (boolean)false));
        }
        allSnapshotDirs.clear();
    }

    @Override
    protected Set<String> snapshotFolders() {
        return this.snapshotDirs;
    }

    @Override
    protected void removeFileOfOneNode(long id) throws IgniteCheckedException {
        String snapshotDirName = null;
        for (String dir : this.snapshotDirs) {
            if (dir.equals("dummy")) continue;
            snapshotDirName = dir;
            break;
        }
        File snapshotDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), snapshotDirName, (boolean)false);
        File fullSnapDir = new File(snapshotDir, FileDatabaseSnapshotSpi.generateSnapshotDirName((long)id, null));
        U.delete((File)fullSnapDir);
    }
}

