/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.DatabaseSnapshotSpi;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class IgniteDbSnapshotMoveCopyCancelledTest
extends AbstractSnapshotTest {
    private IgniteEx ignite;
    private GridGain gg;
    private File targetDirectory;
    private CountDownLatch moveFinished;
    private CountDownLatch forceCancelled;
    private DatabaseSnapshotSpi spi = null;

    protected void beforeTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.cleanSnapshotDirs();
        this.targetDirectory = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"temp", (boolean)true);
        this.moveFinished = new CountDownLatch(1);
        this.forceCancelled = new CountDownLatch(1);
    }

    @Override
    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.cleanSnapshotDirs();
        U.delete((File)this.targetDirectory);
    }

    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration configuration = super.getConfiguration(gridName);
        GridCacheSnapshotManager.TEST_SNAPSHOT_SPI.set(this.spi);
        return configuration;
    }

    @Test
    public void testMoveForceCancelFinishedMetadataIsOk() throws Exception {
        this.operationForceCancelOperationFinishedMetadataIsOk(SnapshotOperationType.MOVE, false, false);
    }

    @Test
    public void testCopyForceCancelCopyFinishedMetadataIsOk() throws Exception {
        this.operationForceCancelOperationFinishedMetadataIsOk(SnapshotOperationType.COPY, false, false);
    }

    @Test
    public void testMoveForceCancelSeemsFinishedButMetadataIsBroken() throws Exception {
        this.operationForceCancelOperationSeemsFinishedButMetadataIsBroken(SnapshotOperationType.MOVE, false, false);
    }

    @Test
    public void testCopyForceCancelSeemsFinishedButMetadataIsBroken() throws Exception {
        this.operationForceCancelOperationSeemsFinishedButMetadataIsBroken(SnapshotOperationType.COPY, false, false);
    }

    @Test
    public void testMoveForceCancelMoveUnfinished() throws Exception {
        this.operationForceCancelOperationUnfinished(SnapshotOperationType.MOVE, false, false);
    }

    @Test
    public void testCopyForceCancelCopyUnfinished() throws Exception {
        this.operationForceCancelOperationUnfinished(SnapshotOperationType.COPY, false, false);
    }

    protected void operationWithSkipWalThenOperation(boolean expectedWalExists) throws Exception {
        FileDatabaseSnapshotSpi spiedSpi = (FileDatabaseSnapshotSpi)Mockito.spy((Object)new FileDatabaseSnapshotSpi());
        this.spi = spiedSpi;
        this.ignite = this.startGrid(0);
        this.ignite.cluster().active(true);
        this.load((Ignite)this.ignite);
        this.gg = (GridGain)this.ignite.plugin("GridGain");
        SnapshotFuture snapshotFut = this.gg.snapshot().createFullSnapshot(null, null);
        snapshotFut.get();
        long snapId = snapshotFut.snapshotOperation().snapshotId();
        this.gg.snapshot().createFullSnapshot(null, null).get();
        this.doOperation(SnapshotOperationType.COPY, snapId, true).get();
        ((FileDatabaseSnapshotSpi)Mockito.verify((Object)spiedSpi, (VerificationMode)Mockito.times((int)1))).copySnapshotEntirely(Matchers.eq((long)snapId), (SnapshotPath)Matchers.any(), (SnapshotOperationContext)Matchers.any(), (ExecutorService)Matchers.any());
        this.verifySnapshotContent(this.targetDirectory, snapId, this.gg, (Ignite)this.ignite, false, null);
        this.doOperation(SnapshotOperationType.COPY, snapId, false).get();
        ((FileDatabaseSnapshotSpi)Mockito.verify((Object)spiedSpi, (VerificationMode)Mockito.times((int)1))).copySnapshotEntirely(Matchers.eq((long)snapId), (SnapshotPath)Matchers.any(), (SnapshotOperationContext)Matchers.any(), (ExecutorService)Matchers.any());
        this.verifySnapshotContent(this.targetDirectory, snapId, this.gg, (Ignite)this.ignite, expectedWalExists, null);
        this.doRestore(snapId);
    }

    protected void operationForceCancelOperationFinishedMetadataIsOk(SnapshotOperationType snapshotOperationType, boolean skipWalMove, boolean expectedWalExists) throws Exception {
        FileDatabaseSnapshotSpi spiedSpi = (FileDatabaseSnapshotSpi)Mockito.spy((Object)new FileDatabaseSnapshotSpi());
        ((FileDatabaseSnapshotSpi)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock mock) throws Throwable {
                Object result = mock.callRealMethod();
                IgniteDbSnapshotMoveCopyCancelledTest.this.moveFinished.countDown();
                IgniteDbSnapshotMoveCopyCancelledTest.this.forceCancelled.await();
                return result;
            }
        }).when((Object)spiedSpi)).finishCopy(Matchers.anyLong(), (SnapshotPath)Matchers.anyObject());
        this.spi = spiedSpi;
        long snapId = this.doOperationAndForceCancel(snapshotOperationType, skipWalMove);
        ((FileDatabaseSnapshotSpi)Mockito.verify((Object)spiedSpi, (VerificationMode)Mockito.times((int)1))).copySnapshotEntirely(Matchers.eq((long)snapId), (SnapshotPath)Matchers.any(), (SnapshotOperationContext)Matchers.any(), (ExecutorService)Matchers.any());
        ((FileDatabaseSnapshotSpi)Mockito.verify((Object)spiedSpi, (VerificationMode)Mockito.times((int)(expectedWalExists ? 1 : 0)))).copyWalSegments(Matchers.eq((long)snapId), (Collection)Matchers.any(), (SnapshotPath)Matchers.any(), (SnapshotOperationContext)Matchers.any());
        ((FileDatabaseSnapshotSpi)Mockito.doCallRealMethod().when((Object)spiedSpi)).finishCopy(Matchers.anyLong(), (SnapshotPath)Matchers.anyObject());
        this.doOperation(snapshotOperationType, snapId, skipWalMove).get();
        ((FileDatabaseSnapshotSpi)Mockito.verify((Object)spiedSpi, (VerificationMode)Mockito.times((int)1))).copySnapshotEntirely(Matchers.eq((long)snapId), (SnapshotPath)Matchers.any(), (SnapshotOperationContext)Matchers.any(), (ExecutorService)Matchers.any());
        ((FileDatabaseSnapshotSpi)Mockito.verify((Object)spiedSpi, (VerificationMode)Mockito.times((int)(expectedWalExists ? 2 : 0)))).copyWalSegments(Matchers.eq((long)snapId), (Collection)Matchers.any(), (SnapshotPath)Matchers.any(), (SnapshotOperationContext)Matchers.any());
        this.verifySnapshotContent(this.targetDirectory, snapId, this.gg, (Ignite)this.ignite, expectedWalExists, null);
        this.doRestore(snapId);
    }

    protected void operationForceCancelOperationSeemsFinishedButMetadataIsBroken(SnapshotOperationType snapshotOperationType, boolean skipWalMove, boolean expectedWalExists) throws Exception {
        final FileDatabaseSnapshotSpi spiedSpi = (FileDatabaseSnapshotSpi)Mockito.spy((Object)new FileDatabaseSnapshotSpi());
        ((FileDatabaseSnapshotSpi)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock mock) throws Throwable {
                Object result = mock.callRealMethod();
                long snapId = (Long)mock.getArguments()[0];
                FsSnapshotPath pathToMove = (FsSnapshotPath)mock.getArguments()[1];
                FsSnapshotPath targetConsistentIdDir = (FsSnapshotPath)spiedSpi.generateCurNodeSnapshotFolderPath((SnapshotPath)pathToMove, snapId);
                FsSnapshotPath file = targetConsistentIdDir.resolveRegularOrCompressed("snapshot-meta.bin");
                IgniteDbSnapshotMoveCopyCancelledTest.this.corruptFile(file.getFile());
                IgniteDbSnapshotMoveCopyCancelledTest.this.moveFinished.countDown();
                IgniteDbSnapshotMoveCopyCancelledTest.this.forceCancelled.await();
                return result;
            }
        }).when((Object)spiedSpi)).finishCopy(Matchers.anyLong(), (SnapshotPath)Matchers.anyObject());
        this.spi = spiedSpi;
        long snapId = this.doOperationAndForceCancel(snapshotOperationType, skipWalMove);
        ((FileDatabaseSnapshotSpi)Mockito.verify((Object)spiedSpi, (VerificationMode)Mockito.times((int)1))).copySnapshotEntirely(Matchers.eq((long)snapId), (SnapshotPath)Matchers.any(), (SnapshotOperationContext)Matchers.any(), (ExecutorService)Matchers.any());
        ((FileDatabaseSnapshotSpi)Mockito.verify((Object)spiedSpi, (VerificationMode)Mockito.times((int)(expectedWalExists ? 1 : 0)))).copyWalSegments(Matchers.eq((long)snapId), (Collection)Matchers.any(), (SnapshotPath)Matchers.any(), (SnapshotOperationContext)Matchers.any());
        ((FileDatabaseSnapshotSpi)Mockito.doCallRealMethod().when((Object)spiedSpi)).finishCopy(Matchers.anyLong(), (SnapshotPath)Matchers.anyObject());
        this.doOperation(snapshotOperationType, snapId, skipWalMove).get();
        ((FileDatabaseSnapshotSpi)Mockito.verify((Object)spiedSpi, (VerificationMode)Mockito.times((int)2))).copySnapshotEntirely(Matchers.eq((long)snapId), (SnapshotPath)Matchers.any(), (SnapshotOperationContext)Matchers.any(), (ExecutorService)Matchers.any());
        ((FileDatabaseSnapshotSpi)Mockito.verify((Object)spiedSpi, (VerificationMode)Mockito.times((int)(expectedWalExists ? 2 : 0)))).copyWalSegments(Matchers.eq((long)snapId), (Collection)Matchers.any(), (SnapshotPath)Matchers.any(), (SnapshotOperationContext)Matchers.any());
        this.verifySnapshotContent(this.targetDirectory, snapId, this.gg, (Ignite)this.ignite, expectedWalExists, null);
        this.doRestore(snapId);
    }

    protected void operationForceCancelOperationUnfinished(SnapshotOperationType snapshotOperationType, boolean skipWalMove, boolean expectedWalExists) throws Exception {
        FileDatabaseSnapshotSpi spiedSpi = (FileDatabaseSnapshotSpi)Mockito.spy((Object)new FileDatabaseSnapshotSpi());
        ((FileDatabaseSnapshotSpi)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock mock) throws Throwable {
                IgniteDbSnapshotMoveCopyCancelledTest.this.moveFinished.countDown();
                IgniteDbSnapshotMoveCopyCancelledTest.this.forceCancelled.await();
                return null;
            }
        }).when((Object)spiedSpi)).finishCopy(Matchers.anyLong(), (SnapshotPath)Matchers.anyObject());
        this.spi = spiedSpi;
        long snapId = this.doOperationAndForceCancel(snapshotOperationType, skipWalMove);
        ((FileDatabaseSnapshotSpi)Mockito.verify((Object)spiedSpi, (VerificationMode)Mockito.times((int)1))).copySnapshotEntirely(Matchers.eq((long)snapId), (SnapshotPath)Matchers.any(), (SnapshotOperationContext)Matchers.any(), (ExecutorService)Matchers.any());
        ((FileDatabaseSnapshotSpi)Mockito.verify((Object)spiedSpi, (VerificationMode)Mockito.times((int)(expectedWalExists ? 1 : 0)))).copyWalSegments(Matchers.eq((long)snapId), (Collection)Matchers.any(), (SnapshotPath)Matchers.any(), (SnapshotOperationContext)Matchers.any());
        ((FileDatabaseSnapshotSpi)Mockito.doCallRealMethod().when((Object)spiedSpi)).finishCopy(Matchers.anyLong(), (SnapshotPath)Matchers.anyObject());
        this.doOperation(snapshotOperationType, snapId, skipWalMove).get();
        ((FileDatabaseSnapshotSpi)Mockito.verify((Object)spiedSpi, (VerificationMode)Mockito.times((int)2))).copySnapshotEntirely(Matchers.eq((long)snapId), (SnapshotPath)Matchers.any(), (SnapshotOperationContext)Matchers.any(), (ExecutorService)Matchers.any());
        ((FileDatabaseSnapshotSpi)Mockito.verify((Object)spiedSpi, (VerificationMode)Mockito.times((int)(expectedWalExists ? 2 : 0)))).copyWalSegments(Matchers.eq((long)snapId), (Collection)Matchers.any(), (SnapshotPath)Matchers.any(), (SnapshotOperationContext)Matchers.any());
        this.verifySnapshotContent(this.targetDirectory, snapId, this.gg, (Ignite)this.ignite, expectedWalExists, null);
        this.doRestore(snapId);
    }

    protected SnapshotFuture<Void> doOperation(SnapshotOperationType snapshotOperationType, long snapId, boolean skipWalMove) {
        switch (snapshotOperationType) {
            case MOVE: {
                return this.gg.snapshot().moveSnapshot(snapId, this.targetDirectory, skipWalMove, null);
            }
            case COPY: {
                return this.gg.snapshot().copySnapshot(snapId, this.targetDirectory, skipWalMove, new SnapshotUpdateOperationParams(), null);
            }
        }
        throw new UnsupportedOperationException(snapshotOperationType + " is not supported by test");
    }

    private long doOperationAndForceCancel(SnapshotOperationType snapshotOperationType, boolean skipWalMove) throws Exception {
        this.ignite = this.startGrid(0);
        this.ignite.cluster().active(true);
        this.load((Ignite)this.ignite);
        this.gg = (GridGain)this.ignite.plugin("GridGain");
        SnapshotFuture snapshotFut = this.gg.snapshot().createFullSnapshot(null, null);
        snapshotFut.get();
        long firstSnapshotId = snapshotFut.snapshotOperation().snapshotId();
        snapshotFut = this.gg.snapshot().createFullSnapshot(null, null);
        snapshotFut.get();
        SnapshotFuture<Void> moveFut = this.doOperation(snapshotOperationType, firstSnapshotId, skipWalMove);
        this.moveFinished.await();
        IgniteFuture res = this.gg.snapshot().forceCancelSnapshotOperation(moveFut.operationId(), null);
        this.forceCancelled.countDown();
        try {
            IgniteDbSnapshotMoveCopyCancelledTest.assertTrue((boolean)((Boolean)res.get()));
            moveFut.get();
            IgniteDbSnapshotMoveCopyCancelledTest.fail((String)"Move should fail, force cancelled");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return firstSnapshotId;
    }

    private void doRestore(long snapId) {
        SnapshotFuture restoreFuture = this.gg.snapshot().restoreSnapshot(snapId, Collections.singleton(this.targetDirectory), null, "");
        restoreFuture.get();
        IgniteCache cache1 = this.ignite.cache("cache1");
        IgniteCache cache2 = this.ignite.cache("cache2");
        for (int i = 0; i < 300; ++i) {
            Integer val1 = (Integer)cache1.get((Object)i);
            IgniteDbSnapshotMoveCopyCancelledTest.assertNotNull((String)("index=" + i), (Object)val1);
            IgniteDbSnapshotMoveCopyCancelledTest.assertEquals((String)("index=" + i), (int)i, (int)val1);
            AbstractSnapshotTest.TestValue val2 = (AbstractSnapshotTest.TestValue)cache2.get((Object)i);
            IgniteDbSnapshotMoveCopyCancelledTest.assertNotNull((String)("index=" + i), (Object)val2);
            IgniteDbSnapshotMoveCopyCancelledTest.assertEquals((String)("index=" + i), (Object)new AbstractSnapshotTest.TestValue(i, i), (Object)val2);
        }
    }
}

