/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.database.snapshot;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCluster;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.InvalidUserCommandException;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpi;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.GridPluginProvider;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleProcessor;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshots;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class VisorSnapshotsTest {
    @Mock
    private Ignite ignite;
    @Mock
    private GridGainImpl gridGain;
    private final IgniteConfiguration config = new IgniteConfiguration();
    @Mock
    private IgniteDiscoverySpi discoverySpi;
    @Mock
    private GridPluginProvider gridPluginProvider;
    @Mock
    private IgniteCluster igniteCluster;

    @Before
    public void prepareDiscoverySpi() {
        this.config.setDiscoverySpi((DiscoverySpi)this.discoverySpi);
        Mockito.lenient().when((Object)this.discoverySpi.allNodesSupport((IgniteFeatures)ArgumentMatchers.eq((Object)IgniteFeatures.HAS_INVALID_USER_COMMAND_EXCEPTION), (IgnitePredicate)ArgumentMatchers.any())).thenReturn((Object)true);
    }

    @Test
    public void snapshotThrowsWhenPersistenceIsNotEnabled() {
        Mockito.when((Object)this.ignite.configuration()).thenReturn((Object)this.config);
        GridTestUtils.assertThrows(null, () -> VisorSnapshots.snapshot((Ignite)this.ignite), InvalidUserCommandException.class, (String)"Persistence is not configured");
    }

    @Test
    public void snapshotThrowsWhenSnapshotsAreNotEnabled() {
        Mockito.when((Object)this.ignite.configuration()).thenReturn((Object)this.config);
        Mockito.when((Object)this.ignite.plugin((String)ArgumentMatchers.any())).thenReturn((Object)this.gridGain);
        Mockito.when((Object)this.gridGain.configuration()).thenReturn((Object)new GridGainConfiguration());
        Mockito.when((Object)this.gridGain.snapshot()).thenReturn(Mockito.mock(GridSnapshotEx.class));
        Mockito.when((Object)this.ignite.cluster()).thenReturn((Object)this.igniteCluster);
        Mockito.when((Object)this.igniteCluster.state()).thenReturn((Object)ClusterState.ACTIVE);
        this.config.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
        GridTestUtils.assertThrows(null, () -> VisorSnapshots.snapshot((Ignite)this.ignite), InvalidUserCommandException.class, (String)"GridGain snapshots are not configured");
    }

    @Test
    public void schedulerThrowsWhenSnapshotsAreNotEnabled() {
        Mockito.when((Object)this.ignite.configuration()).thenReturn((Object)this.config);
        Mockito.when((Object)this.ignite.plugin((String)ArgumentMatchers.any())).thenReturn((Object)this.gridGain);
        Mockito.when((Object)this.gridGain.configuration()).thenReturn((Object)new GridGainConfiguration());
        Mockito.when((Object)this.gridGain.provider()).thenReturn((Object)this.gridPluginProvider);
        Mockito.when((Object)this.gridPluginProvider.getSnapshotScheduler()).thenReturn(Mockito.mock(SnapshotScheduleProcessor.class));
        Mockito.when((Object)this.ignite.cluster()).thenReturn((Object)this.igniteCluster);
        Mockito.when((Object)this.igniteCluster.state()).thenReturn((Object)ClusterState.ACTIVE);
        this.config.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
        GridTestUtils.assertThrows(null, () -> VisorSnapshots.scheduler((Ignite)this.ignite), InvalidUserCommandException.class, (String)"GridGain snapshots are not configured");
    }
}

