/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationFuture;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutApplyMessage;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutStore;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class TxDrStateChangeTest
extends AbstractReplicationTest {
    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        System.setProperty("TX_DR_SKIP_STRICT_BOUNDS_CHECK", Boolean.TRUE.toString());
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        System.clearProperty("TX_DR_SKIP_STRICT_BOUNDS_CHECK");
    }

    @Test
    public void testReplicaStateChangeInternalApi() throws Exception {
        List<IgniteEx> cluster = this.startCluster(ClusterRole.REPLICA, 2);
        this.snapMgr(ClusterRole.REPLICA).startGlobalReplicationStateChange(ClusterRole.REPLICA, ReplicationState.RUNNING, 1L, 0L).get();
        this.assertClusterState(cluster, ClusterRole.REPLICA, ReplicationState.RUNNING, 1L);
        AffinityTopologyVersion topVerBefore = this.node(ClusterRole.REPLICA).context().discovery().topologyVersionEx();
        this.snapMgr(ClusterRole.REPLICA).startGlobalReplicationStateChange(ClusterRole.REPLICA, ReplicationState.PAUSED, 1L, 0L).get();
        this.assertClusterState(cluster, ClusterRole.REPLICA, ReplicationState.PAUSED, 1L);
        AffinityTopologyVersion topVerAfter = this.node(ClusterRole.REPLICA).context().discovery().topologyVersionEx();
        TxDrStateChangeTest.assertTrue((topVerAfter.compareTo(topVerBefore) > 0 ? 1 : 0) != 0);
        this.snapMgr(ClusterRole.REPLICA).startGlobalReplicationStateChange(ClusterRole.REPLICA, ReplicationState.RUNNING, 1L, 0L).get();
        this.assertClusterState(cluster, ClusterRole.REPLICA, ReplicationState.RUNNING, 1L);
        try {
            this.snapMgr(ClusterRole.REPLICA).startGlobalReplicationStateChange(ClusterRole.REPLICA, ReplicationState.STOPPED, 2L, 0L).get();
            TxDrStateChangeTest.fail((String)"Replication with wrong session id can't be stopped");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertClusterState(cluster, ClusterRole.REPLICA, ReplicationState.RUNNING, 1L);
        topVerBefore = this.node(ClusterRole.REPLICA).context().discovery().topologyVersionEx();
        this.snapMgr(ClusterRole.REPLICA).startGlobalReplicationStateChange(ClusterRole.REPLICA, ReplicationState.STOPPED, 1L, 0L).get();
        this.assertClusterState(cluster, ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
        topVerAfter = this.node(ClusterRole.REPLICA).context().discovery().topologyVersionEx();
        TxDrStateChangeTest.assertTrue((topVerAfter.compareTo(topVerBefore) > 0 ? 1 : 0) != 0);
        try {
            this.snapMgr(ClusterRole.REPLICA).startGlobalReplicationStateChange(ClusterRole.REPLICA, ReplicationState.PAUSED, 1L, 0L).get();
            TxDrStateChangeTest.fail((String)"Already stopped replication can't be paused");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertClusterState(cluster, ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
        this.snapMgr(ClusterRole.REPLICA).startGlobalReplicationStateChange(ClusterRole.REPLICA, ReplicationState.RUNNING, 2L, 0L).get();
        this.assertClusterState(cluster, ClusterRole.REPLICA, ReplicationState.RUNNING, 2L);
        this.snapMgr(ClusterRole.REPLICA).startGlobalReplicationStateChange(ClusterRole.REPLICA, ReplicationState.PAUSED, 2L, 0L).get();
        this.assertClusterState(cluster, ClusterRole.REPLICA, ReplicationState.PAUSED, 2L);
        this.snapMgr(ClusterRole.REPLICA).startGlobalReplicationStateChange(ClusterRole.REPLICA, ReplicationState.STOPPED, 2L, 0L).get();
        this.assertClusterState(cluster, ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
    }

    @Test
    public void testReplicaStateChangePublicApi() throws Exception {
        List<IgniteEx> cluster = this.startCluster(ClusterRole.REPLICA, 2);
        this.snapMgr(ClusterRole.REPLICA).startGlobalReplicationStateChange(ClusterRole.REPLICA, ReplicationState.RUNNING, 1L, 0L).get();
        this.assertClusterState(cluster, ClusterRole.REPLICA, ReplicationState.RUNNING, 1L);
        this.txdr(ClusterRole.REPLICA).pause().get();
        this.assertClusterState(cluster, ClusterRole.REPLICA, ReplicationState.PAUSED, 1L);
        this.txdr(ClusterRole.REPLICA).resume().get();
        this.assertClusterState(cluster, ClusterRole.REPLICA, ReplicationState.RUNNING, 1L);
        this.txdr(ClusterRole.REPLICA).stop().get();
        this.assertClusterState(cluster, ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
        try {
            this.txdr(ClusterRole.REPLICA).pause().get();
            TxDrStateChangeTest.fail((String)"Already stopped replication can't be paused");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertClusterState(cluster, ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
        this.snapMgr(ClusterRole.REPLICA).startGlobalReplicationStateChange(ClusterRole.REPLICA, ReplicationState.RUNNING, 2L, 0L).get();
        this.assertClusterState(cluster, ClusterRole.REPLICA, ReplicationState.RUNNING, 2L);
        this.txdr(ClusterRole.REPLICA).pause().get();
        this.assertClusterState(cluster, ClusterRole.REPLICA, ReplicationState.PAUSED, 2L);
        this.txdr(ClusterRole.REPLICA).stop().get();
        this.assertClusterState(cluster, ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
    }

    @Test
    public void testReplicaConsistentPause() throws Exception {
        List<IgniteEx> cluster = this.startCluster(ClusterRole.REPLICA, 3);
        this.snapMgr(ClusterRole.REPLICA).startGlobalReplicationStateChange(ClusterRole.REPLICA, ReplicationState.RUNNING, -1L, 0L).get();
        this.assertClusterState(cluster, ClusterRole.REPLICA, ReplicationState.RUNNING, -1L);
        for (IgniteEx ignite : cluster) {
            TransactionalDrProcessorImpl txdr = this.txdr((Ignite)ignite);
            ConsistentCutStore store = txdr.consistentCutStore();
            FileWALPointer ptr = new FileWALPointer(0L, 0, 1);
            store.save(this.createConsistentCut(1L, txdr.spawnId(), (WALPointer)ptr, (WALPointer)ptr));
            store.save(this.createConsistentCut(2L, txdr.spawnId(), (WALPointer)ptr, (WALPointer)ptr));
            store.save(this.createConsistentCut(3L, txdr.spawnId(), (WALPointer)ptr, (WALPointer)ptr));
        }
        long cutId = 0L;
        for (IgniteEx ignite : cluster) {
            this.sendApplyMessageAndAwakeForApplying(ignite, ++cutId);
        }
        TxDrStateChangeTest.assertTrue((String)"Failed to wait for applying cuts", (boolean)GridTestUtils.waitForCondition(() -> {
            long expCutId = 0L;
            for (IgniteEx ignite : cluster) {
                if (this.txdr((Ignite)ignite).localState().lastSuccessfullyAppliedCutId() == ++expCutId) continue;
                return false;
            }
            return true;
        }, (long)5000L));
        SnapshotFuture pauseStateFut = this.snapMgr(ClusterRole.REPLICA).startGlobalReplicationStateChange(ClusterRole.REPLICA, ReplicationState.PAUSED, -1L, 0L);
        pauseStateFut.initFuture().get();
        ArrayList<SnapshotOperationFuture> stateChangeFuts = new ArrayList<SnapshotOperationFuture>(3);
        for (IgniteEx ignite : cluster) {
            stateChangeFuts.add(this.snapMgr((Ignite)ignite).snapshotFuture());
        }
        TxDrStateChangeTest.assertTrue((String)"Failed to wait for 2-nd phase finish of replication state change on node2", (boolean)GridTestUtils.waitForCondition(() -> {
            SnapshotOperationFuture fut = (SnapshotOperationFuture)stateChangeFuts.get(2);
            return fut.stage() == SnapshotOperationStage.FINISH && fut.isCurrentStageFinished();
        }, (long)5000L));
        SnapshotOperationFuture fut = (SnapshotOperationFuture)stateChangeFuts.get(0);
        TxDrStateChangeTest.assertTrue((String)("Wrong stage of state change future for node 0 [stage=" + fut.stage() + ", isFinished=" + fut.isCurrentStageFinished()), (fut.stage() == SnapshotOperationStage.FINISH && !fut.isCurrentStageFinished() ? 1 : 0) != 0);
        fut = (SnapshotOperationFuture)stateChangeFuts.get(1);
        TxDrStateChangeTest.assertTrue((String)("Wrong stage of state change future for node1 [stage=" + fut.stage() + ", isFinished=" + fut.isCurrentStageFinished()), (fut.stage() == SnapshotOperationStage.FINISH && !fut.isCurrentStageFinished() ? 1 : 0) != 0);
        this.sendApplyMessageAndAwakeForApplying(cluster.get(0), 2L);
        this.sendApplyMessageAndAwakeForApplying(cluster.get(1), 3L);
        TxDrStateChangeTest.assertTrue((String)"Failed to wait for 2-nd phase finish of replication state change on node1", (boolean)GridTestUtils.waitForCondition(() -> {
            SnapshotOperationFuture fut1 = (SnapshotOperationFuture)stateChangeFuts.get(1);
            return fut1.stage() == SnapshotOperationStage.FINISH && fut1.isCurrentStageFinished();
        }, (long)5000L));
        fut = (SnapshotOperationFuture)stateChangeFuts.get(0);
        TxDrStateChangeTest.assertTrue((String)("Wrong stage of state change future for node 0 [stage=" + fut.stage() + ", isFinished=" + fut.isCurrentStageFinished()), (fut.stage() == SnapshotOperationStage.FINISH && !fut.isCurrentStageFinished() ? 1 : 0) != 0);
        this.sendApplyMessageAndAwakeForApplying(cluster.get(0), 3L);
        pauseStateFut.get();
        this.assertClusterState(cluster, ClusterRole.REPLICA, ReplicationState.PAUSED, -1L);
        for (IgniteEx ignite : cluster) {
            TxDrStateChangeTest.assertEquals((long)3L, (long)this.txdr((Ignite)ignite).localState().lastSuccessfullyAppliedCutId());
        }
    }

    @Test
    public void testCCStoreRecreationOnRestart() throws Exception {
        List<IgniteEx> cluster = this.startCluster(ClusterRole.REPLICA, 2);
        this.snapMgr(ClusterRole.REPLICA).startGlobalReplicationStateChange(ClusterRole.REPLICA, ReplicationState.RUNNING, 1L, 0L).get();
        TransactionalDrProcessorImpl txdr = this.txdr((Ignite)cluster.get(0));
        ConsistentCutStore ccStore = txdr.consistentCutStore();
        txdr.stop().get();
        this.snapMgr(ClusterRole.REPLICA).startGlobalReplicationStateChange(ClusterRole.REPLICA, ReplicationState.RUNNING, 2L, 0L).get();
        TxDrStateChangeTest.assertNotSame((Object)txdr.consistentCutStore(), (Object)ccStore);
        txdr.stop().get();
    }

    private void sendApplyMessageAndAwakeForApplying(IgniteEx ignite, long cutId) throws IgniteCheckedException {
        GridKernalContext ctx = ignite.context();
        ConsistentCutApplyMessage msgApply = new ConsistentCutApplyMessage(cutId, false);
        ctx.io().sendToGridTopic(ignite.localNode(), GridTopic.TOPIC_TXDR, (Message)msgApply, (byte)2);
        this.awakeCutsWatcher(ignite);
    }

    private ConsistentCut createConsistentCut(long id, long spawnId, WALPointer fuzzyBorderPtr, WALPointer cutPtr) {
        return new ConsistentCut(id, spawnId, fuzzyBorderPtr, cutPtr, -1L, Collections.emptySet(), Collections.emptyMap(), null, false, Collections.emptyMap(), null);
    }
}

